/*
 * Example of how a rexx file can operate on a list file created by
 * FM/2 (the list file should contain filenames only).
 */

/* get name of listfile from command line */
parse arg listfile
/* if no listfile name was given, issue help and exit */
if listfile = '' then
do
  say 'Give the name of a listfile as an argument to this REXX script.'
  exit
end
/* see if the listfile given exists -- exit with error message if not */
rc = stream(listfile,'C','QUERY EXISTS')
if rc = '' then
do
  say "File "listfile" doesn't exist."
  exit
end
/* attempt to open the listfile given on the command line */
rc = stream(listfile,'C','OPEN')
/* if open was successful, enter loop */
if rc = 'READY:' then
do
  counter = 0     /* initialize counter */
  /* read each line of the listfile into filename */
  do while lines(listfile) = 1
    filename = linein(listfile)
    /* remove any leading/trailing blanks */
    filename = strip(filename,'b')
    /* process only non-blank strings */
    if filename \= '' then
    /*
     * here you would do something to/with the file in filename
     * since this is just an example, we'll just print the name
     */
    do
      say filename
      counter = counter + 1 /* count files processed */
    end
  end
  /* close the listfile */
  rc = stream(listfile,'C','CLOSE')
end
else
do
  say 'Error opening 'listfile'.'
  exit
end
/* we're done */
say '  **We processed 'counter' files.'
