/* Sample unattended download script */

/********************************************************/
/* I wrote this sample script to demonstrate LiveWire's */
/* scripting abilities. This script was written for my  */
/* internet service provider.                           */
/*                                                      */
/* The script does the following:                       */
/*    1. Waits for a specific time                      */
/*    2. Calls my service provider and logs in          */
/*    3. Starts a UNIX shell session                    */
/*    4. Downloads a set of files                       */
/*    5. Tests the success of the download              */
/*    6. Will retry the download up to three times      */
/*    7. Completes on successful download               */
/*                                                      */
/* If you intend to use all or part of this script,     */
/* you will have to modify it to login to your specific */
/* internet service provider. Enjoy!                    */
/*                                                      */
/*                                                      */
/* Provided free for the users of LiveWire for OS/2     */
/********************************************************/

/* Turn REXX debug debugging off */
Trace(Off);

/* Set timeout */
SetLW(TimeOut,60);

/* Set inter-character pacing to 40ms */
SetLW(Pacing,40);

/* GLOBAL VARIABLES */
NumberToDial = "555-9109"
LogonName = "xxx"              /* PUT YOUR USER NAME HERE */
Password = "xxxxxxx"           /* PUT YOUR PASSWORD HERE  */
Retries = 3
FilesToDownload = "*.ZIP *.zip"
DownloadHour = 14
DownloadMinute = 23

/* Start Logon Session */
    /* Wait for the appointed time */
    ClrScrLW();
    DispLW("Waiting for unattended download at " || DownloadHour || ":" || DownloadMinute || "^M^J");
    WaitTimeLW(DownloadHour, DownloadMinute);

    Completed = 0
    Do While ((Retries > 0) & (Completed = 0))

       /* Dial to the UNIX host */
       SendLW("ATDT " || NumberToDial || "^M");
       Result = FindLW("CONNECT", "BUSY", "NO CARRIER");

       /* Check if we connected */
       if (Result = "CONNECT") then do

          /* Attempt the transfer */
          Retries = Retries - 1

          /* Login to the UNIX host */
          ret=FindLW("login: ");
          DelayLW(100);
          SendLW(LogonName || "^M");

          /* Send password */
          ret=FindLW("^M^JPassword: ");
          DelayLW(100);
          SendLW(Password || "^M");

          /* Here we wait to be asked whether we should go to a shell */
          /* account or go into PPP mode, I request shell account     */
          ret=FindLW("Choice [1]: ");
          DelayLW(100);
          SendLW("1^M");

          /* At the account menu, I ask to go directly to the shell */
          ret=FindLW("Main Menu]: ^[[0;0;0m[ ]^H^H");
          DelayLW(100);
          SendLW("s");

          /* Wait for the shell prompt */
          ret=FindLW("$");
          DelayLW(100);

          /* Tell the remote host to begin sending all .ZIP files!  */
          /* Note that we request both upper and lowercase because  */
          /* UNIX is case sensitive */
          SendLW("sz " || FilesToDownload || "^M");

          /* Tell LiveWire to begin downloading Zmodem to the       */
          /* default  download path                                 */
          ReceiveResult = ReceiveFilesLW("Z", "");

          /* Successful transfer? */
          if (ReceiveResult = "SUCCESS") then do
            Completed = 1;
          End
       End

       /* Hangup the phone */
       ret = HangupLW();

    End

    if (Completed = 0) then
       say "UNSUCCESSFUL DOWNLOAD, please see the log file."
    else
       say "Successful download completed."

Exit
