/*-----------------------------------------------------------------------------
    file:   boyer.h
    desc:   Boyer-Moore text search algorithm (Windows version) header
    by:     Patrick Ko
    date:   6 Mar 91 - born
    revi:   4 Apr 94 - port Windows 3.1
            13 Jan 95 - v0.4
    note:   use huge pointers to cater for big contiguous memory
-----------------------------------------------------------------------------*/
#ifndef _INC_BOYER
#define _INC_BOYER

/* store the pattern, pattern length and skip table for 256 alphabets */
/* maximum pattern length (MAXPAT) cannot be larger than 65535 */

#define MAXPAT  256

#ifndef HPSTR
typedef BYTE _huge *    HPSTR;
#endif

typedef struct {
        unsigned int plen;
        char p[MAXPAT + 1];
        char pIC[MAXPAT + 1];
        unsigned int skip[256];
        unsigned int skipb[256];
        unsigned int skipIC[256];
        unsigned int skipbIC[256];
} FINDSTRUCT;

typedef FINDSTRUCT FAR * LPFIND;
typedef HANDLE HFIND;
        
/* boyer.c prototypes */

#ifdef BOYERDLL
        HFIND FAR PASCAL SetFindPattern( LPSTR lpszPattern );
        void FAR PASCAL FreeFindPattern( HFIND hfind );
        LPSTR FAR PASCAL Find( HFIND hfind, LPSTR s, LONG slen );
        LPSTR FAR PASCAL FindBackward( HFIND hfind, LPSTR s, LONG slen );
        LPSTR FAR PASCAL FindIC( HFIND hfind, LPSTR s, LONG slen );
        LPSTR FAR PASCAL FindBackwardIC( HFIND hfind, LPSTR s, LONG slen );
#else
        HFIND SetFindPattern( LPSTR lpszPattern );
        void FreeFindPattern( HFIND hfind );
        LPSTR Find( HFIND hfind, LPSTR s, LONG slen );
        LPSTR FindBackward( HFIND hfind, LPSTR s, LONG slen );
        LPSTR FindIC( HFIND hfind, LPSTR s, LONG slen );
        LPSTR FindBackwardIC( HFIND hfind, LPSTR s, LONG slen );
#endif

#endif
