/* kbmlock.c -- memory locking
 * Copyright (C) 1995, 1996 Markus F.X.J. Oberhumer
 * For conditions of distribution and use, see copyright notice in kb.h 
 */


#include <stdio.h>
#include <stdlib.h>
#include <kb.h>
#include "_kb.h"


/***********************************************************************
// low level locking
************************************************************************/

#if defined(__DJGPP__)		/* djgpp v2 */

/* This locking code is based on work by Jonathan Paul Griffiths (JLib)
 * which itself is loosely based on work by Charles Sandman from the
 * DJGPP V2 beta 2 release of DJGPP. (file DPMIEXCP.C)
 * This software may be freely distributed, no warranty.
 */

static __inline__ int _kb_lock_mem(void *addr, long size, int do_lock)
{
	__dpmi_meminfo kb_memblock;
	u_short __kb_ds = _go32_my_ds();		/* get our ds  */

	__dpmi_get_segment_base_address(__kb_ds, &kb_memblock.address);
	kb_memblock.address += (unsigned) addr;
	kb_memblock.size = size;

	if (do_lock)
		return __dpmi_lock_linear_region(&kb_memblock);
	else
		return __dpmi_unlock_linear_region(&kb_memblock);
}

#define KB_LOCK_MEM(a,s)	_kb_lock_mem(a,s,1)
#define KB_UNLOCK_MEM(a,s)	_kb_lock_mem(a,s,0)

#endif /* __DJGPP__ */



#if defined(__WATCOMC__) && defined(__KB_MSDOS)
#if defined(__386__)

static int _kb_lock_mem(void *addr, long size, int do_lock)
{
	/* FIXME: how do we lock in DOS/4GW ? */
	/* (we do not have to lock in PMODE/W) */

	return 0;
}

#define KB_LOCK_MEM(a,s)	_kb_lock_mem(a,s,1)
#define KB_UNLOCK_MEM(a,s)	_kb_lock_mem(a,s,0)

#endif /* __386__ */
#endif /* __WATCOMC__ */


/***********************************************************************
// high level locking
************************************************************************/

int kb_lock_code(void (*start)(), void (*end)())
{
	if (start == NULL || end == NULL || start == end)
		return -1;

#if defined(KB_LOCK_MEM)
	/* warning: ANSI C forbids ordered comparisons of pointers to functions */
	{
		char *s = (char *) start;
		char *e = (char *) end;
		if (s < e)
			return KB_LOCK_MEM(s,e-s);
		else
			return KB_LOCK_MEM(e,s-e);
	}
#else
	return 0;
#endif
}


int kb_lock_var(void *addr, unsigned size)
{
	if (addr == NULL || size <= 0)
		return -1;

#if defined(KB_LOCK_MEM)
	return KB_LOCK_MEM(addr,size);
#else
	return 0;
#endif
}


/***********************************************************************
// high level unlocking
************************************************************************/

int kb_unlock_code(void (*start)(), void (*end)())
{
	if (start == NULL || end == NULL || start == end)
		return -1;

#if defined(KB_UNLOCK_MEM)
	/* warning: ANSI C forbids ordered comparisons of pointers to functions */
	{
		char *s = (char *) start;
		char *e = (char *) end;
		if (s < e)
			return KB_UNLOCK_MEM(s,e-s);
		else
			return KB_UNLOCK_MEM(e,s-e);
	}
#else
	return 0;
#endif
}


int kb_unlock_var(void *addr, unsigned size)
{
	if (addr == NULL || size <= 0)
		return -1;

#if defined(KB_UNLOCK_MEM)
	return KB_UNLOCK_MEM(addr,size);
#else
	return 0;
#endif
}



/*
vi:ts=4
*/
