/* datetime.c */

#include <stdio.h>
#include <dos.h>

#define BYTE unsigned char
#define WORD unsigned int

#include "datetime.h"

#define FALSE 0
#define TRUE !FALSE

int GetFileDT(int Handle, WORD *Date, WORD *Time)
{union REGS reg;
 reg.h.ah = 0x57;
 reg.h.al = 0x00;
 reg.x.bx = Handle;
 int86(0x21, &reg, &reg);
 *Time = reg.x.cx;
 *Date = reg.x.dx;
 if(reg.x.cflag) return FALSE;
 return TRUE;
}

int SetFileDT(int Handle, WORD Date, WORD Time)
{union REGS reg;
 reg.h.ah = 0x57;
 reg.h.al = 0x01;
 reg.x.bx = Handle;
 reg.x.cx = Time;
 reg.x.dx = Date;
 int86(0x21, &reg, &reg);
 if(reg.x.cflag) return FALSE;
 return TRUE;
}

void PackDate(BYTE Year,BYTE Month,BYTE Day,WORD *Date)
{WORD LoDate;
 WORD HiDate;
 Year -= 80;
 HiDate = 0x00ff & ((Year<<1) | (Month>>3));
 LoDate = 0x00ff & ((Month<<5) | Day);
 *Date = ((HiDate<<8) + LoDate);
}

void PackTime(BYTE Hours,BYTE Minutes,BYTE Seconds,WORD *Time)
{WORD LoTime;
 WORD HiTime;
 HiTime = 0x00ff & ((Hours<<3) | (Minutes>>3));
 LoTime = 0x00ff & ((Minutes<<5) | Seconds);
 *Time = ((HiTime<<8) + LoTime);
}

void UnpackDate(WORD Date,BYTE *Year,BYTE *Month,BYTE *Day)
{BYTE LoDate;
 BYTE HiDate;
 LoDate = 0x00ff & Date;
 HiDate = Date >> 8;
 *Year = 80 + (HiDate >> 1);
 *Month = 0x0f & ((HiDate<<3) | (LoDate>>5));
 *Day = 0x1f & LoDate;
}

void UnpackTime(WORD Time,BYTE *Hours,BYTE *Minutes,BYTE *Seconds)
{BYTE LoTime;
 BYTE HiTime;
 LoTime = 0x00ff & Time;
 HiTime = Time >> 8;
 *Hours = (HiTime >> 3);
 *Minutes = 0x3f & ((HiTime << 3) | (LoTime >> 5));
 *Seconds = 0x1f & LoTime;
}