/* Script um Areas.Temp nach Msgarea.Ctl zu konvertieren     */
/* -----------------------------------------------------     */
/* 1995 by A. Schoeller using Rexx/2 :-)       */

/* Aufbau der AREAS.TMP:         */
/* ---------------------         */
/* <group> <path> <areatag> <maxmsg> <addr> <read> <write> <number> <mtype> <desc>   */

/* 1.01 by Jens Holm                                                         */
/* Added some minor changes to the naming to ensure that the QWK part of MAX */
/* Don't screw up, done by using FE numbers to name the areas (%f in feconv) */
/* Added detecting of readonly areas if read <> write                        */
/* Added very primitive Echo/Local detecting based on group                  */
/* TODO: Determing the style (Echo, local ect) Volker please...              */
/* TODO: More intelligent readonly/writeaccess detection                     */
/* TODO: Make this  sucker run more than one area under REXX/DOS             */

/* 1.02 by Jens Holm                                                         */
/* Added simple override on areas with different read/write security         */
/* Not sure about max's reaction to this, but it seems to work here          */

/* 1.03 by Jens Holm                                                         */
/* Added mailtype (Local/Echo) Tnx for %K Volker                             */
/* Added private status on netmail, badmail ect.                             */
/* Added UGLY screen output when run, mainly for debugging purpose           */
/* Probably a bug in rexx/DOS. Anyone using personal rexx?                   */


areatmp = 'g:\fastecho\msg.tmp'
maxtmp = 'g:\max\msgarea.ctl'

'@del 'maxtmp

sollich=0
lastgroup="."
count = 1

do while Lines(areatmp)
 il = LineIn(areatmp)
 parse var il group path tag msgs addr read write number mtype desc /* JH Added Numbers and msgtype */

/* Check for Netmail, badmail and dupemail, change to local */

  if mtype = "Netmail"  then status = "pvt"     /* JH add private to 'funny types' */
  if mtype = "Badmail"  then status = "pvt"     /* JH add private to 'funny types' */
  if mtype = "Dupemail" then status = "pvt"     /* JH add private to 'funny types' */
  if mtype = "Echomail" then status = "pub"     /* JH add private to 'funny types' */
  if mtype = "Local"    then status = "pub"     /* JH add private to 'funny types' */

  if mtype = "Echomail" then msgtype = "echomail" /* JH add a maximus valid type */
  if mtype = "Local"    then msgtype = "local"    /* JH add a maximus valid type */
  if mtype = "Netmail"  then msgtype = "local"    /* JH add a maximus valid type */
  if mtype = "Dupemail" then msgtype = "local"    /* JH add a maximus valid type */
  if mtype = "Badmail"  then msgtype = "local"    /* JH add a maximus valid type */

/* Hier kann man die Securitylevel entsprechend den Maximusleveln
anpassen */
/* Leselevel           */

 if read =  "0" then readl = "Transient"
 if read =  "5" then readl = "Demoted"
 if read = "10" then readl = "Limited"
 if read = "15" then readl = "Normal"
 if read = "20" then readl = "Worthy"
 if read = "25" then readl = "Privil"
 if read = "30" then readl = "Favored"
 if read = "35" then readl = "Extra"
 if read = "40" then readl = "Clerk"
 if read = "45" then readl = "AsstSysop"
 if read = "50" then readl = "Sysop"
 if read = "100" then readl = "Sysop"
 if read = "101" then readl = "worthy/t"
 if read = "500" then readl = "Sysop"
 if read = "1000" then readl = "Sysop"

 if write =  "0" then writel = "Transient"
 if write =  "5" then writel = "Demoted"
 if write = "10" then writel = "Limited"
 if write = "15" then writel = "Normal"
 if write = "20" then writel = "Worthy"
 if write = "25" then writel = "Privil"
 if write = "30" then writel = "Favored"
 if write = "35" then writel = "Extra"
 if write = "40" then writel = "Clerk"
 if write = "45" then writel = "AsstSysop"
 if write = "50" then writel = "Sysop"
 if write = "100" then writel = "Sysop"
 if write = "101" then writel = "worthy/t"
 if write = "500" then writel = "Sysop"
 if write = "1000" then writel = "Sysop"

/* Gruppenzuweisungen an Keys         */

 if group = "A" then division = "Auto Sysop . -> Auto Add"
 if group = "B" then division = "Begr SysOp . -> Begrnset"
 if group = "C" then division = "Net238 AsstSysOp . -> Net 238 related"
 if group = "D" then division = "LOKAL Demoted . -> Lokale Bretter"
 if group = "E" then division = "Eznet Demoted . -> Eznet"
 if group = "F" then division = "Misc sysOp . -> Blandet"
 if group = "G" then division = "Elnet Demoted . -> Electronet"
 if group = "H" then division = "GAMESNET Demoted . -> Gamesnet"
 if group = "I" then division = "Int Limited . -> International"
 if group = "J" then division = "USENET Limited . -> Usenet"
 if group = "K" then division = "XNET Sysop . -> XNet"
 if group = "L" then division = "Locp AsstSysOp . -> Point's"
 if group = "M" then division = "TWINET Demoted . -> TwiNet"
 if group = "N" then division = "TWINET Demoted . -> TwiNet"
 if group = "O" then division = "FidoDk Demoted . -> FidoNet Danmark"
 if group = "P" then division = "Pirat  AsstSysOp . -> Pirat"
 if group = "Q" then division = "Point  Clerk   . -> Fidodk"
 if group = "R" then division = "Point_R/O  Demoted . -> Fidonet"
 if group = "S" then division = "SysOp SysOp  . -> SysOp"
 if group = "T" then division = "OS2 Limited . -> OS2 Net"
 if group = "U" then division = "Sat Limited . -> Satnet"
 if group = "V" then division = "Virnet Clerk   . -> Virnet"
 if group = "W" then division = "TEAMET! Clerk/T . -> Team OS/2 DK!"
 if group = "X" then division = "Local Twit . -> Local Post"
 if group = "Y" then division = "TWINET SysOp . -> TwiNet"
 if group = "Z" then division = "TWINET SysOp . -> TwiNet"

/* Boeh ,-)           */

 rdlvl = format(read)

 if lastgroup<>group then count = 1
 if lastgroup<>group & sollich<>0 then rc = LineOut(maxtmp,"MsgDivisionEnd ")
 if lastgroup<>group & sollich<>0 then rc = LineOut(maxtmp,"")
 say "Now processing:" tag status mtype msgtype division
 if lastgroup<>group then rc = LineOut(maxtmp,"MsgDivisionBegin "division)
 if lastgroup<>group then rc = LineOut(maxtmp,"")
 rc = LineOut(maxtmp," MsgArea       "number) /* JH To ensure a unique name */
 rc = LineOut(maxtmp,"     ACS       " readl)
 if readl =  writel then rc = LineOut(maxtmp,"     Style      Squish " msgtype status ) /* JH Support for diff read/write */
 if readl <> writel then rc = LineOut(maxtmp,"     Style      Squish " msgtype status "readonly ") /* JH Ditto */
 rc = LineOut(maxtmp,"     Desc      " desc)
 rc = LineOut(maxtmp,"     Tag       " tag)
 rc = LineOut(maxtmp,"     Path      " path)
 if readl <> writel then rc = LineOut(maxtmp,"     Override   Message Msg_Reply " writel) /* JH Test of Write security add */
 if readl <> writel then rc = LineOut(maxtmp,"     Override   Message Msg_Enter " writel) /* JH Ditto */
 if readl <> writel then rc = LineOut(maxtmp,"     Override   Message Msg_Upload " writel) /* JH Ditto */
 rc = LineOut(maxtmp,"     Origin    " addr addr "Online at McBears Cave, the electronic heaven") /* This one too */
 rc = LineOut(maxtmp,"     Renum Max " msgs)
 rc = LineOut(maxtmp," End MsgArea")
 rc = LineOut(maxtmp,"")
 lastgroup=group
 count = count + 1
 sollich=1
end
rc = LineOut(maxtmp,"MsgDivisionEnd")
