DECLARE SUB HELPME ()
DECLARE SUB GetExtDesc (FiletoFind$, FileNum!, OutFile!)
DECLARE SUB DoScreen (PN$, VER$)
DECLARE SUB DoHeader (HeaderFN$, OutFN!)
DECLARE FUNCTION MakeFLTime$ ()
DECLARE SUB SetConf (ConfToLookFor$, FoundCNF!)
DECLARE SUB ReadCfgFile (CFGFileName$)
DECLARE FUNCTION DARChk! (DARInt%, DARTxt$)
DECLARE FUNCTION PHan$ (StringIn$)
DECLARE SUB ChkParm (Parm$, Oper$)
DECLARE SUB SetParms (CommandLine$)
COMMON SHARED CnfDir()
DIM SHARED DSL, DAR$, OutputFile$, CFGFile$, DataDir$
DIM SHARED Conf$, AgeLimit, HeaderFile$, ProgName$, Version$
DIM SHARED FLTime$, FLDate$, ListType

'$INCLUDE: 'errorcod.bi'
ON ERROR GOTO Error.Handle

ProgName$ = "File List Generator/WWIV"
Version$ = "1.10"

DSL = 255
ListType = 1
OutputFile$ = "FILELIST.TXT"

SetParms COMMAND$
IF CFGFile$ <> "" THEN ReadCfgFile CFGFile$

TYPE uploadrec
        FileName AS STRING * 13
        Description AS STRING * 59
        UpldDate AS STRING * 9
        UpBy AS STRING * 46
        filetype AS STRING * 1
        numdloads AS INTEGER
        ownersys AS INTEGER
        ownerusr AS INTEGER
        mask AS INTEGER
        daten AS LONG
        NumBytes AS LONG
END TYPE

TYPE directoryrec
        name1 AS STRING * 41
        FileName AS STRING * 9
        Path AS STRING * 81
        DSL AS STRING * 1
        Age AS STRING * 1
        DAR AS INTEGER
        maxfiles AS INTEGER
        mask AS INTEGER
        type1 AS INTEGER
END TYPE

DoScreen ProgName$, Version$

COLOR 11
LOCATE 8, 18: PRINT "Initalize..."

DIM Js1 AS uploadrec
DIM Js2 AS directoryrec
DIM FSize AS STRING * 6
DIM DirName2 AS STRING * 8
DIM FhdrNumFile AS STRING * 4
DIM CFGPrint AS STRING * 12
DIM OUTPrint AS STRING * 45
DIM HDRPrint AS STRING * 12
DIM DDRPrint AS STRING * 56
DIM UpByOut AS STRING * 46

CFGPrint = RIGHT$(CFGFile$, 12)
OUTPrint = RIGHT$(OutputFile$, 45)
HDRPrint = RIGHT$(HeaderFile$, 12)
DDRPrint = RIGHT$(DataDir$, 56)

LOCATE 6, 10: PRINT USING "###"; DSL
LOCATE 6, 21: PRINT DAR$
LOCATE 6, 36: PRINT Conf$
LOCATE 6, 45: PRINT USING "###"; AgeLimit
LOCATE 8, 76: PRINT USING "#"; ListType

IF CFGFile$ = "" THEN
        LOCATE 6, 64: PRINT "(none)"
ELSE
        LOCATE 6, 64: PRINT CFGPrint;
END IF

LOCATE 8, 18: PRINT OUTPrint
IF HeaderFile$ = "" THEN
        LOCATE 19, 65: PRINT "(none)"
ELSE
        LOCATE 19, 65: PRINT HDRPrint;
END IF

IF DataDir$ = "" THEN
        LOCATE 23, 21: PRINT "Current Directory";
ELSE
        LOCATE 23, 21: PRINT DDRPrint$;
END IF

OPEN OutputFile$ FOR OUTPUT AS 5
OPEN DataDir$ + "DIRS.DAT" FOR RANDOM AS 4 LEN = LEN(Js2)

FLDate$ = DATE$
FLTime$ = MakeFLTime$

IF HeaderFile$ <> "" THEN DoHeader HeaderFile$, 5

EndOfDir = LOF(4) / LEN(Js2)
IF Conf$ <> "" THEN
        SetConf Conf$, Found
        IF Found THEN EndOfDir = Found
END IF

LOCATE 13, 38: PRINT USING "###"; EndOfDir

TStart& = FIX(TIMER)

FOR PDir = 1 TO EndOfDir

IF Conf$ = "" THEN
        GET #4, PDir, Js2
ELSE
        GET #4, CnfDir(PDir) + 1, Js2
END IF

IF ASC(Js2.DSL) > DSL THEN GOTO SkipDir
IF AgeLimit > 0 THEN IF AgeLimit < ASC(Js2.Age) THEN GOTO SkipDir
IF DAR$ = "" THEN
        IF Js2.DAR GOTO SkipDir
ELSE
        IF DARChk(Js2.DAR, DAR$) = 0 THEN
                GOTO SkipDir
        END IF
END IF

DirName$ = PHan$(Js2.FileName)
DirName2 = DirName$
DirDesc$ = PHan$(Js2.name1)
DirPath$ = PHan$(Js2.Path)

LOCATE 11, 16: PRINT DirDesc$ + SPACE$(40 - LEN(DirDesc$))
LOCATE 12, 15: PRINT DirPath$ + SPACE$(62 - LEN(DirPath$))
LOCATE 11, 66: PRINT DirName2
LOCATE 13, 31: PRINT USING "###"; PDir
IF Js2.mask > 64 THEN
        LOCATE 13, 15: PRINT "CD-ROM    "
ELSE
        LOCATE 13, 15: PRINT "Hard Drive"
END IF

OPEN DataDir$ + DirName$ + ".dir" FOR RANDOM AS 1 LEN = LEN(Js1)
OPEN DataDir$ + DirName$ + ".ext" FOR BINARY AS 2 LEN = 1

GET 1, 1, Js1
NumofFile& = Js1.NumBytes

LOCATE 13, 64: PRINT USING "####"; NumofFile&
LOCATE 15, 33: PRINT USING "####"; NumofFile&

FHdrText$ = PHan$(Js2.name1)
FhdrNumFile = RTRIM$(LTRIM$(STR$(NumofFile&)))

FhdrR$ = "[ " + FHdrText$ + " ]"
FHdrL$ = "[ " + RTRIM$(FhdrNumFile) + " Files ]"

PRINT #5, FhdrR$ + STRING$(79 - LEN(FhdrR$) - LEN(FHdrL$), "") + FHdrL$




FOR Z = 2 TO NumofFile& + 1

GET 1, Z, Js1

FSize = LTRIM$(STR$(FIX(Js1.NumBytes / 1024) + 1)) + "k"
OutFName$ = PHan$(Js1.FileName)
Descript$ = PHan$(Js1.Description)
UpDateOut$ = PHan$(Js1.UpldDate)

SELECT CASE ListType
CASE 1
        PRINT #5, OutFName$ + ": " + FSize + ":" + Descript$
        IF Js1.mask < -1 THEN
                GetExtDesc Js1.FileName, 2, 5
        END IF
CASE 2
        PRINT #5, OutFName$ + ": " + FSize + ":" + Descript$
        IF Js1.mask < -1 THEN
                GetExtDesc Js1.FileName, 2, 5
        END IF
        PRINT #5, SPACE$(21) + "Upld By: " + PHan$(Js1.UpBy) + "  TDL:"; Js1.numdloads
CASE 3
        PRINT #5, OutFName$ + ": " + FSize + ":" + Descript$
CASE 4
        PRINT #5, OutFName$ + ": " + FSize + ": " + UpDateOut$ + " :"; Js1.numdloads
CASE ELSE
        PRINT #5, OutFName$ + ": " + FSize + ":" + Descript$
        IF Js1.mask < -1 THEN
                GetExtDesc Js1.FileName, 2, 5
        END IF
END SELECT

FileCnt& = FileCnt& + 1
LOCATE 19, 32: PRINT USING "###,###"; FileCnt&
KBCount& = KBCount& + FIX(Js1.NumBytes / 1024)
KBDirCnt = KBDirCnt + FIX(Js1.NumBytes / 1024)
LOCATE 20, 36: PRINT USING "##,###,###"; KBCount&

IF TIMER >= TStart& THEN
        LOCATE 18, 33: PRINT USING "###.###"; FileCnt& / (TIMER - TStart&)
ELSE
        LOCATE 18, 33: PRINT USING "###.###"; FileCnt& / ((TIMER + 86400) - TStart&)
END IF

LOCATE 21, 66: PRINT USING "###,### bytes"; FRE(-1)

LOCATE 15, 25: PRINT USING "####"; Z - 1

LOCATE 15, 45: PRINT USING "##,###"; FIX(Js1.NumBytes / 1024)
LOCATE 15, 65: PRINT Js1.UpldDate
LOCATE 15, 11: PRINT OutFName$
LOCATE 16, 18: PRINT Descript$ + SPACE$(59 - LEN(Descript$))

LOCATE 2, 3: PRINT DATE$
LOCATE 3, 3: PRINT TIME$

'----Early Exit----
IF INKEY$ = CHR$(27) THEN
        FFtr$ = "[ " + RTRIM$(FhdrNumFile) + " Files Totaling " + LTRIM$(STR$(KBDirCnt)) + "k ]"
        PRINT #5, FFtr$ + STRING$(79 - LEN(FFtr$), "")
        PRINT #5, ""
        PRINT #5, "File List Generation ABORTED!"
        PRINT #5, ""
        PRINT #5, "File List Generated on " + FLDate$ + " at " + FLTime$ + " by " + ProgName$ + " v" + Version$
        FFtr$ = "[ " + LTRIM$(STR$(FileCnt&)) + " Files Totaling " + LTRIM$(STR$(KBCount&)) + "k ]"
        PRINT #5, FFtr$ + STRING$(79 - LEN(FFtr$), "")
        CLOSE
        EndTime& = TIMER
        CLS
        COLOR 7
        PRINT "Partial File Listing " + OutputFile$ + " Created!": PRINT
        IF EndTime& > TStart& THEN
                PRINT "TRT:"; EndTime& - TStart&; "Seconds": PRINT
        ELSE
                PRINT "TRT:"; (EndTime& + 86400) - TStart&; "Seconds": PRINT
        END IF
        PRINT "Run ABORTED, Goodbye!": PRINT
        END
END IF

NEXT Z


CLOSE 1: CLOSE 2
FFtr$ = "[ " + RTRIM$(FhdrNumFile) + " Files Totaling " + LTRIM$(STR$(KBDirCnt)) + "k ]"
PRINT #5, FFtr$ + STRING$(79 - LEN(FFtr$), "")
PRINT #5, ""
KBDirCnt = 0

SkipDir:
NEXT PDir

PRINT #5, "File List Generated on " + FLDate$ + " at " + FLTime$ + " by " + ProgName$ + " v" + Version$
FFtr$ = "[ " + LTRIM$(STR$(FileCnt&)) + " Files Totaling " + LTRIM$(STR$(KBCount&)) + "k ]"
PRINT #5, FFtr$ + STRING$(79 - LEN(FFtr$), "")

CLOSE
EndTime& = TIMER
CLS
COLOR 7
PRINT "File Listing " + OutputFile$ + " Created!": PRINT
IF EndTime& > TStart& THEN
        TS& = EndTime& - TStart&
ELSE
        TS& = (EndTime& + 86400) - TStart&
END IF
TM& = FIX(TS& / 60)
IF TM& THEN TS& = TS& - (TM& * 60)
PRINT "TRT: "; TM&; "Minutes,"; TS&; "Seconds": PRINT
PRINT "Run Sucessful, Goodbye!": PRINT
END

'---------------Error Handler v2.0
Error.Handle:
COLOR 7, 0
CLS
PRINT "A unrecoverable error #" + LTRIM$(STR$(ERR)) + " ("; ErrorCode$(ERR) + ")" + " has happened!"
PRINT "Please Contact James Songer for assistance."
PRINT
PRINT "Program Terminated With Errors!"
END

SUB ChkParm (Parm$, Oper$)
Parm$ = UCASE$(LTRIM$(RTRIM$(Parm$))): Oper$ = UCASE$(LTRIM$(RTRIM$(Oper$)))
SELECT CASE Parm$
        CASE "DSL"
                DSL = VAL(Oper$)
        CASE "DAR"
                DAR$ = Oper$
        CASE "OUT"
                OutputFile$ = Oper$
        CASE "CFG"
                CFGFile$ = Oper$
        CASE "CONF"
                Conf$ = Oper$
        CASE "AGE"
                AgeLimit = VAL(Oper$)
        CASE "LISTTYPE"
                ListType = VAL(Oper$)
        CASE "HEADER"
                HeaderFile$ = Oper$
        CASE "DATADIR"
                IF RIGHT$(Oper$, 1) = "\" THEN
                        DataDir$ = Oper$
                ELSE
                        DataDir$ = Oper$ + "\"
        END IF
        CASE "HELP"
                HELPME
        CASE "?"
                HELPME
END SELECT
END SUB

FUNCTION DARChk (DARInt%, DARTxt$)
DarTmp% = DARInt%

IF DarTmp% < 0 THEN DarTmp% = DarTmp% + 32768: DAR = 16
FOR A = 14 TO 0 STEP -1
        IF DarTmp% >= 2 ^ A THEN
                DarTmp% = DarTmp% - 2 ^ A: DAR = A + 1
        END IF
NEXT A

DarTmp% = ASC(DARTxt$) - 64

IF DAR = 0 THEN DARChk = 1
IF DAR = DarTmp% THEN DARChk = 1

END FUNCTION

SUB DoHeader (HeaderFN$, OutFN)
FF = FREEFILE
OPEN HeaderFN$ FOR INPUT AS FF
WHILE NOT EOF(FF)
LINE INPUT #FF, A$
B = INSTR(A$, "@@TIME@@")
IF B THEN
        A$ = LEFT$(A$, B - 1) + FLTime$ + RIGHT$(A$, LEN(A$) - B - 7)
        B = 0
END IF
B = INSTR(A$, "@@@DATE@@@")
IF B THEN
        A$ = LEFT$(A$, B - 1) + FLDate$ + RIGHT$(A$, LEN(A$) - B - 9)
        B = 0
END IF
PRINT #OutFN, A$
WEND
CLOSE FF
END SUB

SUB DoScreen (PN$, VER$)
CLS : COLOR 2
PRINT "ͻ"
PRINT "                        "; : COLOR 12: PRINT PN$ + " v" + VER$; : COLOR 2: PRINT "                        "
PRINT "                               "; : COLOR 12: PRINT "By: James Songer"; : COLOR 2: PRINT "                               "
PRINT "Ķ"
PRINT " Ŀ "
PRINT "  "; : COLOR 3: PRINT "DSL="; : COLOR 2: PRINT "      "; : COLOR 3: PRINT "DAR="; : COLOR 2: PRINT "    "; : COLOR 3: PRINT "Confrence="; : COLOR 2: PRINT "    ";
COLOR 3: PRINT "Age="; : COLOR 2: PRINT "      "; : COLOR 3: PRINT "Config File:"; : COLOR 2: PRINT "                "
PRINT " Ĵ "
PRINT "  "; : COLOR 3: PRINT "Output File:"; : COLOR 2: PRINT "                                              "; : COLOR 3: PRINT " List Type: "; : COLOR 2: PRINT "   "
PRINT "  "
PRINT " Ŀ "
PRINT " "; : COLOR 3: PRINT " Directory:                                           Dir FN:             "; : COLOR 2: PRINT " "
PRINT " "; : COLOR 3: PRINT " Dir Path:                                                                "; : COLOR 2: PRINT " "
PRINT " "; : COLOR 3: PRINT " Dir Type:             Dir     of      Num of Files in Dir:               "; : COLOR 2: PRINT " "
PRINT " Ĵ "
PRINT " "; : COLOR 3: PRINT " File:              (     of     )  Size       K  Upld Date:              "; : COLOR 2: PRINT " "
PRINT " "; : COLOR 3: PRINT " Description:                                                             "; : COLOR 2: PRINT " "
PRINT "  "
PRINT " "; : COLOR 3: PRINT " Files Per Second Processed:                "; : COLOR 2: PRINT " Ŀ "
PRINT " "; : COLOR 3: PRINT " Number of Files Processed:                 "; : COLOR 2: PRINT "  "; : COLOR 3: PRINT "Header File:              "; : COLOR 2: PRINT " "
PRINT " "; : COLOR 3: PRINT " Total Size of Processed Files:           K "; : COLOR 2: PRINT "  "
PRINT "  "; : COLOR 12: PRINT "ESC to Abort!"; : COLOR 2: PRINT "                 "
PRINT " Ŀ "
LOCATE 23, 1: PRINT " "; : COLOR 3: PRINT " Data Directory:                                                          "; : COLOR 2: PRINT " ";
LOCATE 24, 1: PRINT "  ";
LOCATE 25, 1: PRINT "ͼ";
END SUB

SUB GetExtDesc (FiletoFind$, FileNum, OutFile)
SEEK #FileNum, 1
ReDo:
A$ = INPUT$(13 + 2, #FileNum)
IF EOF(FileNum) THEN GOTO EndRtn:

B$ = LEFT$(A$, 12): D = CVI(RIGHT$(A$, 2))

IF LEFT$(FiletoFind$, 12) = B$ THEN
        Desc$ = INPUT$(D, #FileNum)
        FOR A = 1 TO LEN(Desc$)
                SELECT CASE MID$(Desc$, A, 1)
                        CASE CHR$(0)
                                EXIT FOR
                        CASE CHR$(13)
                                PRINT #OutFile, SPACE$(21) + FixedDesc$: FixedDesc$ = ""
                        CASE CHR$(10)
                        CASE ELSE
                                FixedDesc$ = FixedDesc$ + MID$(Desc$, A, 1)
                        END SELECT
        NEXT A
ELSE
        SEEK FileNum, LOC(FileNum) + D + 1
        GOTO ReDo:
END IF
EndRtn:
END SUB

SUB HELPME
CLS
COLOR 2
PRINT "ͻ"
PRINT "                        "; : COLOR 12: PRINT ProgName$ + " v" + Version$; : COLOR 2: PRINT "                        "
PRINT "                               "; : COLOR 12: PRINT "By: James Songer"; : COLOR 2: PRINT "                               "
PRINT "Ķ"
PRINT " Help Requested!                                                              "
PRINT "                                                                              "
PRINT "  "; : COLOR 11: PRINT "/DSL=nnn              "; : COLOR 3: PRINT "DSL To Print Files For (ex 95)                        "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/DAR=x                "; : COLOR 3: PRINT "DAR To Print Files For (ex A)                         "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/CONF=x               "; : COLOR 3: PRINT "Confrence To Print Files For (ex W)                   "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/AGE=nn               "; : COLOR 3: PRINT "Minimum Age of DIR Access (ex 18)                     "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/LISTTYPE=n           "; : COLOR 3: PRINT "What List Type To Print (1 to 4)                      "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/OUT=filename         "; : COLOR 3: PRINT "File Name to Output File List To (Include Path)       "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/CFG=filename         "; : COLOR 3: PRINT "CFG File To Use (Include Path)                        "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/HEADER=filename      "; : COLOR 3: PRINT "Header File To Use (See Doc For Info)                 "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/DATADIR=path         "; : COLOR 3: PRINT "Location of Data Dir (Path Only ex D:\BBS\DATA)       "; : COLOR 2: PRINT ""
PRINT "  "; : COLOR 11: PRINT "/HELP or /?           "; : COLOR 3: PRINT "You are reading it!                                   "; : COLOR 2: PRINT ""
PRINT "Ķ"
PRINT " These switches (Minus the /) are used in the CFG file.                       "
PRINT "ͼ";
END
END SUB

FUNCTION MakeFLTime$
A$ = TIME$
C = VAL(LEFT$(A$, 2))
D$ = MID$(A$, 4, 2)
IF C > 12 THEN
        B$ = "0" + LTRIM$(STR$(C - 12)) + ":" + D$ + " pm"
ELSE
        IF C = 0 THEN C = 12
        B$ = "0" + LTRIM$(STR$(C)) + ":" + D$ + " am"
END IF
IF LEN(B$) = 9 THEN B$ = RIGHT$(B$, 8)
MakeFLTime$ = B$
END FUNCTION

FUNCTION PHan$ (StringIn$)
Js1AA$ = StringIn$
IF INSTR(Js1AA$, CHR$(0)) THEN Js1AA$ = LEFT$(StringIn$, INSTR(StringIn$, CHR$(0)) - 1)
IF INSTR(Js1AA$, CHR$(13)) THEN Js1AA$ = LEFT$(Js1AA$, INSTR(Js1AA$, CHR$(13)) - 1)
IF INSTR(Js1AA$, CHR$(10)) THEN Js1AA$ = LEFT$(Js1AA$, INSTR(StringIn$, CHR$(10)) - 1)
PHan$ = Js1AA$
END FUNCTION

SUB ReadCfgFile (CFGFileName$)
A = FREEFILE
OPEN CFGFileName$ FOR INPUT AS A
WHILE NOT EOF(A)
LINE INPUT #A, B$
C$ = UCASE$(B$)
D = INSTR(1, C$, "=")
IF D > 0 THEN
        ChkParm LEFT$(C$, D - 1), RIGHT$(C$, LEN(C$) - D)
ELSE
        ChkParm C$, ""
END IF

WEND
CLOSE A
END SUB

SUB SetConf (ConfToLookFor$, FoundCNF)
FF = FREEFILE
OPEN DataDir$ + "Dirs.cnf" FOR INPUT AS FF

WHILE NOT EOF(FF)
StartSCnf:
LINE INPUT #FF, A$
IF LEFT$(A$, 1) <> "~" THEN GOTO StartSCnf
LINE INPUT #FF, B$
LINE INPUT #FF, C$
LINE INPUT #FF, jnk$
CnfDsg$ = MID$(A$, 2, 1)
CnfName$ = RIGHT$(A$, LEN(A$) - 3)
IF ConfToLookFor$ = CnfDsg$ THEN GOTO NSSCnf
WEND
FoundCNF = 0
GOTO EndSC

NSSCnf:

IF LTRIM$(RTRIM$(C$)) = "@" THEN GOTO EndSC

FOR Z = 1 TO LEN(C$)
        IF MID$(C$, Z, 1) = " " THEN NumDir = NumDir + 1
NEXT Z

DIM CnfDir(NumDir)

D$ = RIGHT$(C$, LEN(C$) - 1)

FOR Z = 1 TO NumDir
        ZZ = INSTR(D$, " ")
        CnfDir(Z) = VAL(LEFT$(D$, ZZ))
        D$ = RIGHT$(D$, LEN(D$) - ZZ)
NEXT Z

CLOSE FF

EndSC:
FoundCNF = NumDir
END SUB

SUB SetParms (CommandLine$)

FOR A = 1 TO LEN(CommandLine$)
IF MID$(CommandLine$, A, 1) = "-" THEN
        CommandLine$ = LEFT$(CommandLine$, A - 1) + "/" + RIGHT$(CommandLine$, LEN(CommandLine$) - A)
END IF
NEXT A

CommandLine2$ = CommandLine$
Delim$ = "/"
LoopItA:
A = INSTR(1, CommandLine2$, Delim$)
IF A > 0 THEN
        B = INSTR(A + 1, CommandLine2$, Delim$)
        IF B = 0 THEN
                C$ = MID$(CommandLine2$, A + 1)
        ELSE
                C$ = MID$(CommandLine2$, A + 1, B - A - 1)
        END IF
        D = INSTR(1, C$, "=")
        IF D > 0 THEN
                ChkParm LEFT$(C$, D - 1), RIGHT$(C$, LEN(C$) - D)
        ELSE
                ChkParm C$, ""
        END IF
        IF B = 0 THEN
                CommandLine2$ = ""
        ELSE
                CommandLine2$ = RIGHT$(CommandLine2$, LEN(CommandLine2$) - B + 1)
        END IF
        GOTO LoopItA
END IF
END SUB

