(* TriBBS Pascal API Include File
   Header Definitions and Constants *)

type
  SYSTEMDATABITFIELDS = (PhoneNumberFlag,TestUploadsFlag,AutoANSIDetectFlag,
  CheckforWaitingMessagesFlag,ULDLRatioTypeFlag,
  PhoneOnHookDuringMaintenceFlag,NoOneWordNamesFlag,
  NoBulletinMenuAtLogonFlag,AllowAliasesFlag,ClearScreenBeforeMenusFlag,
  ExactFileNameMatchingForDupesFlag,DisableNewUserBirthdayPromptFlag,
  DisableDetailedCallersLogFlag,EnableRipScripEmulationFlag,UseAliasorRealNamesFlag,
  ClearUploadsandDownloadsFlag,ClearPrivateMessageAreasFlag,
  ClearPrivateFileAreasFlag,DisableUploadedByFlag,SD1LastBit);
type
  SYSDAT1DATA = record
  registerationcode : array[0..80] of char;
  boardname : array[0..40] of char;
  sysopname : array[0..60] of char;
  DefaultArchiveExtension : array[0..3] of char;
  SystemPassword : array[0..15] of char;
  VirusCheckerCommandLine : array[0..80] of char;
  ZIPCompressCommandLine : array[0..80] of char;
  ZIPUnCompressCommandLine : array[0..80] of char;
  ARJCompressCommandLine : array[0..80] of char;
  ARJUnCompressCommandLine : array[0..80] of char;
  LZHCompressCommandLine : array[0..80] of char;
  LZHUnCompressCommandLine : array[0..80] of char;
  ARCCompressCommandLine : array[0..80] of char;
  ARCUnCompressCommandLine : array[0..80] of char;
  PAKCompressCommandLine : array[0..80] of char;
  PAKUnCompressCommandLine : array[0..80] of char;
  SDNCompressCommandLine : array[0..80] of char;
  SDNUnCompressCommandLine : array[0..80] of char;
  RARCompressCommandLine : array[0..80] of char;
  RARUnCompressCommandLine : array[0..80] of char;
  BoardStartDate : array[0..8] of char;
  TotalNodes : word;
  CallsToday : word;
  MessagesToday : word;
  UploadsToday : word;
  DownloadsToday : word;
  DefaultDailyTimeLimit : word;
  DefaultDailyLogons : word;
  DefaultTimePerLogon : word;
  MinimumSysopSecurityLevel : word;
  NewUserSecurityLevel : word;
  NewUserTimeLimit : word;
  UploadTimeCompensationRation : word;
  MinimumFileAttachmentSecuritylevel : word;
  MinimumAtVariableSecurityLevel : word;
  FastLogonSecurityLevel : word;
  TotalCalls : longint;
  bitfields : array[0..9] of byte;
  reserveddataarea : array[0..2624] of char;
end; {SYSDAT1.DAT}

type
  SYSDAT2DATA = record
   Node1sMainDirectory : array[0..80] of char;
   ReservedDataArea : array[0..174] of char;
end; {SYSDAT2.DAT}

type
  NODEDATABITFIELD = (No300BaudCallersFlag, No1200BaudCallersFlag,
  No2400BaudCallersFlag,RTSCTSHandShakingFlag,LockSerialPortFlag,
  DirectScreenWriteFlag, PageBellOnFlag,UseNodeDisplayDirectoryFlag,
  PhoneOffHookDuringEventsFlag,EnableLocalRIPScripEmulationFlag,
  UseFossilDriverFlag, NDLastBit);
type
  NODEDATA = record
  initializationstring : array[0..80] of char;
  errorcorrectingconnectionmessage : array[0..4] of char;
  ATZString : array[0..15] of char;
  ATAString : array[0..15] of char;
  ATH0String: array[0..15] of char;
  ATH1String: array[0..15] of char;
  DateofLastCall : array[0..8] of char;
  NodeNumber : word;
  SerialPort : word;
  DelayBeforeATA : word;
  NumberofRings: word;
  NodeSecurityLevel : word;
  MaximumKeyBoardIdleTime : word;
  NonStandardIRQNumber : word;
  DelayAfterCONNECT : word;
  MaximumBaudRate : longint;
  bitfields : array[0..9] of byte;
  reserveddataarea : array[0..3906] of char;
end; {NODE.DAT}

type
  USERDATABITFIELD  = (LockedOutFlag,MarkedForDeletionFlag,
  IncludeLOGON1InQWKFlag,IncludeGOODBYEInQWKFlag,IncludeBulletinsInQWKFlag,
  IncludeNewFilesinQWKFlag,IncludeNewsLetterInQWKFlag,
  CheckWaitingMessagesFlag,GoodbyeAfterUploadFlag,
  AttachedFilesinQWKFlag,UDLastBit);

type USERSDATA = record
  name : array[0..60] of char;
  alias: array[0..60] of char;
  password : array[0..15] of char;
  streetaddress1 : array[0..40] of char;
  streetaddress2 : array[0..40] of char;
  city   : array[0..30] of char;
  state : array[0..30] of char;
  country : array[0..30] of char;
  zipcode : array[0..10] of char;
  phonenumber : array[0..30] of char;
  birthday : array[0..8] of char;
  DateofFirstCall : array[0..8] of char;
  DateofLastFileCheck : array[0..8] of char;
  SubscriptionExpirationDate : array[0..8] of char;
  DateAndTimeofLastCall : array[0..14] of char;
  ExpertMode : word;
  SecurityLevel : word;
  NumberofCalls : word;
  TimeLeftforToday : word;
  LastMessageConference : word;
  LastFileArea : word;
  DefaultProtocal : word;
  NumberofCallsToday : word;
  QWKNetworkNode : word;
  DefaultEditor : word;
  InitialChatstatus : word;
  NumberofFilesDownloadedToday : word;
  ArchiveUsedInQWK : word;
  NumberofFilesUploaded : longint;
  NumberofFilesDownloaded : longint;
  NumberofKBytesUploaded : longint;
  NumberofKBytesDownloaded : longint;
  NumberofMessagesPosted : longint;
  NumberofBytesDownloadedToday : longint;
  networkflags : array[0..1] of byte;
  bitfields    : array[0..9] of byte;
  ReservedDataArea : array[0..555] of byte;
end;

type
 USERSINDEXFILES = (Users, Alias);

type
  USERSINDEX = record
  Name : array[0..60] of char;
  RecordNumber : longint;
end;
type
 USERSUPMESSAGESBITFIELDS = ( AccessPrivateConferenceFlag,CoSysopStatusFlag,
 USMLastBit);

type
 USERSSUPMESSAGES = record
  lastmessageread : longint;
  lastwaitingmessageread: longint;
  waitingmessagecounter : word;
  queuedconference : word;
  bitfields : byte;
end;

type
  USERMSGPTR = ^userssupmsglist;
  userssupmsglist = record
  msgs            : userssupmessages;
  next            : usermsgptr;
end; {Linked List}

type
  USERSUPFILEBITFIELDS = (AccessPrivateAreaFlag, USFLastBit);

type
  USERSSUPFILES = record
   bitfields  : byte;
end;
type
  USERFILEPTR = ^USERSSUPFILELIST;
  USERSSUPFILELIST = record
  files        : USERSSUPFILES;
  next         : USERFILEPTR;
end;
type
 MCONFDATABITFIELDS = (NetworkedConferenceFlag,PrivateConferenceFlag,
 FidoStyleNetMailFlag, AliasConferenceFlag,UserDeleteFlag,TriPackBackupFlag,
 DisablePrivateMessagesFlag,DisablePublicMessagesFlag,MCLastBit);

type
  MCONFDATA = record
  name : array[0..40] of char;
  readsecuritylevel : word;
  postsecuritylevel : word;
  TriPackNumberofDaysToSave : word;
  HighestMessageNumber : longint;
  NetworkFlags : array[0..1] of byte;
  BitFields : array[0..9] of byte;
  ReservedDataAreas : array[0..960] of char;
end;
type
  NETWORKDATA = record
  Name : array[0..40] of char;
  ReservedDataArea : array[0..214] of char;
end;
type
 MHDRDATABITFIELDS = (EchoMessageFlag,ThreadedMessageFlag,PrivateMessageFlag,
 DeletedMessageFlag,RecievedMessageFlag,PermanentMessageFlag,TriTossEchoFlag,
 MHLastBit);

type
  MHDRDATA = record
  from : array[0..60] of char;
  towhom : array[0..60] of char;
  subject : array[0..60] of char;
  nameofattachedfile : array[0..80] of char;
  dateandtime : array[0..14] of char;
  netmailfromzone : word;
  netmailfromnet : word;
  netmailfromnode : word;
  netmailfrompoint :word;
  netmailtozone : word;
  netmailtonet : word;
  netmailtonode : word;
  netmailtopoint : word;
  offsetintotextfile : longint;
  messagelength : longint;
  Number : longint;
  NumberofMessageThisRepliesTo : longint;
  FromHash,ToHash : longint;
  BitField : array[0..9] of byte;
  ReservedDataArea : array[0..694] of char;
end;

type
  FAREADATABITFIELDS = (PrivateAreaFlag,CDROMFileAreaFlag,
  AliasAreaFlag,FADLastBit);

type
   FAREADATA = record
   name   : array[0..40] of char;
   fileareapath : array[0..80] of char;
   fileareauploadpath : array[0..80] of char;
   fileareafilelist : array[0..80] of char;
   fileareauploadlist : array[0..80] of char;
   fileareaindexfile : array[0..80] of char;
   additionalfileareapaths : array[1..10,0..80] of char;
   securitylevel     : word;
   viewsecuritylevel : word;
   sorttype          : word;
   bitfields          : array[0..9] of byte;
   reserveddataarea  : array[0..2823] of char;
end;

type
 DOORSTMPDATAFLAG = (ANSIFlag,FrontEndFlag,FrontEndHangUpFlag,UserWindowFlag,
 ChatRequestedFlag,EventPendingFlag,GoodByeFromDoorFlag,ForceBoardDownAfterCallFlag,
 RIPScripFlag,DoorSYSFlag,ErrorCorrectingConnectionFlag,DTLastBit);
type
 DOORSTMPDATA = record
 TimeLeftAtLogon : word;
 CurrentFileArea : word;
 CurrentMessageArea : word;
 FrontEndTime : word;
 WhereTheDoorWasCalledFrom : word;
 LanguageNumber: word;
 NumberofFilesFlagged : word;
 TimeinDoorSys : word;
 UserRecordNumber : longint;
 BaudRate : longint;
 FrontEndBaudRate : longint;
 TimeWhenUserLoggedOn : longint;
 bitfield : array[0..9] of byte;
end;

type
 WHOSONDATA = record
  name  : array[0..60] of char;
  chatbuffer : array[0..1023] of char;
  chatstatus : word;
  nodechattingwith : word;
  head,tail : word;
  ReservedDataArea : array[0..3002] of char;
end;

type
  EVENTSDATABITFIELDS = (EventExecutedTodayFlag,SlidingEventFlag, EDLastBit);
type
 EVENTSDATA = record
  time : array[0..5] of char;
  FileName : array[0..12] of char;
  Day : word;
  BitFields : byte;
  ReservedDataArea :array[0..233] of char;
end;