(*
   TBAPI For TriBBS 10.0 / TriBBS/Pro 10.0
   Copyright 1995 ProSoft Productions   *)

unit tbapi;

interface
{$I TBAPI.INC}

{Misc Variables - Global}
var
TBIOError : word;
TBISShare : boolean;
TBNode1sMainDirectory,
TBNodesMainDirectory : string[80];
TBNumberofMessageAreas,TBNumberofFileAreas : word;
type
  txtarray = array[1..64000] of char;

{Generic Data Object for Opening Files}
type DATAFILE = object
    openflag  : boolean;
    openfile  : file;
    filename  : string[80];
    procedure open(s : string);
    procedure closefile;
    procedure dread(n,size : longint;var data);
    procedure dwrite(n,size : longint;var data);
    procedure seekfile(n : longint);
    function length(size : longint) : longint;
    procedure add(size : longint;var data);
    function recordnumber (size :longint): longint;
    procedure error(s : string;i : word);
end;
type
  SYSDAT2_DAT = object
  private
  SYSDAT2_DATA : SYSDAT2DATA;
  SYSDAT2_FILE : DATAFILE;
  public
  procedure open;
  procedure closefile;
  procedure read;
  procedure write;
  procedure openread;
  procedure writeclose;
  procedure openreadclose;
  procedure openwriteclose;
  procedure clearit;
  function length : longint;
  procedure set_Node1sMainDirectory (s : string);
  function get_Node1sMainDirectory : string;
end;

type
   USER_DAT = object
   private
   USER_DATA : USERSDATA;
   USER_FILE : DATAFILE;
   public
    procedure open;
    procedure closefile;
    procedure read(n : longint);
    procedure write(n : longint);
    function length : longint;
    procedure openread(n : longint);
    procedure writeclose(n : longint);
    procedure openreadclose(n : longint);
    procedure openwriteclose(n: longint);
    procedure clearit;
    procedure set_name (  s : string);
    function get_name : string;
    procedure set_alias( s: string);
    function get_alias : string;
    procedure set_password(s: string);
    function get_password : string;
    procedure set_streetaddress1 ( s: string);
    function get_streetaddress1 : string;
    procedure set_streetaddress2 ( s: string);
    function get_streetaddress2 : string;
    procedure set_city ( s: string);
    function get_city : string;
    procedure set_state (s : string);
    function get_state : string;
    procedure set_country (s : string);
    function get_country : string;
    procedure set_zipcode (s : string);
    function get_zipcode : string;
    procedure set_phonenumber(s : string);
    function get_phonenumber : string;
    procedure set_birthday (s : string);
    function get_birthday : string;
    procedure set_dateoffirstcall (s:string);
    function get_dateoffirstcall : string;
    procedure set_dateoflastfilecheck (s:string);
    function get_dateoflastfilecheck : string;
    procedure set_SubscriptionExpirationDate (s:string);
    function get_subscriptionExpirationDate : string;
    procedure set_DateandTimeofLastCall ( s: string);
    function get_DateandTimeofLastCall : string;
    procedure set_expertmode (n : word);
    function get_expertmode : word;
    procedure set_Securitylevel (n :word);
    function get_SecurityLevel : word;
    procedure set_NumberofCalls ( n : word);
    function get_NumberofCalls : word;
    procedure set_TimeLeftForToday (n : word);
    function get_timeleftfortoday : word;
    procedure set_LastMessageConference (n : word);
    function get_lastmessageconference : word;
    procedure set_LastFileArea (n : word);
    function get_lastfilearea : word;
    procedure set_DefaultProtocal( n: word);
    function get_defaultprotocal : word;
    procedure set_NumberofCallsToday (n :word);
    function get_numberofcallstoday : word;
    procedure set_DefaultEditor (n : worD);
    function get_defaultEditor : word;
    procedure set_InitialChatStatus(n : word);
    function get_initialchatstatus : word;
    procedure set_numberoffilesdownloadedtoday (n : word);
    function get_numberoffilesdownloadedtoday : word;
    procedure set_archiveusedinqwk (n : word);
    function get_archiveusedinqwk : word;
    procedure set_numberoffilesuploaded (n : longint);
    function get_numberoffilesuploaded : longint;
    procedure set_numberoffilesdownloaded (n : longint);
    function get_numberoffilesdownloaded : longint;
    procedure set_numberofkbytesuploaded (n : longint);
    function get_numberofkbytesuploaded : longint;
    procedure set_numberofkbytesdownloaded (n : longint);
    function get_numberofkbytesdownloaded : longint;
    procedure set_numberofmessagesposted (n: longint);
    function get_numberofmessagesposted : longint;
    procedure set_numberofbytesdownloadedtoday (n : longint);
    function get_numberofbytesdownloadedtoday : longint;
    procedure set_network(n : word;b : boolean);
    function get_network( n : word) : boolean;
    procedure set_lockedout (n : boolean);
    function get_lockedout : boolean;
    procedure set_markedfordeletion (n : boolean);
    function get_markedfordeletion : boolean;
    procedure set_includelogon1inqwk (n:boolean);
    function get_includelogon1inqwk : boolean;
    procedure set_includegoodbyeinqwk ( n:boolean);
    function get_includegoodbyeinqwk : boolean;
    procedure set_includebulletinsinqwk (n : boolean);
    function get_includebulletinsinqwk : boolean;
    procedure set_includenewfilesinqwk (n : boolean);
    function get_includenewfilesinqwk : boolean;
    procedure set_checkforwaitingmessages (n : boolean);
    function get_checkforwaitingmessages : boolean;
    procedure set_goodbyeafterupload (n : boolean);
    function get_goodbyeafterupload : boolean;
    procedure set_attachedfilesinqwk (n : boolean);
    function get_attachedfilesinqwk : boolean;
end;

type
  USERS_IDX = object
  private
  USERSIDX_DATA : USERSINDEX;
  USERSIDX_FILE : DATAFILE;
  public
  procedure open(w: word);
  procedure closefile;
  procedure read(n : word);
  procedure write(n : word);
  function length : word;
  procedure openread(w,n : word);
  procedure openwriteclose(w,n : word);
  procedure openreadclose(w,n : word);
  procedure openwrite(w,n : word);
  function recordnumber : longint;
  procedure search( s : string);
  procedure replace(s,n : string);
  procedure set_name (n : string);
  function get_name : string;
  procedure set_recordnumber ( n: word);
  function get_recordnumber : word;

end;
type
  USERS_SPM = object
  private
   USERSM_FILE : DATAFILE;
   USERSM_HEADER : USERMSGPTR;
   USERSM_DATA    : USERSSUPMESSAGES;
   procedure additem;
   procedure deletelist;
  public
   procedure getconference(c : longint);
   procedure setconference(c : longint);
   procedure open;
   procedure closefile;
   procedure read(n : longint);
   procedure write(n : longint);
   function length : longint;
   procedure openread(n : longint);
   procedure writeclose(n : longint);
   procedure openreadclose(n : longint);
   procedure openwriteclose(n: longint);
   procedure set_lastmessageread (n : longint);
   function get_lastmessageread : longint;
   procedure set_waitingmessagecounter ( n: word);
   function get_waitingmessagecounter : word;
   procedure set_queuedconference (n : word);
   function get_queuedconference : word;
   procedure set_accessprivateconference (b : boolean);
   function get_accessprivateconference : boolean;
   procedure set_cosysopstatus (b : boolean);
   function get_cosysopstatus : boolean;
end;

type
  USERS_SPF = object
   private
   USERSF_DATA : USERSSUPFILES;
   USERSF_FILE : DATAFILE;
   USERSF_HEADER : USERFILEPTR;
   procedure additem;
   procedure deletelist;
   public
   procedure getconference (i : word);
   procedure setconference(i : word);
   procedure open;
   procedure closefile;
   procedure read(n : longint);
   procedure write(n : longint);
   function length : longint;
   procedure openread(n : longint);
   procedure writeclose(n : longint);
   procedure openreadclose(n : longint);
   procedure openwriteclose(n: longint);
   procedure set_accessprivatearea ( b : boolean);
   function get_accessprivatearea : boolean;
end;
type
  MCONF_DAT = object
  private
  MCONF_DATA : MCONFDATA;
  MCONF_FILE : DATAFILE;
  public
    procedure open;
    procedure closefile;
    procedure read(n : longint);
    procedure write(n : longint);
    function length : longint;
    procedure openread(n : longint);
    procedure writeclose(n : longint);
    procedure openreadclose(n : longint);
    procedure openwriteclose(n: longint);
    procedure clearit;
    procedure set_name (  s : string);
    function get_name : string;
    procedure set_readsecuritylevel (n : word);
    function get_readsecuritylevel : word;
    procedure set_postsecuritylevel (n : word);
    function get_postsecuritylevel : word;
    procedure set_tripacknumberofdaystosave (n: word);
    function get_tripacknumberofdaystosave : word;
    procedure set_highestmessagenumber (n : longint);
    function get_highestmessagenumber : longint;
    procedure set_network(n : word;b: boolean);
    function get_network( n: word) : boolean;
    procedure set_networkedconference (b : boolean);
    function get_networkedconference : boolean;
    procedure set_privateconference (b : boolean);
    function get_privateconference : boolean;
    procedure set_fidostylenetmail (b : boolean);
    function get_fidostylenetmail : boolean;
    procedure set_aliasconference (b : boolean);
    function get_aliasconference : boolean;
    procedure set_userdelete(b : boolean);
    function get_userdelete : boolean;
    procedure set_tripackbackup ( b : boolean);
    function get_tripackbackup : boolean;
    procedure set_disableprivatemessages (b : boolean);
    function get_disableprivatemessages : boolean;
    procedure set_disablepublicmessages(b: boolean);
    function get_disablepublicmessages: boolean;
  end;

type
   NETWORK_DAT = object
    private
    NETWORK_DATA : NETWORKDATA;
    NETWORK_FILE : DATAFILE;
    public
    procedure open;
    procedure closefile;
    procedure read(n : word);
    procedure write(n : word);
    function length : longint;
    procedure openread(n : word);
    procedure writeclose(n : word);
    procedure openreadclose(n : word);
    procedure openwriteclose(n: word);
    procedure clearit;
    procedure set_name (  s : string);
    function get_name : string;
end;
type
    MHDR_DAT = object
    private
     MHDR_DATA : MHDRDATA;
     MHDR_FILE : DATAFILE;
    public
    procedure open(c : longint);
    procedure closefile;
    procedure read(n : longint);
    procedure write(n : longint);
    function length : longint;
    procedure openread(c,n : longint);
    procedure writeclose(n : longint);
    procedure openreadclose(c,n : longint);
    procedure openwriteclose(c,n: longint);
    procedure clearit;
    procedure set_from(s : string);
    function  get_from : string;
    procedure set_to ( s : string);
    function  get_to : string;
    procedure set_subject (s : string);
    function  get_subject  : string;
    procedure set_nameofattached(s : string);
    function get_nameofattached : string;
    procedure set_datetime(s : string);
    function  get_datetime : string;
    procedure set_fromzone (w : word);
    function get_fromzone : word;
    procedure set_fromnet (w : word);
    function get_fromnet : word;
    procedure set_fromnode (w : word);
    function  get_fromnode : word;
    procedure set_frompoint (w : word);
    function get_frompoint : word;
    procedure set_tozone (w : word);
    function get_tozone : word;
    procedure set_tonet (w : word);
    function get_tonet : word;
    procedure set_tonode (w : word);
    function  get_tonode : word;
    procedure set_topoint (w : word);
    function get_topoint : word;
    procedure set_offset( l :longint);
    function get_offset : longint;
    procedure set_number (l : longint);
    function get_number : longint;
    procedure set_numberofmessagerepliesto (l :longint);
    function get_numberofmessagerepliesto : longint;
    procedure set_messagelength( l : longint);
    function  get_messagelength : longint;
    procedure set_fromhash ( l :longint);
    function get_fromhash :  longint;
    procedure set_tohash (l : longint);
    function get_tohash : longint;
    procedure set_echomessageflag( b : boolean);
    function get_echomessageflag : boolean;
    procedure set_threadedmessageflag (b : boolean);
    function get_threadedmessageflag: boolean;
    procedure set_privatemessage ( b : boolean);
    function get_privatemessage : boolean;
    procedure set_deletedmessage (b : boolean);
    function get_deletedmessage : boolean;
    procedure set_recievedmessage( b : boolean);
    function get_recievedmessage : boolean;
    procedure set_permanentmessage(b : boolean);
    function get_permanentmessage : boolean;
    procedure set_tritossecho (b : boolean);
    function get_tritossecho : boolean;
end;
type
   FAREA_DAT = object
   private
    FAREA_DATA : FAREADATA;
    FAREA_FILE : DATAFILE;
    public
    procedure open;
    procedure closefile;
    procedure read(n : longint);
    procedure write(n : longint);
    function length : longint;
    procedure openread(n : longint);
    procedure writeclose(n : longint);
    procedure openreadclose(n : longint);
    procedure openwriteclose(n: longint);
    procedure clearit;
    procedure set_name (  s : string);
    function get_name : string;
    procedure set_fileareapath (s : string);
    function get_fileareapath  : string;
    procedure set_fileareauploadpath (s : string);
    function get_fileareauploadpath : string;
    procedure set_fileareafilelist (s : string);
    function get_fileareafilelist : string;
    procedure set_fileareauploadlist (s : string);
    function get_fileareauploadlist : string;
    procedure set_fileareaindexfile (s : string);
    function get_fileareaindexfile : string;
    procedure set_additionalfileareapaths(n : byte;s : string);
    function get_additionalfileareapaths(n :byte) : string;
    procedure set_securitylevel (n : word);
    function get_securitylevel : word;
    procedure set_viewsecuritylevel (n : word);
    function get_viewsecuritylevel : word;
    procedure set_sorttype ( n : word);
    function get_sorttype : word;
    procedure set_privatearea (b : boolean);
    function get_privatearea : boolean;
    procedure set_cdromfilearea (b : boolean);
    function get_cdromfilearea : boolean;
    procedure set_aliasarea(b : boolean);
    function get_aliasarea : boolean;
end;

type
   DOORS_TMP = object
   private
   DOORS_FILE : DATAFILE;
   DOORS_DATA : DOORSTMPDATA;
   public
   procedure open;
   procedure closefile;
   procedure read;
   procedure write;
   procedure openread;
   procedure writeclose;
   procedure openreadclose;
   procedure openwriteclose;
   procedure clearit;
   function length : longint;
   procedure set_TimeLeftAtLogon(w : word);
   function get_TimeLeftAtLogon : word;
   procedure set_CurrentFileArea (w : word);
   function get_CurrentFileArea : word;
   procedure set_CurrentMessageArea (w : word);
   function get_currentmessagearea : word;
   procedure set_FrontEndTime (w : word);
   function get_frontendtime : word;
   procedure set_WhereTheDoorWasCalledFrom(w : word);
   function get_wherethedoorwascalledfrom : word;
   procedure set_Languagenumber (w : word);
   function get_LanguageNumber: word;
   procedure  set_NumberofFilesFlagged (w : word);
   function get_numberoffilesflagged : word;
   procedure set_TimeinDoorSys (w : word);
   function get_timeindoorsys : word;
   procedure set_UserRecordNumber (l : longint);
   function get_Userrecordnumber : longint;
   procedure set_BaudRate (L : longint);
   function get_Baudrate : longint;
   procedure set_FrontEndBaudRate (l : longint);
   function get_Frontendbaudrate : longint;
   procedure set_TimeWhenUserLoggedOn (l : longint);
   function get_TimeWhenuserloggedon : longint;
   procedure set_ANSI(b : boolean);
   function get_ANSI : boolean;
   procedure set_FrontEnd(b : boolean);
   function get_FrontEnd : boolean;
   procedure set_FrontEndHangup ( b : boolean);
   function get_FrontEndHangup : boolean;
   procedure set_UserWindowFlag ( B : boolean);
   function get_UserWindowFlag : boolean;
   procedure set_ChatRequested (b : boolean);
   function get_ChatRequested : boolean;
   procedure set_EventPending ( b: boolean);
   function get_EventPending : boolean;
   procedure set_GoodByeFromDoor ( b : boolean);
   function get_GoodByeFromDoor : boolean;
   procedure set_ForceBoardDownAfterCaller (b : boolean);
   function get_ForceBoardDownAfterCaller : boolean;
   procedure set_RIPScrip (b : boolean);
   function get_RIPScrip : boolean;
   procedure set_DoorSYS (B : boolean);
   function get_DoorSYS : boolean;
   procedure set_ErrorCorrecting (b : boolean);
   function get_ErrorCorrecting : boolean;
end;{Doors TMP}
var
 tbptr   : longint;
 tbtxtptr : ^txtarray;
procedure APIINIT;
procedure tbaddline(s : string);
function tbgetline(l : longint) : string;
function tbeom (l : longint): boolean;


implementation
(*Include File with Record Definitions *)

(*Bit Manipulations - Not Interfaced to Main Programs, Used
  Internally  *)
uses strings,msgstr;

const
  bytes : array[0..7] of byte = (1,2,4,8,16,32,64,128);

procedure apiinit;
var
mconf : mconf_dat;
farea : farea_dat;
sysdat2 : sysdat2_dat;
begin
tbnodesmaindirectory := withbackslash(tbnodesmaindirectory);
sysdat2.openreadclose;
tbnode1smaindirectory := sysdat2.get_node1smaindirectory;
mconf.open;
tbnumberofmessageareas := mconf.length;
mconf.closefile;
farea.open;
tbnumberoffileareas := farea.length;
farea.closefile;
end;


procedure setbit(bit : byte;var bits : array of byte);
var
w,bt : byte;

begin
 bt := bit div 8;
 w  := bit mod 8;
 bits[bt] := bits[bt] or bytes[w];
end;
procedure zerobit(bit : byte;var bits : array of byte);
var
w,bt : byte;
begin
 bt := bit div 8;
 w  := bit mod 8;
 bits[bt] := bits[bt] and not bytes[w];
end;
function getbit(bit : byte;var bits : array of byte) : boolean;
var
w,bt : byte;
begin
  bt := bit div 8;
  w  := bit mod 8;
  getbit := (bits[bt] and bytes[w]) = bytes[w];
end;

procedure datafile.open(s : string);
begin
assign(openfile,s);
filename := s;
{$I-}reset(openfile,1);{$I+}
tbioerror := ioresult;
if tbioerror <> 0 then error(s,tbioerror);
if tbioerror = 0 then openflag := true;
end;
procedure datafile.closefile;
begin
if openflag = true then {$I-}close(openfile);{$I+}
tbioerror := ioresult;
openflag := false;
end;
procedure datafile.dread(n,size : longint;var data);
begin
 if (n > 0) and (openflag = true) then begin
   dec(n);
   {$I-}seek(openfile,n*size);{$I+}
   tbioerror := ioresult;
   {$I-}blockread(openfile,data,size);{$I+}
   tbioerror := ioresult;
 end;
end;
procedure datafile.dwrite(n,size : longint;var data);
begin
 if (n > 0) and (openflag = true) then begin
   dec(n);
   seek(openfile,n*size);
   blockwrite(openfile,data,size);
 end;
end;
procedure datafile.seekfile( n : longint);
begin
  if openflag = true then
    seek(openfile,n);
end;
function datafile.length(size : longint) : longint;
begin
  if openflag = true then length := filesize(openfile) div size
  else length := -1;
end;
procedure datafile.add(size : longint;var data);
begin
  dwrite((filesize(openfile)*size)+1,size,data);
end;
function datafile.recordnumber (size :longint) : longint;
begin
  recordnumber := (filepos(openfile) div size)+1;
end;
procedure datafile.error(s : string;i : word);
begin
 write(' Error ');
 case i of
 2..5 : writeln('Opening: ',s);
 100  : writeln('Reading: ',s);
 101  : writeln('Writing: ',s);
 else writeln('');
 end;{case}
end;

procedure FAREA_DAT.open;
begin
  FAREA_FILE.open(tbnode1smaindirectory+'MWORK\FAREA.DAT');
end;
procedure FAREA_DAT.closefile;
begin
  FAREA_FILE.closefile;
end;
procedure FAREA_DAT.read(n : longint);
begin
  FAREA_FILE.dread(n,sizeof(FAREA_DATA),farea_data);
end;
procedure FAREA_DAT.write(n : longint);
begin
  FAREA_FILE.dwrite(n,sizeof(FAREA_DATA),farea_Data);
end;
function FAREA_DAT.length : longint;
begin
  length := FAREA_FILE.length(sizeof(farea_Data));
end;
procedure FAREA_DAT.openread(n : longint);
begin
open;read(n);
end;
procedure FAREA_DAT.writeclose(n : longint);
begin
write(n);closefile;
end;
procedure FAREA_DAT.openreadclose(n : longint);
begin
open;read(n);closefile;
end;
procedure FAREA_DAT.openwriteclose(n: longint);
begin
open;write(n);closefile;
end;
procedure FAREA_DAT.clearit;
begin
fillchar(farea_Data,sizeof(farea_Dat),#0);
end;
procedure FAREA_DAT.set_name (  s : string);
begin
  strpcopy(farea_Data.name,s);
end;
function FAREA_DAT.get_name : string;
begin
  get_name := strpas(farea_data.name);
end;
procedure FAREA_DAT.set_fileareapath (s : string);
begin
   strpcopy(farea_Data.fileareapath,s);
end;
function FAREA_DAT.get_fileareapath  : string;
begin
  get_fileareapath := strpas(farea_data.fileareapath);
end;
procedure FAREA_DAT.set_fileareauploadpath (s : string);
begin
  strpcopy(farea_data.fileareauploadpath,s);
end;
function FAREA_DAT.get_fileareauploadpath : string;
begin
  get_fileareauploadpath := strpas(farea_data.fileareauploadpath);
end;
procedure FAREA_DAT.set_fileareafilelist (s : string);
begin
  strpcopy(farea_data.fileareafilelist,s);
end;
function FAREA_DAT.get_fileareafilelist : string;
begin
  get_fileareafilelist := strpas(farea_data.fileareafilelist);
end;
procedure FAREA_DAT.set_fileareauploadlist (s : string);
begin
  strpcopy(farea_data.fileareauploadlist,s);
end;
function FAREA_DAT.get_fileareauploadlist : string;
begin
  get_fileareauploadlist := strpas(farea_Data.fileareauploadlist);
end;
procedure FAREA_DAT.set_fileareaindexfile (s : string);
begin
  strpcopy(farea_Data.fileareaindexfile,s);
end;
function FAREA_DAT.get_fileareaindexfile : string;
begin
  get_fileareaindexfile := strpas(farea_data.fileareaindexfile);
end;
procedure FAREA_DAT.set_additionalfileareapaths(n : byte;s : string);
begin
  strpcopy(farea_data.additionalfileareapaths[n],s);
end;
function FAREA_DAT.get_additionalfileareapaths(n :byte) : string;
begin
  get_additionalfileareapaths := strpas(farea_data.additionalfileareapaths[n]);
end;
procedure FAREA_DAT.set_securitylevel (n : word);
begin
  farea_data.securitylevel := n;
end;
function FAREA_DAT.get_securitylevel : word;
begin
  get_securitylevel := farea_data.securitylevel;
end;
procedure FAREA_DAT.set_viewsecuritylevel (n : word);
begin
  farea_data.viewsecuritylevel := n;
end;
function FAREA_DAT.get_viewsecuritylevel : word;
begin
  get_viewsecuritylevel := farea_data.viewsecuritylevel;
end;
procedure FAREA_DAT.set_sorttype ( n : word);
begin
  farea_data.sorttype := n;
end;
function FAREA_DAT.get_sorttype : word;
begin
 get_sorttype :=  farea_data.sorttype
end;
procedure FAREA_DAT.set_privatearea (b : boolean);
begin
  if b then setbit(ord(privateareaflag),farea_data.bitfields)
  else zerobit(ord(privateareaflag),farea_data.bitfields);
end;
function FAREA_DAT.get_privatearea :boolean;
begin
  get_privatearea := getbit(ord(privateareaflag),farea_data.bitfields);
end;
procedure FAREA_DAT.set_cdromfilearea (b : boolean);
begin
  if b then setbit(ord(cdromfileareaflag),farea_data.bitfields)
  else zerobit(ord(cdromfileareaflag),farea_Data.bitfields);
end;
function FAREA_DAT.get_cdromfilearea : boolean;
begin
  get_cdromfilearea := getbit(ord(cdromfileareaflag),farea_data.bitfields);
end;
procedure FAREA_DAT.set_aliasarea(b : boolean);
begin
  if b then setbit(ord(aliasareaflag),farea_data.bitfields)
  else zerobit(ord(aliasareaflag),farea_data.bitfields);
end;
function FAREA_DAT.get_aliasarea : boolean;
begin
  get_aliasarea := getbit(ord(aliasareaflag),farea_Data.bitfields);
end;

    procedure USER_DAT.open;
    begin
     USER_FILE.open(tbnode1smaindirectory+'MWORK\USERS.DAT');
    end;
    procedure USER_DAT.closefile;
    begin
     USER_FILE.closefile;
    end;
    procedure USER_DAT.read(n : longint);
    begin
     USER_FILE.dread(n,sizeof(user_data),user_data);
    end;
    procedure USER_DAT.write(n : longint);
    begin
     user_file.dwrite(n,sizeof(user_data),user_data);
    end;
    function USER_DAT.length : longint;
    begin
     length := user_file.length(sizeof(user_data));
   end;
   procedure USER_DAT.openread(n : longint);
   begin
   open;read(n);
   end;
   procedure USER_DAT.writeclose(n : longint);
   begin
   write(n);closefile;
   end;
   procedure USER_DAT.openreadclose(n : longint);
   begin
   open;read(n);closefile;
   end;
   procedure USER_DAT.openwriteclose(n: longint);
   begin
   open;write(n);closefile;
   end;
  procedure USER_DAT.clearit;
  begin
    fillchar(user_data,sizeof(user_data),#0);
  end;
  procedure USER_DAT.set_name (  s : string);
  begin
    strpcopy(user_data.name,s);
  end;
  function USER_DAT.get_name : string;
  begin
    get_name := strpas(user_data.name);
  end;
  procedure USER_DAT.set_alias( s: string);
  begin
   strpcopy(user_data.alias,s);
  end;
  function USER_DAT.get_alias : string;
  begin
    get_alias := strpas(user_data.alias);
  end;
  procedure USER_DAT.set_password(s: string);
  begin
   strpcopy(user_Data.password,s);
  end;
  function USER_DAT.get_password : string;
  begin
    get_password := strpas(user_data.password);
  end;
  procedure USER_DAT.set_streetaddress1 ( s: string);
  begin
    strpcopy(user_data.streetaddress1,s);
  end;
  function USER_DAT.get_streetaddress1 : string;
  begin
    get_streetaddress1 := strpas(user_data.streetaddress1);
  end;
  procedure USER_DAT.set_streetaddress2 ( s: string);
  begin
    strpcopy(user_data.streetaddress2,s);
  end;
  function USER_DAT.get_streetaddress2 : string;
  begin
    get_streetaddress2 := strpas(user_data.streetaddress2);
  end;
  procedure USER_DAT.set_city ( s: string);
  begin
    strpcopy(user_data.city,s);
  end;
  function USER_DAT.get_city : string;
  begin
    get_city := strpas(user_data.city);
  end;
 procedure USER_DAT.set_state (s : string);
 begin
  strpcopy(user_data.state,s);
 end;
 function USER_DAT.get_state : string;
 begin
   get_state := strpas(user_data.state);
 end;
 procedure USER_DAT.set_country (s : string);
 begin
  strpcopy(user_data.country,s);
 end;
 function USER_DAT.get_country : string;
 begin
   get_country := strpas(user_data.country);
 end;
 procedure USER_DAT.set_zipcode (s : string);
 begin
   strpcopy(user_data.zipcode,s);
 end;
 function USER_DAT.get_zipcode : string;
 begin
   get_zipcode := strpas(user_data.zipcode);
 end;
 procedure USER_DAT.set_phonenumber(s : string);
 begin
  strpcopy(user_data.phonenumber,s);
 end;
 function USER_DAT.get_phonenumber : string;
 begin
   get_phonenumber := strpas(user_data.phonenumber);
 end;
 procedure USER_DAT.set_birthday (s : string);
 begin
   strpcopy(user_data.birthday,s);
 end;
 function USER_DAT.get_birthday : string;
 begin
   get_birthday := strpas(user_data.birthday);
 end;
 procedure USER_DAT.set_dateoffirstcall (s:string);
 begin
   strpcopy(user_data.dateoffirstcall,s);
 end;
 function USER_DAT.get_dateoffirstcall : string;
  begin
    get_dateoffirstcall := strpas(user_data.dateoffirstcall);
  end;
procedure USER_DAT.set_dateoflastfilecheck (s:string);
  begin
     strpcopy(user_data.dateoflastfilecheck,s);
  end;
function USER_DAT.get_dateoflastfilecheck : string;
  begin
    get_dateoflastfilecheck := strpas(user_data.dateoflastfilecheck);
  end;
procedure USER_DAT.set_SubscriptionExpirationDate (s:string);
begin
  strpcopy(user_data.subscriptionexpirationdate,s);
end;
function USER_DAT.get_subscriptionExpirationDate : string;
begin
  get_subscriptionexpirationdate := strpas(user_data.subscriptionexpirationdate);
end;
procedure USER_DAT.set_DateandTimeofLastCall ( s: string);
begin
  strpcopy(user_data.dateandtimeoflastcall,s);
end;
function USER_DAT.get_DateandTimeofLastCall : string;
begin
  get_dateandtimeoflastcall := strpas(user_data.dateandtimeoflastcall);
end;
procedure USER_DAT.set_expertmode (n : word);
begin
  user_data.expertmode := n;
end;
function USER_DAT.get_expertmode : word;
begin
  get_expertmode := user_data.expertmode;
end;
procedure USER_DAT.set_Securitylevel (n :word);
begin
  user_data.securitylevel := n;
end;
function USER_DAT.get_SecurityLevel : word;
begin
  get_securitylevel := user_data.securitylevel;
end;
procedure USER_DAT.set_NumberofCalls ( n : word);
begin
  user_data.numberofcalls := n;
end;
function USER_DAT.get_NumberofCalls : word;
begin
  get_numberofcalls := user_data.numberofcalls;
end;
procedure USER_DAT.set_TimeLeftForToday (n : word);
begin
  user_data.timeleftfortoday := n;
end;
function USER_DAT.get_timeleftfortoday : word;
begin
  get_timeleftfortoday := user_data.timeleftfortoday;
end;
procedure USER_DAT.set_LastMessageConference (n : word);
begin
   user_data.lastmessageconference := n;
end;
function USER_DAT.get_lastmessageconference : word;
begin
  get_lastmessageconference := user_data.lastmessageconference;
end;
procedure USER_DAT.set_LastFileArea (n : word);
begin
   user_data.lastfilearea := n;
end;
function USER_DAT.get_lastfilearea : word;
begin
  get_lastfilearea := user_data.lastfilearea;
end;
procedure USER_DAT.set_DefaultProtocal( n: word);
begin
  user_data.defaultprotocal := n;
end;
function USER_DAT.get_defaultprotocal : word;
begin
   get_defaultprotocal := user_data.defaultprotocal;
end;
procedure USER_DAT.set_NumberofCallsToday (n :word);
begin
  user_data.numberofcallstoday := n;
end;
function USER_DAT.get_numberofcallstoday : word;
begin
  get_numberofcallstoday := user_Data.numberofcallstoday;
end;
procedure USER_DAT.set_DefaultEditor (n : worD);
begin
  user_data.defaulteditor := n;
end;
function USER_DAT.get_defaultEditor : word;
begin
  get_defaulteditor := user_data.defaulteditor;
end;
procedure USER_DAT.set_InitialChatStatus(n : word);
begin
   user_data.initialchatstatus := n;
end;
function USER_DAT.get_initialchatstatus : word;
begin
  get_initialchatstatus := user_data.initialchatstatus;
end;
procedure USER_DAT.set_numberoffilesdownloadedtoday (n : word);
begin
  user_data.numberoffilesdownloadedtoday := n;
end;
function USER_DAT.get_numberoffilesdownloadedtoday : word;
begin
   get_numberoffilesdownloadedtoday := user_data.numberoffilesdownloadedtoday;
end;
procedure USER_DAT.set_archiveusedinqwk (n : word);
begin
    user_data.archiveusedinqwk := n;
end;
function USER_DAT.get_archiveusedinqwk : word;
begin
  get_archiveusedinqwk := user_data.archiveusedinqwk;
end;
procedure USER_DAT.set_numberoffilesuploaded (n : longint);
begin
  user_data.numberoffilesuploaded := n;
end;
function USER_DAT.get_numberoffilesuploaded : longint;
begin
   get_numberoffilesuploaded := user_data.numberoffilesuploaded;
end;
procedure USER_DAT.set_numberoffilesdownloaded (n : longint);
begin
  user_data.numberoffilesdownloaded := n;
end;
function USER_DAT.get_numberoffilesdownloaded : longint;
begin
   get_numberoffilesdownloaded := user_data.numberoffilesdownloaded;
end;
procedure USER_DAT.set_numberofkbytesuploaded (n : longint);
begin
   user_data.numberofkbytesuploaded := n;
end;
function USER_DAT.get_numberofkbytesuploaded : longint;
begin
   get_numberofkbytesuploaded := user_data.numberofkbytesuploaded;
end;
procedure USER_DAT.set_numberofkbytesdownloaded (n : longint);
begin
   user_data.numberofkbytesdownloaded := n;
end;
function USER_DAT.get_numberofkbytesdownloaded : longint;
begin
   get_numberofkbytesdownloaded :=  user_Data.numberofkbytesdownloaded;
end;
procedure USER_DAT.set_numberofmessagesposted (n: longint);
begin
  user_data.numberofmessagesposted := n;
end;
function USER_DAT.get_numberofmessagesposted : longint;
begin
  get_numberofmessagesposted := user_data.numberofmessagesposted;
end;
procedure USER_DAT.set_numberofbytesdownloadedtoday (n : longint);
begin
  user_data.numberofbytesdownloadedtoday := n;
end;
function USER_DAT.get_numberofbytesdownloadedtoday : longint;
begin
  get_numberofbytesdownloadedtoday := user_data.numberofbytesdownloadedtoday;
end;
procedure USER_DAT.set_network(n: word; b: boolean);
begin
 if b then setbit(n,user_data.networkflags)
 else zerobit(n,user_data.networkflags);
end;
function USER_DAT.get_network( n : word) : boolean;
begin
  get_network := getbit(n,user_data.networkflags);
end;
procedure USER_DAT.set_lockedout (n : boolean);
begin
  if n then setbit(ord(lockedoutflag),user_data.bitfields)
  else zerobit(ord(lockedoutflag),user_data.bitfields);
end;
function USER_DAT.get_lockedout : boolean;
begin
   get_lockedout := getbit(ord(lockedoutflag),user_data.bitfields);
end;
procedure USER_DAT.set_markedfordeletion (n : boolean);
begin
  if n then setbit(ord(markedfordeletionflag),user_data.bitfields)
  else zerobit(ord(markedfordeletionflag),user_data.bitfields);
end;
function USER_DAT.get_markedfordeletion : boolean;
begin
 get_markedfordeletion := getbit(ord(markedfordeletionflag),user_data.bitfields);
end;
procedure USER_DAT.set_includelogon1inqwk (n:boolean);
begin
 if n then setbit(ord(includelogon1inqwkflag),user_data.bitfields)
 else zerobit(ord(includelogon1inqwkflag),user_Data.bitfields);
end;
function USER_DAT.get_includelogon1inqwk : boolean;
begin
   get_includelogon1inqwk := getbit(ord(includelogon1inqwkflag),user_data.bitfields);
end;
procedure USER_DAT.set_includegoodbyeinqwk ( n:boolean);
begin
if n then setbit(ord(includegoodbyeinqwkflag),user_data.bitfields)
 else zerobit(ord(includegoodbyeinqwkflag),user_Data.bitfields);
end;
function USER_DAT.get_includegoodbyeinqwk : boolean;
begin
 get_includegoodbyeinqwk := getbit(ord(includegoodbyeinqwkflag),user_data.bitfields);
end;
procedure USER_DAT.set_includebulletinsinqwk (n : boolean);
begin
if n then setbit(ord(includebulletinsinqwkflag),user_data.bitfields)
 else zerobit(ord(includebulletinsinqwkflag),user_Data.bitfields);
end;
function USER_DAT.get_includebulletinsinqwk : boolean;
begin
  get_includebulletinsinqwk := getbit(ord(includebulletinsinqwkflag),user_Data.bitfields);
end;
procedure USER_DAT.set_includenewfilesinqwk (n : boolean);
begin
 if n then setbit(ord(includenewfilesinqwkflag),user_data.bitfields)
 else zerobit(ord(includenewfilesinqwkflag),user_Data.bitfields);
end;
function USER_DAT.get_includenewfilesinqwk : boolean;
begin
 get_includenewfilesinqwk := getbit(ord(includenewfilesinqwkflag),user_Data.bitfields);
end;
procedure USER_DAT.set_checkforwaitingmessages (n : boolean);
begin
if n then setbit(ord(checkforwaitingmessagesflag),user_data.bitfields)
 else zerobit(ord(checkforwaitingmessagesflag),user_Data.bitfields);
end;
function USER_DAT.get_checkforwaitingmessages : boolean;
begin
  get_checkforwaitingmessages := getbit(ord(checkforwaitingmessagesflag),user_data.bitfields);
end;
procedure USER_DAT.set_goodbyeafterupload (n : boolean);
begin
if n then setbit(ord(goodbyeafteruploadflag),user_data.bitfields)
 else zerobit(ord(goodbyeafteruploadflag),user_Data.bitfields);
end;
function USER_DAT.get_goodbyeafterupload : boolean;
begin
  get_goodbyeafterupload := getbit(ord(goodbyeafteruploadflag),user_data.bitfields);
end;
procedure USER_DAT.set_attachedfilesinqwk (n : boolean);
begin
if n then setbit(ord(attachedfilesinqwkflag),user_data.bitfields)
 else zerobit(ord(attachedfilesinqwkflag),user_Data.bitfields);
end;
function USER_DAT.get_attachedfilesinqwk : boolean;
begin
  get_attachedfilesinqwk := getbit(ord(attachedfilesinqwkflag),user_data.bitfields);
end;

procedure MCONF_DAT.open;
begin
  MCONF_FILE.open(tbnode1smaindirectory+'MWORK\MCONF.DAT');
end;
procedure MCONF_DAT.closefile;
begin
 MCONF_FILE.closefile;
end;
procedure MCONF_DAT.read(n : longint);
begin
if mconf_file.openflag = false then writeln('Error');
  mconf_file.dread(n,sizeof(mconf_data),mconf_data);
end;
procedure MCONF_DAT.write(n : longint);
begin
  mconf_file.dwrite(n,sizeof(mconf_data),mconf_data);
end;
function MCONF_DAT.length : longint;
begin
  length := mconf_file.length(sizeof(mconf_data));
end;
procedure MCONF_DAT.openread(n : longint);
begin
open;read(n);
end;
procedure MCONF_DAT.writeclose(n : longint);
begin
write(n);
closefile;
end;
procedure MCONF_DAT.openreadclose(n : longint);
begin
open;read(n);closefile;
end;
procedure MCONF_DAT.openwriteclose(n: longint);
begin
open;write(n);closefile;
end;
procedure MCONF_DAT.clearit;
begin
fillchar(mconf_data,sizeof(mconf_data),#0);
end;
procedure MCONF_DAT.set_name (  s : string);
begin
  strpcopy(mconf_data.name,s);
end;
function MCONF_DAT.get_name : string;
begin
  get_name := strpas(mconf_data.name);
end;
procedure MCONF_DAT.set_readsecuritylevel (n : word);
begin
  mconf_data.readsecuritylevel := n;
end;
function MCONF_DAT.get_readsecuritylevel : word;
begin
  get_readsecuritylevel := mconf_data.readsecuritylevel;
end;
procedure MCONF_DAT.set_postsecuritylevel (n : word);
begin
  mconf_data.postsecuritylevel := n;
end;
function MCONF_DAT.get_postsecuritylevel : word;
begin
  get_postsecuritylevel := mconf_data.postsecuritylevel;
end;
procedure MCONF_DAT.set_tripacknumberofdaystosave (n: word);
begin
  mconf_Data.tripacknumberofdaystosave := n;
end;
function MCONF_DAT.get_tripacknumberofdaystosave : word;
begin
  get_tripacknumberofdaystosave := mconf_data.tripacknumberofdaystosave;
end;
procedure MCONF_DAT.set_highestmessagenumber (n : longint);
begin
  mconf_data.highestmessagenumber := n;
end;
function MCONF_DAT.get_highestmessagenumber : longint;
begin
  get_highestmessagenumber := mconf_data.highestmessagenumber;
end;

procedure MCONF_DAT.set_network(n : word;b: boolean);
begin
 if b then setbit(n,mconf_data.networkflags)
  else zerobit(n,mconf_data.networkflags);
end;
function MCONF_DAT.get_network( n: word) : boolean;
begin
  dec(n);
  get_network := getbit(n,mconf_data.networkflags);
end;
procedure MCONF_DAT.set_networkedconference (b : boolean);
begin
  if b then setbit(ord(networkedconferenceflag),mconf_data.bitfields)
  else zerobit(ord(networkedconferenceflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_networkedconference : boolean;
begin
 get_networkedconference :=  getbit(ord(networkedconferenceflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_privateconference (b : boolean);
begin
 if b then setbit(ord(privateconferenceflag),mconf_data.bitfields)
  else zerobit(ord(privateconferenceflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_privateconference : boolean;
begin
  get_privateconference := getbit(ord(privateconferenceflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_fidostylenetmail (b : boolean);
begin
 if b then setbit(ord(fidostylenetmailflag),mconf_data.bitfields)
  else zerobit(ord(fidostylenetmailflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_fidostylenetmail : boolean;
begin
 get_fidostylenetmail := getbit(ord(fidostylenetmailflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_aliasconference (b : boolean);
begin
 if b then setbit(ord(aliasconferenceflag),mconf_data.bitfields)
  else zerobit(ord(aliasconferenceflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_aliasconference : boolean;
begin
 get_aliasconference := getbit(ord(aliasconferenceflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_userdelete(b : boolean);
begin
 if b then setbit(ord(userdeleteflag),mconf_data.bitfields)
  else zerobit(ord(userdeleteflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_userdelete : boolean;
begin
  get_userdelete := getbit(ord(userdeleteflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_tripackbackup ( b : boolean);
begin
 if b then setbit(ord(tripackbackupflag),mconf_data.bitfields)
  else zerobit(ord(tripackbackupflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_tripackbackup : boolean;
begin
  get_tripackbackup := getbit(ord(tripackbackupflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_disableprivatemessages (b : boolean);
begin
 if b then setbit(ord(disableprivatemessagesflag),mconf_data.bitfields)
  else zerobit(ord(disableprivatemessagesflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_disableprivatemessages : boolean;
begin
  get_disableprivatemessages := getbit(ord(disableprivatemessagesflag),mconf_data.bitfields);
end;
procedure MCONF_DAT.set_disablepublicmessages(b: boolean);
begin
 if b then setbit(ord(disablepublicmessagesflag),mconf_data.bitfields)
  else zerobit(ord(disablepublicmessagesflag),mconf_data.bitfields);
end;
function MCONF_DAT.get_disablepublicmessages: boolean;
begin
 get_disablepublicmessages := getbit(ord(disablepublicmessagesflag),mconf_data.bitfields);
end;


procedure NETWORK_DAT.open;
begin
  NETWORK_FILE.open(tbnode1smaindirectory+'MWORK\NETWORK.DAT');
end;
procedure NETWORK_DAT.closefile;
begin
 NETWORK_FILE.closefile;
end;
procedure NETWORK_DAT.read(n : word);
begin
if NETWORK_file.openflag = false then writeln('Error');
  NETWORK_file.dread(n,sizeof(NETWORK_data),NETWORK_data);
end;
procedure NETWORK_DAT.write(n : word);
begin
  NETWORK_file.dwrite(n,sizeof(NETWORK_data),NETWORK_data);
end;
function NETWORK_DAT.length : longint;
begin
  length := NETWORK_file.length(sizeof(NETWORK_data));
end;
procedure NETWORK_DAT.openread(n : word);
begin
open;read(n);
end;
procedure NETWORK_DAT.writeclose(n : word);
begin
write(n);
closefile;
end;
procedure NETWORK_DAT.openreadclose(n : word);
begin
open;read(n);closefile;
end;
procedure NETWORK_DAT.openwriteclose(n: word);
begin
open;write(n);closefile;
end;
procedure NETWORK_DAT.clearit;
begin
fillchar(NETWORK_data,sizeof(NETWORK_data),#0);
end;
procedure NETWORK_DAT.set_name (  s : string);
begin
  strpcopy(NETWORK_data.name,s);
end;
function NETWORK_DAT.get_name : string;
begin
  get_name := strpas(NETWORK_data.name);
end;


procedure USERS_SPM.additem;
var
 spm,spm1 : USERMSGPTR;
begin
  new(spm);
  spm^.msgs := usersm_data;
  spm^.next := nil;
 if usersm_header = nil then usersm_header := spm
   else begin
        spm1 := usersm_header;
        while spm1^.next <> nil do
          spm1 := spm1^.next;
          spm1^.next := spm;
   end; {else}
end;
procedure USERS_SPM.deletelist;
var
s,s1 : USERMSGPTR;
i : word;
begin
s := usersm_header;
While s <> Nil Do
		Begin
			s1 := s;
			s := s^.Next;
			Dispose(s1);
		End;
usersm_header := nil;
end;
procedure USERS_SPM.getconference(c : longint);
var i : longint;
s : usermsgptr;
begin
s := usersm_header;
 for i := 1 to c-1 do
  s := s^.next;
  usersm_data := s^.msgs;
end;
procedure USERS_SPM.setconference(c : longint);
var i : longint;
 s : usermsgptr;
begin
  s := usersm_header;
   for i := 1 to c-1 do
     s := s^.next;
     s^.msgs := usersm_data;
end;
procedure USERS_SPM.open;
begin
 USERSM_FILE.open(tbnode1smaindirectory+'MWORK\USERS.SPM');
 USERSM_HEADER := nil;
end;
procedure USERS_SPM.closefile;
begin
 USERSM_FILE.closefile;
 deletelist;
end;
procedure USERS_SPM.read(n : longint);
var c,u,i : longint;
begin
 dec(n);
 u := n * (tbnumberofmessageareas * sizeof(usersm_data));
 for i := 1 to tbnumberofmessageareas do begin
  c := u + ((i-1) * sizeof(usersm_data));
  c := c div sizeof(usersm_data);
  usersm_file.dread(c+1,sizeof(usersm_data),usersm_Data);
  additem;
end;
end;
procedure USERS_SPM.write(n : longint);
var c,u,i : longint;
begin
 dec(n);
 u := n * (tbnumberofmessageareas * sizeof(usersm_data));
 for i := 1 to tbnumberofmessageareas do begin
  c := u + ((i-1) * sizeof(usersm_data));
  c := c div sizeof(usersm_data);
  getconference(i);
  usersm_file.dwrite(c+1,sizeof(usersm_data),usersm_Data);
end;
end;
function USERS_SPM.length : longint;
begin
 length := tbnumberofmessageareas div sizeof(userssupmessages);
end;
procedure USERS_SPM.openread(n : longint);
begin
  open;
  read(n);
end;
procedure USERS_SPM.writeclose(n : longint);
begin
 write(n);
 closefile;
end;
procedure USERS_SPM.openreadclose(n : longint);
begin
 open;read(n);closefile;
end;
procedure USERS_SPM.openwriteclose(n: longint);
begin
  open;write(n);closefile;
end;
procedure USERS_SPM.set_lastmessageread (n : longint);
begin
  usersm_data.lastmessageread := n;
end;
function USERS_SPM.get_lastmessageread : longint;
begin
  get_lastmessageread := usersm_data.lastmessageread;
end;
procedure USERS_SPM.set_waitingmessagecounter ( n: word);
begin
  usersm_data.waitingmessagecounter := n;
end;
function USERS_SPM.get_waitingmessagecounter : word;
begin
  get_waitingmessagecounter := usersm_data.waitingmessagecounter;
end;
procedure USERS_SPM.set_queuedconference (n : word);
begin
  usersm_data.queuedconference := n;
end;
function USERS_SPM.get_queuedconference : word;
begin
 get_queuedconference := usersm_data.queuedconference;
end;
procedure USERS_SPM.set_accessprivateconference ( b : boolean);
begin
  if b then setbit(ord(accessprivateconferenceflag),usersm_data.bitfields)
  else zerobit(ord(accessprivateconferenceflag),usersm_data.bitfields);
end;
function USERS_SPM.get_accessprivateconference : boolean;
begin
  get_accessprivateconference := getbit(ord(accessprivateconferenceflag),usersm_data.bitfields);
end;
procedure USERS_SPM.set_cosysopstatus (b : boolean);
begin
  if b then setbit(ord(cosysopstatusflag),usersm_data.bitfields)
  else zerobit(ord(cosysopstatusflag),usersm_data.bitfields);
end;
function USERS_SPM.get_cosysopstatus : boolean;
begin
  get_cosysopstatus := getbit(ord(cosysopstatusflag),usersm_data.bitfields);
end;

  procedure USERS_IDX.open(w: word);
  begin
   case w of
     0  : USERSIDX_FILE.OPEN(tbnode1smaindirectory+'MWORK\USERS.IDX');
     1  : USERSIDX_FILE.OPEN(tbnode1smaindirectory+'MWORK\ALIAS.IDX');
   end;{case}
  end;
  function USERS_IDX.recordnumber : longint;
  begin
   recordnumber := USERSIDX_FILE.recordnumber(sizeof(USERSINDEX));
  end;
  procedure USERS_IDX.closefile;
  begin
    USERSIDX_FILE.closefile;
  end;
  procedure USERS_IDX.read(n : word);
  begin
    USERSIDX_FILE.dREAD(n,sizeof(USERSINDEX),USERSIDX_DATA);
  end;
  procedure USERS_IDX.write(n : word);
  begin
    USERSIDX_FILE.dWRITE(n,sizeof(USERSINDEX),USERSIDX_DATA);
  end;
  function  USERS_IDX.length : word;
  begin
     length := USERSIDX_FILE.length(sizeof(USERSINDEX));
  end;
  procedure USERS_IDX.openread(w,n : word);
  begin
   open(w);read(n);
  end;
  procedure USERS_IDX.openwriteclose(w,n : word);
  begin
   open(w);write(n);closefile;
  end;
  procedure USERS_IDX.openreadclose(w,n : word);
  begin
   open(w);read(n);closefile;
  end;
  procedure USERS_IDX.openwrite(w,n : word);
  begin
   open(w);write(n);
  end;
  procedure USERS_IDX.search( s : string);
  begin
  end;
  procedure USERS_IDX.replace(s,n : string);
  begin
  end;
  procedure USERS_IDX.set_name (n : string);
  begin
    strpcopy(USERSIDX_DATA.name,n);
  end;
  function USERS_IDX.get_name : string;
  begin
    get_name := strpas(USERSIDX_DATA.name);
  end;
  procedure USERS_IDX.set_recordnumber ( n: word);
  begin
    USERSIDX_DATA.recordnumber := n;
  end;
  function USERS_IDX.get_recordnumber : word;
  begin
    get_recordnumber := USERSIDX_DATA.recordnumber;
  end;

  procedure SYSDAT2_DAT.open;
  begin
   SYSDAT2_FILE.open(tbnodesmaindirectory+'SYSDAT2.DAT');
  end;
  procedure SYSDAT2_DAT.closefile;
  begin
    SYSDAT2_FILE.closefile;
  end;
  procedure SYSDAT2_DAT.read;
  begin
    SYSDAT2_FILE.dread(1,sizeof(sysdat2_data),sysdat2_Data);
  end;
  procedure SYSDAT2_DAT.write;
  begin
    SYSDAT2_FILE.dwrite(1,sizeof(sysdat2_data),sysdat2_data);
  end;
  procedure SYSDAT2_DAT.openread;
  begin
    open;read;
  end;
  procedure SYSDAT2_DAT.writeclose;
  begin
   write;closefile;
  end;
  procedure SYSDAT2_DAT.openreadclose;
  begin
   open;read;closefile;
  end;
  procedure SYSDAT2_DAT.openwriteclose;
  begin
    open;write;closefile;
  end;
  procedure SYSDAT2_DAT.clearit;
  begin
   fillchar(sysdat2_data,sizeof(sysdat2_data),#0);
  end;
  function SYSDAT2_DAT.length : longint;
  begin
    length := SYSDAT2_FILE.length(sizeof(sysdat2_data));
  end;
  procedure SYSDAT2_DAT.set_Node1sMainDirectory (s : string);
  begin
    strpcopy(sysdat2_data.node1smaindirectory,s);
  end;
  function SYSDAT2_DAT.get_Node1sMainDirectory : string;
  begin
    get_node1smaindirectory := strpas(sysdat2_data.node1smaindirectory);
  end;
    procedure MHDR_DAT.open(c : longint);
    var tmp : string;
    begin
    tmp := padleft(long2str(c),'0',4);
    mhdr_file.open(tbnode1smaindirectory+'MWORK\M'+tmp+'.HDR');
    end;
    procedure MHDR_DAT.closefile;
    begin
    mhdr_file.closefile;
    end;
    procedure MHDR_DAT.read(n : longint);
    begin
    mhdr_file.dread(n,sizeof(mhdr_data),mhdr_data);
    end;
    procedure MHDR_DAT.write(n : longint);
    begin
    mhdr_file.dwrite(n,sizeof(mhdr_data),mhdr_data);
    end;
    function MHDR_DAT.length : longint;
    begin
     length := mhdr_file.length(sizeof(mhdr_data));
    end;
    procedure MHDR_DAT.openread(c,n : longint);
    begin
    open(c);read(n);
    end;
    procedure MHDR_DAT.writeclose(n : longint);
    begin
    write(n);closefile;
    end;
    procedure MHDR_DAT.openreadclose(c,n : longint);
    begin
    open(c);read(n);closefile;
    end;
    procedure MHDR_DAT.openwriteclose(c,n: longint);
    begin
    open(c);write(n);closefile;
    end;
    procedure MHDR_DAT.clearit;
    begin
     fillchar(mhdr_data,sizeof(mhdr_data),#0);
    end;
    procedure MHDR_DAT.set_from(s : string);
    begin
     strpcopy(mhdr_data.from,s);
    end;
    function  MHDR_DAT.get_from : string;
    begin
     get_from := strpas(mhdr_data.from);
    end;
    procedure MHDR_DAT.set_to ( s : string);
    begin
     strpcopy(mhdr_data.towhom,s);
    end;
    function  MHDR_DAT.get_to : string;
    begin
     get_to := strpas(mhdr_data.towhom);
    end;
    procedure MHDR_DAT.set_subject (s : string);
    begin
     strpcopy(mhdr_data.subject,s);
    end;
    function  MHDR_DAT.get_subject  : string;
    begin
      get_subject := strpas(mhdr_data.subject);
    end;
    procedure MHDR_DAT.set_nameofattached(s : string);
    begin
      strpcopy(mhdr_data.nameofattachedfile,s);
    end;
    function MHDR_DAT.get_nameofattached : string;
    begin
     get_nameofattached := strpas(mhdr_data.nameofattachedfile);
    end;
    procedure MHDR_DAT.set_datetime(s : string);
    begin
      strpcopy(mhdr_data.dateandtime,s);
    end;
    function  MHDR_DAT.get_datetime : string;
    begin
     get_datetime := strpas(mhdr_data.dateandtime);
    end;
    procedure MHDR_DAT.set_fromzone (w : word);
    begin
     mhdr_Data.netmailfromzone := w;
    end;
    function MHDR_DAT.get_fromzone : word;
    begin
      get_fromzone := mhdr_Data.netmailfromzone;
    end;
    procedure MHDR_DAT.set_fromnet (w : word);
    begin
     mhdr_Data.netmailfromnet := w;
    end;
    function MHDR_DAT.get_fromnet : word;
    begin
      get_fromnet := mhdr_Data.netmailfromnet;
    end;
    procedure MHDR_DAT.set_fromnode (w : word);
    begin
      mhdr_Data.netmailfromnode := w;
    end;
    function  MHDR_DAT.get_fromnode : word;
    begin
       get_fromnode := mhdr_Data.netmailfromnode;
    end;
    procedure MHDR_DAT.set_frompoint (w : word);
    begin
      mhdr_Data.netmailfrompoint := w;
    end;
    function MHDR_DAT.get_frompoint : word;
    begin
      get_frompoint := mhdr_Data.netmailfrompoint;
    end;
    procedure MHDR_DAT.set_tozone (w : word);
    begin
     mhdr_data.netmailtozone := w;
    end;
   function MHDR_DAT.get_tozone : word;
    begin
      get_tozone := mhdr_data.netmailtozone;
    end;
   procedure MHDR_DAT.set_tonet (w : word);
   begin
     mhdr_data.netmailtonet := w;
    end;
    function MHDR_DAT.get_tonet : word;
    begin
       get_tonet := mhdr_data.netmailtonet;
    end;
    procedure MHDR_DAT.set_tonode (w : word);
     begin
      mhdr_data.netmailtonode := w;
    end;
    function  MHDR_DAT.get_tonode : word;
    begin
       get_tonode := mhdr_data.netmailtonode;
    end;
    procedure MHDR_DAT.set_topoint (w : word);
    begin
      mhdr_data.netmailtopoint := w;
    end;
    function MHDR_DAT.get_topoint : word;
    begin
        get_topoint := mhdr_data.netmailtopoint;
    end;
    procedure MHDR_DAT.set_offset( l :longint);
    begin
      mhdr_data.offsetintotextfile := l;
    end;
    function MHDR_DAT.get_offset : longint;
    begin
     get_offset := mhdr_data.offsetintotextfile;
    end;
    procedure MHDR_DAT.set_messagelength(l : longint);
    begin
     mhdr_data.messagelength := l;
    end;
    function MHDR_DAT.get_messagelength : longint;
    begin
      get_messagelength := mhdr_data.messagelength;
    end;
    procedure MHDR_DAT.set_number (l : longint);
    begin
      mhdr_data.number := l;
    end;
    function MHDR_DAT.get_number : longint;
    begin
     get_number := mhdr_data.number;
    end;
    procedure MHDR_DAT.set_numberofmessagerepliesto (l :longint);
    begin
     mhdr_data.numberofmessagethisrepliesto := l;
    end;
    function MHDR_DAT.get_numberofmessagerepliesto : longint;
    begin
     get_numberofmessagerepliesto := mhdr_data.numberofmessagethisrepliesto;
    end;
    procedure MHDR_DAT.set_fromhash ( l :longint);
    begin
     mhdr_data.fromhash := l;
    end;
    function MHDR_DAT.get_fromhash :  longint;
    begin
     get_fromhash := mhdr_data.fromhash;
    end;
    procedure MHDR_DAT.set_tohash (l : longint);
    begin
     mhdr_data.tohash := l;
    end;
    function MHDR_DAT.get_tohash : longint;
    begin
     get_tohash := mhdr_data.tohash;
    end;
    procedure MHDR_DAT.set_echomessageflag( b : boolean);
    begin
      if b then setbit(ord(echomessageflag),mhdr_data.bitfield)
      else zerobit(ord(echomessageflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_echomessageflag : boolean;
    begin
      get_echomessageflag := getbit(ord(echomessageflag),mhdr_data.bitfield);
    end;
    procedure MHDR_DAT.set_threadedmessageflag (b : boolean);
    begin
      if b then setbit(ord(threadedmessageflag),mhdr_data.bitfield)
      else zerobit(ord(threadedmessageflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_threadedmessageflag: boolean;
    begin
      get_threadedmessageflag := getbit(ord(threadedmessageflag),mhdr_data.bitfield);
    end;
    procedure MHDR_DAT.set_privatemessage ( b : boolean);
    begin
     if b then setbit(ord(privatemessageflag),mhdr_data.bitfield)
     else zerobit(ord(privatemessageflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_privatemessage : boolean;
     begin
     get_privatemessage := getbit(ord(privatemessageflag),mhdr_data.bitfield);
    end;
    procedure MHDR_DAT.set_deletedmessage (b : boolean);
    begin
     if b then setbit(ord(deletedmessageflag),mhdr_data.bitfield)
     else zerobit(ord(deletedmessageflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_deletedmessage : boolean;
    begin
     get_deletedmessage := getbit(ord(deletedmessageflag),mhdr_data.bitfield);
    end;
    procedure MHDR_DAT.set_recievedmessage( b : boolean);
    begin
     if b then setbit(ord(recievedmessageflag),mhdr_data.bitfield)
     else zerobit(ord(recievedmessageflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_recievedmessage : boolean;
    begin
     get_recievedmessage := getbit(ord(recievedmessageflag),mhdr_data.bitfield);
    end;
    procedure MHDR_DAT.set_permanentmessage(b : boolean);
    begin
     if b then setbit(ord(permanentmessageflag),mhdr_data.bitfield)
     else zerobit(ord(permanentmessageflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_permanentmessage : boolean;
     begin
      get_permanentmessage := getbit(ord(permanentmessageflag),mhdr_Data.bitfield);
    end;
    procedure MHDR_DAT.set_tritossecho (b : boolean);
    begin
     if b then setbit(ord(tritossechoflag),mhdr_data.bitfield)
     else zerobit(ord(tritossechoflag),mhdr_data.bitfield);
    end;
    function MHDR_DAT.get_tritossecho : boolean;
    begin
     get_tritossecho := getbit(ord(tritossechoflag),mhdr_data.bitfield);
    end;


procedure USERS_SPF.additem;
var
 SPF,SPF1 : USERFILEPTR;
begin
  new(SPF);
  SPF^.files := usersf_data;
  SPF^.next := nil;
 if usersf_header = nil then usersf_header := SPF
   else begin
        SPF1 := usersf_header;
        while SPF1^.next <> nil do
          SPF1 := SPF1^.next;
          SPF1^.next := SPF;
   end; {else}
end;
procedure USERS_SPF.deletelist;
var
s,s1 : USERFILEPTR;
i : word;
begin
s := usersf_header;
While s <> Nil Do
		Begin
			s1 := s;
			s := s^.Next;
			Dispose(s1);
		End;
usersf_header := nil;
end;
procedure USERS_SPF.getconference(i : word);
var c : longint;
s : userfileptr;
begin
s := usersf_header;
 for c := 1 to i-1 do
  s := s^.next;
  usersf_data := s^.files;
end;
procedure USERS_SPF.setconference(i : word);
var c : longint;
 s : userfileptr;
begin
  s := usersf_header;
   for c := 1 to i-1 do
     s := s^.next;
     s^.files := usersf_data;
end;
procedure USERS_SPF.open;
begin
 USERSF_FILE.open(tbnode1smaindirectory+'MWORK\USERS.SPF');
 USERSF_HEADER := nil;
end;
procedure USERS_SPF.closefile;
begin
 USERSF_FILE.closefile;
 deletelist;
end;
procedure USERS_SPF.read(n : longint);
var c,u,i : longint;
begin
 dec(n);
 u := n * (tbnumberofmessageareas * sizeof(userSF_data));
 for i := 1 to tbnumberofmessageareas do begin
  c := u + ((i-1) * sizeof(userSF_data));
  c := c div sizeof(userSF_data);
  userSF_file.dread(c+1,sizeof(userSF_data),userSF_Data);
  additem;
end;
end;
procedure USERS_SPF.write(n : longint);
var c,u,i : longint;
begin
 dec(n);
 u := n * (tbnumberofmessageareas * sizeof(userSF_data));
 for i := 1 to tbnumberofmessageareas do begin
  c := u + ((i-1) * sizeof(userSF_data));
  c := c div sizeof(userSF_data);
  getconference(i);
  userSF_file.dwrite(c+1,sizeof(userSF_data),userSF_Data);
end;
end;
function USERS_SPF.length : longint;
begin
 length := tbnumberofmessageareas div sizeof(userssupmessages);
end;
procedure USERS_SPF.openread(n : longint);
begin
  open;
  read(n);
end;
procedure USERS_SPF.writeclose(n : longint);
begin
 write(n);
 closefile;
end;
procedure USERS_SPF.openreadclose(n : longint);
begin
 open;read(n);closefile;
end;
procedure USERS_SPF.openwriteclose(n: longint);
begin
  open;write(n);closefile;
end;
procedure USERS_SPF.set_accessprivatearea ( b : boolean);
begin
  if b then setbit(ord(accessprivateconferenceflag),userSF_data.bitfields)
  else zerobit(ord(accessprivateconferenceflag),userSF_data.bitfields);
end;
function USERS_SPF.get_accessprivatearea : boolean;
begin
  get_accessprivatearea := getbit(ord(accessprivateconferenceflag),userSF_data.bitfields);
end;



procedure DOORS_TMP.open;
begin
  DOORS_FILE.open(tbnodesmaindirectory+'NWORK\DOORS.TMP');
end;
procedure  DOORS_TMP.closefile;
begin
  DOORS_FILE.closefile;
end;
procedure  DOORS_TMP.read;
begin
  DOORS_FILE.dRead(1,sizeof(DOORS_DATA),DOORS_DATA);
end;
procedure  DOORS_TMP.write;
begin
  DOORS_FILE.dWrite(1,sizeof(DOORS_DATA),DOORS_DATA);
end;
procedure  DOORS_TMP.openread;
begin
open;read;
end;
procedure  DOORS_TMP.writeclose;
begin
write;closefile;
end;
procedure  DOORS_TMP.openreadclose;
begin
open;read;closefile;
end;
procedure  DOORS_TMP.openwriteclose;
begin
open;write;closefile;
end;
procedure  DOORS_TMP.clearit;
begin
fillchar(DOORS_DATA,sizeof(DOORS_DATA),#0);
end;
function  DOORS_TMP.length : longint;
begin
  length := DOORS_FILE.length(sizeof(DOORS_DATA));
end;
procedure  DOORS_TMP.set_TimeLeftAtLogon(w : word);
begin
   DOORS_DATA.TimeLeftAtLogon := w;
end;
function  DOORS_TMP.get_TimeLeftAtLogon : word;
begin
  get_TimeLeftAtLogon := DOORS_DATA.TimeLeftAtLogon;
end;
procedure  DOORS_TMP.set_CurrentFileArea (w : word);
begin
   DOORS_DATA.CurrentFileArea := w;
end;
function  DOORS_TMP.get_CurrentFileArea : word;
begin
  get_currentfilearea := doors_data.currentfilearea;
end;
procedure  DOORS_TMP.set_CurrentMessageArea (w : word);
begin
  doors_Data.currentmessagearea := w;
end;
function  DOORS_TMP.get_currentmessagearea : word;
begin
  get_currentmessagearea := doors_data.currentmessagearea;
end;
procedure  DOORS_TMP.set_FrontEndTime (w : word);
begin
  doors_data.frontendtime := w;
end;
function  DOORS_TMP.get_frontendtime : word;
begin
  get_frontendtime := doors_data.frontendtime;
end;
procedure  DOORS_TMP.set_WhereTheDoorWasCalledFrom(w : word);
begin
  doors_data.wherethedoorwascalledfrom := w;
end;
function  DOORS_TMP.get_wherethedoorwascalledfrom : word;
begin
  get_wherethedoorwascalledfrom := doors_Data.wherethedoorwascalledfrom;
end;
procedure  DOORS_TMP.set_Languagenumber (w : word);
begin
  doors_Data.languagenumber := w;
end;
function  DOORS_TMP.get_LanguageNumber: word;
begin
  get_languagenumber := doors_Data.languagenumber;
end;
procedure  DOORS_TMP. set_NumberofFilesFlagged (w : word);
begin
  doors_Data.numberoffilesflagged := w;
end;
function  DOORS_TMP.get_numberoffilesflagged : word;
begin
  get_numberoffilesflagged := doors_Data.numberoffilesflagged;
end;
procedure  DOORS_TMP.set_TimeinDoorSys (w : word);
begin
  doors_Data.timeindoorsys := w;
end;
function  DOORS_TMP.get_timeindoorsys : word;
begin
   get_timeindoorsys := doors_Data.timeindoorsys;
end;
procedure  DOORS_TMP.set_UserRecordNumber (l : longint);
begin
    Doors_Data.UserRecordNumber := l;
end;
function  DOORS_TMP.get_Userrecordnumber : longint;
begin
    get_userRecordNumber := doors_data.userrecordnumber;
end;
procedure  DOORS_TMP.set_BaudRate (L : longint);
begin
   doors_Data.baudrate := l;
end;
function  DOORS_TMP.get_Baudrate : longint;
begin
   get_baudrate := doors_Data.baudrate;
end;
procedure  DOORS_TMP.set_FrontEndBaudRate (l : longint);
begin
  doors_Data.frontendbaudrate := l;
end;
function  DOORS_TMP.get_Frontendbaudrate : longint;
begin
   get_frontendbaudrate := doors_Data.frontendbaudrate;
end;
procedure  DOORS_TMP.set_TimeWhenUserLoggedOn (l : longint);
begin
  doors_Data.timewhenuserloggedon := l;
end;
function  DOORS_TMP.get_TimeWhenuserloggedon : longint;
begin
  get_timewhenuserloggedon := doors_Data.timewhenuserloggedon;
end;

procedure  DOORS_TMP.set_ANSI(b : boolean);
begin
  if b then setbit(ord(ansiflag),doors_Data.bitfield) else
  zerobit(ord(ansiflag),doors_Data.bitfield);
end;
function  DOORS_TMP.get_ANSI : boolean;
begin
  get_ansi := getbit(ord(ansiflag),doors_Data.bitfield);
end;
procedure  DOORS_TMP.set_FrontEnd(b : boolean);
begin
  if b then setbit(ord(frontendflag),doors_Data.bitfield)
  else zerobit(ord(frontendflag),doors_Data.bitfield);
end;
function  DOORS_TMP.get_FrontEnd : boolean;
begin
  get_frontend := getbit(ord(frontendflag),doors_Data.bitfield);
end;
procedure  DOORS_TMP.set_FrontEndHangup ( b : boolean);
begin
end;
function  DOORS_TMP.get_FrontEndHangup : boolean;
begin
end;
procedure  DOORS_TMP.set_UserWindowFlag ( B : boolean);
begin
end;
function  DOORS_TMP.get_UserWindowFlag : boolean;
begin
end;
procedure  DOORS_TMP.set_ChatRequested (b : boolean);
begin
end;
function  DOORS_TMP.get_ChatRequested : boolean;
begin
end;
procedure  DOORS_TMP.set_EventPending ( b: boolean);
begin
end;
function  DOORS_TMP.get_EventPending : boolean;
begin
end;
procedure  DOORS_TMP.set_GoodByeFromDoor ( b : boolean);
begin
  if b then setbit(ord(goodbyefromdoorflag),doors_Data.bitfield)
  else zerobit(ord(goodbyefromdoorflag),doors_Data.bitfield);
end;
function  DOORS_TMP.get_GoodByeFromDoor : boolean;
begin
  get_goodbyefromdoor := getbit(ord(goodbyefromdoorflag),doors_Data.bitfield);
end;
procedure  DOORS_TMP.set_ForceBoardDownAfterCaller (b : boolean);
begin
end;
function  DOORS_TMP.get_ForceBoardDownAfterCaller : boolean;
begin
end;
procedure  DOORS_TMP.set_RIPScrip (b : boolean);
begin
end;
function  DOORS_TMP.get_RIPScrip : boolean;
begin
end;
procedure  DOORS_TMP.set_DoorSYS (B : boolean);
begin
end;
function  DOORS_TMP.get_DoorSYS : boolean;
begin
end;
procedure  DOORS_TMP.set_ErrorCorrecting (b : boolean);
begin
end;
function  DOORS_TMP.get_ErrorCorrecting : boolean;
begin
end;

procedure tbaddline (s : string);
var i : longint;
begin
if tbptr = 0 then begin
   tbptr := 1;
   new(tbtxtptr);
   fillchar(tbtxtptr^,64000,#32);
end;
                  if tbptr = 1 then begin
                     tbtxtptr^[1] := #32;
                     inc(tbptr);
                  end;
                  for i := tbptr to tbptr + length(s) do
                     tbtxtptr^[i] := s[(i - tbptr)+1];
                     inc(tbptr,length(s));
                     inc(tbptr);
                     tbtxtptr^[tbptr-1] := #13;

end;

function tbgetline(l : longint) : string;
var temp : string;
begin
temp := '';
  repeat
   temp := temp + tbtxtptr^[tbptr];
   inc(tbptr);
  until (tbtxtptr^[tbptr] = #13) or ( tbptr >= l);
  inc(tbptr);
  dec(byte(temp[0]));
  tbgetline := temp;
end;
function tbeom (l : longint): boolean;
begin
 tbeom := tbptr >= l;
end;

begin
end.