/* File created by MERGEC 1.0 (c) 1995 Tillmann Steinbrecher */

/* UNTGZ Decompression Utiliy 0.92 Copyright (c) 1996 Tillmann Steinbrecher  

   This freeware program may be distributed according to the terms of the
   GNU general public license version 2 - see file 'copying' for details.

   Revision History
	Ver. 0.01	Sep  9, 1995	original version
	Ver. 0.02	Sep 13, 1995	implemented crc-check
	Ver. 0.03	Sep 15, 1995	minor modifications (speedup???)
	Ver. 0.04	Sep 16, 1995	Implemented list-feature, much more
	Ver. 0.05	Sep 17, 1995	LOTS of bug fixes
	Ver. 0.06	Sep 18, 1995	minor bug fixes
	Ver. 0.07	Sep 23, 1995	implemented timestamp support
	Ver. 0.08	Sep 28, 1995	increased buffer size, 32bit version
	Ver. 0.09	Nov 25, 1995    implemented checksum-routines, bugfixes
	Ver. 0.90       Jan 06, 1996    revamped routines for creating subdirs
	Ver. 0.91	Jan 15, 1996	bugfixes, added Win32 long filenames
	Ver. 0.92	Jan 20, 1996	much better wildcard matching (MATCH.C)

   If you improve this code, please send it to:
			t.steinbrecher@hems.da.he.schule.de

 Known bugs:
     - None in this release. Please report any bugs you can find!

 To Do:
     - add PKZIP archive support
     - add -d option (same as gzip -d)
     - add option for extracting uncompressed tar archives (same as tar xvf)
     - add -t option (for testing archives) (low priority)
*/


#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <io.h>
#include <dos.h>
#include <process.h>

#ifdef __BORLANDC__
  #include <alloc.h>
  #include <dir.h>
#else
  #include <time.h>
  #include <sys/timeb.h>
#endif

/* Definitions for UNTGZ - Copyright (c) 1996 Tillmann Steinbrecher */

#define	CMD_DONOTHING	0
#define	CMD_EXTRACT	1
#define CMD_EXTRACT_NOPATH	2
#define	CMD_LIST	3
#define	CMD_TEST	4

#ifdef _32BIT_VERSION_
  #define LONG_NAME "UNTGZ/32bit Decompression Utility "
  #define PROG_NAME "\nuntgz32"
  #define EXE_NAME "UNTGZ32"
#else
#ifdef _386_VERSION_
  #define LONG_NAME "UNTGZ/386 Decompression Utility "
  #define PROG_NAME "\nuntgz386"
  #define EXE_NAME "UNTGZ386"
#else
  #define PROG_NAME "\nuntgz"
  #define LONG_NAME "UNTGZ Decompression Utility "
  #define EXE_NAME "UNTGZ"
#endif
#endif

#define VERSION		"0.92 "
#define TEST_STATUS	"freeware" /* or "beta ", "alpha ", " " */

char filespec[100];
int command=0;
int error=0;
char ignore_case=1;

int match(char*, char*, int);

#include    "inflate.c"
/* 32-Bit CRC engine, from FUNZIP.C Version 3.83
   put in the public domain by Mark J.Adler.
   Minor modifications by Tillmann Steinbrecher			*/

#include "crc_tab.h"

unsigned long updcrc(unsigned char *s,unsigned long n)
	       /* pointer to bytes to pump through */
	       /* number of bytes in s[] */
/* Run a set of bytes through the crc shift register.  If s is a NULL
   pointer, then initialize the crc shift register contents instead.
   Return the current crc in either case. */
{
  register unsigned long c;       /* temporary variable */

  static unsigned long crc = 0xffffffffL; /* shift register contents */

  if (s == (unsigned char *)NULL)
    c = 0xffffffffL;
  else
  {
    c = crc;
    while (n--)
      c = crc_32_tab[((int)c ^ (*s++)) & 0xff] ^ (c >> 8);
  }
  crc = c;
  return c ^ 0xffffffffL;       /* (instead of ~c for 64-bit machines) */
}

#include    "match.c"
/* Convert long (UNIX-Style) filenames to DOS 8+3 Format
   Copyright (c) 1996 Tillmann Steinbrecher. Ver. 0.08			*/

int dos_pathname(char name[], char dos_name[]){
	int pos=0,length=1,newpos=0,max=8;
	while(name[pos]){
		 if(name[pos]=='.'){
		   if(length!=1){
			if(max!=3){ max=3;length=0; }
			else { length=max+1; }
			}
		   else if(name[pos+1]!='/') pos++;
		  }
		if(length<=max){
			dos_name[newpos]=name[pos];
                        if(dos_name[newpos]==',') dos_name[newpos]='_';
                        if(dos_name[newpos]=='+') dos_name[newpos]='_';
			if(dos_name[newpos]=='\\') dos_name[newpos]='_';
			if(dos_name[newpos]=='=') dos_name[newpos]='_';
                        newpos++;
		}
		pos++; length++;
		if(name[pos]=='/'){ max=8;length=0; }
	   }
		dos_name[newpos]=0;
/*		printf("%s, length=%i\n",dos_name,strlen(dos_name)); */
		return 1;
	}

/*	TAR stream decompression engine Copyright (c) 1996 T. Steinbrecher */


#ifndef PROG_NAME
	#define	PROG_NAME	"untar-engine"
#endif

/* #define VERBOSE */

typedef struct {
  char name[100];
  char operm[8];
  char ouid[8];
  char ogid[8];
  char osize[12];
  char otime[12];
  char ocsum[8];
  char flags;
  char filler[355];
} TARHEADER;

  int outfile;
  long position=-1,size;
  long datapos=0;
  char dosname[100]="";
  char skip=0, answer=0, s_answer=0;
  struct ftime timedate;

int c_break(void){
	printf(PROG_NAME ": error - aborted, file may be corrupt.");
	error++;
	printf(PROG_NAME ": found %i errors\n",error);
	exit(2);
	return 0; /* Never reached ... */
	}

int ask(void){
	if(answer=='a'||answer=='A') return 1;
	if(answer=='s'||answer=='S') { printf(" skipped"); return 0; }
	for(;;){
		printf(" (Y/N/A/S/Q) Y\b");
		answer=getche();
		if(answer=='y'||answer=='Y'||answer==13) return 1;
		if(answer=='n'||answer=='N'||answer==27) return 0;
		if(answer=='a'||answer=='A') return 1;
		if(answer=='s'||answer=='S') return 0;
		if(answer=='q'||answer=='Q') c_break();
		printf("\nYes, No, Always, Skip or Quit\a");
	       }
	  }

int istarheader(unsigned char *hdr,long csum){
	long newsum=0;
	int cnt;
	for(cnt=0;cnt<=147;cnt++) newsum+=*(hdr+cnt);
	for(cnt=156;cnt<512;cnt++) newsum+=*(hdr+cnt);
	newsum+=256;
#ifdef VERBOSE
	printf("newsum=%li csum=%li\n",newsum,csum); 
#endif
	if(newsum==csum) return 1;
        else {
                if(s_answer=='a'||s_answer=='A'||s_answer==13) return 0;
                printf(PROG_NAME ": warning - possibly invalid tar archive, skip to next block");
	for(;;){
		printf(" (Y/N/A/Q) A\b");
                s_answer=getche();
		if(s_answer=='y'||s_answer=='Y') return 0;
		if(s_answer=='n'||s_answer=='N') return 1;
                if(s_answer=='a'||s_answer=='A'||s_answer==13) {
			printf(PROG_NAME ": searching for valid tar header ...");
			return 0;
		      }	
                if(s_answer=='q'||s_answer=='Q') c_break();
                printf("\nYes, No, Always or Quit\a");
	       }
           }     
	}

int createnewdir(char name[]){
	char stat;
	if (name[strlen(name)-1] == '/') name[strlen(name)-1] = 0;
	printf(" Creating directory: %s ", name);
	stat = mkdir(name
#ifdef GNUDOS
	,0
#endif
	);
	if (stat && (errno==EACCES))
	{
	  printf(PROG_NAME ": warning - duplicate directory name\n");
	  stat=0;
	}

	if (stat) {
	  printf(PROG_NAME ": error - unable to create directory\n");
	  error++;
	  return -1;
		}
	return 0;
    }

int create_path(char *path){
	char create[128],pos;
	printf("- missing directory!\n Auto-creating directories for %s\n",path);
        for(pos=0;pos<=(strrchr(path,'/')-path);pos++){
          if(path[pos]=='/') { 
		create[pos]=0;
		createnewdir(create);
		create[pos]='/';
		printf("OK\n");
			   }
          else create[pos]=path[pos];
        }
	printf(" Directories created, extracting %s ",path);
	return 0;
	}


int openfile(char oldname[],char name[]) {
      printf(" Extracting %s ",oldname);
      if(strcmp(oldname,name))printf("to %s ",name);

      outfile = open(name, O_WRONLY|O_BINARY|O_CREAT|O_EXCL, S_IWRITE|S_IREAD);
      if (outfile < 0 && errno==ENOENT) {
		create_path(name);
		outfile = open(name, O_WRONLY|O_BINARY|O_CREAT|O_EXCL, S_IWRITE|S_IREAD);
	      }
      if (outfile < 0 && errno==EEXIST){
	  printf(PROG_NAME ": file %s exists - overwrite",name);
	  if(ask()) {
		outfile=open(name, O_WRONLY|O_BINARY|O_TRUNC, S_IWRITE|S_IREAD);
		printf("\n Overwritig %s ",name);
		    }
	  else{
	    printf("\n Skipping %s ",name);
	    return 1;
	   }
	  }
	 if(outfile<0){
                printf(PROG_NAME ": error - can't create file, skipping %s ",dosname);
		error++;
		return 1;
	    }
	return 0;
	}


int untarstream(unsigned char data[], unsigned long datasize)
{
  unsigned long dsize=0;
  TARHEADER header;
  long perm, uid, gid, time, csum;
  struct time filetime;
  struct date filedate;

  datapos=0;
  for(;;){
   if(position==-1) {
do{
    memcpy( &header, data+datapos,512);
    if (header.name[0] == 0) break; 
    sscanf(header.operm, "%lo", &perm);
    sscanf(header.ouid, "%lo", &uid);
    sscanf(header.ogid, "%lo", &gid);
    sscanf(header.ocsum, "%lo", &csum);
    sscanf(header.osize, "%lo", &size);
    sscanf(header.otime, "%lo", &time);
#ifdef VERBOSE
    printf("otime= %s ocsum= %s ",header.otime,header.ocsum);
#endif
    datapos+=512;
    if(datapos>datasize) return 0;
}while(!istarheader((char*)&header,csum));
    if (header.name[0] == 0) break; 
    position=0;
    skip=0;
#ifdef _32BIT_VERSION_
    strcpy(dosname,header.name);
#else	
    dos_pathname(header.name,dosname);
#endif
    unixtodos(time,&filedate,&filetime);
    timedate.ft_tsec=filetime.ti_sec;
    timedate.ft_min=filetime.ti_min;
    timedate.ft_hour=filetime.ti_hour;
    timedate.ft_day=filedate.da_day;
    timedate.ft_month=filedate.da_mon;
    timedate.ft_year=filedate.da_year-1980;

    if (header.flags=='5'||header.name[strlen(header.name)-1]=='/')
    {
       if (header.name[strlen(header.name)-1] == '/')
	header.name[strlen(header.name)-1] = 0;
       createnewdir(dosname);
       skip=1; /* Directory ??? */
	}
    else if(match(header.name,filespec,ignore_case))
          { skip=openfile(header.name,dosname); }
	 else { skip=1; printf(" Omitting %s ",header.name); }
}

   if ((size-position) <= (datasize-datapos)){
	dsize = size-position;

       }

   else dsize = (datasize-datapos);
   if(!skip){
    if (write(outfile,data+datapos,dsize)<dsize){
	printf(PROG_NAME ": error - can't write file, disk full?");
	error++;
	c_break();
    }
   }
   position += dsize;
   datapos += dsize;
   if(size==position) {
	if(!skip){
		setftime(outfile,&timedate);
		close(outfile);
		}
	position=-1;
	if(datapos % 512) datapos=( (datapos / 512) + 1) * 512;
	printf("OK   \n");
       }
   if(datasize==datapos)
	 return 0;  /* Finished processing buffer */
       }
return 0;
}

int listtarstream(unsigned char data[],unsigned long datasize)
{
  unsigned int dsize=0;
  TARHEADER header;
  long perm, uid, gid, time, csum;
  struct time filetime;
  struct date filedate;
  datapos=0;
  for(;;){
   if(position==-1) {
do{
    memcpy( &header, data+datapos,512);
    if (header.name[0] == 0) break;
    sscanf(header.operm, "%lo", &perm);
    sscanf(header.ouid, "%lo", &uid);
    sscanf(header.ogid, "%lo", &gid);
    sscanf(header.ocsum, "%lo", &csum);
    sscanf(header.osize, "%lo", &size);
    sscanf(header.otime, "%lo", &time);
    datapos+=512;
    if(datapos>datasize) return 0;	
}while(!istarheader((char*)&header,csum));
    if (header.name[0] == 0) break;
    position=0;
    skip=0;
    dos_pathname(header.name,dosname);
    unixtodos(time,&filedate,&filetime);

    if (header.flags=='5'||header.name[strlen(header.name)-1]=='/')
    {
       if (header.name[strlen(header.name)-1] == '/')
	header.name[strlen(header.name)-1] = 0;
       printf(" <DIR>  %02i-%02i-%02i %02i:%02i %s\n",
      filedate.da_day,filedate.da_mon,filedate.da_year,
      filetime.ti_hour,filetime.ti_min,header.name);

    }


    else if(match(header.name,filespec,ignore_case))
	  {
       printf("%li	%02i-%02i %02i %02i:%02i %s ",
      size,filedate.da_day,filedate.da_mon,filedate.da_year,
      filetime.ti_hour,filetime.ti_min,header.name);

      if(strcmp(header.name,dosname))printf("[%s]",dosname);
	printf("\n");
	  }
    fprintf(stderr," Searching ...\r");
}

   if ((size-position) < (datasize-datapos)){
	dsize = size-position;
       }
   else dsize = (datasize-datapos);
   position += dsize;
   datapos += dsize;
   if(size==position) {
	position=-1;
	if(datapos % 512) datapos=( (datapos / 512) + 1) * 512;
       }
   if(datasize==datapos)
	 return 0;  /* Finished processing buffer */
       }
 return 0;
}


/*	Interface to INFLATE.C decompression routines / tar stream handler
	Copyright (c) 1996 Tillmann Steinbrecher */


/* #define DEBUG	*/

#ifndef PROG_NAME
	#define	PROG_NAME	"gzip-engine"
#endif


/* GZIP flag definitions */
#define IS_MULTI	2
#define IS_EXTRA	4
#define IS_FILENAME	8
#define	IS_COMMENT	16
#define IS_ENCRYPT	32


UWORD mask_bits[] = {
    0x0000,
    0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f, 0x00ff,
    0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff, 0x3fff, 0x7fff, 0xffff
};

int outcnt=0;
ULONG outsiz=0;
byte *outptr;
byte *outbuf;
FILE* in;

typedef struct{
	UWORD magic;
	byte method;
	byte flags;
	ULONG time;
	byte extra_flags;
	byte os;
}gzip_hdr;

typedef struct{
	ULONG crc32;
	ULONG size;
}gzip_end;

int check_valid(void){
	gzip_end end_info;
	ULONG new_crc32;
	fread(&end_info,sizeof(end_info),1,in);
	new_crc32=updcrc(outbuf,0L);
	if(new_crc32!=end_info.crc32){
		printf(PROG_NAME ": warning - broken file(s), crc32 error!\n");
		return -1;
	       }
	return 0;
	}

int read_gzip_header(void){
	gzip_hdr header;
	char *orig_name[260]={0};/* 260 bytes hopefully is enough for filename */
	char *comments[4096];   /* 4096 bytes hopefully is enough for comments */
	char ch;
	struct time filetime;
	struct date filedate;

	fread(&header,sizeof(header),1,in);

	 if(header.magic!=0x8b1f) {
	  printf(PROG_NAME ": error - bad magic number (0x%x), not a gzip file.\n",header.magic);
	  return -1;
	 }

	if(header.method!=8) {
		printf(PROG_NAME ": error - unknown compression (%i)\n",header.method);
		return -1;
		}
	if(header.flags & IS_MULTI) {
		fprintf(stderr, PROG_NAME ": error - multi-volume archives not supported\n");
		return -1;
		}
	if(header.flags & IS_EXTRA){
		fprintf(stderr, PROG_NAME ": error - don't know how to handle extended gzip header.\n");
		return -1;
		}
	if(header.flags & IS_FILENAME){
		fscanf(in,"%s",orig_name);
		if(getc(in)==EOF) {
			fprintf(stderr, PROG_NAME ": error - unexpected EOF\n");
			return -1;
		       }
		}
	if(header.flags & IS_COMMENT){
		fscanf(in,"%s",comments);
		fprintf(stderr, "comments:\n%s",comments);
		if(getc(in)==EOF) {
			fprintf(stderr, PROG_NAME ": error - unexpected EOF\n");
			return -1;
		       }

		}
	if(header.flags & IS_ENCRYPT){
		fprintf(stderr, PROG_NAME ": error - file is encrypted.\n");
		return -1;
		}

	unixtodos(header.time,&filedate,&filetime);
	printf("Archive %s created %02i-%02i-%02i %02i:%02i on ",
	orig_name, filedate.da_day, filedate.da_mon,
	filedate.da_year, filetime.ti_hour, filetime.ti_min);

	switch(header.os){
		case 0x00:
			printf("MS-DOS platform");
			break;
		case 0x01:
			printf("Amiga platform");
			break;
		case 0x02:
			printf("VAX/VMS platform");
			break;
		case 0x03:
			printf("UNIX platform");
			break;
		case 0x05:
			printf("Atari platform");
			break;
		case 0x06:
			printf("OS/2 platform");
			break;
		case 0x07:
			printf("Macintosh platform");
			break;
		case 0x0a:
			printf("TOPS20 platform");
			break;
		case 0x0b:
			printf("Windows NT platform");
			break;
		case 0x0f:
			printf("PRIMOS platform");
			break;
		default:
			printf("unknown platform (0x%X)",header.os);
		}
	printf("\n");
	updcrc(NULL,0);	/* Initialize CRC engine */
	return 0;
}

int ReadByte(UWORD *x){
	register int ch=getc(in);
	if(ch==EOF)return 0;
	*x=(UWORD)ch;
	return 8;
	}

int FlushOutput(void){
 if (outcnt)
  {
/*  fwrite(outbuf,1,outcnt,stdout);
    printf(outbuf);exit(1); */
    updcrc(outbuf,outcnt);
    switch(command){
	case CMD_EXTRACT:
	    untarstream(outbuf,outcnt);
	    break;
	case CMD_LIST:
	    listtarstream(outbuf,outcnt);
	    break;
	default:
	    printf(PROG_NAME ": internal error - nothing to do.\n");
	}
    outsiz += outcnt;
    outptr = outbuf;
    outcnt = 0;
  }
  return 0;
	}



char aname[128];

void usage(void){
	printf("USAGE:	" EXE_NAME " <filename> <filespec> to extract from TGZ archive\n"
	       "        " EXE_NAME " -l <filename> <filespec> to list/test TGZ archive\n\n"
	       "        This freeware program may be distributed according to \n"
	       "        the terms of the GNU general public license version 2.\n\n"
	       "        If you frequently use this program, please send e-mail\n"
	       "        to t.steinbrecher@hems.da.he.schule.de - a simple mail\n"
	       "        like \"I'm using your program\" will _seriously_ enhance\n"
	       "        the possiblity of updates being made. ;-) Thank you...\n");
	      }

void print_list(void){
	printf("\nSize	Date  Year Time  Name [DOS Name]\n\
------- ----- ---- ----- ---------------------------------------------------\n");
}


main(int argc,char **argv){
	int i;
	printf("\n" LONG_NAME VERSION TEST_STATUS " version\n"
		"Copyright (c) 1996 Tillmann Steinbrecher.\n\n");

#ifndef _32BIT_VERSION_
	ctrlbrk(c_break);
#endif

	command=CMD_EXTRACT;
	if(argc<2){ usage(); return 1; }
	outbuf=(byte*)malloc(OUTBUFSIZ);
	outptr=outbuf;


	  for (i=1; i < argc; i++){
   if((argv[i][0]=='-'||argv[i][0]=='/')&&(argv[i][1]=='l'||argv[i][1]=='L'))
     {
      if(i+1==argc){printf(PROG_NAME ": error - missing filename");error++;break;}
      else command=CMD_LIST;
	 }
     else {
	if(i<argc-1){ strcpy(aname,argv[i]);
		      if(!strcmp(argv[i+1],".")){
			 printf(PROG_NAME ": error - '%s' is not a valid filespec.",argv[i+1]);
			 c_break();
			}
		      strcpy(filespec,argv[i+1]);
		      break;
		}
	else{	      strcpy(aname,argv[i]);
		      strcpy(filespec,"*");
		      break;
		}
	  }
    }

	if((in=fopen(aname,"rb"))==0){
		printf(PROG_NAME ": error - can't open %s.\n",aname);
		return 1;
		}
	if(read_gzip_header()==-1) return -1;
	if(command==CMD_LIST) print_list();
	if(inflate_entry()) printf(PROG_NAME ": decompression engine error - bad compressed data.\n");
	FlushOutput();
	check_valid();
	return 0;
	}
