    @echo off
: This batch file demonstrates how EDDY can be used to make a copy of a
: file (with a new name, of course) in the current working directory.
:
: This is accomplished by putting an entry in EDDY.USE that names this
: file (or one like it), and associates a filespec of "*.*" with it.
:
: The sample EDDY.USE that comes with the EDDY distribution package is
: set up to demonstrate how this works (Example 13).
:
: Here's some batch code that will do the job...
:
    if &%1==& goto err
    if &%2==& goto err
    if not exist %2 goto doit
    echo .
    echo File "%2" already exists:
:
: The following lines, up to the "choice" command, are non-essential.
: They are only used to ensure that the filename has a "." in it, so
: that when it's used with the "dir" command, we don't list irrelevant
: files.  The technique is from the July, 1992 issue of "PC Magazine",
: which explains that a "/" as used in the "for" statement below peels
: off the first byte of the argument string.
:
    set __xx=%2
    :next
    set __yy=%__xx%
    for %%f in (/%__xx%) do set __xx=%%f
    if .%__xx%==%__yy% goto dot
    if %__xx%==. goto dot
    if not &%__xx%==&%__yy% goto next
    dir %2.
    goto reset
    :dot
    dir %2
    :reset
    set __xx=
    set __yy=
    :
    choice /c:yn "Overwrite "
    if errorlevel 2 goto done
:
: If you are using a version of DOS that doesn't have the "choice" command,
: you might replace the two lines above by something like this...
:
:   echo If you don't want to overwrite, press [^c]
:   pause
:
    :doit
    copy %1 %2
    goto done
    :err
    echo Syntax:  EDDYCOPY  file-to-be-copied  filename-for-copied-file
    :done
:
: NOTE -
: This file illustrates one use of EDDY's PATCH command:  The last line has
: been truncated to get rid of the CR, LF, and ^z that would normally be
: found at the end of a text file.  The result is that you don't get the
: __extra__ DOS command line prompt when the batch file is run.  Of course,
: if someone modifies this file, those 3 bytes will most likely reappear.