; MAPLAY.LSP    02/04/95        By: David Bunch
; Map layers created with DLGLX to more understandable layer names, colors &
; line types.
; Uses the the file LAYER.MAP in the SUPPORT directory of ACAD
;
(defun c:MAPLAY (/ CMDE LAYER_MAP CURLAY LAYTBL LAYLEN R_PT E_RD LSTLAY
                   RD_LINE CHAR LIN_IN COL_OUT LTYPE_OUT LAY_OUT IDX LNAME
                   LAY_LONG LAY_SHORT LEN_LAY_OUT MINL MAXL ACADDIR DIRLEN
                   FLAG_DIR IPOS)
 (setq olderr *error*)
 (setq *error* ddb_err)
 (setq ACADDIR (parchr (getvar "ACADPREFIX") ";"))   ;get acad directories
 (setq DIRLEN (length ACADDIR))                      ;# of directories
 (setq CMDE (getvar "CMDECHO"))
 (setq FLAG_DIR 0 IPOS 0)
 (while (and (= FLAG_DIR 0) (< IPOS DIRLEN))
;Try each path name listed in the variable ACADPREFIX until file is found
;or list is exhausted
  (setq LAYER_MAP (strcat (nth IPOS ACADDIR) "LAYER.MAP"))
  (princ (strcat "\nTrying \"" LAYER_MAP "\""))
;Is it in this directory path?
  (if (findfile LAYER_MAP)
   (progn
    (princ (strcat "\nUsing layer map file '" LAYER_MAP "'"))
    (setq FLAG_DIR 1)
    (setq MINL 100 MAXL 0)
    (setq LSTLAY (tblnext "LAYER" T))            ;Get 1st layer name
    (while (/= LSTLAY nil)
     (setq CURLAY (CDR (ASSOC '2 LSTLAY)))       ;Layer name
     (setq LAYTBL (append LAYTBL (list CURLAY))) ;Create list of layers
     (setq LSTLAY (tblnext "LAYER"))             ;Get next layer name
    )
    (setq LAYLEN (length LAYTBL))                ;# of layers in drawing
    (setq R_PT (open LAYER_MAP "r"))             ;Open Layer Map file
    (princ "\nWorking...")
    (while (setq RD_LINE (read-line R_PT))      ;Read a line from file
     (setq CHAR (substr RD_LINE 1 1))           ;Check for a comment line
     (if (and (/= RD_LINE nil)(/= CHAR ";"))
      (progn
       (setq LIN_IN (parchr RD_LINE ","))        ;Turn read line into a list
;Line must have at least 4 fields
       (if (> (length LIN_IN) 4)
        (progn
         (setq LAY_IN (nth 0 LIN_IN))            ;Layer to map from
         (setq COL_OUT (nth 1 LIN_IN))           ;Color to map to
         (setq LTYPE_OUT (nth 2 LIN_IN))         ;Line type to map to
         (setq LAY_OUT (nth 4 LIN_IN))           ;Layer to map to
         (setq IDX 0)
         (while (< IDX LAYLEN)
          (if (= (setq LNAME (nth IDX LAYTBL)) LAY_IN)
           (progn
            (princ (strcat "\nChanging " LNAME " to " LAY_OUT))
            (setvar "cmdecho" 0)
            (command "._RENAME" "LAYER" LNAME LAY_OUT)
            (command "._LAYER" "COLOR" COL_OUT  LAY_OUT "")
            (command "._LAYER" "LTYPE" LTYPE_OUT LAY_OUT "")
            (setvar "cmdecho" CMDE)
           )
          )
          (setq IDX (+ IDX 1))
         )
        )
       )
      )
     )
    )
    (close R_PT)
   )
  )
  (setq IPOS (+ IPOS 1))
 )
 (if (= FLAG_DIR 0)
  (progn
   (princ "\nLAYER.MAP file not found in any of the directories that\n")
   (princ "the envirornment variable \"ACAD\" points to\n")
  )
 )
 (setq *error* olderr)                ; Restore old *error* handler
 (princ)
)
(defun ddb_err (st)                   ; If an error (such as CTRL-C) occurs
                                      ; while this command is active...
  (if (and (/= st "Function cancelled") 
           (/= st "quit / exit abort")
      )
    (princ (strcat "\nError: " st))
  ) 
  (setq *error* olderr)               ; Restore old *error* handler
  (princ)
)
; PARSE.LSP     By: Paul Amout
;
; Date February 1, 19xx
;
; The PARSE routine will read CDF (Comma Delimited Format) or SDF (Space
; Delimited format) string and returns a list. Each field is an element of
; returned list. Example.
;
; Example (PARSE "Hello, Goodbye") returns ("Hello" "Goodbye")
;
; Revised 11/21/94 By: David Bunch to handle TAB's as well
;
(defun PARSE (STR / REF N CHAR LSTR LADD LST)
 (setq REF (strlen STR) N 1)
 (while (>= REF N)
  (setq CHAR (substr STR N 1))
  (while
   (and
    (/= CHAR ",")
    (/= CHAR "")
    (/= CHAR " ")               ;Space Character
    (/= CHAR "	")              ;Tab Character
   )                            ;-----end AND
   (if
    (null LSTR)
    (setq LSTR CHAR)
    (setq LSTR (strcat LSTR CHAR))
   )                            ;-----end IF
   (setq N (1+ N))
   (setq CHAR (substr STR N 1))
  )                             ;-----end WHILE
  (setq LADD LSTR LSTR nil)
  (setq N (1+ N))
  (if
   (/= LADD nil)
   (setq LST (append LST
              (list LADD)
             )                  ;-----end APPEND
   )                            ;-----end SETQ
  )                             ;-----end IF
 )                              ;-----end WHILE
)                               ;-----end DEFUN
;Parse using 1 specific character
(defun PARCHR (STR PCHR / REF N CHAR LSTR LADD LST)
 (setq REF (strlen STR) N 1)
 (while (>= REF N)
  (setq CHAR (substr STR N 1))
  (while (and (/= CHAR PCHR)(/= CHAR ""))
   (if (null LSTR)(setq LSTR CHAR)(setq LSTR (strcat LSTR CHAR)))
   (setq N (1+ N))
   (setq CHAR (substr STR N 1))
  )
  (setq LADD LSTR LSTR nil)
  (setq N (1+ N))
  (if (/= LADD nil)
   (setq LST (append LST(list LADD)))
  )
 )
)
(princ)
