/*
 * FM/2 2.x installation program copyright (c) 1994/96 by M. Kimes
 *
 * This program creates folders to hold program and data objects,
 * then creates program objects for each executable.  It only needs to be
 * run once (unless you move the FM/2 directory -- see say notes at end).
 * Run this program in the FM/2 directory (where you unpacked the archive).
 *
 * For unattended installation, remove the lines marked with "NOTE:" below.
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

say'     Ŀ'
say'                       FM/2 2.x Installation Program                    '
say'                  FM/2 is copyright (c) 1993-96 by M. Kimes             '
say'                            All rights reserved                         '
say'     Ĵ'
say'     Ĵ'
say'                     Have you read the READ.ME file yet?                '
say'             By running this program, you agree to the license          '
say'                          as specified in that file,                    '
say'           and it tells you how to install, so you should read it.      '
say'                                  Please?                               '
say'     '

/*
 * allow user to eliminate associations from being placed on AV/2.
 * seemed to upset some fellow on CIS (I guess he doesn't know about
 * Settings notebooks on WPS objects).
 */
assocfilter = ';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0,READ.ME,README,README.1ST,README.OS2,REGISTER.TXT'
existed = ''
parse upper arg dummy
if dummy = 'NOASSOC' then assocfilter = ''

rc = stream('fm3.exe','c','query exists')
if rc = '' then
do
  say 'Sorry, FM3.EXE not found.  Must not be right directory.  Terminating.'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */

say ''
say 'This program creates objects for FM/2 and does some drudgework for you.'
say ''

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* NOTE:  remove following 6 lines for unattended use... */
call charout ,'  Press [Enter] to continue...'
dummy = ''
do until dummy = '0d'x
  dummy = SysGetKey('NOECHO')
end
call charout ,'0d1b'x'[K'

/* save current directory */

curdir = directory()

/* say it, then do it */

say "Creating File Manager/2 folders and objects..."

/* first, create FM/2 folder */

rc = stream('fm2fldr.ico','c','query exists')
title = "File Manager/2"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<FM3_Folder>;OPEN=DEFAULT'
if rc \= '' then setup = setup';ICONFILE='rc
result = SysCreateObject(classname,title,location,setup,f)

/* NOTE:  remove following 18 lines for unattended use... */
if result = 0 then
do
  assocfilter = ''
  existed = 'TRUE'
  say ''
  say 'The File Manager/2 folder already exists.'
  call charout ,"Should I update the objects (it's painless)? (Y/N) "
  dummy = ''
  do forever
    dummy = SysGetKey('NOECHO')
    parse upper var dummy dummy
    if dummy = '1b'x then dummy = 'N'
    if dummy = '0d'x then dummy = 'Y'
    if dummy = 'N' then leave
    if dummy = 'Y' then leave
  end
  call charout ,dummy
  say ''
  if dummy = 'N' then exit
end

/* create objects in appropriate folders */

rc = stream('fm3.exe','c','query exists')
if rc \= '' then
do
  title = "FM/2"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('fm4.exe','c','query exists')
if rc \= '' then
do
  title = "FM/2 Lite"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'OBJECTID=<FM/2 LITE>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

/* create toolbox folder in FM/2 folder */
rc = stream('toolbox.ico','c','query exists')
title = "FM/2 Tools"
classname = 'WPFolder'
location = '<FM3_Folder>'
setup = 'OBJECTID=<FM3_Tools>;OPEN=DEFAULT'
if rc \= '' then setup = setup';ICONFILE='rc
result = SysCreateObject(classname,title,location,setup,u)
end

rc = stream('av2.exe','c','query exists')
if rc \= '' then
do
  title = "Archive Viewer/2"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_AV/2>;EXENAME='rc';STARTUPDIR='curdir''assocfilter
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('eas.exe','c','query exists')
if rc \= '' then
do
  title = "EA Viewer"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_EAVIEW>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('dirsize.exe','c','query exists')
if rc \= '' then
do
  title = "Dir Sizes"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_DIRSIZE>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('makearc.exe','c','query exists')
if rc \= '' then
do
  title = "Make Archive"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_MAKEARC>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('ini.exe','c','query exists')
if rc \= '' then
do
  if assocfilter \= '' then assocfilter = ';ASSOCFILTER=*.INI'
  title = "INI Viewer"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_INIVIEW>;EXENAME='rc';STARTUPDIR='curdir''assocfilter
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('viewinfs.exe','c','query exists')
if rc \= '' then
do
  title = "Bookshelf Viewer"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_BOOKSHELF>;EXENAME='rc';STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
  title = "Helpfile Viewer"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'EXENAME='rc';PARAMETERS=DUMMY;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('killproc.exe','c','query exists')
if rc \= '' then
do
  title = "Process Killer"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_KILLPROC>;EXENAME='rc';PARAMETERS=%;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('undel.exe','c','query exists')
if rc \= '' then
do
  title = "Undeleter"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_UNDEL>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vtree.exe','c','query exists')
if rc \= '' then
do
  title = "Visual Tree"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_VTREE>;EXENAME='rc';STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vdir.exe','c','query exists')
if rc \= '' then
do
  title = "Visual Directory"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_VDIR>;EXENAME='rc';STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vcollect.exe','c','query exists')
if rc \= '' then
do
  title = "Collector"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_VCOLLECT>;EXENAME='rc';STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
  title = "Seek and scan"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_VSEEK>;EXENAME='rc';PARAMETERS=**;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('global.exe','c','query exists')
if rc \= '' then
do
  title = "Global File Viewer"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_SEEALL>;EXENAME='rc';STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('databar.exe','c','query exists')
if rc \= '' then
do
  title = "Databar"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_DATABAR>;EXENAME='rc';STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('sysinfo.exe','c','query exists')
if rc \= '' then
do
  title = "SysInfo"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'OBJECTID=<FM/2_SYSINFO>;EXENAME='rc';STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('READ.ME','c','query exists')
if rc \= '' then
do
  title = "Read.Me"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('HISTORY.TXT','c','query exists')
if rc \= '' then
do
  title = "History.Txt"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('REGISTER.TXT','c','query exists')
if rc \= '' then
do
  title = "Register.Txt"
  classname = 'WPShadow'
  location = '<FM3_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('FM3.HLP','c','query exists')
if rc \= '' then
do
  if assocfilter \= '' then assocfilter=';ASSOCFILTER=*.HLP'
  rc = stream('SEEHELP.EXE','c','query exists')
  if rc \= '' then
  do
    title = "FM/2 Online Help"
    classname = 'WPProgram'
    location = '<FM3_Folder>'
    setup = 'EXENAME='rc';STARTUPDIR='curdir';PARAMETERS= %* 'curdir'\FM3.HLP'
    call SysCreateObject classname,title,location,setup,u
  end
end

rc = stream('UTILS\MAKEOBJ.CMD','c','query exists')
if rc \= '' then
do
  title = "Make Object"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'EXENAME='rc';STARTUPDIR='curdir'\UTILS;PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('UTILS\FM2UTILS.DOC','c','query exists')
if rc \= '' then
do
  title = "FM2UTILS.DOC"
  classname = 'WPShadow'
  location = '<FM3_Tools>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

/* create sample customizations for the user so they don't start 'blank' */

rc = stream('FM3MENU.DAT','c','query exists')
if rc = '' then
do
  rc = stream('FM2MENU.TMP','c','query exists')
  if rc \= '' then
  do
    say 'Creating a sample FM3MENU.DAT file for you.'
    'REN FM3MENU.TMP FM3MENU.DAT 1>NUL 2>NUL'
  end
end
'DEL FM3MENU.TMP 1>NUL 2>NUL'
rc = stream('ASSOC.DAT','c','query exists')
if rc = '' then
do
  rc = stream('ASSOC.TMP','c','query exists')
  if rc \= '' then
  do
    say 'Creating a sample ASSOC.DAT file for you.'
    'REN ASSOC.TMP ASSOC.DAT 1>NUL 2>NUL'
  end
end
'DEL ASSOC.TMP 1>NUL 2>NUL'
rc = stream('COMMANDS.DAT','c','query exists')
if rc = '' then
do
  rc = stream('COMMANDS.TMP','c','query exists')
  if rc \= '' then
  do
    say 'Creating a sample COMMANDS.DAT file for you.'
    'REN COMMANDS.TMP COMMANDS.DAT 1>NUL 2>NUL'
  end
end
'DEL COMMANDS.TMP 1>NUL 2>NUL'
rc = stream('FILTERS.DAT','c','query exists')
if rc = '' then
do
  rc = stream('FILTERS.TMP','c','query exists')
  if rc \= '' then
  do
    say 'Creating a sample FILTERS.DAT file for you.'
    'REN FILTERS.TMP FILTERS.DAT 1>NUL 2>NUL'
  end
end
'DEL FILTERS.TMP 1>NUL 2>NUL'
rc = stream('FM3TOOLS.DAT','c','query exists')
if rc = '' then
do
  rc = stream('FM3TOOLS.TMP','c','query exists')
  if rc \= '' then
  do
    say 'Installing an FM3TOOLS.DAT file for you.'
    'REN FM3TOOLS.TMP FM3TOOLS.DAT 1>NUL 2>NUL'
  end
end
'DEL FM3TOOLS.TMP 1>NUL 2>NUL'
rc = stream('QUICKTLS.DAT','c','query exists')
if rc = '' then
do
  rc = stream('QUICKTLS.TMP','c','query exists')
  if rc \= '' then
  do
    rc = stream('CMDS.TMP','c','query exists')
    if rc \= '' then
    do
      rc = stream('UTILS.TMP','c','query exists')
      if rc \= '' then
      do
        rc = stream('SORT.TMP','c','query exists')
        if rc \= '' then
        do
          rc = stream('SELECT.TMP','c','query exists')
          if rc \= '' then
          do
            say 'Creating a sample QUICKTLS.DAT file and toolboxes for you.'
            'REN QUICKTLS.TMP QUICKTLS.DAT 1>NUL 2>NUL'
            'REN CMDS.TMP CMDS.TLS 1>NUL 2>NUL'
            'REN UTILS.TMP UTILS.TLS 1>NUL 2>NUL'
            'REN SORT.TMP SORT.TLS 1>NUL 2>NUL'
            'REN SELECT.TMP SELECT.TLS 1>NUL 2>NUL'
          end
          'DEL SELECT.TMP 1>NUL 2>NUL'
        end
       'DEL SORT.TMP 1>NUL 2>NUL'
      end
      'DEL UTILS.TMP 1>NUL 2>NUL'
    end
    'DEL CMDS.TMP 1>NUL 2>NUL'
  end
end
'DEL QUICKTLS.TMP 1>NUL 2>NUL'

/*
 * create command files that the user can execute from anywhere (we'll
 * ask the user to put this utils directory on the PATH) and that other
 * programs can execute to use FM/2 as "their" file manager.
 */

'del SETENV.CMD 1>NUL 2>NUL'
dummy = stream('SETENV.CMD','C','open')
if dummy = 'READY:' then
do
  call lineout 'SETENV.CMD','@ECHO OFF'
  call lineout 'SETENV.CMD','REM'
  call lineout 'SETENV.CMD','REM If you prefer, you can call this .CMD file'
  call lineout 'SETENV.CMD','REM instead of altering the PATH= statement in'
  call lineout 'SETENV.CMD','REM CONFIG.SYS to gain access to the FM/2'
  call lineout 'SETENV.CMD','REM command line utilities.'
  call lineout 'SETENV.CMD','REM'
  call lineout 'SETENV.CMD','IF "%FM2ENVSET%" == "" GOTO INSTALL'
  call lineout 'SETENV.CMD','GOTO SKIP'
  call lineout 'SETENV.CMD',':INSTALL'
  call lineout 'SETENV.CMD','SET FM2ENVSET=YES'
  call lineout 'SETENV.CMD','SET PATH=%PATH%;'curdir'\utils;'
  call lineout 'SETENV.CMD','ECHO Path set for FM/2 and utilities.'
  call lineout 'SETENV.CMD','GOTO END'
  call lineout 'SETENV.CMD',':SKIP'
  call lineout 'SETENV.CMD','ECHO Paths already set for FM/2 and utilities.'
  call lineout 'SETENV.CMD',':END'
  call stream 'SETENV.CMD','C','close'
end

/*
 * place an object for SETENV.CMD in folder so user doesn't have to diddle
 * their PATH statement if they don't want to for command line work.
 */


rc = stream('SETENV.CMD','c','query exists')
if rc \= '' then
do
  dummy = value('COMSPEC',,'OS2ENVIRONMENT')
  if dummy = '' then dummy = value('OS2_SHELL',,'OS2ENVIRONMENT')
  if dummy = '' then dummy = 'CMD.EXE'
  title = "FM/2 Utilities command line"
  classname = 'WPProgram'
  location = '<FM3_Tools>'
  setup = 'EXENAME='dummy';PARAMETERS=/K 'rc';STARTUPDIR=C:\'
  call SysCreateObject classname,title,location,setup,u
end

call SysMkDir curdir'\UTILS'
dummy = directory(curdir'\UTILS')
if dummy = curdir'\UTILS' then
do
  'set PATH=%PATH%;'curdir'\utils'
  'move ..\example.cmd 1>NUL 2>NUL'
  'del FM2.CMD 1>NUL 2>NUL'
  dummy = stream('FM2.CMD','C','open')
  if dummy = 'READY:' then
  do
    say 'Creating an FM2.CMD file.'
    call lineout 'FM2.CMD', "/* FM/2 command file.  Locate in a directory"
    call lineout 'FM2.CMD', " * on your PATH. */"
    call lineout 'FM2.CMD', "'@echo off'"
      call lineout 'FM2.CMD', "mydir = directory()"
      call lineout 'FM2.CMD', "arg arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'FM2.CMD', "if arg1 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg1"
      call lineout 'FM2.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg1 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg1 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "else arg1 = mydir"
      call lineout 'FM2.CMD', "if arg2 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg2,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg2"
      call lineout 'FM2.CMD', "    arg2 = stream(arg2,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg2 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg2 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg3 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg3,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg3"
      call lineout 'FM2.CMD', "    arg3 = stream(arg3,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg3 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg3 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg4 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg4,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg4"
      call lineout 'FM2.CMD', "    arg4 = stream(arg4,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg4 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg4 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg5 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg5,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg5"
      call lineout 'FM2.CMD', "    arg5 = stream(arg5,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg5 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg5 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg6 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg6,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg6"
      call lineout 'FM2.CMD', "    arg6 = stream(arg6,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg6 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg6 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg7 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg7,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg7"
      call lineout 'FM2.CMD', "    arg7 = stream(arg7,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg7 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg7 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg8 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg8,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg8"
      call lineout 'FM2.CMD', "    arg8 = stream(arg8,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg8 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg8 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
      call lineout 'FM2.CMD', "if arg9 \= '' then "
      call lineout 'FM2.CMD', "do"
      call lineout 'FM2.CMD', "  if left(arg9,1,1) \= '/' then"
      call lineout 'FM2.CMD', "  do"
      call lineout 'FM2.CMD', "    arg0 = arg9"
      call lineout 'FM2.CMD', "    arg9 = stream(arg9,'c','query exists')"
      call lineout 'FM2.CMD', "    if arg9 = '' then"
      call lineout 'FM2.CMD', "    do"
      call lineout 'FM2.CMD', "      arg9 = directory(arg0)"
      call lineout 'FM2.CMD', "      call directory mydir"
      call lineout 'FM2.CMD', "    end"
      call lineout 'FM2.CMD', "  end"
      call lineout 'FM2.CMD', "end"
    call lineout 'FM2.CMD', "n = setlocal()"
    call lineout 'FM2.CMD', "n = directory('"curdir"')"
    call lineout 'FM2.CMD', "'start fm3.exe 'arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
    call lineout 'FM2.CMD', "n = endlocal()"
    call stream 'FM2.CMD','C','close'
    'del AV2.CMD 1>NUL 2>NUL'
    dummy = stream('AV2.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an AV2.CMD file.'
      call lineout 'AV2.CMD', "/* AV/2 command file.  Locate in a directory"
      call lineout 'AV2.CMD', " * on your PATH. */"
      call lineout 'AV2.CMD', "'@echo off'"
      call lineout 'AV2.CMD', "arg arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'AV2.CMD', "if arg1 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "else arg1 = directory()"
      call lineout 'AV2.CMD', "if arg2 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg2,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg2 = stream(arg2,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg3 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg3,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg3 = stream(arg3,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg4 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg4,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg4 = stream(arg4,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg5 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg5,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg5 = stream(arg5,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg6 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg6,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg6 = stream(arg6,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg7 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg7,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg7 = stream(arg7,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg8 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg8,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg8 = stream(arg8,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "if arg9 \= '' then "
      call lineout 'AV2.CMD', "do"
      call lineout 'AV2.CMD', "  if left(arg9,1,1) \= '/' then"
      call lineout 'AV2.CMD', "  do"
      call lineout 'AV2.CMD', "    arg9 = stream(arg9,'c','query exists')"
      call lineout 'AV2.CMD', "  end"
      call lineout 'AV2.CMD', "end"
      call lineout 'AV2.CMD', "n = setlocal()"
      call lineout 'AV2.CMD', "n = directory('"curdir"')"
      call lineout 'AV2.CMD', "'start av2.exe 'arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'AV2.CMD', "n = endlocal()"
      call stream 'AV2.CMD','C','close'
    end
    else say "Couldn't create AV2.CMD file."
    'del VDIR.CMD 1>NUL 2>NUL'
    dummy = stream('VDIR.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VDIR.CMD file.'
      call lineout 'VDIR.CMD', "/* VDIR (FM/2) command file.  Locate in a directory"
      call lineout 'VDIR.CMD', " * on your PATH. */"
      call lineout 'VDIR.CMD', "'@echo off'"
      call lineout 'VDIR.CMD', "mydir = directory()"
      call lineout 'VDIR.CMD', "arg arg1 arg2"
      call lineout 'VDIR.CMD', "if arg1 \= '' then "
      call lineout 'VDIR.CMD', "do"
      call lineout 'VDIR.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'VDIR.CMD', "  do"
      call lineout 'VDIR.CMD', "    arg0 = arg1"
      call lineout 'VDIR.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'VDIR.CMD', "    if arg1 = '' then"
      call lineout 'VDIR.CMD', "    do"
      call lineout 'VDIR.CMD', "      arg1 = directory(arg0)"
      call lineout 'VDIR.CMD', "      call directory mydir"
      call lineout 'VDIR.CMD', "    end"
      call lineout 'VDIR.CMD', "  end"
      call lineout 'VDIR.CMD', "end"
      call lineout 'VDIR.CMD', "else arg1 = mydir"
      call lineout 'VDIR.CMD', "n = setlocal()"
      call lineout 'VDIR.CMD', "n = directory('"curdir"')"
      call lineout 'VDIR.CMD', "'start vdir.exe 'arg1 '%2 %3 %4 %5 %6 %7 %8 %9'"
      call lineout 'VDIR.CMD', "n = endlocal()"
      call stream 'VDIR.CMD','C','close'
    end
    else say "Couldn't create VDIR.CMD file."
    'del VTREE.CMD 1>NUL 2>NUL'
    dummy = stream('VTREE.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VTREE.CMD file.'
      call lineout 'VTREE.CMD', "/* VTREE (FM/2) command file.  Locate in a directory"
      call lineout 'VTREE.CMD', " * on your PATH. */"
      call lineout 'VTREE.CMD', "'@echo off'"
      call lineout 'VTREE.CMD', "n = setlocal()"
      call lineout 'VTREE.CMD', "n = directory('"curdir"')"
      call lineout 'VTREE.CMD', "'start vtree.exe %1 %2 %3 %4 %5 %6 %7 %8 %9'"
      call lineout 'VTREE.CMD', "n = endlocal()"
      call stream 'VTREE.CMD','C','close'
    end
    else say "Couldn't create VTREE.CMD file."
    'del VCOLLECT.CMD 1>NUL 2>NUL'
    dummy = stream('VCOLLECT.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VCOLLECT.CMD file.'
      call lineout 'VCOLLECT.CMD', "/* VCOLLECT (FM/2) command file.  Locate in a directory"
      call lineout 'VCOLLECT.CMD', " * on your PATH. */"
      call lineout 'VCOLLECT.CMD', "'@echo off'"
      call lineout 'VCOLLECT.CMD', "arg arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'VCOLLECT.CMD', "if arg1 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg2 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg2,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg2 = stream(arg2,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg3 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg3,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg3 = stream(arg3,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg4 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg4,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg4 = stream(arg4,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg5 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg5,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg5 = stream(arg5,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg6 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg6,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg6 = stream(arg6,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg7 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg7,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg7 = stream(arg7,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg8 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg8,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg8 = stream(arg8,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "if arg9 \= '' then "
      call lineout 'VCOLLECT.CMD', "do"
      call lineout 'VCOLLECT.CMD', "  if left(arg9,1,1) \= '/' then"
      call lineout 'VCOLLECT.CMD', "  do"
      call lineout 'VCOLLECT.CMD', "    arg9 = stream(arg9,'c','query exists')"
      call lineout 'VCOLLECT.CMD', "  end"
      call lineout 'VCOLLECT.CMD', "end"
      call lineout 'VCOLLECT.CMD', "n = setlocal()"
      call lineout 'VCOLLECT.CMD', "n = directory('"curdir"')"
      call lineout 'VCOLLECT.CMD', "'start vcollect.exe 'arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'VCOLLECT.CMD', "n = endlocal()"
      call stream 'VCOLLECT.CMD','C','close'
    end
    else say "Couldn't create VCOLLECT.CMD file."
    'del INI.CMD 1>NUL 2>NUL'
    dummy = stream('INI.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an INI.CMD file.'
      call lineout 'INI.CMD', "/* INI (FM/2) command file.  Locate in a directory"
      call lineout 'INI.CMD', " * on your PATH. */"
      call lineout 'INI.CMD', "'@echo off'"
      call lineout 'INI.CMD', "arg arg1"
      call lineout 'INI.CMD', "if arg1 \= '' then arg1 = stream(arg1,'c','query exists')"
      call lineout 'INI.CMD', "n = setlocal()"
      call lineout 'INI.CMD', "n = directory('"curdir"')"
      call lineout 'INI.CMD', "'start INI.exe 'arg1"
      call lineout 'INI.CMD', "n = endlocal()"
      call stream 'INI.CMD','C','close'
    end
    else say "Couldn't create INI.CMD file."
    'del EAS.CMD 1>NUL 2>NUL'
    dummy = stream('EAS.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an EAS.CMD file.'
      call lineout 'EAS.CMD', "/* EAS (FM/2) command file.  Locate in a directory"
      call lineout 'EAS.CMD', " * on your PATH. */"
      call lineout 'EAS.CMD', "'@echo off'"
      call lineout 'EAS.CMD', "arg arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'EAS.CMD', "if arg1 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "else arg1 = directory()"
      call lineout 'EAS.CMD', "if arg2 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg2,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg2 = stream(arg2,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg3 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg3,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg3 = stream(arg3,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg4 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg4,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg4 = stream(arg4,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg5 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg5,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg5 = stream(arg5,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg6 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg6,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg6 = stream(arg6,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg7 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg7,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg7 = stream(arg7,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg8 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg8,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg8 = stream(arg8,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "if arg9 \= '' then "
      call lineout 'EAS.CMD', "do"
      call lineout 'EAS.CMD', "  if left(arg9,1,1) \= '/' then"
      call lineout 'EAS.CMD', "  do"
      call lineout 'EAS.CMD', "    arg9 = stream(arg9,'c','query exists')"
      call lineout 'EAS.CMD', "  end"
      call lineout 'EAS.CMD', "end"
      call lineout 'EAS.CMD', "n = setlocal()"
      call lineout 'EAS.CMD', "n = directory('"curdir"')"
      call lineout 'EAS.CMD', "'start eas.exe 'arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'EAS.CMD', "n = endlocal()"
      call stream 'EAS.CMD','C','close'
    end
    else say "Couldn't create EAS.CMD file."
    'del DIRSIZE.CMD 1>NUL 2>NUL'
    dummy = stream('DIRSIZE.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a DIRSIZE.CMD file.'
      call lineout 'DIRSIZE.CMD', "/* DIRSIZE (FM/2) command file.  Locate in a directory"
      call lineout 'DIRSIZE.CMD', " * on your PATH. */"
      call lineout 'DIRSIZE.CMD', "'@echo off'"
      call lineout 'DIRSIZE.CMD', "mydir = directory()"
      call lineout 'DIRSIZE.CMD', "arg arg1 arg2"
      call lineout 'DIRSIZE.CMD', "if arg1 \= '' then "
      call lineout 'DIRSIZE.CMD', "do"
      call lineout 'DIRSIZE.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'DIRSIZE.CMD', "  do"
      call lineout 'DIRSIZE.CMD', "    arg0 = arg1"
      call lineout 'DIRSIZE.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'DIRSIZE.CMD', "    if arg1 = '' then"
      call lineout 'DIRSIZE.CMD', "    do"
      call lineout 'DIRSIZE.CMD', "      arg1 = directory(arg0)"
      call lineout 'DIRSIZE.CMD', "      call directory mydir"
      call lineout 'DIRSIZE.CMD', "    end"
      call lineout 'DIRSIZE.CMD', "  end"
      call lineout 'DIRSIZE.CMD', "end"
      call lineout 'DIRSIZE.CMD', "else arg1 = mydir"
      call lineout 'DIRSIZE.CMD', "n = setlocal()"
      call lineout 'DIRSIZE.CMD', "n = directory('"curdir"')"
      call lineout 'DIRSIZE.CMD', "'start dirsize.exe 'arg1 '%2 %3 %4 %5 %6 %7 %8 %9'"
      call lineout 'DIRSIZE.CMD', "n = endlocal()"
      call stream 'DIRSIZE.CMD','C','close'
    end
    else say "Couldn't create DIRSIZE.CMD file."
    'del UNDEL.CMD 1>NUL 2>NUL'
    dummy = stream('UNDEL.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating an UNDEL.CMD file.'
      call lineout 'UNDEL.CMD', "/* UNDEL (FM/2) command file.  Locate in a directory"
      call lineout 'UNDEL.CMD', " * on your PATH. */"
      call lineout 'UNDEL.CMD', "'@echo off'"
      call lineout 'UNDEL.CMD', "n = setlocal()"
      call lineout 'UNDEL.CMD', "n = directory('"curdir"')"
      call lineout 'UNDEL.CMD', "'start undel.exe %1'"
      call lineout 'UNDEL.CMD', "n = endlocal()"
      call stream 'UNDEL.CMD','C','close'
    end
    else say "Couldn't create UNDEL.CMD file."
    'del KILLPROC.CMD 1>NUL 2>NUL'
    dummy = stream('KILLPROC.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a KILLPROC.CMD file.'
      call lineout 'KILLPROC.CMD', "/* KILLPROC (FM/2) command file.  Locate in a directory"
      call lineout 'KILLPROC.CMD', " * on your PATH. */"
      call lineout 'KILLPROC.CMD', "'@echo off'"
      call lineout 'KILLPROC.CMD', "n = setlocal()"
      call lineout 'KILLPROC.CMD', "n = directory('"curdir"')"
      call lineout 'KILLPROC.CMD', "'start killproc.exe'"
      call lineout 'KILLPROC.CMD', "n = endlocal()"
      call stream 'KILLPROC.CMD','C','close'
    end
    else say "Couldn't create KILLPROC.CMD file."
    'del VIEWINFS.CMD 1>NUL 2>NUL'
    dummy = stream('VIEWINFS.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VIEWINFS.CMD file.'
      call lineout 'VIEWINFS.CMD', "/* VIEWINFS (FM/2) command file.  Locate in a directory"
      call lineout 'VIEWINFS.CMD', " * on your PATH. */"
      call lineout 'VIEWINFS.CMD', "'@echo off'"
      call lineout 'VIEWINFS.CMD', "n = setlocal()"
      call lineout 'VIEWINFS.CMD', "n = directory('"curdir"')"
      call lineout 'VIEWINFS.CMD', "'start viewinfs.exe'"
      call lineout 'VIEWINFS.CMD', "n = endlocal()"
      call stream 'VIEWINFS.CMD','C','close'
    end
    else say "Couldn't create VIEWINFS.CMD file."
    'del VIEWHELP.CMD 1>NUL 2>NUL'
    dummy = stream('VIEWHELP.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a VIEWHELP.CMD file.'
      call lineout 'VIEWHELP.CMD', "/* VIEWHELP (FM/2) command file.  Locate in a directory"
      call lineout 'VIEWHELP.CMD', " * on your PATH. */"
      call lineout 'VIEWHELP.CMD', "'@echo off'"
      call lineout 'VIEWHELP.CMD', "n = setlocal()"
      call lineout 'VIEWHELP.CMD', "n = directory('"curdir"')"
      call lineout 'VIEWHELP.CMD', "'start viewinfs.exe DUMMY'"
      call lineout 'VIEWHELP.CMD', "n = endlocal()"
      call stream 'VIEWHELP.CMD','C','close'
    end
    else say "Couldn't create VIEWHELP.CMD file."
    'del GLOBAL.CMD 1>NUL 2>NUL'
    dummy = stream('GLOBAL.CMD','C','open')
    if dummy = 'READY:' then
    do
      say 'Creating a GLOBAL.CMD file.'
      call lineout 'GLOBAL.CMD', "/* GLOBAL (FM/2) command file.  Locate in a directory"
      call lineout 'GLOBAL.CMD', " * on your PATH. */"
      call lineout 'GLOBAL.CMD', "'@echo off'"
      call lineout 'GLOBAL.CMD', "arg arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'GLOBAL.CMD', "if arg1 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg1,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg1 = stream(arg1,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "else arg1 = directory()"
      call lineout 'GLOBAL.CMD', "if arg2 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg2,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg2 = stream(arg2,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg3 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg3,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg3 = stream(arg3,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg4 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg4,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg4 = stream(arg4,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg5 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg5,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg5 = stream(arg5,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg6 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg6,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg6 = stream(arg6,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg7 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg7,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg7 = stream(arg7,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg8 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg8,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg8 = stream(arg8,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "if arg9 \= '' then "
      call lineout 'GLOBAL.CMD', "do"
      call lineout 'GLOBAL.CMD', "  if left(arg9,1,1) \= '/' then"
      call lineout 'GLOBAL.CMD', "  do"
      call lineout 'GLOBAL.CMD', "    arg9 = stream(arg9,'c','query exists')"
      call lineout 'GLOBAL.CMD', "  end"
      call lineout 'GLOBAL.CMD', "end"
      call lineout 'GLOBAL.CMD', "n = setlocal()"
      call lineout 'GLOBAL.CMD', "n = directory('"curdir"')"
      call lineout 'GLOBAL.CMD', "'start global.exe' arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9"
      call lineout 'GLOBAL.CMD', "n = endlocal()"
      call stream 'GLOBAL.CMD','C','close'
    end
    else say "Couldn't create GLOBAL.CMD file."
    say ""
    parse upper var curdir curdir
    say "Please add the directory"
    say "  "curdir"\UTILS"
    say "to your PATH in CONFIG.SYS."
    say "Ŀ"
    say "Remember, you'll need to reboot before such a change takes effect."
    say "FM/2 will run fine from its WPS objects without this change; the  "
    say "proposed change allows it to be run from any command line, and for"
    say "other programs that might want to use FM/2 as its file manager to "
    say "find and run it easily.                                           "
    say ""
    say "While you're in there, check your LIBPATH statement for a '.' entry..."
    if existed \= "TRUE" then
    do
      say ""
      /* remove next 6 lines for unattended use */
      call charout ,'  Press [Enter] for more...'
      dummy = ''
      do until dummy = '0d'x
        dummy = SysGetKey('NOECHO')
      end
      call charout ,'0d1b'x'[K'
      rc = stream('fatopt.exe','c','query exists')
      say   "Ŀ"
      if rc = '' then
      do
        say "I suggest that you place the utilities from the FM/2 Utilities  "
        say "archive in this directory, also, in which case you should       "
        say "_definitely_ make the change to PATH so that FM/2 can find them."
      end
      say   "You may want to tweak the command lines in the .CMD files I just"
      say   "built and/or those in the WPS objects in the FM/2 folder for    "
      say   "desired specific behaviors.  The READ.ME file will tell you how."
      say   ""
    end
    if existed = 'TRUE' then
    do
      say ''
      say "If you have previously altered your CONFIG.SYS's PATH statement"
      say 'as instructed above, please ignore this rambling.'
    end
    say ""
    /* remove next 6 lines for unattended use */
    call charout ,'  Press [Enter] to continue...'
    dummy = ''
    do until dummy = '0d'x
      dummy = SysGetKey('NOECHO')
    end
    call charout ,'0d1b'x'[K'
  end
  else say "Couldn't create FM2.CMD file.  Panic."
  dummy = directory(curdir)
end
else say "Couldn't switch to "curdir"\utils"

/* type the install.dat file to show any critical info/notices */

/* NOTE:  remove following 8 lines for unattended use... */
rc = stream('install.dat','c','query exists')
if rc \= '' then
do
  'type install.dat'
  'DEL INSTALL.DAT 1>NUL 2>NUL'
  /* remove next 6 lines for unattended use */
  call charout ,'  Press [Enter] to continue...'
  dummy = ''
  do until dummy = '0d'x
    dummy = SysGetKey('NOECHO')
  end
  call charout ,'0d1b'x'[K'
end

/* Final words */

say 'Ŀ'
say 'To move FM/2 to another directory, move the files, delete the FM/2 folder,'
say 'then rerun INSTALL.  There is no need to "uninstall" to move FM/2.        '
say '                                                                          '
say 'To remove FM/2 completely, run UNINSTAL and follow its directions.        '
say ''
say "I'm done now."
say ''

