/************************************************************************/
/*                                                                      */
/*  REXX Mail processor                                                 */
/*                                                                      */
/* (C) 1996, Axel Mueller (amueller@stargate.rz.fh-offenburg.de)        */
/*     Version 0.90    04.03.96                                         */
/************************************************************************/

parse arg MailInFile

call on error


/************************************************************************/
/*                                                                      */
/* Setup                                                                */
/*                                                                      */
/************************************************************************/


True			= 1
False		= 0


/**************/
/*   setup    */
/**************/

ETCPath				= value('ETC',,'OS2ENVIRONMENT')
MailOutFile			= left(MailInFile, (length(MailInFile)-4))'.rsp'
LogFile				= ETCPath'\mailproc.log'
ContactAddress		= 'amueller@stargate.rz.fh-offenburg.de'
MailProcessorUser	= 'mail-processor'
MailProcessorName	= '(Mail-Processor)'
Hostname				= value('HOSTNAME',,'OS2ENVIRONMENT')

ResolvFile			= ETCPath'\resolv'
Line = linein(ResolvFile)
do while (left(Line,6) <> 'domain')
	Line = linein(ResolvFile)
end
rc = lineout(ResolvFile)
parse value Line with dummy Domain

HostDomain			= Hostname'.'Domain



/*#################################################*/
/*#              main routine                     #*/
/*#################################################*/

Line = linein(MailInFile)
do while (left(Line,8) <> 'Subject:')
	Line = linein(MailInFile)
end
rc = lineout(MailInFile)

parse value Line with Subject User Password CommandArguments
parse value CommandArguments with Command Argument1 Argument2

if User=="HELP" | User=="help" then
	Command = "HELP"
parse upper value Command with Command


Line = linein(MailInFile)
do while (left(Line,5) <> 'From:')
	Line = linein(MailInFile)
end
rc = lineout(MailInFile)

parse value Line with From ResponseAddress ResponseName

call log('Received mail 'Line)


select
	when ((Command='CHANGE_PASSWORD') | (Command='C_P')) & (Argument2=="") then
		call change_password
	when ((Command='FORWARD_MAIL') | (Command='F_M')) & (Argument2=="") then
		call forward_mail('0')
	when ((Command='FORWARD_COPY') | (Command='F_C')) & (Argument2=="") then
		call forward_mail('1')
	when ((Command='STOP_FORWARD') | (Command='S_F')) & (Argument1=="") & (Argument2=="") then
		call stop_forward
	when Command='HELP' then
		call help
	otherwise
		call unknown_command
end

call log('Finished mail processing')


exit


/*#################################################*/
/*#          mail processor commands              #*/
/*#################################################*/


/*****************************/
/* change_password           */
/*****************************/

change_password:

	call log('... password change request')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 rc = RxPrfSetPassword(User, Argument1)
		 call write_mail_header
		 call write_robot_header
		 rc = lineout(MailOutFile, '*** Password has been successfully changed.')
		 rc = lineout(MailOutFile, '*** Do not forget your new password in order to be able to')
		 rc = lineout(MailOutFile, '*** login via modem and retrieve mails.')
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... password has been changed')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* forward_mail              */
/*****************************/

forward_mail:

	parse arg ForwardCopy

	call log('... mail forward request')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 call write_mail_header
		 call write_robot_header
		 OwnAddress = User'@'HostDomain
		 if(Argument1 <> OwnAddress) then
			 do
			  rc = RxPrfSetForwardAddress(User, Argument1, ForwardCopy)
			  rc = lineout(MailOutFile, '*** Mail forwarding has been activated.')
			  if (ForwardCopy == 1) then
				do
				  rc = lineout(MailOutFile, '*** A copy of every incoming mail will be forwarded to 'Argument1 )
				  rc = lineout(MailOutFile, '*** The original mails will be keep for POP3 retrieval on this system.' )
				  call log('... copy forward has been activated')
				end
			  else
				do
				  rc = lineout(MailOutFile, '*** Every incoming mail will be forwarded to 'Argument1 )
				  rc = lineout(MailOutFile, '*** No incoming mail be kept on this system.' )
				  call log('... mail forward has been activated')
				end
			  call write_contact
			  rc = lineout(MailOutFile)
			 end
		 else
			 do
			  rc = lineout(MailOutFile, '*** Mail forwarding has NOT been activated.')
			  rc = lineout(MailOutFile, '*** The forward address specified would create a loop.')
			  call write_contact
			  rc = lineout(MailOutFile)
			  call log('... forward has not been activated in order to avoid loop')
			 end
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* stop_forward              */
/*****************************/

stop_forward:

	call log('... stop forward request')
	if (RxPrfCheckPassword(User, Password)) then
		do
		 rc = RxPrfSetForwardAddress(User, "", '0')
		 call write_mail_header
		 call write_robot_header
		 rc = lineout(MailOutFile, '*** Mail forwarding has been deactivated.')
		 call write_contact
		 rc = lineout(MailOutFile)
		 call log('... mail forward has been deactivated')
		end
	else
		do
		 call refuse_action
		 call write_contact
		 rc = lineout(MailOutFile)
		end

	return



/*****************************/
/* help                      */
/*****************************/

help:

	call write_mail_header
	call write_robot_header
	call write_help
	call write_contact
	rc = lineout(MailOutFile)
	call log('... help requested has been answered')

	return



/*****************************/
/* unknown_command           */
/*****************************/

unknown_command:

	call write_mail_header
	call write_robot_header
	rc = lineout(MailOutFile, '*** Command/Parameter error: 'CommandArguments)
	rc = lineout(MailOutFile, '')
	call write_help
	call write_contact
	rc = lineout(MailOutFile, '   ----- Original message follows -----')
	rc = lineout(MailOutFile, '')
	call write_original_mail
	rc = lineout(MailOutFile)
	call log('... command/parameter error: 'CommandArguments)

	return



/*#################################################*/
/*#              sub procedures                   #*/
/*#################################################*/


/*****************************/
/* write_mail_header         */
/*****************************/

write_mail_header:

	rc = lineout(MailOutFile, 'Return-Path: 'MailProcessorUser'@'HostDomain' 'MailProcessorName)
	rc = lineout(MailOutFile, 'From: 'MailProcessorUser'@'HostDomain' 'MailProcessorName)
	rc = lineout(MailOutFile, 'Subject: Response for request')
	if ResponseName=="" then
		rc = lineout(MailOutFile, 'To: 'ResponseAddress)
	else
		rc = lineout(MailOutFile, 'To: 'ResponseAddress' 'ResponseName)

	return


/*****************************/
/* write_robot_header        */
/*****************************/

write_robot_header:

	rc = lineout(MailOutFile, 'This mail was created by an automatic mail processor.')
	rc = lineout(MailOutFile, 'PLEASE DO NOT REPLY TO THIS MAIL.')
	rc = lineout(MailOutFile, '')

	return


/*****************************/
/* write_contact             */
/*****************************/

write_contact:

	rc = lineout(MailOutFile, '')
	rc = lineout(MailOutFile, 'If you have any questions, suggestions or problems - please contact:')
	rc = lineout(MailOutFile, ContactAddress)
	rc = lineout(MailOutFile, '')

	return



/*****************************/
/* write_help                */
/*****************************/

write_help:

	rc = lineout(MailOutFile, '***********************************************************************')
	rc = lineout(MailOutFile, '*               = SYNTAX FOR MAIL PROCESSOR v0.98 =                   *')
	rc = lineout(MailOutFile, '* (C) Axel Mueller, 1996 (amueller@stargate.rz.fh-offenburg.de)       *')
	rc = lineout(MailOutFile, '*                                                                     *')
	rc = lineout(MailOutFile, '* All commands must be given in the SUBJECT!                          *')
	rc = lineout(MailOutFile, '* Commands and parameter(s) must be separated by SPACE!               *')
	rc = lineout(MailOutFile, '* All commands start with <user> <password> and are followd by        *')
	rc = lineout(MailOutFile, '* <command>     and    <parameter(s)>                                 *')
	rc = lineout(MailOutFile, '*                                                                     *')
	rc = lineout(MailOutFile, '* change_password      <new password>                                 *')
	rc = lineout(MailOutFile, '* forward_mail         <forward address>                              *')
	rc = lineout(MailOutFile, '* forward_copy         <forward address>                              *')
	rc = lineout(MailOutFile, '* stop_forward                                                        *')
	rc = lineout(MailOutFile, '*                                                                     *')
	rc = lineout(MailOutFile, '* Instead of the commands above you can use the following short cuts: *')
	rc = lineout(MailOutFile, '* <command>            <short cut>                                    *')
	rc = lineout(MailOutFile, '*                                                                     *')
	rc = lineout(MailOutFile, '* change_password      c_p                                            *')
	rc = lineout(MailOutFile, '* forward_mail         f_m                                            *')
	rc = lineout(MailOutFile, '* forward_copy         f_c                                            *')
	rc = lineout(MailOutFile, '* stop_forward         s_f                                            *')
	rc = lineout(MailOutFile, '*                                                                     *')
	rc = lineout(MailOutFile, '* You will receive a confirmation mail immediately after your         *')
	rc = lineout(MailOutFile, '* mail has been received by the mail processor.                       *')
	rc = lineout(MailOutFile, '*                                                                     *')
	rc = lineout(MailOutFile, '***********************************************************************')
	
	return



/*****************************/
/* write_original_mail       */
/*****************************/

write_original_mail:

	MailInFilePos = 0
	MailInFileSize = stream(MailInFile, 'c', 'query size')
	do while (MailInFilePos<MailInFileSize)
		rc = lineout(MailOutFile, Line)
		Line = linein(MailInFile)
		MailInFilePos=MailInFilePos+length(Line)+1
	end
	rc = lineout(MailInFile)

	return


/*****************************/
/* refuse_action             */
/*****************************/

refuse_action:

	call write_mail_header
	call write_robot_header
	rc = lineout(MailOutFile, '*** You are not authorized for the requested action!')
	call log('... no authorization for requested action')

	return



/*****************************/
/* log                       */
/*****************************/

log:

	parse arg LogString

	rc = lineout( LogFile, date(european)' 'time(normal)'' LogString )

	return
