// Example4.Cpp - This is an example of how to setup and use a database
//   with the LsDoor SDK.  This is also the only example project/IDE file.
//
// Databases can be a fairly advanced topic.
// Setting up a database involves creating macros for it, and defining it.
// Once that is done, accessing the database is sometimes easy, but with many
// different variations.  Study this example, then take a good look at
// Example4.h to understand how these databases work.
//

#define MainModule
#include "LsDoor.H"
#include "Example4.H"

char *errorModule( void ){ return "Example4 Databases"; }


void main( void )
{
  if( !DoorInit( doorsysDISABLE ) ) exit(1);      // Get things started...

  display( "\n@CW@celcome %s.\n", user.handle );

  // Presented now are several different methods of loading data from your
  // database.  You would only need to use one of these cases in a real
  // program, however for this example we are including multiple.

  // Case 1 - See if we can find the user's key.  For a user/player database
  //   such as this, this is probably the best technique.

  open_player();     // Open the file.
  if( !find_player( user.handle ) )
  {
    display("\n  @Y You have no key.  @R You are new here.");
  } else {
    display("\n  @Y Found your key." );
  }

  // Case 2 - Load using next_player()...

  test found = false;

  reset_player();           // Start at the beginning of the database...
  while( next_player() )    // ...And load players until we run out.
  {
    if( !strcmpi( user.handle, player.bbshandle ) ){ found = true; break; }
  }
  if( !found ){
    display("\n  @Y You have no records.  @R You are a new user." );
  } else {
    display("\n  @Y Found your record." );
  }

  // Case 3 - Load using load_player()...  This can be slower than the other
  // methods, however it is the only way to load your records in any
  // ordered manor.

  unsigned long num = 0;
  found = false;

  reset_player();
  while( !end_player() ){    // Loop until past the highest 'num'
    if( !load_player( num++ ) ) continue;
    if( !strcmpi( user.handle, player.bbshandle ) ){ found = true; break; }
  }
  if( !found ){
    display("\n  @Y Couldn't load you.  @R You are a new user." );
  } else {
    display("\n  @Y Loaded your records just fine." );
  }

  char c;
  while( online ){
    display( "\n@CA@cdd your name to the player database?  @w(@GY@w/@gN@w) ");
    c = toupper(s_in());
    if( c == 'Y' ){ echo_yn( c );
      strcpy( player.bbshandle, user.handle );
      display("\n@CW@chat alias will use here:  @W" );
      s_gets( player.handle, 20 );
      player.points = 0;    // Fill in some dummy data
      player.power  = 2;
      add_player();

      display("\n@RI@rt is done.\n\n" );
      break;
    }
    if( c == 'N' ){ echo_yn( c ); break; }
  }
  close_player();
  display("\n@GA@gu revior.");

  exit(0);                                        // Always use exit()
}

// End of Example4.Cpp



