// Example5.Cpp - This example demonstrates how to locate a particular
//   database handle using only part of the name.
//
//   An example where this might be used would be a door game where you can
// send money to another player.  Your door prompts the player, "Who do you
// wish to send money to?"  By using routines similar to the one presented
// below the user needn't type the entire handle out, nor will they need
// to spell it exactly right.
//
//   The routine can also be modified to ask the user (when searching
// for "ShadowWave"):
//   "Is Shadow who you mean?  (Y/N)"     User answers No.
//   "Is Shades who you mean?  (Y/N)"     User answers No.
//   "Is ShadowWand who you mean?  (Y/N"  User answers Yes.
//
//   See Example4.Cpp for information on using the LsDoor SDK databases.

#define MainModule
#include "LsDoor.H"
#include "Example4.H"    // This provides the data base functions.

char *errorModule( void ){ return "Example5 Partials"; }


void main( void )
{
  if( !DoorInit( doorsysDISABLE ) ) exit(1);      // Get things started...

  char find[80];

  display( "\n@CW@cho shall I look up? @W" );
  s_gets( find, 80 );

  int i;
  int amount = 0, best = -1;
  open_player();               // Open the player database, see Example5.Cpp.
  while( next_player() )       // Retrieves the next player's record..
  {
    if( (i=matches( find, player.handle ) ) >= 1 )
    {
      if( i > amount )  // More of the strings match, make this the 'best'.
      {
	best = player.num; amount = i;
      }
    }
  }
  if( best != -1 ) load_player( best );
  close_player();         // Close the player database, see Example5.Cpp

  display("\n@RT@rhe best I could do was the player %s (a.k.a. %s).",
    player.handle, player.bbshandle );

  exit(0);                                        // Always use exit()
}

// End of Example5.Cpp



