// LORD Routines for LsDoor SDK...

//   LORD stands for Legend Of the Red Dragon, a very popular online BBS
// door game created by Seth Robinson (a.k.a. Seth Able).  LORD provides a
// mechanism for programmers to create IGM programs - [I]n [G]ame [M]odules
// which allow you to add to the LORD game with your own creations.

//   To create a LORD IGM using the LsDoor SDK, the main requirement is that
// you call the LORD_Init() function instead of DoorInit().  LORD_Init()
// does most of the same things that DoorInit() does, including setting up
// the status line and serial port.  All of the other LsDoor functions
// should work normally in a LORD IGM.

/*

   For a program to be considered an official LORD IGM by Seth Able it
   must meet these requirements:

   1. It reads *NO* external drop file.  It gets all its data from the
      Info.* and Node*.Dat files.  In the LsDoor SDK, this is all taken
      care of by the LORD_Init() function below.

   2. It has options to install *AND* uninstall itself.  Part of this task
      is handled by the LORD_Install() and LORD_UnInstall() functions
      below, however it is up to you to write a utility or installation
      program to call these functions.  In addition, any special options
      which your program needs are your responsibility.  Only the internals
      of LORD are taken care of by the LsDoor SDK.

   3. The top line of the FILE_ID.DIZ reads like so:
      <NAME & VERSION OF YOUR PROGRAM> LORD IGM
      You may decorate it if you like.

     ***
   Statement from Seth A. Robinson:  You have my permission to build
   add-ons, editers, whatever - BUT, if you decide to charge money for
   them I would appreciate it if you would upload me your file
   privately, let me evualuate it and see if it deserves my stamp of
   approval.

   That's right, I'm not against others making money off their mods, in
   fact, I don't demand any percentage whatsoever.  God knows I've made
   much more than I deserve already.  Just try not to charge more than
   I do for LORD itself, k?

   Also, in ANY util for LORD, be sure to give some credit to ME! <G>
     ***

*/


#ifndef __LORD_HEADER__
#define __LORD_HEADER__

test LORD_Init( char *path );   // See below
test LORD_SetPath( char *path );// Returns same as LORD_Init()
  // For your program to use any of the LORD_ Functions, you must first
  // call one of these two functions.  If your program is for local-use
  // only (such as an installation utility), use LORD_SetPath().  If your
  // program is being run via LORD, use LORD_Init().
  // Both functions will exit the program on general failure, return false
  // if LORD could not be found in the given path (or version < 3.53a),
  // or return true if successful.

char *WithLORDPath( char * );
  // This function will return "C:\Lord\****" where **** is the (char *).

int LORD_read( char *filename, long record_number, void *buffer, unsigned len );
int LORD_write( char *filename, long record_number, void *buffer, unsigned len );
  // These two functions work much like the C functions read() and write().
  // They use the same return value as read() and write().

short LORD_open( char *filename, int access );
FILE *LORD_fopen( char *filename, char *mode );
void  LORD_close( char *filename, short handle );
void  LORD_fclose( char *filename, FILE *handle );
  // The above functions open and close LORD's .DAT files, blocking access
  // to any other nodes while the file is open.  *** WARNING:  Never keep
  // a LORD data file open for more than 3 seconds!

void LORD_ExitSleep( char *msg, char *cmdline );
  // This function exits your program and LORD.  The next time the user
  // enters LORD, the IGM specified in cmdline will be executed (after
  // the user's mail and such.)  The format for (char *)cmdline is the
  // same as that for LORD_Install()'s cmdline paramater, however you might
  // want to add a command line option such as /RET to indicate to your
  // program at that time that the user is returning from their slumber.
  // To other users, (char *)msg will show up until the user next enters
  // LORD (and your IGM.)  Example use:
  //
  // LORD_ExitSleep( "is sleeping in the heavens.",
  //                   "C:\MyGame\Cloud.Exe /N* /RET" );
  //

test LORD_FixBadWords( char *str );
  // This function checks LORD's BADWORDS.DAT file against *str and replaces
  // any bad words.

void LORD_Install( char *msg, char *cmdline );
void LORD_UnInstall( char *cmdline );
  // These two functions install or uninstall your IGM into LORD.  They
  // modify the 3RDPARTY.DAT file.  *msg is the text string that will show
  // up in LORD's "Other Places" listing (it can include ` color codes.)
  // *cmdline is the command line LORD should execute to run your program.
  // This will usually be the path and filename of your EXE file.  You may
  // use asterik (*) symbols to be replaced by the current node number.
  // For LORD_UnInstall(), what you specify from *cmdline will be searched
  // for.  If a match is found in 3RDPARTY.DAT, it is removed.  Examples:
  //
  // LORD_Install( "`0V`2isit `0H`2eaven", "C:\\IGM\\Mine.Exe /N*" );
  // LORD_UnInstall( "Mine.Exe" );
  //

struct LORDPlayer
{
  unsigned short account;    // Account number
  unsigned char handle[40];  // LORD Handle
  test fairy;                // Do they have a fairy with them?
  test lord_registered;      // (True/False) Is LORD registered?
  test clean;                // (True/False) Clean Mode
} global LORDPlayer;

  // The LORDPlayer structure is completely filled by LORD_Init().
  //
  // Also valid in LORD IGM's and LOCAL mode:
  //
  //   user.real, terminal, drop.terminal, redirect, drop.redirect,
  //   Valid, but from LORD and not BBS:  user.timelimit, user.timeused
  //   node.ID.num, node.comport, node.irq, node.base, node.baud, nodeid.baud
  //
  //
  // Valid in LORD IGM's only:
  //
  //   master.bbs_name
  //

  /***  LORD Data  ***/

  //   There is no requirement that you must access any of the LORD records.
  // You can modify the current user (or any user)'s account using mail
  // (see "Mail Services" below.)  However, if you do want to mess around
  // with a user's account, or an enemy from the forest, here's the tools.


  //
  // Use the LORD_read() and LORD_write() functions to access these records.
  // For example, to read account #2 into LORDAccount, use this:
  //
  // if( LORD_read( "Player.Dat", 2, &LORDAccount, sizeof(LORDAccount) )
  //       < sizeof(LORDAccount) )
  //   errorHandler();
  //
  // Note:  The record number always starts at 0 (there is always a valid
  // record numbered 0.)
  //
  // ** LORD STRINGS:
  //
  //   LORD uses Pascal style strings.  In C, a string is a character array
  // which ends in a 0 to mark the string's end.  The 0 is also called the
  // NULL-Terminator, a NULL character, a '\0', etc.  In Pascal (which is
  // what LORD uses) a string is also a character array, but there is no
  // terminator character, and the first character in the array is a number
  // giving the string's entire length.  We have worked around this by
  // providing a lxxxx variable and a xxxx variable for each string.  Use
  // the functions below to translate between them.

char *LORD_toC( char len, char *string );
  // For some insight about these two functions, see the above comment.
  // To translating from C to Pascal, use strlen().  Examples:
  //
  /*                     // Pascal to C
     char mine[ 80 ];
     strcpy( mine, LORD_toC(lnames,names) );
  */
  /*                     // C to Pascal
     char mine[ 80 ] = "My C String";
     strcpy( LORDAccount.names, mine );
     LORDAccount.lnames = strlen( mine );
  */

  //  Thanks to John Hutton for helping in translating these records from
  //  Pascal to C.  I could have done it myself, but thanks to him I can
  //  have a day off.

typedef struct           // LORDAccount - Records in PLAYER.DAT
{
  char lnames;           // length for names (See above)
  char names[20];        // array for names
  char lreal_names;      // length for real names
  char real_names[50];   // array for real names
  short hit_points;      // hit points
  short bad;             // not used
  short rate;            // not used
  short hit_max;         // maximum hit points
  short weapon_num;      // weapon number
  char lweapon;          // length of weapon name
  char weapon[20];       // array for weapon name
  short seen_master;     // 5 if seen Master, else 0
  short fights_left;     // forest fights left
  short human_left;      // human fights left
  long gold;             // gold in hand
  long bank;             // gold in bank
  short def;             // total defense points
  short strength;        // total strength
  short charm;           // good looking meter
  short seen_dragon;     // seen dragon? 5 if yes else 0
  short seen_violet;     // seen violet? 5 if yes else 0
  short level;           // level of player
  ushort time;           // day # that player last played on
  char larm;             // length of armour name
  char arm[20];          // armour name
  short arm_num;         // armour number
  char dead;             // player dead? 5 if yes else 0
  char inn;              // player sleeping at inn? 5 if yes else 0
  short gem;             // # of gems on hand
  long exp;              // experience
  char sex;              // gender, 5 if female else 0
  char seen_bard;        // seen bard? 5 if yes else 0
  short last_alive_time; // day # player was last reincarnated on
  short lays;            // players lays stat
  short why;             // not used yet
  test on_now;           // is player on?
  short m_time;          // day on_now stat wa last used
  char ltime_on;         // length of time_on string
  char time_on[5];       // time player logged on in HH:MM format
  char _class;           // class, should be 1, 2 or 3
  short extra;           // if 1, player has a horse
  char llove;            // length of love string
  char love[25];         // not used - may be for inter player marriage
  short married;         // who player is married to, -1 if not married
  short kids;            // # of kids
  short king;            // # of times player has won game
  char skillw;           // number of Death Knight skill points
  char skillm;           // number of Mystical Skills points
  char skillt;           // number of Thieving Skills points
  char levelw;           // number of Death Knight skill uses left today
  char levelm;           // number of Mystical Skill uses left today
  char levelt;           // number of Thieving Skill usues left today
  test inn_random;       // not used yet
  short married_to;      // same as Married?
  long v1;
  short v2;              // number of player kills
  short v3;              // if 5, 'weird' event in forest will happen
  test v4;               // has player done 'special' for that day?
  char v5;               // has player flirted with another player today 5
  char new_stat1;
  char new_stat2;
  char new_stat3;
} LORDAccount;

typedef struct          // LORDMonster - Records in LENEMY.DAT
{
  char lname;           // length for name
  char name[60];        // name
  long strength;
  long gold;
  char lweapon;         // length for name of weapon
  char weapon[60];      // name of weapon
  long exp_points;
  long hit_points;
  char ldeath;          // length for death string
  char death[100];      // shown when monster is killed by power move
} LORDMonster;

  /*
short armor_strength[] = { 0, 1, 3, 10, 15, 25, 35, 50, 75, 100, 150, 225,
			300, 400, 600, 1000};

short weapon_strength[] = { 0, 5, 10, 20, 30, 40, 60, 80, 120, 180, 250, 350,
			 500, 800, 1200, 1800};
  */


  /***  Mail Services  ***/

  //   Use the C++ class LORD_Mail to send mail to LORD users.  For C
  // programmers, follow the examples below for some help.  You can also
  // use LORD's mail services to modify a user, such as giving them
  // experience, charm, or taking away different things.  You can also send
  // romantic mail and the like.  You can send a message to any user, using
  // their account number.


  //
  // class LORD_Mail:
  //
  //   * SetNone() only needs to be called to clear one of the other
  // settings.  If you have not called any SetXXX() functions, the default
  // is SetNone().
  //
  //   * A LORD_Mail object should never exist for more than 3 seconds!
  //
  // Examples:
  /*
     LORD_Mail mess( 12 );
     mess.AddText( "Thats all folks." );
  */
  //   In the above, the message "Thats all folks." will be sent to the
  // reader, user #12.  The first line "creates an object".  C Programmers
  // can generally think of an object as "just another variable".  But keep
  // in mind that the time the variable (or object) is created to the time
  // that it is destroyed should not exceed 3 seconds.  The most common way
  // for an object to be destroyed is for it to "go out of scope".  For
  // example:
  /*
     if( somevar == 2 )
     {
       LORD_Mail mess( 6 );
       mess.AddText( "Just saying hi." );
     }
     // At this point the local variable 'mess' will have been destroyed,
     // "if" it was ever created at all.
  */
  // More examples:
  /*
     LORD_Mail mess( 22 );
     mess.AddText( "`%  Message from THE DEMON..." );
     mess.AddText( "`0-=-=-=-=-=-=-=-=-=-=-=-" );
     mess.AddText( "  I give you these things to aid thee in thy quest." );
     mess.AddText( "In exchange, I take from thee 400 experience points." );
     mess.AddText( "" );
     mess.AddCharm();
     mess.AddSkill( 4 );
     mess.AddBank( 45000 );
     mess.AddExp( -400 );
  */
  //   The above example demonstrates that the default color for AddText()
  // is dark green (2).  It also shows that you can use negative numbers
  // in any of the AddXXX functions except those that take an 'unsigned'
  // value, such as AddSkill().
  /*
     LORD_Mail *m = new LORD_Mail( 15 );
     m->AddText( "An anonymous person wants dinner with you." );
     m->SetDinner( 25 );
     delete m;
  */
  //   The above demonstrates a different way to create an object which lets
  // you control when it is deleted.  It also shows how to use the SetXXXX()
  // functions.  Note that the SetXXXX() functions may be used anywhere
  // between the creation and destruction of the object.  Only one SetXXXX()
  // can be used in the end, calling a second SetXXXX() function overrides
  // any previous calls.
  //


class LORD_Mail
{
private:
  FILE *handle;
  char space[80];

  char endCode;
  unsigned short account;

  static char EndCodes[8];

  unsigned short to_acc;

  void Add( char *line );
public:
  ~LORD_Mail();

  LORD_Mail( unsigned short to_account );

  void SetNone( void ){ endCode = 0; }
  void SetReply( unsigned short to ){    endCode = 1; account = to; }
  void SetFlirt( unsigned short with ){  endCode = 2; account = with; }
  void SetKiss( unsigned short with ){   endCode = 3; account = with; }
  void SetDinner( unsigned short with ){ endCode = 4; account = with; }
  void SetSleep( unsigned short with ){  endCode = 5; account = with; }
  void SetPropose( unsigned short to ){  endCode = 6; account = to; }

  void AddText( char *line );
  void AddMoney( long amount ){ sprintf(space,"`G%li",amount); Add(space); }
  void AddBank( long amount ){ sprintf(space,"`b%li",amount); Add(space); }
  void AddExp( long experience ){ sprintf(space,"`E%li",experience); Add(space); }
  void AddCharm( void ){ Add("`}"); }
  void SetCharm( ushort charm ){ sprintf(space,"`+%u",charm); Add(space); }
  void AddLay( void ){ Add("`{"); }
  void AddKid( void ){ Add("`K"); }
  void AddStrength( long amount ){ sprintf(space,"`M%li",amount); Add(space); }
  void AddDefense( long amount ){ sprintf(space,"`D%li",amount); Add(space); }
  void AddForest( short fights ){ sprintf(space,"`,%i",fights); Add(space); }
  void AddUser( short fights ){ sprintf(space,"`:%i",fights); Add(space); }
  void AddHPMax( short amount ){ sprintf(space,"`;%i",amount); Add(space); }
  void AddSkill( ushort points ){ sprintf(space,"`S%u",points); Add(space); }
  void Marry( short to ){ sprintf(space,"`?%i",to); Add(space); }
  void Unmarry( void ){ Marry( -1 ); }
  void AddCLS( void ){ Add("`c"); }
};


#endif

// End of LORD.H

