// BTree.h

#ifndef __BTREE_HEADOR_FILE__
#define __BTREE_HEADOR_FILE__

#define BTREE_OK       	0
#define BTREE_ERROR    	1
#define BTREE_END      	2
#define BTREE_LOCK     	3

#define MAX_KEY        	120   // Maximum size of an index key
#define NUM_BUFS    	6 // x IXBLOCK = Total cache memory
#define MAX_LEVELS  	8
#define IXBLOCK    	(1024 - 10)  // To change block size, change 1024...

typedef long POS;


struct Block
{
  POS pos;
  POS next;
  int end;
  uchar entries[IXBLOCK];         // the actual data
};

struct Index
{
  int handle;                     // file handle

  int level;
  uchar trunk_changed;

  Block trunk;
  POS empty;
  char dupe;                      // Dupe keys allowed (True or false)
  int levels;

  POS cblock[MAX_LEVELS];
  int coffset[MAX_LEVELS];
};

struct Entry
{
  POS lower;
  POS data;                       // Place the data's file position here
  unsigned char key[MAX_KEY];     // Place the null-terminated keyword here
};


int open_index( char *filename, Index *ix );
int create_index( char *filename, Index *ix, int dupe=1 );

int add_key( Index *, Entry * );
int delete_key( Index *, Entry * );

int first_key( Index *, Entry * );
int last_key( Index *, Entry * );

int next_key( Index *, Entry * );
int prev_key( Index *, Entry * );

int find_key( Index *, Entry * );
int locate_key( Index *, Entry * );
int match_key( Index *, Entry * );

int cache_flush( Index * );
int close_index( Index * );

#endif

// End of BTree.H




