// LightSpeed Standard - Serial functions - Standard v1.0

#include "lib.h"

#define global extern
#include "fos.h"
#include "lite.h"
#include "util.h"
#include "dispf.h"
#undef global

#define global
#include "serial.h"
#undef global

truth timed_in( uchar c ){
  uint seconds = lsTimeout;
  while( seconds-- ){
    while( direct_ready() )
      if( (uchar)direct_in() == (uchar)c ) return true;
    dvsleep(1);
  }
  return false;
}

int timed_get( void ){
  uint seconds = lsTimeout;
  while( seconds-- ){
    if( direct_ready() ) return direct_in();
    if( !carrier() ) break;
    dvsleep(1);
  }
  return -1;
}

truth confirm_in( uchar c ){
  uint seconds = lsTimeout;
  while( seconds-- ){
    if( direct_ready() ){
      if( direct_in() == c && timed_get() == c ){
	direct_out(c); if( timed_get() == '!' ) return true;
      }
    }
    if( !carrier() ) break;
    dvsleep(1);
  }
  return false;
}

int confirm_get( void ){
  uint seconds = lsTimeout;
  while( seconds-- ){
    if( direct_ready() ){
      int c = direct_in();
      if( timed_get() == c ){
	direct_out(c); if( timed_get() == '!' ) return c;
      }
    }
    if( !carrier() ) break;
    dvsleep(1);
  }
  return -1;
}

truth confirm_out( uchar c ){
  direct_out( c ); direct_out(c);
  if( timed_in(c) ){ direct_out('!'); return true; }
  return false;
}


void direct_write( void *dat, uint len )
{
  uchar *ss = (uchar *)dat;
  while( len-- ){
    direct_out( *ss );
    ss++;
  }
}

int direct_read( void *dat, uint len )
{
  uchar *ss = (uchar *)dat; int ii, jj; uint cntlen=0;
  while( len-- ){
    ii = timed_get();
    if( ii == -1 ) return cntlen;
    *ss = ii; ss++; cntlen++;
  }
  return cntlen;
}


int confirm_write( void *dat, uchar len )
{
  uchar *ss, cnt, retries=0; ulong chksum, insum;
  while( carrier() && retries++ < 10 ){
    if( !confirm_out( len ) ) return 0;
    ss = (uchar *)dat; chksum = 0; cnt = 0;
    while( cnt < len ){
      direct_out( *ss ); chksum += *ss; ss++; cnt++;
    }
    insum = 0;
    direct_read( &insum, sizeof(ulong) );
    if( chksum == insum && confirm_out('+') ) break;
    confirm_out('-');
    cnt = 0;
  }
  return cnt;
}

int confirm_read( void *dat, uchar len )
{
  uchar *ss, cnt, retries=0; ulong chksum; int ii, jj, kk, fails=0;
  while( carrier() && fails < 2 && retries++ < 10 ){
    ii = confirm_get();
    if( ii == -1 ){ fails++; continue; }
    if( ii > len ) return 0;
    ss = (uchar *)dat; chksum = 0; cnt = 0;
    while( cnt < ii ){
      jj = timed_get();
      if( jj == -1 ){ cnt=0; fails++; continue; }
      *ss = (uchar)jj; chksum += *ss; ss++; cnt++;
    }
    direct_write( &chksum, sizeof(ulong) );
    if( confirm_get() == '+' ) break;
    cnt = 0;
  }
  return cnt;
}


// End of Serial.Cpp

