// LightSpeed Standard - Serial Communications - Standard v1.0

#ifndef _LSSERIAL_HEADR_
#define _LSSERIAL_HEADR_

#define lsTimeout	5

truth timed_in( uchar c );       // Looks for c with timeout
int   timed_get( void );         // Waits for input with timeout return -1

truth confirm_in( uchar c );     // Looks for and confirms c with timeout
int   confirm_get( void );       // Looks for and confirms input (or -1)
truth confirm_out( uchar c );    // Sends and confirms c

  // The following functions (except direct_write) all return the number of
  // bytes actually read or writen successfully.

void  direct_write( void *dat, uint len );    // Sends raw data
int   direct_read( void *dat, uint len );     // Recvs raw data with timeout

int   confirm_write( void *dat, uchar len );  // Sends data with checksum
int   confirm_read( void *dat, uchar len );   // Recvs data w chksum & tout

#endif

// End of Serial.H


