// Text.H

// Usage of LightSpeed TextSystem:
//
//   The only function you need to use to access the TextSystem() is
// getText(), the macro.  If you wish to use a data file other than the
// default of LSText.Dat, then simply change the value of LSTextFile[]
// BEFORE calling getText() but AFTER calling DoorInit().
//

#ifndef __TEXT_HEADER_FILE__
#define __TEXT_HEADER_FILE__

global char LSTextFile[80];

#define getText(S) textSystem.TSgetText( S )



// The following is private to Text.Cpp, and Data.Cpp:InitDataSystem()...

class textSystem {
private:
  int textHandle;
public:
  textSystem(){ textHandle = -1; }
  ~textSystem(){ close( textHandle ); }
  unsigned char *TSgetText( unsigned int promptNum );
  void InitSystem( void );
} global textSystem;

#endif

// End of Text.H




