/*****************************************************************************
   MODULE: rgets.c
  PURPOSE: recio character delimited string and char input functions
COPYRIGHT: (C) 1994-1996, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.14
  RELEASE: June 14, 1996
*****************************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

#define rflags(rp)       ((rp)->r_flags)
#define rcol(rp)         ((rp)->r_colno)
#define rreclen(rp)      ((rp)->r_reclen)

/****************************************************************************/
int                          /* return character; EOF=error or missing data */
    str2c(                   /* convert string to character                 */
        const char  *nptr,   /* pointer to string to convert                */
              char **endptr) /* pointer to conversion leftover string       */
/****************************************************************************/
{
    int ch=EOF;              /* result to return */

    /* set *endptr to nptr just in case conversion fails */
    if (endptr) *endptr = (char *) nptr;

    /* skip over white space */
    while (isspace(*nptr)) nptr++;
    
    /* if string contains a non-whitespace character */
    if (*nptr != '\0') {
        
        /* get the character */
        ch = (int) *nptr;
        
        /* position endptr just past the character */
        if (endptr) *endptr = (char *) ++nptr;
    } 
    return ch;
}

/****************************************************************************/
int                          /* return pointer to char; EOF on error        */
    rgetc(                   /* get character from record stream            */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
    int result=EOF;          /* character to return */
    int ch;                  /* conversion character */
    char *fldptr;            /* pointer to field string */
    char *endptr;            /* pointer to first invalid field char */

    if (_risready(rp, R_READ)) {
      fldptr = _rfldstr(rp, 0);
      if (fldptr) {
        strims(fldptr);
        for (;;) {
          if (*fldptr != '\0') {
            endptr = fldptr;
            ch = str2c(fldptr, &endptr);
            while (isspace(*endptr)) endptr++;
            if (!*endptr) {
                result = ch;
                goto done;
            } /* invalid data (more than 1 character in field) */
            fldptr = _rerrs(rp, R_EINVDAT);
            if (fldptr) { continue; } else { goto done; }
          } /* missing data (nothing but white space) */
          fldptr = _rerrs(rp, R_EMISDAT);
          if (fldptr) { continue; } else { goto done; }
        }
      }
    }
done:
    return result;
}

/****************************************************************************/
char *                       /* return pointer to string; "" on error       */
    rgets(                   /* get string from record stream               */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
    static char empty[]="";  /* empty string */
    char *retp=empty;        /* return pointer */
    char *fldptr;            /* pointer to field buffer */

    if (_risready(rp, R_READ)) {

        /* if field position is within record */
        if (rcol(rp) <= rreclen(rp)) {
            fldptr = _rfldstr(rp, 0);
            if (fldptr) {
                /* if string not empty */
                if (*fldptr) {
                    retp = fldptr;
                } else {
                    rsetwarn(rp, R_WEMPSTR);
                    retp = rflds(rp);
                }
            }

        /* else beyond end of record */
        } else {
            rfldno(rp)++;
            rsetfldstr(rp, "");
            rsetwarn(rp, R_WEMPSTR);
            retp = rflds(rp);
        }
    }
    return retp;
}
