/*****************************************************************************
   MODULE: rputt.c
  PURPOSE: recio character delimited time output functions
COPYRIGHT: (C) 1994-1996, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.14
  RELEASE: June 14, 1996
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rflags(rp)       ((rp)->r_flags)
#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rtmfmt(rp)       ((rp)->r_tmfmt)

/****************************************************************************/
void                         /* returns nothing                             */
    rputtm(                  /* put time to record stream                   */
        REC *rp,             /* record pointer                              */
        struct tm t)         /* broken-down time                            */
/****************************************************************************/
{
    size_t maxsize;          /* max size of str buffer */
    size_t len;              /* actual length of str */
    char *str=NULL;          /* storage for output string */
    int errnum;              /* error number */

    if (_risready(rp, R_WRITE)) {
        rfldno(rp)++;
        rflags(rp) &= ~_R_TXT;

        /* if not first field, put field separator if not null */
        if (rfldno(rp) > 1 && rfldch(rp)) {
            if (_rputc(rp, rfldch(rp))) goto done;
        }

        /* put time into formatted string */
        maxsize = strlen(rtmfmt(rp));  /* arbitrary initial max size   */
        do {                           /* loop until max size adequate */
            maxsize += 16;             /* arbitrary max size increment */
            do {                       /* loop until memory allocated  */
                str = (char *) realloc(str, maxsize+1);
                if (!str) {
                    errnum = rseterr(rp, R_ENOMEM);
                    if (errnum) goto done;
                }
            } while (!str);
            len = strftime(str, maxsize, rtmfmt(rp), &t);
        } while (!len);

        /* put formatted string to output */
        if (fputs(str, rfp(rp)) != EOF) { 
            rcol(rp) += len;
        } else {
            rseterr(rp, R_ENOPUT);
            goto done;
        }
    }
done:
    free(str);
    return;
}

/****************************************************************************/
void                         /* returns nothing                             */
    rputt(                   /* put time to record stream                   */
        REC *rp,             /* record pointer                              */
        time_t time)         /* time                                        */
/****************************************************************************/
{
    rputtm(rp, timetotm(time));
}
