{ Delphi Object for R&R XBASE SQL Edition }

{ Author Chris Brooksbank (cbrooksbank@msn.com) }
{ Written : October 1995 }

unit RRX65;

interface

uses
  SysUtils,WinTypes,WinProcs,Messages,Classes,Graphics,Controls,Forms,
  Dialogs,rrxint;

type
  TrrFilterUsage = (rrfuSaved,rrfuNone,rrfuComponent,rrfuInteractive);
  TrrDest = (rrdDisplay,rrdTextFile,rrdPrinter,rrdWorksheet,rrdXBase,
             rrdInteractive,rrdCSV,rrdMSWord,rrdRTF);
  TrrExportDest = (rredDisplay,rredFile,rredPrinter);
  TrrwsBorderStyle = (rrwsNone,rrwsFixedSingle,rrwsSizable,rrwsFixedDouble);


  {XBASE Specific Type definitions}

  TRRIndexExt = (rrieNone,rrieCDX,rrieIDX,rrieMDX,rrieNDX,rrieNSX,
                 rrieNTX,rrieWDX);
  TRRScopeUsage = (rrsuSaved,rrsuEntire,rrsuOverride,rrsuInteractive);
  TRRDataType = (rrdtNumeric,rrdtDate,rrdtCharacter);


  TRRX65 = class(TComponent)
  private
    { Private declarations }

     { XBASE Specific Fields Follow }
     fIndexExtension:TRRIndexExt;
     fMasterIndexName:String;
     fMasterIndexTag:String;
     fMasterIndexType:TRRDataType;
     fRelationTables:Tstrings;
     fRelationIndexs:TStrings;
     fRelationTags:Tstrings;
     fRelationAlias:Tstrings;
     fScopeLow:String;
     fScopeHigh:String;
     fScopeUsage:TRRScopeUsage;
     fWriteAllow:Boolean;
     fXbaseEditor:Boolean;


     { Generic Fields Follow }
     fActive:Boolean;
     fAskPrinter:Boolean;
     fAskReport:Boolean;
     fAuthor:String;
     fAppName:String;
     fBeginPage: Longint;
     fCopies: Longint;
     fDatabasename: String;
     fDataDir    : String;
     fDisplayErrors: Boolean;
     fDisplayStatus: Boolean;
     fEndPage: LongInt;
     fErrorCode: String;
     fErrorMessage: String;
     fExportDest: TrrExportDest;
     fFields: TStrings;
     fFilter: String;
     fFilterUsage: TrrFilterUsage;
     fGroupFields: TStrings;
     fImageDir   : String;
     fLastErrorPage:Longint;
     fLibName: String;
     fMasterTableName: String;
     fMemoName: String;
     fOutputDest: TRRDest;
     fOutputFile: String;
     fPreventEscape: Boolean;
     fPrinterName: String;
     fPrinterPort: String;
     fRepName:String;
     fReportPick: Boolean;
     fSortFields: TStrings;
     fStatusEveryPage: Boolean;
     fSuppressTitle: Boolean;
     fTestPattern: Boolean;
     fUserParamsNames: TStrings;
     fUserParamsValues: TStrings;
     fVersion: String;
     fWait: Boolean;
     fWinBorderStyle: TrrwsBorderStyle;
     fWinControlBox: Boolean;
     fWinHeight: Integer;
     fWinLeft:Integer;
     fWinMaxButton: Boolean;
     fWinMinButton: Boolean;
     fWinParentHandle: Integer;
     fWinTitle: String;
     fWinTop: Integer;
     fWinWidth:Integer;


     { XBASE Specific private functions follow }

     procedure setRelationTables(Value:Tstrings);
     procedure setRelationIndexs(Value:Tstrings);
     procedure setRelationTags(Value:Tstrings);
     procedure setRelationAlias(Value:Tstrings);
     procedure LoadRelations(hReport:Integer);
     procedure LoadScopes(hReport:Integer);
     procedure LoadIndex(hReport:Integer);
     procedure LoadFromReportH(hMyReport:Integer);

     { Generic functions follow }

     procedure setfActive(Value:Boolean);
     procedure setfAuthor(Value:String);
     procedure LoadFields(hReport:Integer);
     procedure LoadGroupFields(hReport:Integer);
     procedure LoadSortFields(hReport:Integer);
     procedure LoadUserParams(hReport:Integer);
     procedure LoadTitle(hReport:Integer);
     procedure LoadPages(hReport:Integer);
     procedure LoadTable(hReport:Integer);
     procedure LoadFilter(hReport:Integer);
     procedure LoadDests(hReport:Integer);
     procedure LoadPrinter(hReport:Integer);

     procedure setfFields(Value:Tstrings);
     procedure setfGroupFields(Value:Tstrings);
     procedure setfSortFields(Value:Tstrings);
     procedure setfUserParamsNames(Value:Tstrings);
     procedure setfUserParamsValues(Value:Tstrings);
     procedure SetLibName(NewLibName:String);
     procedure SetRepName(NewRepName: String);
     procedure SaveToReportH(hReport:Integer);

  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Aowner:TComponent); override;
    destructor Free;
    function execute:Boolean;
    function run:Boolean;
    procedure LoadFromReport;
    function SaveToFile(MyFile:String):Boolean;
    function LoadFromFile(MyFile:String):Boolean;

  published
    { Published declarations }

    { XBASE Specific Properties Follow }

    property IndexExtension:TRRIndexExt read fIndexExtension
                                        write fIndexExtension;
    property MasterIndexType:TRRDataType read  fMasterIndexType
                                         write fMasterIndexType;
    property MasterIndexName:String read fMasterIndexName
                                    write fMasterIndexName;
    property MasterIndexTag:String read fMasterIndexTag
                                   write fMasterIndexTag;
    property ScopeLow:String read fScopeLow write fScopeLow;
    property RelationTables:TStrings read fRelationTables write SetRelationTables;
    property RelationIndexs:TStrings read fRelationIndexs write SetRelationIndexs;
    property RelationTags:Tstrings read fRelationTags write SetRelationTags;
    property RelationAlias:Tstrings read fRelationAlias write setRelationAlias;
    property ScopeHigh:String read fScopeHigh write fScopeHigh;
    property ScopeUsage:TRRScopeUsage read fScopeUsage write fScopeUsage;
    property WriteAllow:Boolean read fWriteAllow write fWriteAllow;
    property XbaseEditor:Boolean read fXbaseEditor write fXbaseEditor;

    { Generic Properties follow }

    property Active: Boolean read fActive write SetfActive;
    property AppName: String read fAppName write fAppName;
    property AskPrinter:Boolean read fAskPrinter write fAskPrinter;
    property AskReport:Boolean read fAskReport write fAskReport;
    property Author: String read fAuthor write setfAuthor;
    property BeginPage: Longint read fBeginPage write fBeginPage;
    property Copies: Longint read fCopies write fCopies;
    property Databasename:String read fDatabasename write fDatabasename;
    property DataDirectory:String read fDataDir write fDataDir;
    property DisplayErrors: Boolean read fDisplayErrors write fDisplayErrors;
    property DisplayStatus: Boolean read fDisplayStatus write fDisplayStatus;
    property EndPage: Longint read fEndPage write fEndPage;
    property ErrorCode: String read fErrorcode write fErrorcode;
    property ErrorMessage: String read fErrorMessage write fErrorMessage;
    property ExportDest: TrrExportDest read fExportDest write fExportDest;
    property Fields: TStrings read fFields write setfFields;
    property Filter: String read fFilter write fFilter;
    property FilterUsage: TrrFilterUsage read fFilterUsage write fFilterUsage;
    property GroupFields: TStrings read fGroupFields write setfGroupFields;
    property ImageDir: String read fImageDir write fImageDir;
    property LastErrorPage: Longint read fLastErrorPage write fLastErrorPage;
    property MasterTableName: String read fMasterTableName write fMasterTableName;
    property MemoName: String read fMemoName write fMemoName;
    property OutputDest: TrrDest read fOutputDest write fOutputDest;
    property OutputFile: String read fOutputFile write fOutputFile;
    property PreventEscape: Boolean read fPreventEscape write fPreventEscape;
    property PrinterName: String read fPrinterName write fPrinterName;
    property PrinterPort: String read fPrinterPort write fPrinterPort;
    property ReportLibrary:String read fLibName write setLibName;
    property ReportName: String read fRepName write setRepName;
    property SortFields: TStrings read fSortFields write setfSortFields;
    property StatusEveryPage: Boolean read fStatusEveryPage
                                      write fStatusEveryPage;
    property SuppressTitle: Boolean read fSuppressTitle write fSuppressTitle;
    property TestPattern: Boolean read fTestPattern write fTestPattern;
    property UserParamsNames: TStrings read fUserParamsNames
                                       write setfUserParamsNames;
    property UserParamsValues: TStrings read fUserParamsValues
                                       write setfUserParamsValues;
    property Version:String read fVersion write fversion;
    property Wait: Boolean read fWait write fWait;
    property WinBorderStyle:TrrwsBorderStyle read fWinBorderStyle
             write fWinBorderStyle;
    property WinControlBox: Boolean read fWinControlBox write fWinControlBox;
    property WinHeight: Integer read fWinHeight write fWinHeight;
    property WinLeft: Integer read fWinLeft write fWinLeft;
    property WinMaxButton: Boolean read fWinMaxButton write fWinMaxButton;
    property WinMinButton: Boolean read fWinMinButton write fWinMinButton;
    property WinParentHandle: Integer read fWinParentHandle write fWinParentHandle;
    property WinTitle: String read fWinTitle write fWinTitle;
    property WinTop:Integer read fWinTop write fWinTop;
    property WinWidth:Integer read fWinWidth write fWinWidth;

end;

procedure Register;

implementation

{ ************************************************************************** }
constructor TRRX65.create(AOwner:Tcomponent);
{ ************************************************************************** }
begin
  inherited create(AOwner);

  initruntimeinstance;

  { XBASE Specific TSTRING fields }
  fRelationTables:=TStringList.Create;
  fRelationIndexs:=TStringList.Create;
  fRelationTags:=TStringList.Create;
  fRelationAlias:=TStringList.Create;
  fXbaseEditor:=true;

  { Generic TSTRING fields }
  fFields:=TStringList.Create;
  fGroupFields:=TStringList.Create;
  fSortFields:=TstringList.Create;
  fUserParamsNames:=TStringList.Create;
  fUserParamsValues:=TStringList.Create;

  fWait:=true;
  fMasterIndexType:=rrdtCharacter;
  fIndexExtension:=rrieNTX;
  fAppName:=Application.exename;
  fAuthor:='cbrooksbank@msn.com';
  fAskPrinter:=true;


end;

{ ************************************************************************** }
destructor TRRX65.Free;
{ ************************************************************************** }
begin

  { XBASE Specific TSTRING fields }
  fRelationTables.Free;
  fRelationIndexs.Free;
  fRelationTags.Free;
  fRelationAlias.Free;

  { Generic TSTRING Fields }
  fFields.free;
  fGroupFields.free;
  fSortFields.free;
  fUserParamsNames.free;
  fUserParamsValues.free;

  endruntimeinstance;

  inherited Free;
end;


{ ************************************************************************** }
procedure Register;
{ ************************************************************************** }
begin
  RegisterComponents('Data Access', [TRRX65]);
end;

{ ************************************************************************** }
procedure TRRX65.LoadFromReport;
{ ************************************************************************** }
{ Using the fRepname and fLibname load object info from report defaults }
var
  hMyReport:Integer;
  MyApp_,MyLib_,MyRep_:PChar;
begin
  if ((flibname<>'') and (frepname<>'')) then
  begin
    MyApp_:=StrAlloc(length(fAppName)+1);
    StrPCopy(MyApp_,fAppName);
    MyLib_:=StrAlloc(length(fLibName)+1);
    StrPCopy(MyLib_,fLibName);
    MyRep_:=StrAlloc(length(fRepName)+1);
    StrPCopy(MyRep_,fRepName);
    try

      hMyReport:=ChooseReport(MyApp_,MyLib_,MyRep_,StrBufSize(MyRep_));
      if hMyReport>0 then
      begin
        try
          LoadFromReportH(hMyReport);
        finally
          EndReport(hMyReport);
        end;
      end;

      if hMyReport<1 then MessageDlg('Cant load info on R&&R report '+ReportName,
                                     mtError,[mbAbort],0);
    finally
      StrDispose(MyApp_);
      StrDispose(MyLib_);
      StrDIspose(MyRep_);
    end;
  end;
end;


{ ************************************************************************** }
procedure TRRX65.LoadFromReportH(hMyReport:Integer);
{ ************************************************************************** }

{ Using passed report handle load object info from report defaults }

begin

  { Clear XBASE Specific TSTRING Fields }
  fRelationTables.Clear;
  fRelationIndexs.Clear;
  fRelationTags.Clear;
  fRelationAlias.Clear;

  { Clear Generic TSTRING Fields }
  fFields.Clear;
  fGroupFields.Clear;
  fSortFields.Clear;
  fUserParamsNames.Clear;
  fUserParamsValues.Clear;

  { Load XBASE Specific Properties }
  LoadRelations(hMyReport);
  LoadScopes(hMyReport);
  LoadIndex(hMyReport);

  { Load Generic Properties }
  LoadFields(hMyReport);
  LoadGroupFields(hMyReport);
  LoadSortFields(hMyReport);
  LoadUserParams(hMyReport);
  LoadTitle(hMyReport);
  LoadPages(hMyReport);
  LoadTable(hMyReport);
  LoadFilter(hMyReport);
  LoadDests(hMyReport);
  LoadPrinter(hMyReport);

end;

{ ************************************************************************** }
procedure TRRX65.setlibname(NewLibName:String);
{ ************************************************************************** }
var
  Designing:Boolean;
begin
  flibname:=NewLibName;
  Designing:=(csDesigning in ComponentState);
  if ((csReading in ComponentState) or (csLoading in ComponentState)) then
    Designing:=false;

  if (Designing and (fLibName<>'') and (fRepName<>'') ) then
  begin
    if MessageDlg('Load Properties From Report ?',mtconfirmation,
                  [mbNo,mbYes],0)=mrYes then loadfromreport;
  end;
end;

{ ************************************************************************** }
function TRRX65.Run:Boolean;
{ ************************************************************************** }
begin
  Result:=Execute;
end;


{ ************************************************************************** }
function TRRX65.Execute:Boolean;
{ ************************************************************************** }
var
  { Handle of report }
  hReport: Integer;

  { Flags returned after report was run }
  ECode:Integer;
  cmdshow: Integer;
  PageCount:LongInt;
  EMsg:Pchar;
  ErrorMess: String;

  AppName_,LibName_,RepName_:Pchar;
begin
  {Run the report }
  Result:=false;

  { Convert Pascal type strings to C++ strings as expected by DLL }
  AppName_:=StrAlloc(length(fAppName)+1);
  LibName_:=StrAlloc(length(fLibName)+1);
  RepName_:=StrAlloc(length(fRepName)+1);
  StrPCopy(AppName_,fAppName);
  StrPCopy(LibName_,flibname);
  EMsg:=StrAlloc(256);
  if faskreport then StrPCopy(RepName_,'') else
    StrPCopy(RepName_,fRepName);

  try
    { If object specifys ask for report then blank out the report name }
    { to make sure user is prompted for report name }

    hReport:=ChooseReport(Appname_,LibName_,RepName_,StrBufSize(RepName_));

    if hReport>0 then begin
      try
        { Pass all the propertys to RSREPORT.DLL }
        SaveToReportH(hReport);

        { Run the report and then clean up }
        cmdshow:=SW_SHOWNORMAL;
        fErrorCode:='';
        fErrorMessage:='';
        ResetErrorInfo;
        if ExecRunTime(hReport,fWait,cmdshow,@ECode,@PageCount,EMsg,StrBufSize(EMsg))
        then Result:=True else begin
          geterrorinfo(Emsg,StrBufSize(EMsg),@Ecode);
          fErrorMessage:=StrPas(EMsg);

          case Ecode of
            Ord('C'):fErrorCode:='Cancelled';
            Ord('D'):fErrorCode:='Diagnostic';
            Ord('I'):fErrorCode:='Iteration';
            Ord('J'):fErrorCode:='Job Control';
            Ord('L'):fErrorCode:='Library';
            Ord('S'):fErrorCode:='Syntax';
            Ord('V'):fErrorCode:='Value';
          else
            fErrorCode:=Chr(Ecode);
          end;

          MessageDlg('R&&R Error : '+StrPas(EMsg),mtError,[mbAbort],0);
        end;
      finally
        EndReport(hReport);
      end;
    end;
    fLastErrorPage:=PageCount;
    if hReport<1 then MessageDlg('Cant allocate handle for report '+fRepname,
                                 mtError,[mbAbort],0)
  finally
    StrDispose(AppName_);
    StrDispose(LibName_);
    StrDispose(RepName_);
    StrDispose(EMsg);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadUserParams(hReport:Integer);
{ ************************************************************************** }
var
  ParamName,ParamValue:Pchar;
begin
  ParamName:=StrAlloc(31);
  ParamValue:=StrAlloc(31);
  try
    if GetFirstUserParam(hReport,ParamName,StrBufSize(ParamName),
                      paramValue,StrBufSize(ParamValue)) then begin
      fUserParamsNames.Add(StrPas(ParamName));
      fUserParamsValues.Add(StrPas(ParamValue));
    end;
    while GetNextUserParam(hReport,ParamName,StrBufSize(ParamName),
                           ParamValue,StrBufSize(ParamValue)) do begin
      fUserParamsNames.Add(StrPas(ParamName));
      fUSerParamsValues.Add(StrPas(ParamValue));
    end;
  finally
    StrDispose(ParamName);
    StrDispose(ParamValue);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadFields(hReport:Integer);
{ ************************************************************************** }
var
  FieldName:PChar;
begin
  FieldName:=StrAlloc(31);
  try
    if GetFirstFieldName(hReport,FieldName,StrBufSize(FieldName)) then
      fFields.Add(StrPas(FieldName));
    while GetNextFieldName(hReport,FieldName,StrBufSize(FieldName)) do
      fFields.Add(StrPas(FieldName));
  finally
    StrDispose(FieldName);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadGroupFields(hReport:Integer);
{ ************************************************************************** }
var
  GroupField:Pchar;
begin
  GroupField:=StrAlloc(31);
  try
    if GetFirstGroupField(hReport,GroupField,StrBufSize(GroupField)) then
      fGroupFields.Add(StrPas(GroupField));
    while GetNextGroupField(hReport,GroupField,StrBufSize(GroupField)) do
      fGroupFields.Add(StrPas(GroupField));
  finally
    StrDispose(GroupField);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadSortFields(hReport:Integer);
{ ************************************************************************** }
var
  SortField:Pchar;
begin
  SortField:=StrAlloc(31);
  try
    if GetFirstSortField(hReport,SortField,StrBufSize(SortField)) then
      fSortFields.Add(StrPas(SortField));
    while GetNextSortField(hReport,SortField,StrBufSize(SortField)) do
      fSortFields.Add(StrPas(SortField));
  finally
    StrDispose(SortField);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.SetRepName(NewRepName: String);
{ ************************************************************************** }
var
  Designing:Boolean;
begin
  fRepName:=NewRepName;
  Designing:=(csDesigning in ComponentState);
  if ((csReading in ComponentState) or (csLoading in ComponentState)) then
    Designing:=false;

  if (Designing and (fLibName<>'') and (fRepName<>'') ) then
  begin
    if MessageDlg('Load Properties From Report ?',mtconfirmation,
                  [mbYes,mbNo],0)=mrYes then loadfromreport;
  end;
end;

{ ************************************************************************** }
procedure TRRX65.SetfFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetfGroupFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fGroupFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetfSortFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fSortFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetfUserParamsNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fUserParamsNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetfUserParamsValues(Value:Tstrings);
{ ************************************************************************** }
begin
  fUserParamsValues.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetfActive(Value:Boolean);
{ ************************************************************************** }
begin
  if (csDesigning in ComponentState) and (Value=True) then execute;
end;

{ ************************************************************************** }
procedure TRRX65.SetfAuthor(Value:String);
{ ************************************************************************** }
begin
  if Value<>'cbrooksbank@msn.com' then
  messagedlg('Please send bugs/comments/enhancements to cbrooksbank@msn.com',mtInformation,
              [mbOk],0);
  fAuthor:='cbrooksbank@msn.com';
end;

{ ************************************************************************** }
procedure TRRX65.LoadTitle(hReport:Integer);
{ ************************************************************************** }
var
  title_:PChar;
begin
  title_:=StrAlloc(256);
  try
    if GetWinTitle(hReport,title_,StrBufSize(title_)) then
      fWinTitle:=StrPas(title_);
  finally
    StrDispose(title_);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadPages(hReport:Integer);
{ ************************************************************************** }
begin
  GetBeginPage(hReport,@fBeginPage);
  GetEndPage(hReport,@fEndPage);
  GetCopies(hReport,@fCopies);
end;

{ ************************************************************************** }
procedure TRRX65.LoadTable(hReport:Integer);
{ ************************************************************************** }
var
  table_:Pchar;
begin
  table_:=StrAlloc(256);
  try
    if GetMasterTableName(hReport,table_,StrBufSize(table_)) then
      fMasterTableName:=StrPas(table_);
  finally
    StrDispose(table_);
  end;
end;


{ ************************************************************************** }
procedure TRRX65.LoadFilter(hReport:Integer);
{ ************************************************************************** }
var
  filter_:Pchar;
begin
  filter_:=StrAlloc(256);
  try
    if getFilter(hReport,filter_,StrBufSize(filter_)) then
      fFilter:=StrPas(filter_);
  finally
    StrDispose(Filter_);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadDests(hReport:Integer);
{ ************************************************************************** }
var
  Dest_:Pchar;
  DestStr:String;
begin

Dest_:=StrAlloc(256);
try

  { Load fExportDest}
  if getExportDest(hReport,Dest_) then
  begin
    DestStr:=StrPas(Dest_);
    if DestStr[1]='D' then
      fExportDest:=rredDisplay;
    if DestStr[1]='F' then
      fExportDest:=rredFile;
    if DestStr[1]='P' then
      fExportDest:=rredPrinter;
  end;

  { Load fOutPutDest }
  if getOutputDest(hReport,Dest_) then
  begin
    DestStr:=StrPas(Dest_);
    if DestStr[1]='D' then
      fOutPutDest:=rrdDisplay;
    if DestStr[1]='A' then
      fOutPutDest:=rrdTextFile;
    if DestStr[1]='T' then
      fOutPutDest:=rrdTextFile;
    if DestStr[1]='P' then
      fOutPutDest:=rrdPrinter;
    if DestStr[1]='W' then
      fOutPutDest:=rrdWorksheet;
    if DestStr[1]='X' then
      fOutPutDest:=rrdXBase;
    if DestStr[1]='?' then
      fOutPutDest:=rrdInteractive;
  end;

  { Load fOutputFile }
  if getOutputDest(hReport,Dest_) then
    fOutPutFile:=StrPas(Dest_);
finally
  StrDispose(Dest_);
end;

end;

{ ************************************************************************** }
procedure TRRX65.LoadPrinter(hReport:Integer);
{ ************************************************************************** }
var
  Printer_,Port_:Pchar;
begin
  Printer_:=StrAlloc(256);
  Port_:=StrAlloc(256);
  try
    if getPrinter(hReport,Printer_,StrBufSize(Printer_)) then
      fPrinterName:=StrPas(Printer_);
    if getPrinterPort(hReport,Port_,StrBufSize(Port_)) then
      fPrinterPort:=StrPas(Port_);
  finally
    StrDispose(Printer_);
    StrDispose(Port_);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.SaveToReportH(hReport:Integer);
{ ************************************************************************** }

{ Given a report handle save object properties to the report }
{ Pass all the propertys to RSREPORT.DLL }

var
  { Temp vars to hold Pchar versions of String properties }
  PrinterName_:PChar;
  PrinterPort_:PChar;
  filter_:PChar;
  MasterTableName_,MemoName_,OutputFile_,WinTitle_:PChar;
  Tablename_,Databasename_:PChar;

  CharString:String;
  SiField,SiField2:PChar;
  datadir_,imagedir_:PChar;

  i,maxi:Integer;

  { XBASE specific VARS }
  lowscope_,highscope_:PChar;
  MasterIndex_,MasterTag_:PChar;
  RelationTable_,RelationIndex_,RelationTag_,RelationAlias_:PChar;


begin

  PrinterName_:= StrAlloc(256);
  PrinterPort_:= StrAlloc(31);
  filter_:= StrAlloc(256);
  MasterTableName_:=StrAlloc(256);
  MemoName_:=StrAlloc(256);
  OutputFile_:=StrAlloc(256);
  WinTitle_:=StrAlloc(256);
  Tablename_:=StrAlloc(256);
  DatabaseName_:=StrAlloc(256);
  SiField:=StrAlloc(256);
  SiField2:=StrAlloc(256);
  datadir_:=StrAlloc(256);
  imagedir_:=StrAlloc(256);
  lowscope_:=StrAlloc(256);
  highscope_:=StrAlloc(256);
  MasterIndex_:=StrAlloc(256);
  MasterTag_:=StrAlloc(256);
  RelationTable_:=StrAlloc(256);
  RelationIndex_:=StrAlloc(256);
  RelationTag_:=StrAlloc(256);
  RelationAlias_:=StrAlloc(256);
  try


    if AskPrinter then fPrinterName:='?';

    { Convert Pascal type strings to C++ strings as expected by DLL }
    StrPCopy(Filter_,fFilter);
    StrPCopy(MasterTableName_,fMasterTableName);
    StrPCopy(MemoName_,fMemoName);
    StrPCopy(OutputFile_,fOutputFile);
    StrPCopy(Printername_,fPrinterName);
    StrPCopy(PrinterPort_,fPrinterPort);
    StrPCopy(WinTitle_,fWinTitle);
    StrPCopy(Databasename_,fDatabasename);
    StrPCopy(ImageDir_,fimagedir);
    StrPCopy(DataDir_,fdatadir);

    { XBASE Specific StrPcopys }
    StrPcopy(lowscope_,fscopelow);
    StrPCopy(highscope_,fscopehigh);
    StrPCopy(Masterindex_,fMasterIndexName);
    StrPCopy(Mastertag_,fMasterIndexTag);

    SetBeginPage(hReport,fBeginPage);
    SetCopies(hReport,fCopies);
    SetDisplayErrors(hReport,fDisplayErrors);
    SetDisplayStatus(hReport,FDisplayStatus);
    SetEndPage(hReport,fEndPage);

    CharString:=Copy('DFP',Ord(fExportDest)+1,1);
    SetExportDest(hReport,CharString[1]);

    SetFilter(hReport,Filter_);

    CharString:=Copy('SEO?',Ord(fFilterUsage)+1,1);
    SetFilterUsage(hReport,CharString[1]);

    if fMasterTableName<>''then
      SetMasterTableName(hReport,MasterTableName_);

    if fMemoName<>'' then
      SetMemoName(hReport,MemoName_);

    CharString:=Copy('DAPWX?CMR',Ord(fOutputDest)+1,1);
    SetOutputDest(hReport,CharString[1]);

    SetOutPutFile(hReport,OutputFile_);
    SetPreventEscape(hReport,fPreventEscape);
    SetStatusEveryPage(hReport,fStatusEveryPage);
    SetTestPattern(hReport,fTestPattern);

    CharString:=Copy('0123',Ord(fWinBorderStyle)+1,1);
    SetWinBorderStyle(hReport,Ord(CharString[1])-Ord('0'));

    SetWinControlBox(hReport,fWinControlBox);
    SetWinHeight(hReport,fWinHeight);
    SetWinLeft(hReport,fWinLeft);
    SetWinMaxButton(hReport,fWinMaxButton);
    SetWinMinButton(hReport,fWinMinButton);
    SetWinParentHandle(hReport,fWinParentHandle);
    SetWinTitle(hReport,WinTitle_);
    SetWinTop(hReport,fWinTop);
    SetWinWidth(hReport,fWinWidth);

    { Set sort fields }
    for i:=0 to (fSortFields.Count-1) do begin
      if ((fSortFields[i]<>'') and
         (Pos('RECNO',UpperCase(fSortFields[i]))=0)) then begin
        StrPCopy(SiField,fSortFields[i]);
        SetSortField(hReport,SiField,i+1);
      end;
    end;

    { Set Group Fields }
    for i:=0 to (fGroupFields.Count-1) do begin
      if fGroupFields[i]<>'' then begin
        StrPCopy(SiField,fGroupFields[i]);
        SetGroupField(hReport,SiField,i+1);
      end;
    end;

    { Set user paramaters }
    for i:=0 to (fUserParamsNames.Count-1) do begin
      if fUserParamsNames[i]<>'' then begin
        StrPCopy(SiField,fUserParamsNames[i]);
        StrPCopy(SiField2,fUserParamsValues[i]);
        SetUserParam(hreport,SiField,SiField2);
      end;
    end;


    if ((fPrinterName<>'') or AskPrinter) then
    begin
      SetPrinter(hReport,PrinterName_);
      SetPrinterPort(hReport,PrinterPort_);
    end;

    if fimagedir<>'' then SetImageDir(hreport,imagedir_);
    if fdatadir<>'' then SetDataDir(hreport,datadir_);

    { Set XBASE specific things }

    SetXBaseEditor(hReport,fXbaseEditor);
    SetWriteAllow(hReport,fWriteAllow);
    SetIndexExtension(hReport,Ord(fIndexExtension));

    CharString:=Copy('SEO?',Ord(fScopeUsage)+1,1);
    SetScopeUsage(hReport,CharString[1]);

    if fScopeLow<>'' then SetLowScope(hreport,LowScope_);
    if fScopeHigh<>'' then SetHighScope(hreport,HighScope_);

    if fMasterIndexName<>'' then begin
      CharString:=Copy('NDC',Ord(fMasterIndexType)+1,1);
      SetMasterIndexInfo(hReport,MasterIndex_,CharString[1],MasterTag_);
    end;

    { Set XBASE Relationships }
    for i:=0 to (fRelationTables.Count-1) do begin
      StrPCopy(RelationTable_,fRelationTables[i]);
      StrPCopy(RelationIndex_,fRelationIndexs[i]);
      StrPCopy(RelationTag_,fRelationTags[i]);
      StrPCopy(RelationAlias_,fRelationAlias[i]);
      SetRelationInfo(hReport,RelationTable_,RelationIndex_,RelationTag_,
                      RelationAlias_,i+1);
    end;
  finally
    StrDispose(PrinterName_);
    StrDispose(PrinterPort_);
    StrDispose(filter_);
    StrDispose(MasterTableName_);
    StrDispose(MemoName_);
    StrDispose(OutputFile_);
    StrDispose(WinTitle_);
    StrDispose(Tablename_);
    StrDispose(DatabaseName_);
    StrDispose(SiField);
    StrDispose(SiField2);
    StrDispose(datadir_);
    StrDispose(imagedir_);
    StrDispose(lowscope_);
    StrDispose(highscope_);
    StrDispose(MasterIndex_);
    StrDispose(MasterTag_);
    StrDispose(RelationTable_);
    StrDispose(RelationIndex_);
    StrDispose(RelationTag_);
    StrDispose(RelationAlias_);
  end;

end;


{ ************************************************************************** }
function TRRX65.SaveToFile(MyFile:String):Boolean;
{ ************************************************************************** }
var
  hReport:Integer;
  MyFile_,MyApp_,MyLib_,MyRep_:PChar;
begin
  MyFile_:=StrAlloc(256);
  MyApp_:=StrAlloc(256);
  MyLib_:=StrAlloc(256);
  MyRep_:=StrAlloc(256);
  try

    Result:=false;
    StrPCopy(MyApp_,fAppName);
    StrPCopy(MyLib_,fLibName);
    StrPCopy(MyRep_,fRepName);

    hReport:=ChooseReport(MyApp_,MyLib_,MyRep_,StrBufSize(MyRep_));
    try
      if hReport>0 then
      begin
        StrPCopy(MyFile_,MyFile);
        savetoreportH(hReport);
        if writeRunTimeRecord(hReport,MyFile_) then result:=true;
      end;
    finally
      EndReport(hReport);
    end;
  finally
    StrDispose(MyFile_);
    StrDispose(MyApp_);
    StrDispose(MyLib_);
    StrDispose(MyRep_);
  end;
end;

{ ************************************************************************** }
function TRRX65.LoadFromFile(MyFile:String):boolean;
{ ************************************************************************** }
var
  hReport:Integer;
  MyFile_,MyApp_,MyLib_,MyRep_:PChar;
begin
  MyFile_:=StrAlloc(256);
  MyApp_:=StrAlloc(256);
  MyLib_:=StrAlloc(256);
  MyRep_:=StrAlloc(256);
  try
    Result:=false;
    StrPCopy(MyApp_,fAppName);
    StrPCopy(MyLib_,fLibName);
    StrPCopy(MyRep_,fRepName);

    StrPCopy(MyFile_,MyFile);
    hReport:=getRunTimeRecord(MyApp_,MyFile_);
    if hReport>0 then
    begin
      try
        { Load report information into this object }
        Result:=true;
        loadfromreporth(hReport);
      finally
        EndReport(hReport);
      end;
    end;
  finally
    StrDispose(MyFile_);
    StrDispose(MyApp_);
    StrDispose(MyLib_);
    StrDispose(MyRep_);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.SetRelationTables(Value:Tstrings);
{ ************************************************************************** }
begin
  fRelationTables.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetRelationIndexs(Value:Tstrings);
{ ************************************************************************** }
begin
  fRelationIndexs.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetRelationTags(Value:Tstrings);
{ ************************************************************************** }
begin
  fRelationTags.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.SetRelationAlias(Value:Tstrings);
{ ************************************************************************** }
begin
  fRelationAlias.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRX65.LoadRelations(hReport:Integer);
{ ************************************************************************** }
var
  Table_,Index_,Tag_,Alias_:Pchar;
begin
  Table_:=StrAlloc(256);
  Index_:=StrAlloc(256);
  Tag_:=StrAlloc(256);
  Alias_:=StrAlloc(256);
  try

    if GetFirstRelationInfo(hReport,Table_,StrBufSize(Table_),Index_,StrBufSize(Index_),
                          Tag_,StrBufSize(Tag_),Alias_,StrBufSize(Alias_)) then begin

      fRelationTables.Add(StrPas(Table_));
      fRelationIndexs.Add(StrPas(Index_));
      fRelationTags.Add(StrPas(Tag_));
      fRelationAlias.Add(StrPas(Alias_));
    end;
    while GetNextRelationInfo(hReport,Table_,StrBufSize(Table_),Index_,StrBufSize(Index_),
                            Tag_,StrBufSize(Tag_),Alias_,StrBufSize(Alias_)) do begin
      fRelationTables.Add(StrPas(Table_));
      fRelationIndexs.Add(StrPas(Index_));
      fRelationTags.Add(StrPas(Tag_));
      fRelationAlias.Add(StrPas(Alias_));
    end;
  finally
    StrDispose(Table_);
    StrDispose(Index_);
    StrDispose(Tag_);
    StrDispose(Alias_);
  end;
end;


{ ************************************************************************** }
procedure TRRX65.LoadScopes(hReport:Integer);
{ ************************************************************************** }
var
  Scope:Pchar;
begin
  Scope:=StrAlloc(256);
  try
    if GetLowScope(hReport,Scope,StrBufSize(Scope)) then
      fScopeLow:=StrPas(Scope);
    if GetHighScope(hReport,Scope,StrBufSize(Scope)) then
      fScopeHigh:=StrPas(Scope);
  finally
    StrDispose(Scope);
  end;
end;

{ ************************************************************************** }
procedure TRRX65.LoadIndex(hReport:Integer);
{ ************************************************************************** }
var
  Index_,Type_,Tag_:Pchar;
  TypeString:String;
begin
  Index_:=StrAlloc(256);
  Type_:=StrAlloc(256);
  Tag_:=StrAlloc(256);
  try

    if GetMasterIndexInfo(hReport,Index_,StrBufSize(Index_),Type_,Tag_,
                          StrBufSize(Tag_)) then begin
      fMasterIndexName:=StrPas(Index_);
      fMasterIndexTag:=StrPas(Tag_);

      TypeString:=StrPas(Type_);
      if TypeString[1]='N' then
        MasterIndexType:=rrdtNumeric;
      if TypeString[1]='D' then
        MasterIndexType:=rrdtDate;
      if TypeString[1]='C' then
        MasterIndexType:=rrdtCharacter;

    end;
  finally
    StrDispose(Index_);
    StrDispose(Type_);
    StrDispose(Tag_);
  end;
end;


end.
