{ Function prototypes and declarations for XBASE edition }
{ Of R&R V6.5 }

{ Author Chris Brooksbank (cbrooksbank@msn.com) }
{ Written : October 1995 }

unit RRxint;

interface

uses WinTypes;




{ XBASE Specific Functions }





{ Get/set Scope info XBASE only }
function GetHighScope(hReport:Integer;HiScope:PChar;ScopeSize:Integer):Boolean;far;
function GetLowScope(hReport:Integer;LoScope:PChar;ScopeSize:Integer):Boolean;far;
function SetHighScope(hReport:Integer;HiScope:Pchar):Boolean;far;
function SetLowScope(hReport:Integer;LowScope:Pchar):Boolean;far;
function SetScopeUsage(hReport:Integer;UsageFlag:Char):Boolean;far;
function GetScopeUsage(hReport:Integer;UsageFlag:PChar):Boolean;far;

{ MasterIndex }
function GetMasterIndexInfo(hReport:Integer;IndexName:PChar;IndexNameSize:Integer;
                            DataType,TagName:PChar;TagSize:Integer):Boolean;far;
function SetMasterIndexInfo(hReport:Integer;IndexName:PChar;DataType:Char;
                            TagName:PChar):Boolean;far;

function SetXbaseEditor(hReport:Integer;MemoFlag:Boolean):Boolean;far;

{ ExtNumber means : 0-none,1-CDX,2-IDX,3-MDX,4-NDX,5-NSX,6-NTX,7-WDX }
function SetIndexExtension(hReport,ExtNumber:Integer):Boolean;far;

{ Allow writes to tables whilst report running ? }
function SetWriteAllow(hReport:Integer;AllowWrites:Boolean):Boolean;far;

{ get/set Relations }
function GetFirstRelationInfo(hReport:Integer;tablename:Pchar;sizetablename:Integer;
                             indexname:PChar;sizeindexname:Integer;
			     TagName:PChar;TagNameSize:Integer;
			     AliasName:PChar;AliasName:Integer):Boolean;far;
function GetNextRelationInfo(hReport:Integer;tablename:Pchar;sizetablename:Integer;
                             indexname:PChar;sizeindexname:Integer;
			     TagName:PChar;TagNameSize:Integer;
			     AliasName:PChar;AliasName:Integer):Boolean;far;
function SetRelationInfo(hReport:Integer;tablename,IndexName,TagName,AliasName:Pchar;
			 RelationNumber:Integer):Boolean;far;




{ Generic functions }




{ ************* Initialisation and cleanup functions/ run report ******* }
function InitRunTimeInstance: Boolean;far;
  { You must call this function first. It initialises an instance of the
    R&R runtime DLL }
function EndRunTimeInstance: Boolean;far;
  { Call this function to cleanup after you have finished using the R&R
    runtime DLL }
function EndReport(hReport: Integer): Boolean;far;
  { Free resources allocated to a report. Always call after using a report. }
function  ChooseReport(MyApp,LibName,RepName:PChar;Size: Integer): Integer;far;
  { Given a report library and report name return a handle to this report.
    Most functions need a hReport param. That is what this function returns.
    If RepName is NIL interactively asks for report from menu }
function  GetNewReportHandle(MyApp: PChar): Integer;far;
  { Another way of getting a report handle. This is a handle to a empty
    report information structure. Use ChooseReport in preference to this }
function  execRuntime(hReport:Integer;Wait:Boolean;cmdShow: Integer;
                      ECode: PInteger;PageCount: PLongInt;
                      EMsg:Pchar;Emsgsizeof: Integer): Boolean;far;
   { After getting a report handle and amending any settings call this
     function to actually run the report
     cmdShow can be sw_hide,sw_minimize,sw_restore,sw_show,sw_showmaximized,
                    sw_showminimized,sw_showminnoactive,sw_showna,
		    sw_shownoactive,sw_shownormal
		    ie any Windows API ShowWindow
     on Return Ecode value indicates (Error message in EMsg) :
     Ecode=N Successful execution of report
     Ecode=C User cancelled the report Emsg="Report canceled"
     Ecode=J Report structure pointed to by hReport is incorrect/corrupt
     Ecode=R Report began to execute but failed to complete. }
{ ********************************************************************** }


{ ********************************************************************** }
{ Getting information about R&R errors }
function GetErrorInfo(Msg:PChar;MsgSize:Integer;ErrCode:PInteger): Boolean;far;
  { Get error message and code returned by last DLL call }
  { ErrCode can be :
    C=Cancel. User cancelled a dialog box presented by the R&R DLL
    D=Diagnostic. Misc. error such as out of memory
    I=Iteration. No more values for requested getfirst or getnext function
    J=Job Control. Problem with specified runtime control file
    L=Library.Problem with report library being accessed
    S=Syntax error.
    V=Value. No value available for specified paramater.}
function resetErrorInfo: Boolean;far;
  { Clear out the last error message }
{ ********************************************************************** }


{ Which page to start printing at }
function  GetBeginPage(hReport: Integer;BeginPage: Plongint): Boolean;far;
function  SetBeginPage(hReport: Integer;lBeginPage: longint): Boolean;far;

{ Which page to end printing at }
function  GetEndPage(hReport:Integer;EndPage: Plongint): Boolean;far;
function  SetEndPage(hReport: Integer;EndPage: LongInt): Boolean;far;

{ How many copies of report to print }
function  GetCopies(hReport: Integer;Copies: PInteger): Boolean;far;
function  SetCopies(hReport: Integer;Copies: Integer): Boolean;far;

{ Should R&R display errors on the screen ? }
function SetDisplayErrors(hReport:Integer;DispErr: Boolean): Boolean;far;
function GetDisplayErrors(hReport:Integer;DispErr: Pbool): Boolean;far;

{ Should R&R display a status window as the report is being generated ? }
function SetDisplayStatus(hReport:Integer;DispStatus: Boolean): Boolean;far;
function GetDisplayStatus(hReport:Integer;DispStatus:PBool): Boolean;far;

{ Export destination }
{ D=Display
  F=File
  P=Printer }
function SetExportDest(hReport:Integer;Val: char ): Boolean;far;
function GetExportDest(hReport:Integer;Val: PChar): Boolean;far;

{ View/alter the filter the report will use }
function setFilter(hReport:Integer;Filter: PChar): Boolean;far;
function getFilter(hReport:Integer;Filter:Pchar;Size:Integer): Boolean;far;

{ Which filter to use }
{ S=use filter saved with report
  E=dont use any filter. Use entire recordset
  O=Use filter specified with setfilter()
  ?=Allow user to interactively design filter at runtime }
function setFilterUsage(hReport:Integer;Val:Char): Boolean;far;
function getFilterUsage(hReport:Integer;Val: PChar): Boolean;far;

{ get/set the main table to be used in the report }
function setMasterTableName(hReport:Integer;FileName:PChar): Boolean;far;
function getMasterTableName(hReport:Integer;Filename: PChar;Size: Integer): Boolean;far;

{ get/set the ASCII memo file to use in the report }
function setMemoName(hReport:Integer;Path:Pchar): Boolean;far;
function getMemoName(hReport:Integer;Path:PChar;Size:Integer): Boolean;far;

{ get/set the Report output destination }
{ D=Display
  A/T=Text File - set by setOutputFile
  P=Printer
  W=Worksheet File
  X=XBASE file
  ?=Interactive at runtime }
function setOutputDest(hReport:Integer;Dest:Char): Boolean;far;
function getOutputDest(hReport:Integer;Dest:Pchar): Boolean;far;

{ Filename to output report to }
function setOutputFile(hReport:Integer;Name:Pchar): Boolean;far;
function getOutputFile(hReport:Integer;Name:PChar;Size: Integer): Boolean;far;

{ Allow user to interactively select the printer to use }
{ can later pass selected name to setPrinter }
function ChoosePrinter(hReport:Integer;Printer:PChar;SizePrinter:Integer;
	               PortName:PChar;SizePort:Integer): Boolean;far;

{ Get/set printer name associated with the report }
function getPrinter(hReport:Integer;PrinterName: PChar;Size: Integer): Boolean;far;
function setPrinter(hReport:Integer;PrinterName: PChar): Boolean;far;

{ Set the parent window of the preview window by passing the window handle }
function SetWinParentHandle(hReport:Integer;hParent:Integer): Boolean;far;

{ Replace the default data directory specified in RSW.INI }
function SetDataDir(hReport:Integer;Dir:PChar): Boolean;far;

{ Get/set functions for group fields }
function GetFirstGroupField(hReport:Integer;Name:PChar;Size:Integer): Boolean;far;
function GetNextGroupField(hReport:Integer;Name:PChar;Size:Integer):  Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetGroupField(hReport:Integer;Name:Pchar;GroupNum:Integer): Boolean;far;
{ Need to setgroupfields 1..last one to modify }

{ Replace the default image directory as stored in RSW.INI }
function SetImageDir(hReport:Integer;Dir:PChar): Boolean;far;

{ Get/Set printer port }
function GetPrinterPort(hReport:Integer;PortName:PChar;Size:Integer): Boolean;far;
function SetPrinterPort(hReport:Integer;Port:PChar): Boolean;far;

{ R=User prompted to select a report from current report library
  ?=User prompted to pick a succession of reports }
function GetReportPick(hReport:Integer;Pickflag:PChar): Boolean;far;
function SetReportPick(hReport:Integer;Pickflag:Char): Boolean;far;

{ Functions to get/set sort fields }
function GetFirstSortField(hReport:Integer;Name:PChar;Size:Integer): Boolean;far;
function GetNextSortField(hReport:Integer;Name:PChar;Size:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetSortField(hReport:Integer;Name:PChar;SortNum:Integer): Boolean;far;

{ Get field names available to report }
function GetFirstFieldName(hReport:Integer;FieldName:PChar;FnSize:Integer): Boolean;far;
function GetNextFieldName(hReport:Integer;FieldName:PChar;Fnsize:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }

{ Get/set user paramaters }
function GetFirstUserParam(hReport:Integer;PName:PChar;PNameSize:Integer;
	                   PValue:PChar;PValueSize:Integer): Boolean;far;
function GetNextUserParam(hReport:Integer;PName:PChar;PNameSize:Integer;
	                   PValue:PChar;PValueSize:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetUserParam(hReport:Integer;Name:PChar;Value:PChar): Boolean;far;
{ To get R&R to ask in a dialog 'Enter Your Name :' then pass a value of
  "?Enter your name:"}

{ Should user be allowed to abort report when R&R is generating it by
  clicking on a cancel button ? }
function GetPreventEscape(hReport:Integer;Value:PBool): Boolean;far;
function SetPreventEscape(hReport:Integer;Value:Boolean): Boolean;far;

{ Get/set report library name and directory }
function GetLibrary(hReport:Integer;LibName:PChar;LibNameSize:Integer): Boolean;far;
function setLibrary(hreport:Integer;LibName:PChar): Boolean;far;
function setLibraryDir(hReport:Integer;DirName:PChar): Boolean;far;


{ Should user be offered a test pattern before real report is printed ? }
function getTestPattern(hReport:Integer;Value:PBool): Boolean;far;
function setTestPattern(hReport:Integer;Value:Boolean): Boolean;far;

{ Read/write all configurations for current report to a ASCII file }
function getRunTimeRecord(AppName:PChar;Filename:PChar): Integer;far;
function writeRunTimeRecord(hReport:Integer;FileName:PChar): Boolean;far;

{ Should status file be updated after every page or just at report end ? }
{ status file only applicable when execRuntime is passed Wait of nonzero}
function getStatusEveryPage(hReport:Integer;Value:PBool):Boolean;far;
function setStatusEveryPage(hReport:Integer;Value:Boolean):Boolean;far;
function setStatusFileName(hReport:Integer;FileName:PChar): Boolean;far;

{ Suppress title and summary areas for empty reports ? }
function setSuppressTitle(hReport:Integer;Value:Boolean): Boolean;far;

{ Get/set caption for runtime windows displayed by R&R runtime }
function setWinTitle(hReport:Integer;Title:PChar): Boolean;far;
function getWinTitle(hReport:Integer;Title:Pchar;Size:Integer): Boolean;far;

{ Style of print-preview window
  0=No Border
  1=Fixed size & single line border
  2=User can change size of preview window
  3=Fixed size and double line border }
function setWinBorderStyle(hReport:Integer;Style:Integer): Boolean;far;

{ Should preview window have a control menu ? }
function setWinControlBox(hReport:Integer;ControlBox:Boolean): Boolean;far;

{ Get/set dimensions of report preview window }
function setWinTop(hReport,WinTop:Integer): Boolean;far;
function setWinLeft(hReport,Left:Integer): Boolean;far;
function setWinWidth(hReport,WinWidth:Integer): Boolean;far;
function setWinHeight(hReport,Height:Integer): Boolean;far;

{ Allow minimize and maximise of preview window ? }
function setWinMaxButton(hReport:Integer;AllowButton:Boolean): Boolean;far;
function setWinMinButton(hReport:Integer;AllowButton:Boolean): Boolean;far;

{ New to R&R V6.5 GetFilteredField Names }
{ Fieldnames available for the report suitable for use in sort/groups }
{ filterid code : 1 sortfield, 2 groupfield } 
function GetFirstFilteredFieldName(hReport:Integer;FieldName:PChar;
                          FieldNameSize:Integer;filterID:Integer):Boolean;far;
function GetNextFilteredFieldName(hReport:Integer;FieldName:PChar;
                          FieldNameSize:Integer;filterID:Integer):Boolean;far;


implementation

{ Tell Delphi that all the functions are stored in RREPORT.DLL }


{ XBASE Specific Functions }

function GetHighScope;
  external 'RREPORT';
function SetHighScope;
  external 'RREPORT';
function GetLowScope;
  external 'RREPORT';
function SetLowScope;
  external 'RREPORT';
function SetScopeUsage;
  external 'RREPORT';
function GetScopeUsage;
  external 'RREPORT';
function GetMasterIndexInfo;
  external 'RREPORT';
function SetMasterIndexInfo;
  external 'RREPORT';
function SetWriteAllow;
  external 'RREPORT';
function SetXbaseEditor;
  external 'RREPORT';
function SetIndexExtension;
  external 'RREPORT';
function GetFirstRelationInfo;
  external 'RREPORT';
function GetNextRelationInfo;
  external 'RREPORT';
function SetRelationInfo;
  external 'RREPORT';


{ Generic Functions }


function initRunTimeInstance;
  external 'RREPORT';
function endRunTimeInstance;
  external 'RREPORT';
function endReport;
  external 'RREPORT';
function chooseReport;
  external 'RREPORT';
function GetNewReportHandle;
  external 'RREPORT';
function execRunTime;
  external 'RREPORT';
function GetErrorInfo;
  external 'RREPORT';
function ResetErrorInfo;
  external 'RREPORT';
function GetBeginPage;
  external 'RREPORT';
function SetBeginPage;
  external 'RREPORT';
function GetEndPage;
  external 'RREPORT';
function SetEndPage;
  external 'RREPORT';
function GetCopies;
  external 'RREPORT';
function SetCopies;
  external 'RREPORT';
function SetDisplayErrors;
  external 'RREPORT';
function GetDisplayErrors;
  external 'RREPORT';
function SetDisplayStatus;
  external 'RREPORT';
function GetDisplayStatus;
  external 'RREPORT';
function SetExportDest;
  external 'RREPORT';
function GetExportDest;
  external 'RREPORT';
function setFilter;
  external 'RREPORT';
function getFilter;
  external 'RREPORT';
function setFilterUsage;
  external 'RREPORT';
function getFilterUsage;
  external 'RREPORT';
function setMasterTableName;
  external 'RREPORT';
function getMasterTableName;
  external 'RREPORT';
function setMemoName;
  external 'RREPORT';
function getMemoName;
  external 'RREPORT';
function setOutputDest;
  external 'RREPORT';
function getOutputDest;
  external 'RREPORT';
function setOutputFile;
  external 'RREPORT';
function getOutputFile;
  external 'RREPORT';
function ChoosePrinter;
  external 'RREPORT';
function getPrinter;
  external 'RREPORT';
function setPrinter;
  external 'RREPORT';
function SetWinParentHandle;
  external 'RREPORT';
function SetDataDir;
  external 'RREPORT';
function getFirstGroupField;
  external 'RREPORT';
function getNextGroupField;
  external 'RREPORT';
function SetGroupField;
  external 'RREPORT';
function SetImageDir;
  external 'RREPORT';
function GetPrinterPort;
  external 'RREPORT';
function SetPrinterPort;
  external 'RREPORT';
function GetReportPick;
  external 'RREPORT';
function SetReportPick;
  external 'RREPORT';
function GetFirstSortField;
  external 'RREPORT';
function GetNextSortField;
  external 'RREPORT';
function SetSortField;
  external 'RREPORT';
function GetFirstFieldName;
  external 'RREPORT';
function GetNextFieldName;
  external 'RREPORT';	 
function GetFirstUserParam;
  external 'RREPORT';
function GetNextUserParam;
  external 'RREPORT';
function SetUserParam;
  external 'RREPORT';
function GetPreventEscape;
  external 'RREPORT';
function SetPreventEscape;
  external 'RREPORT';
function GetLibrary;
  external 'RREPORT';
function setLibrary;
  external 'RREPORT';
function setLibraryDir;
  external 'RREPORT';
function getTestPattern;
  external 'RREPORT';
function setTestPattern;
  external 'RREPORT';
function getRunTimeRecord;
  external 'RREPORT';
function writeRunTimeRecord;
  external 'RREPORT';
function getStatusEveryPage;
  external 'RREPORT';
function setStatusEveryPage;
  external 'RREPORT';
function setStatusFileName;
  external 'RREPORT';
function setSuppressTitle;
  external 'RREPORT';
function setWinTitle;
  external 'RREPORT';
function getWinTitle;
  external 'RREPORT';
function setWinBorderStyle;
  external 'RREPORT';
function setWinControlBox;
  external 'RREPORT';
function setWinTop;
  external 'RREPORT';
function setWinLeft;
  external 'RREPORT';
function setWinWidth;
  external 'RREPORT';
function setWinHeight;
  external 'RREPORT';
function setWinMaxButton;
  external 'RREPORT';
function setWinMinButton;
  external 'RREPORT';
function GetFirstFilteredFieldName;
  external 'RREPORT';
function GetNextFilteredFieldName;
  external 'RREPORT';


end.

