/***********************************************************************/
/* WACOM-Digitizer Driver            (C) 1993-1995 by ROLAND SCHWINGEL */
/***********************************************************************/
/* Demoprogram for obtaining (pressure) data from the driver.          */
/*                                                                     */
/* Prints all data which is provided by the driver in a Window         */
/***********************************************************************/

/* INCLUDES ************/
#include <stdio.h>
#include <string.h>

#include <exec/exec.h>
#include <proto/exec.h>
#include <clib/exec_protos.h>

#include <dos/dos.h>
#include <proto/dos.h>
#include <clib/dos_protos.h>

#include <intuition/intuition.h>
#include <intuition/IntuitionBase.h>
#include <proto/intuition.h>
#include <clib/intuition_protos.h>

#include <libraries/gadtools.h>
#include <proto/gadtools.h>
#include <clib/gadtools_protos.h>

#include "Wacom.h"             /* here is all the Wacomdata defined */

/* global Variables ****/
/* external */
extern struct ExecBase           *SysBase;

/* local */
struct IntuitionBase             *IntuitionBase;
struct Library                   *GadToolsBase;

/* Strings for output */
char *ITexts[]=
{
 "Sync             = %d",
 "Driver_running   = %d",
 "Wacom_Series     = %d",
 "Beeper           = %d",
 "Mode             = %d",
 "MB_Emu           = %d",
 "Pressure_Limit   = %03d",
 "Pressure         = %04d",
 "input_device     = %d",
 "Buttons          = %02d",
 "Tablett_Max_X    = %06ld",
 "Tablett_Max_Y    = %06ld",
 "Tablett_X        = %06ld",
 "Tablett_Y        = %06ld",
 "Set_Mouse        = %d",
 "Commandset       = %d",
 "Multi_Mode       = %d",
 "Multi_Mouse      = %d",
 "Macrokey         = %02d",
 "MM_Dig_Buttons   = %02d",
 "MM_Dig_X         = %06ld",
 "MM_Dig_Y         = %06ld",
 "Proximity        = %d",
 "MM_Dig_Proximity = %d",
 "Min_Pressure     = %d",
 "Max_Pressure     = %d",
 "Tilt_X           = %04d",
 "Tilt_Y           = %04d"
};

/* Menudefinition */
struct NewMenu APINewMenu[] =
{
 NM_TITLE, "Commands", NULL, 0                 , NULL, NULL,
  NM_ITEM, "Pause"   , NULL, CHECKIT|MENUTOGGLE, 0L,   NULL,
   NM_END, NULL      , NULL, 0                 , 0L,   NULL
};

struct TextAttr DefFont={(STRPTR)"topaz.font",TOPAZ_EIGHTY,FS_NORMAL     ,FPF_ROMFONT};
struct IntuiText IText={1,0,JAM2,0,0,&DefFont, NULL,NULL};

/* Version-Tag ***************************/
UBYTE *vers="$VER:ActiveAPIDemo 1.1 "__AMIGADATE__" by Roland Schwingel.";

/* Prototypes **********/
int                   main(void);

/***********************************************************************/
/* main()                                                              */
/***********************************************************************/
int main (void)
{
int                         retval=21;
struct MsgPort             *Wacom_data_Port;      /* This is the way where we get the Data */
struct MsgPort             *Our_Port;
struct WacomMSG             WCommandMess,WDataMess;
struct WacomMSG            *WMess;
struct Window              *Win;
struct RastPort            *WinRP;
struct IntuiMessage        *IMess;
struct Menu                *APIMenu;
struct MenuItem            *mitem;
APTR                        Visinfo;
int                         offy;
BOOL                        cont=TRUE,Unregister_API=TRUE;
ULONG                       code,class,Sigrcvd,Sigmask,WinSig,PortSig;
char                        buffer[80];

 /* First clear WMess */
 memset(&WCommandMess,0,sizeof(struct WacomMSG));

 /* Now check if our MsgPort is here - means if Wacom Driver program is running */
 if(Wacom_data_Port=FindPort(WACOM_PORT_NAME))
 {
  /* Now open intution.library */
  if(IntuitionBase=(struct IntuitionBase *)OpenLibrary("intuition.library",37L))
  {
   /* Get Offset for Textprinting */
   offy=IntuitionBase->ActiveScreen->RastPort.TxHeight+
	IntuitionBase->ActiveScreen->WBorTop +2;

   /* Open Gadtools for menu access */
   if(GadToolsBase=OpenLibrary("gadtools.library",37L))
   {
    /* Create VisualInfo */
    if(Visinfo=GetVisualInfo(IntuitionBase->ActiveScreen,TAG_DONE))
    {
     /* open the Window */
     if(Win=OpenWindowTags(NULL,WA_Left,0,WA_Top,offy,WA_Width,226,WA_Height,28*9+offy+IntuitionBase->ActiveScreen->WBorBottom,
				WA_IDCMP,  IDCMP_CLOSEWINDOW|IDCMP_MENUPICK,
				WA_Flags,  WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE,
				WA_Title,  "ActiveAPIDemo", TAG_DONE))
     {
      /* Get the Rastport and the Sigbit of the Window */
      WinRP=Win->RPort;
      WinSig=1L<<Win->UserPort->mp_SigBit;

      /* Generate Menu */
      if(APIMenu=CreateMenus(APINewMenu,TAG_END))
      {
       /* Layout Menu */
       if(LayoutMenus(APIMenu,Visinfo,TAG_END))
       {
	/* Add Menu to Window */
	if(SetMenuStrip(Win,APIMenu))
	{
	 /* Install our MessagePort */
	 if(Our_Port=CreateMsgPort())
	 {
	  /* Get Port signal */
	  PortSig=1L<<Our_Port->mp_SigBit;

	  /* Set up the Message */
	  WCommandMess.Mess.mn_Node.ln_Type=NT_MESSAGE;
	  WCommandMess.Mess.mn_Length=sizeof(struct WacomMSG);
	  WCommandMess.Mess.mn_ReplyPort=Our_Port;

	  /* Set up Startcommand */
	  WCommandMess.Command=WCMD_START_ACTIVE;              /* The magic word */
	  WCommandMess.Param=WACFLG_ALLOWSCREENEVENTS;         /* Normal Eventhandling */
	  WCommandMess.AppScreen=IntuitionBase->ActiveScreen;  /* Pointer to our Screen */
							       /* So we only get Events */
							       /* which occured on our screen */

	  PutMsg(Wacom_data_Port,(struct Message *)&WCommandMess);

	  /* Wait for Reply */
	  WaitPort(Our_Port);

	  /* Get response from driver */
	  GetMsg(Our_Port);

	  if(WCommandMess.Command==WCMD_OK)
	  {
	   IText.IText=buffer;                        /* Pointer to Text */
	   Sigmask=WinSig|PortSig|SIGBREAKF_CTRL_C;   /* Signal Maks */

	   /* Loop until it's over */
	   while(cont)
	   {
	    /* Wait for Window or CTRL-C Event */
	    Sigrcvd=Wait(Sigmask);

	    /* Check CTRL-C */
	    if(Sigrcvd & SIGBREAKF_CTRL_C)
	     cont=FALSE;

	    /* Check Message from Driver */
	    if(Sigrcvd & PortSig)
	    {
	     /* Print all inquired Data */
	     while(WMess=(struct WacomMSG *)GetMsg(Our_Port))
	     {
	      /* Copy Message */
	      /* Reply as soon as possible AND DON'T WRITE TO THE MESSAGE YOU GET */
	      CopyMem(WMess,&WDataMess,sizeof(struct WacomMSG));
	      ReplyMsg((struct Message *)WMess);     /* Reply immediately */

	      switch(WDataMess.Command)
	      {
	       case WCMD_MSG:           /* Message from Driver */
					switch(WDataMess.Param)
					{
					 case WACMSG_DRIVER_DEACTIVE:  /* Driver was deactivated */
								       SetWindowTitles(Win,"Driver is deactivated !",(UBYTE *)-1);
								       break;

					 case WACMSG_DRIVER_ACTIVE:    /* Driver was (re)activated */
								       SetWindowTitles(Win,"Driver has reactivated !",(UBYTE *)-1);
								       Delay(25);
								       SetWindowTitles(Win,"ActiveAPIDemo",(UBYTE *)-1);
								       break;

					 case WACMSG_DRIVER_QUIT:      /* Driver quits now !! */
								       /* Client application mustn't unregister ! */
								       printf("Driver quits right now !!\nDemo exits too.\n");
								       cont=FALSE;
								       Unregister_API=FALSE;
								       break;
					}
					break;

	       case WCMD_ERROR:         /* Error */
					printf("Driver reported an Error !!\n");
					break;

	       case WCMD_DATA_TRANS:    /* We got a datapackage from the tablet */
					/* now print it in the window */
					sprintf(buffer,ITexts[0],WDataMess.WacomInfo.Sync);
					PrintIText(WinRP,&IText,10,(long)offy);

					sprintf(buffer,ITexts[1],WDataMess.WacomInfo.Driver_running);
					PrintIText(WinRP,&IText,10,(long)offy+9);

					sprintf(buffer,ITexts[2],WDataMess.WacomInfo.Wacom_Series);
					PrintIText(WinRP,&IText,10,(long)offy+2*9);

					sprintf(buffer,ITexts[3],WDataMess.WacomInfo.Beeper);
					PrintIText(WinRP,&IText,10,(long)offy+3*9);

					sprintf(buffer,ITexts[4],WDataMess.WacomInfo.Mode);
					PrintIText(WinRP,&IText,10,(long)offy+4*9);

					sprintf(buffer,ITexts[5],WDataMess.WacomInfo.MB_Emu);
					PrintIText(WinRP,&IText,10,(long)offy+5*9);

					sprintf(buffer,ITexts[6],WDataMess.WacomInfo.Pressure_Limit);
					PrintIText(WinRP,&IText,10,(long)offy+6*9);

					sprintf(buffer,ITexts[7],WDataMess.WacomInfo.Pressure);
					PrintIText(WinRP,&IText,10,(long)offy+7*9);

					sprintf(buffer,ITexts[8],WDataMess.WacomInfo.input_device);
					PrintIText(WinRP,&IText,10,(long)offy+8*9);

					sprintf(buffer,ITexts[9],WDataMess.WacomInfo.Buttons);
					PrintIText(WinRP,&IText,10,(long)offy+9*9);

					sprintf(buffer,ITexts[10],WDataMess.WacomInfo.Tablett_Max_X);
					PrintIText(WinRP,&IText,10,(long)offy+10*9);

					sprintf(buffer,ITexts[11],WDataMess.WacomInfo.Tablett_Max_Y);
					PrintIText(WinRP,&IText,10,(long)offy+11*9);

					sprintf(buffer,ITexts[12],WDataMess.WacomInfo.Tablett_X);
					PrintIText(WinRP,&IText,10,(long)offy+12*9);

					sprintf(buffer,ITexts[13],WDataMess.WacomInfo.Tablett_Y);
					PrintIText(WinRP,&IText,10,(long)offy+13*9);

					sprintf(buffer,ITexts[14],WDataMess.WacomInfo.Set_Mouse);
					PrintIText(WinRP,&IText,10,(long)offy+14*9);

					sprintf(buffer,ITexts[15],WDataMess.WacomInfo.Commandset);
					PrintIText(WinRP,&IText,10,(long)offy+15*9);

					sprintf(buffer,ITexts[16],WDataMess.WacomInfo.Multi_Mode);
					PrintIText(WinRP,&IText,10,(long)offy+16*9);

					sprintf(buffer,ITexts[17],WDataMess.WacomInfo.Multi_Mouse);
					PrintIText(WinRP,&IText,10,(long)offy+17*9);

					sprintf(buffer,ITexts[18],WDataMess.WacomInfo.Macrokey);
					PrintIText(WinRP,&IText,10,(long)offy+18*9);

					sprintf(buffer,ITexts[19],WDataMess.WacomInfo.MM_Dig_Buttons);
					PrintIText(WinRP,&IText,10,(long)offy+19*9);

					sprintf(buffer,ITexts[20],WDataMess.WacomInfo.MM_Dig_X);
					PrintIText(WinRP,&IText,10,(long)offy+20*9);

					sprintf(buffer,ITexts[21],WDataMess.WacomInfo.MM_Dig_Y);
					PrintIText(WinRP,&IText,10,(long)offy+21*9);

					sprintf(buffer,ITexts[22],WDataMess.WacomInfo.Proximity);
					PrintIText(WinRP,&IText,10,(long)offy+22*9);

					sprintf(buffer,ITexts[23],WDataMess.WacomInfo.MM_Dig_Proximity);
					PrintIText(WinRP,&IText,10,(long)offy+23*9);

					sprintf(buffer,ITexts[24],WDataMess.WacomInfo.Min_Pressure);
					PrintIText(WinRP,&IText,10,(long)offy+24*9);

					sprintf(buffer,ITexts[25],WDataMess.WacomInfo.Max_Pressure);
					PrintIText(WinRP,&IText,10,(long)offy+25*9);

					sprintf(buffer,ITexts[26],WDataMess.WacomInfo.Tilt_X);
					PrintIText(WinRP,&IText,10,(long)offy+26*9);

					sprintf(buffer,ITexts[27],WDataMess.WacomInfo.Tilt_Y);
					PrintIText(WinRP,&IText,10,(long)offy+27*9);
					break;

	       default:                 /* Unspecified Package */
					break;

	      }
	     }
	    }

	    /* Check Event from Window */
	    if(Sigrcvd & WinSig)
	    {
	     while(IMess=(struct IntuiMessage *)GT_GetIMsg(Win->UserPort))
	     {
	      class=IMess->Class;
	      code=IMess->Code;
	      GT_ReplyIMsg(IMess);     /* Send Msg back to Intuition */

	      switch(class)
	      {
	       case IDCMP_CLOSEWINDOW:     /* Somebody pushed the Closebutton */
					   cont=FALSE;
					   retval=0;
					   break;

	       case IDCMP_MENUPICK:        /* Menu was selected from Window */
					   if(code != MENUNULL)
					   {
					    mitem=ItemAddress(APIMenu,code);
					    if(ITEMNUM(code)==0)
					    {
					     if(mitem->Flags & CHECKED)
					     {
					      /* command for pause API sending */
					      WCommandMess.Command=WCMD_PAUSE_ACTIVE;
					      SetWindowTitles(Win,"ActiveAPIDemo (paused)",(UBYTE *)-1);
					     }
					     else
					     {
					      /* API command for restarting sending */
					      WCommandMess.Command=WCMD_RESTART_ACTIVE;
					      SetWindowTitles(Win,"ActiveAPIDemo",(UBYTE *)-1);
					     }

					     /* Send Message to API */
					     /* Check if Port is still there */
					     /* Don't forget this */
					     if(FindPort(WACOM_PORT_NAME))
					     {
					      PutMsg(Wacom_data_Port,(struct Message *)&WCommandMess);

					      /* Wait for Reply */
					      WaitPort(Our_Port);

					      /* Get response from driver */
					      GetMsg(Our_Port);

					      if(WCommandMess.Command!=WCMD_OK)
					       printf("Error while pausing/restarting API sending!\n");
					     }
					     else
					     {
					      /* Something went wrong */
					      /* Have we trashed the QUIT Message ?? */
					      cont=FALSE;
					      Unregister_API=FALSE;
					      printf("Emergency Exit: Unable to send Commands to API!\n");
					     }
					    }
					   }
					   break;

	      }
	     }
	    }
	   }
	  }
	  else
	   printf("Error while attaching to active driver API !!\n");

	  if(Unregister_API) /* Unregister only when Driver is still running */
	  {
	   /* Set up Quitcommand */
	   WCommandMess.Command=WCMD_STOP_ACTIVE;               /* The magic word */
	   WCommandMess.Param=WACFLG_ALLOWSCREENEVENTS;         /* Normal Eventhandling */
	   WCommandMess.AppScreen=IntuitionBase->ActiveScreen;  /* Pointer to our Screen */

	   /* Check if Port is still there */
	   /* Don't forget this */
	   if(FindPort(WACOM_PORT_NAME))
	   {
	    PutMsg(Wacom_data_Port,(struct Message *)&WCommandMess);

	    /* Wait for Reply */
	    WaitPort(Our_Port);

	    /* Get response from driver */
	    GetMsg(Our_Port);

	    if(WCommandMess.Command != WCMD_OK)
	     printf("Error while unregistering from active driver API !!\n");
	   }
	   else
	    printf("Emergency Exit: Unable to Unregister from API !\n");
	  }

	  /* get rid of our port */
	  DeleteMsgPort(Our_Port);
	 }
	 else
	  printf("Unable to install a Message Port !!\n");

	 /* Remove Menu from Window */
	 ClearMenuStrip(Win);
	}
	else
	 printf("Can't attach Menu to Window !\n");

	/* Free menus */
	FreeMenus(APIMenu);
       }
       else
	printf("Error layouting menus !\n");
      }
      else
       printf("Can't create Menus !\n");

      /* Close Window */
      CloseWindow(Win);
     }
     else
      printf("Can't open Window !!\n");

     /* Release VisualInfo */
     FreeVisualInfo(Visinfo);
    }
    else
     printf("Can't create Visualinfot for gadtools !\n");

    /* Close Gadtools */
    CloseLibrary(GadToolsBase);
   }
   else
     printf("Unable to open gadtools.library V37+!!!\n");

   /* Close Intution */
   CloseLibrary((struct Library *)IntuitionBase);
  }
  else
   printf("Unable to open intuition.library V37+!!!\n");
 }
 else
  printf("Sorry... Can't find " WACOM_PORT_NAME "\n" );

 /* exit to Shell/WB */
 return(retval);
}

