/***********************************************************************/
/* Demoprogram for obtaining generic tabletdata from Intuition         */
/* ATTENTION !!! You need Kickstart 3.0 or better !                    */
/*                                                                     */
/* Prints some data which is provided by Intuition.                    */
/* (Coordiantes, Pressure etc.)                                        */
/***********************************************************************/

/***********************************************************************/
/* Written in 1994-1996 by:                                            */
/*                                                                     */
/* Roland Schwingel                                                    */
/* Lilienthalstrasse 9                                                 */
/* 92421 Schwandorf                                                    */
/* Germany                                                             */
/*                                                                     */
/* Email: roland.schwingel@extern.uni-regensburg.de                    */
/* Phone: +49-(0)9431-5779                                             */
/***********************************************************************/

/* INCLUDES ************/
#include <stdio.h>
#include <string.h>

#include <exec/exec.h>
#include <proto/exec.h>
#include <clib/exec_protos.h>

#include <intuition/intuition.h>
#include <intuition/IntuitionBase.h>
#include <proto/intuition.h>
#include <clib/intuition_protos.h>

#include <utility/utility.h>
#include <proto/utility.h>
#include <clib/utility_protos.h>

/* global Variables ****/
/* external */
extern struct ExecBase           *SysBase;

/* local */
struct IntuitionBase             *IntuitionBase;
struct Library                   *UtilityBase;
int                               offy;

char *ITexts[]=
{
 " mouse state ",
 "MouseX       = %06d",
 "MouseY       = %06d",
 "MouseButtons = ",
 " tablet state ",
 "td_TabletX   = ",
 "td_TabletY   = ",
 "td_RangeX    = ",
 "td_RangeY    = ",
 " tablet tags ",
 "Pressure     = ",
 "ButtonBits   = ",
 "InProximity  = ",
 "ResolutionX  = ",
 "ResolutionY  = ",
 "AngleX       = ",
 "AngleY       = "
};

struct TextAttr DefFont={(STRPTR)"topaz.font",TOPAZ_EIGHTY,FS_NORMAL     ,FPF_ROMFONT};
struct IntuiText IText={1,0,JAM2,0,0,&DefFont, NULL,NULL};
char buffer[80];

/* Version-Tag ***************************/
UBYTE *vers="$VER:AmigaOSTabletAPI 1.3 "__AMIGADATE__" by Roland Schwingel.";

/* Prototypes **********/
int      main(void);
void     showtexts(char *mousebuttons,struct RastPort *rp,struct ExtIntuiMessage *EIMess);

/***********************************************************************/
/* main()                                                              */
/***********************************************************************/
int main (void)
{
int                         retval=21;
struct Window              *Win;
struct RastPort            *WinRP;
struct ExtIntuiMessage     *EIMess;
BOOL                        cont=TRUE;
ULONG                       class,Sigrcvd;

 /* Now open intution.library */
 if(IntuitionBase=(struct IntuitionBase *)OpenLibrary("intuition.library",39L))
 {
  /* Get Offset for Textprinting */
  offy=IntuitionBase->ActiveScreen->RastPort.TxHeight+
       IntuitionBase->ActiveScreen->WBorTop +2;

  /* open utility.library for tag functions */
  if(UtilityBase=OpenLibrary("utility.library",39L))
  {
   /* pointer to Text */
   IText.IText=buffer;

   /* open the Window */
   if(Win=OpenWindowTags(NULL,WA_Left,0,WA_Top,offy,WA_Width,198,WA_Height,17*9+offy+IntuitionBase->ActiveScreen->WBorBottom,
			      WA_TabletMessages,TRUE,   /* <- This is the magic line which brings */
							/*    tabletdata to your window */
			      WA_ReportMouse,TRUE,
			      WA_IDCMP,  IDCMP_CLOSEWINDOW|IDCMP_MOUSEMOVE|IDCMP_MOUSEBUTTONS,
			      WA_Flags,  WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE,
			      WA_Title,  "V39 Tabletdata", TAG_DONE))
   {
    /* Get the Rastport */
    WinRP=Win->RPort;

    while(cont)
    {
     /* Wait for Window or CTRL-C Event */
     Sigrcvd=Wait(1L << Win->UserPort->mp_SigBit|SIGBREAKF_CTRL_C);
     {
      /* Check CTRL-C */
      if(Sigrcvd & SIGBREAKF_CTRL_C)
       cont=FALSE;

      /* Check Event from Window */
      if(Sigrcvd & 1L << Win->UserPort->mp_SigBit)
      {
       while(EIMess=(struct ExtIntuiMessage *)GetMsg(Win->UserPort))
       {
	class=EIMess->eim_IntuiMessage.Class;

	switch(class)
	{
	 case IDCMP_CLOSEWINDOW:     cont=FALSE;      /* Somebody pushed the Closebutton */
				     retval=0;
				     break;

	 case IDCMP_MOUSEBUTTONS:    switch(EIMess->eim_IntuiMessage.Code)
				     {
				      case SELECTDOWN: showtexts("LMBDOWN",WinRP,EIMess);
						       break;

				      case SELECTUP:   showtexts("LMBUP  ",WinRP,EIMess);
						       break;

				      case MIDDLEDOWN: showtexts("MMBDOWN",WinRP,EIMess);
						       break;

				      case MIDDLEUP:   showtexts("MMBUP  ",WinRP,EIMess);
						       break;

				      case MENUDOWN:   showtexts("RMBDOWN",WinRP,EIMess);
						       break;

				      case MENUUP:     showtexts("RMBUP  ",WinRP,EIMess);
						       break;
				     }
				     break;

	 case IDCMP_MOUSEMOVE:       showtexts("-------",WinRP,EIMess);
				     break;

	 default:                    break;
	}

	ReplyMsg((struct Message *)EIMess);     /* Send Msg back to Intuition */
       }
      }
     }
    }

    /* Close Window */
    CloseWindow(Win);
   }
   else
    printf("Can't open Window !!\n");

   /* Close Utility */
   CloseLibrary(UtilityBase);
  }
  else
   printf("Can't open utility.library V39+ !!!\n");

  /* Close Intution */
  CloseLibrary((struct Library *)IntuitionBase);
 }
 else
  printf("Unable to open intuition.library V39+ !!!\n");

 /* exit to Shell/WB */
 return(retval);
}

/***********************************************************************/
/* showtexts(): Prints Intuitexts into Window                          */
/***********************************************************************/
void showtexts(char *mousebuttons,struct RastPort *rp,struct ExtIntuiMessage *EIMess)
{
static struct TagItem *tag;

 strcpy(buffer,ITexts[0]);
 PrintIText(rp,&IText,10,(long)offy);

 sprintf(buffer,ITexts[1],EIMess->eim_IntuiMessage.MouseX);
 PrintIText(rp,&IText,10,(long)offy+9);

 sprintf(buffer,ITexts[2],EIMess->eim_IntuiMessage.MouseY);
 PrintIText(rp,&IText,10,(long)offy+2*9);

 strcpy(buffer,ITexts[3]);
 strcat(buffer,mousebuttons);
 PrintIText(rp,&IText,10,(long)offy+3*9);

 strcpy(buffer,ITexts[4]);
 PrintIText(rp,&IText,10,(long)offy+4*9);

 if(EIMess->eim_TabletData)
 {
  /* Show only if available (don't check these fields under pre-V39 !) */
  sprintf(buffer,"%s%06ld",ITexts[5],EIMess->eim_TabletData->td_TabletX);
  PrintIText(rp,&IText,10,(long)offy+5*9);

  sprintf(buffer,"%s%06ld",ITexts[6],EIMess->eim_TabletData->td_TabletY);
  PrintIText(rp,&IText,10,(long)offy+6*9);

  sprintf(buffer,"%s%06ld",ITexts[7],EIMess->eim_TabletData->td_RangeX);
  PrintIText(rp,&IText,10,(long)offy+7*9);

  sprintf(buffer,"%s%06ld",ITexts[8],EIMess->eim_TabletData->td_RangeY);
  PrintIText(rp,&IText,10,(long)offy+8*9);

  strcpy(buffer,ITexts[9]);
  PrintIText(rp,&IText,10,(long)offy+9*9);

  if(EIMess->eim_TabletData->td_TagList)
  {
   if(tag=FindTagItem(TABLETA_Pressure,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%06ld",ITexts[10],(LONG)tag->ti_Data);
   else
    sprintf(buffer,"%s------",ITexts[10]);
   PrintIText(rp,&IText,10,(long)offy+10*9);

   if(tag=FindTagItem(TABLETA_ButtonBits,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%06ld",ITexts[11],(LONG)tag->ti_Data);
   else
    sprintf(buffer,"%s------",ITexts[11]);
   PrintIText(rp,&IText,10,(long)offy+11*9);

   if(tag=FindTagItem(TABLETA_InProximity,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%d",ITexts[12],(BOOL)tag->ti_Data);
   else
    sprintf(buffer,"%s-",ITexts[12]);
   PrintIText(rp,&IText,10,(long)offy+12*9);

   if(tag=FindTagItem(TABLETA_ResolutionX,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%06ld",ITexts[13],(LONG)tag->ti_Data);
   else
    sprintf(buffer,"%s------",ITexts[13]);
   PrintIText(rp,&IText,10,(long)offy+13*9);

   if(tag=FindTagItem(TABLETA_ResolutionY,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%06ld",ITexts[14],(LONG)tag->ti_Data);
   else
    sprintf(buffer,"%s------",ITexts[14]);
   PrintIText(rp,&IText,10,(long)offy+14*9);

   if(tag=FindTagItem(TABLETA_AngleX,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%06ld",ITexts[15],(LONG)tag->ti_Data);
   else
    sprintf(buffer,"%s------",ITexts[15]);
   PrintIText(rp,&IText,10,(long)offy+15*9);

   if(tag=FindTagItem(TABLETA_AngleY,EIMess->eim_TabletData->td_TagList))
    sprintf(buffer,"%s%06ld",ITexts[16],(LONG)tag->ti_Data);
   else
    sprintf(buffer,"%s------",ITexts[16]);
   PrintIText(rp,&IText,10,(long)offy+16*9);
  }
  else
  {
   /* no tags */
   sprintf(buffer,"%s------",ITexts[10]);
   PrintIText(rp,&IText,10,(long)offy+10*9);

   sprintf(buffer,"%s------",ITexts[11]);
   PrintIText(rp,&IText,10,(long)offy+11*9);

   sprintf(buffer,"%s-",ITexts[12]);
   PrintIText(rp,&IText,10,(long)offy+12*9);

   sprintf(buffer,"%s------",ITexts[13]);
   PrintIText(rp,&IText,10,(long)offy+13*9);

   sprintf(buffer,"%s------",ITexts[14]);
   PrintIText(rp,&IText,10,(long)offy+14*9);

   sprintf(buffer,"%s------",ITexts[15]);
   PrintIText(rp,&IText,10,(long)offy+15*9);

   sprintf(buffer,"%s------",ITexts[16]);
   PrintIText(rp,&IText,10,(long)offy+16*9);
  }
 }
 else
 {
  sprintf(buffer,"%s------",ITexts[5]);
  PrintIText(rp,&IText,10,(long)offy+5*9);

  sprintf(buffer,"%s------",ITexts[6]);
  PrintIText(rp,&IText,10,(long)offy+6*9);

  sprintf(buffer,"%s------",ITexts[7]);
  PrintIText(rp,&IText,10,(long)offy+7*9);

  sprintf(buffer,"%s------",ITexts[8]);
  PrintIText(rp,&IText,10,(long)offy+8*9);

  strcpy(buffer,ITexts[9]);
  PrintIText(rp,&IText,10,(long)offy+9*9);

  sprintf(buffer,"%s------",ITexts[10]);
  PrintIText(rp,&IText,10,(long)offy+10*9);

  sprintf(buffer,"%s------",ITexts[11]);
  PrintIText(rp,&IText,10,(long)offy+11*9);

  sprintf(buffer,"%s-",ITexts[12]);
  PrintIText(rp,&IText,10,(long)offy+12*9);

  sprintf(buffer,"%s------",ITexts[13]);
  PrintIText(rp,&IText,10,(long)offy+13*9);

  sprintf(buffer,"%s------",ITexts[14]);
  PrintIText(rp,&IText,10,(long)offy+14*9);

  sprintf(buffer,"%s------",ITexts[15]);
  PrintIText(rp,&IText,10,(long)offy+15*9);

  sprintf(buffer,"%s------",ITexts[16]);
  PrintIText(rp,&IText,10,(long)offy+16*9);
 }
}

