/***********************************************************************/
/* WACOM-Digitizer Driver            (C) 1993-1996 by ROLAND SCHWINGEL */
/***********************************************************************/
/* Demoprogram for obtaining (pressure) data from the driver.          */
/*                                                                     */
/* Prints all data which is provided by the driver in a Window         */
/* (only if Window is activated)                                       */
/***********************************************************************/

/* INCLUDES ************/
#include <stdio.h>
#include <string.h>

#include <exec/exec.h>
#include <proto/exec.h>
#include <clib/exec_protos.h>

#include <intuition/intuition.h>
#include <intuition/IntuitionBase.h>
#include <proto/intuition.h>
#include <clib/intuition_protos.h>

#include "Wacom.h"             /* here is all the Wacomdata defined */

/* global Variables ****/
/* external */
extern struct ExecBase           *SysBase;

/* local */
struct IntuitionBase             *IntuitionBase;

char *ITexts[]=
{
 "Sync             = %d",
 "Driver_running   = %d",
 "Wacom_Series     = %d",
 "Beeper           = %d",
 "Mode             = %d",
 "MB_Emu           = %d",
 "Pressure_Limit   = %03d",
 "Pressure         = %04d",
 "input_device     = %d",
 "Buttons          = %02d",
 "Tablett_Max_X    = %06ld",
 "Tablett_Max_Y    = %06ld",
 "Tablett_X        = %06ld",
 "Tablett_Y        = %06ld",
 "Set_Mouse        = %d",
 "Commandset       = %d",
 "Multi_Mode       = %d",
 "Multi_Mouse      = %d",
 "Macrokey         = %02d",
 "MM_Dig_Buttons   = %02d",
 "MM_Dig_X         = %06ld",
 "MM_Dig_Y         = %06ld",
 "Proximity        = %d",
 "MM_Dig_Proximity = %d",
 "Min_Pressure     = %d",
 "Max_Pressure     = %d",
 "Tilt_X           = %04d",
 "Tilt_Y           = %04d"
};

struct TextAttr DefFont={(STRPTR)"topaz.font",TOPAZ_EIGHTY,FS_NORMAL     ,FPF_ROMFONT};
struct IntuiText IText={1,0,JAM2,0,0,&DefFont, NULL,NULL};

/* Version-Tag ***************************/
UBYTE *vers="$VER:PassiveAPIDemo 1.6 "__AMIGADATE__" by Roland Schwingel.";

/* Prototypes **********/
int                   main(void);

/***********************************************************************/
/* main()                                                              */
/***********************************************************************/
int main (void)
{
int                         retval=21;
struct MsgPort             *Wacom_data_Port;      /* This is the way where we get the Data */
struct MsgPort             *Our_Port;
struct WacomMSG             WMess;
struct Window              *Win;
struct RastPort            *WinRP;
struct IntuiMessage        *IMess;
int                         offy;
BOOL                        cont=TRUE;
ULONG                       class,Sigrcvd;
char                        buffer[80];

 /* First clear WMess */
 memset(&WMess,0,sizeof(struct WacomMSG));

 /* Now check if our MsgPort is here - means if Wacom Driver program is running */
 if(FindPort(WACOM_PORT_NAME))
 {
  /* Now open intution.library */
  if(IntuitionBase=(struct IntuitionBase *)OpenLibrary("intuition.library",37L))
  {
   /* Get Offset for Textprinting */
   offy=IntuitionBase->ActiveScreen->RastPort.TxHeight+
	IntuitionBase->ActiveScreen->WBorTop +2;

   /* open the Window */
   if(Win=OpenWindowTags(NULL,WA_Left,0,WA_Top,offy,WA_Width,226,WA_Height,28*9+offy+IntuitionBase->ActiveScreen->WBorBottom,
			      WA_IDCMP,  IDCMP_CLOSEWINDOW|IDCMP_INTUITICKS,
			      WA_Flags,  WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE,
			      WA_Title,  "PassiveAPIDemo", TAG_DONE))
   {
    /* Get the Rastport */
    WinRP=Win->RPort;

    /* Install our MessagePort */
    if(Our_Port=CreateMsgPort())
    {
     /* Set up the Message */
     WMess.Mess.mn_Node.ln_Type=NT_MESSAGE;
     WMess.Mess.mn_Length=sizeof(struct WacomMSG);
     WMess.Mess.mn_ReplyPort=Our_Port;

     /* Set up Command */
     WMess.Command=WCMD_POLL_PASSIVE;              /* The magic word */
     WMess.Param=WACFLG_ALLOWSCREENEVENTS;         /* Normaly not necessary */
     WMess.AppScreen=IntuitionBase->ActiveScreen;  /* with passive API */

     IText.IText=buffer;         /* Pointer to Text */
     while(cont)
     {
      /* Wait for Window or CTRL-C Event */
      Sigrcvd=Wait(1L << Win->UserPort->mp_SigBit|SIGBREAKF_CTRL_C);

      /* Check CTRL-C */
      if(Sigrcvd & SIGBREAKF_CTRL_C)
       cont=FALSE;

      /* Check Event from Window */
      if(Sigrcvd & 1L << Win->UserPort->mp_SigBit)
      {
       while(IMess=(struct IntuiMessage *)GetMsg(Win->UserPort))
       {
	class=IMess->Class;
	ReplyMsg((struct Message *)IMess);     /* Send Msg back to Intuition */

	switch(class)
	{
	 case IDCMP_CLOSEWINDOW:     cont=FALSE;      /* Somebody pushed the Closebutton */
				     retval=0;
				     break;

	 case IDCMP_INTUITICKS:      /* This is only a Demo Programm in YOUR Programm you shouldn't use
					INTUITICKS to read the Wacom Infos. */

				     /* Send Request for Data */
				     /* and make sure that Port is still here */
				     Wacom_data_Port=FindPort(WACOM_PORT_NAME);
				     if(Wacom_data_Port)
				     {
				      PutMsg(Wacom_data_Port,(struct Message *)&WMess);

				      /* Wait for Reply */
				      WaitPort(Our_Port);

				      /* Print all inquired Data */
				      if(GetMsg(Our_Port))
				      {
				       /* Wacom_Driver writes its response directly into WMess */
				       sprintf(buffer,ITexts[0],WMess.WacomInfo.Sync);
				       PrintIText(WinRP,&IText,10,(long)offy);

				       sprintf(buffer,ITexts[1],WMess.WacomInfo.Driver_running);
				       PrintIText(WinRP,&IText,10,(long)offy+9);

				       sprintf(buffer,ITexts[2],WMess.WacomInfo.Wacom_Series);
				       PrintIText(WinRP,&IText,10,(long)offy+2*9);

				       sprintf(buffer,ITexts[3],WMess.WacomInfo.Beeper);
				       PrintIText(WinRP,&IText,10,(long)offy+3*9);

				       sprintf(buffer,ITexts[4],WMess.WacomInfo.Mode);
				       PrintIText(WinRP,&IText,10,(long)offy+4*9);

				       sprintf(buffer,ITexts[5],WMess.WacomInfo.MB_Emu);
				       PrintIText(WinRP,&IText,10,(long)offy+5*9);

				       sprintf(buffer,ITexts[6],WMess.WacomInfo.Pressure_Limit);
				       PrintIText(WinRP,&IText,10,(long)offy+6*9);

				       sprintf(buffer,ITexts[7],WMess.WacomInfo.Pressure);
				       PrintIText(WinRP,&IText,10,(long)offy+7*9);

				       sprintf(buffer,ITexts[8],WMess.WacomInfo.input_device);
				       PrintIText(WinRP,&IText,10,(long)offy+8*9);

				       sprintf(buffer,ITexts[9],WMess.WacomInfo.Buttons);
				       PrintIText(WinRP,&IText,10,(long)offy+9*9);

				       sprintf(buffer,ITexts[10],WMess.WacomInfo.Tablett_Max_X);
				       PrintIText(WinRP,&IText,10,(long)offy+10*9);

				       sprintf(buffer,ITexts[11],WMess.WacomInfo.Tablett_Max_Y);
				       PrintIText(WinRP,&IText,10,(long)offy+11*9);

				       sprintf(buffer,ITexts[12],WMess.WacomInfo.Tablett_X);
				       PrintIText(WinRP,&IText,10,(long)offy+12*9);

				       sprintf(buffer,ITexts[13],WMess.WacomInfo.Tablett_Y);
				       PrintIText(WinRP,&IText,10,(long)offy+13*9);

				       sprintf(buffer,ITexts[14],WMess.WacomInfo.Set_Mouse);
				       PrintIText(WinRP,&IText,10,(long)offy+14*9);

				       sprintf(buffer,ITexts[15],WMess.WacomInfo.Commandset);
				       PrintIText(WinRP,&IText,10,(long)offy+15*9);

				       sprintf(buffer,ITexts[16],WMess.WacomInfo.Multi_Mode);
				       PrintIText(WinRP,&IText,10,(long)offy+16*9);

				       sprintf(buffer,ITexts[17],WMess.WacomInfo.Multi_Mouse);
				       PrintIText(WinRP,&IText,10,(long)offy+17*9);

				       sprintf(buffer,ITexts[18],WMess.WacomInfo.Macrokey);
				       PrintIText(WinRP,&IText,10,(long)offy+18*9);

				       sprintf(buffer,ITexts[19],WMess.WacomInfo.MM_Dig_Buttons);
				       PrintIText(WinRP,&IText,10,(long)offy+19*9);

				       sprintf(buffer,ITexts[20],WMess.WacomInfo.MM_Dig_X);
				       PrintIText(WinRP,&IText,10,(long)offy+20*9);

				       sprintf(buffer,ITexts[21],WMess.WacomInfo.MM_Dig_Y);
				       PrintIText(WinRP,&IText,10,(long)offy+21*9);

				       sprintf(buffer,ITexts[22],WMess.WacomInfo.Proximity);
				       PrintIText(WinRP,&IText,10,(long)offy+22*9);

				       sprintf(buffer,ITexts[23],WMess.WacomInfo.MM_Dig_Proximity);
				       PrintIText(WinRP,&IText,10,(long)offy+23*9);

				       sprintf(buffer,ITexts[24],WMess.WacomInfo.Min_Pressure);
				       PrintIText(WinRP,&IText,10,(long)offy+24*9);

				       sprintf(buffer,ITexts[25],WMess.WacomInfo.Max_Pressure);
				       PrintIText(WinRP,&IText,10,(long)offy+25*9);

				       sprintf(buffer,ITexts[26],WMess.WacomInfo.Tilt_X);
				       PrintIText(WinRP,&IText,10,(long)offy+26*9);

				       sprintf(buffer,ITexts[27],WMess.WacomInfo.Tilt_Y);
				       PrintIText(WinRP,&IText,10,(long)offy+27*9);
				      }
				     }
				     break;

	}
       }
      }
     }

     /* get rid of our port */
     DeleteMsgPort(Our_Port);
    }
    else
     printf("Unable to install a Message Port !!\n");

    /* Close Window */
    CloseWindow(Win);
   }
   else
    printf("Can't open Window !!\n");

   /* Close Intution */
   CloseLibrary((struct Library *)IntuitionBase);
  }
  else
   printf("Unable to open intuition.library V37+!!!\n");
 }
 else
  printf("Sorry... Can't find " WACOM_PORT_NAME "\n" );

 /* exit to Shell/WB */
 return(retval);
}

