/***********************************************************************/
/* WACOM Digitizerdriver             (C) 1993-1996 by ROLAND SCHWINGEL */
/***********************************************************************/
/* Headerfile for receiving tabletdata from the driver                 */
/* Revision 2.0                                                        */
/***********************************************************************/

/* DEFINES *******************************/
#define WACOM_PORT_NAME       "Wacom DataPort" /* Name of the DataPort */

/* The NO_PRESS define is for compatibility reasons to older versions */
/* Use the Proximity field instead with driverversion 1.12 and up ! */
#define NO_PRESS              -64;             /* No valid Pressure */

/* Available Commands for sending to the driver */
#define WCMD_POLL_PASSIVE     0    /* Passive API Request */
#define WCMD_START_ACTIVE     1    /* Start active API */
#define WCMD_STOP_ACTIVE      2    /* Stop Message stream of active API */
#define WCMD_PAUSE_ACTIVE     3    /* Pause sending of active API */
#define WCMD_RESTART_ACTIVE   4    /* Resume sening after WCMD_PAUSE_ACTIVE */

/* the following defines can be found in the command field of WacomMSG */
/* when _RECEIVING_ a message from the driver! Do not set by hand ! */
/* Only valid with active API ! */
#define WCMD_ERROR            5    /* Something went wrong. */
				   /* Check Param field for informations */
#define WCMD_MSG              6    /* Also check Param field now! */
#define WCMD_OK              42    /* Everything went ok */
#define WCMD_DATA_TRANS      99    /* A Data Package from the driver. */
				   /* Do not set by hand ! */

/* Possible values for Param field */
#define WACFLG_ALLOWSCREENEVENTS  0 /* Allow Tabletevents for your screen */
				    /* Use only with WCMD_START_ACTIVE */
#define WACFLG_FORBIDSCREENEVENTS 1 /* No Eventposting for your screen */
				    /* Use only with WCMD_START_ACTIVE */
#define WACERR_REPLY_UNDERFLOW    2 /* To few Replymessages received ! */
#define WACERR_API_INSTALL        3 /* Error adding client to active API */
#define WACERR_API_UNINSTALL      4 /* Error removing client from active API */
#define WACERR_INVALID_COMMAND    5 /* Invalid command was sent to API */
#define WACMSG_DRIVER_DEACTIVE    6 /* Driver was deactivated */
#define WACMSG_DRIVER_ACTIVE      7 /* Driver was reactivated */
#define WACMSG_DRIVER_QUIT        8 /* Driver quits NOW ! */

/* Structures ****************************/
struct Wacom
{
 UBYTE        Sync;            /* Synchronisation with subprocess */
			       /* (internal must be 0)*/
 UBYTE        Driver_running;  /* Driver active or not */
			       /* 0 = inactive */
			       /* 1 = active */
 UBYTE        Wacom_Series;    /* 0 = SD-Series */
			       /* 1 = UD/KT-Series */
 UBYTE        Beeper;          /* State of the Beeper */
			       /* 0 = off */
			       /* 1 = on */
 UBYTE        Mode;            /* Pressure or "normal" Mode */
			       /* 0 = normal */
			       /* 1 = pressure */
 UBYTE        MB_Emu;          /* Mousebuttonemulation in Pressure Mode */
			       /* 0 = inactive */
			       /* 1 = active */
 int          Pressure_Limit;  /* Limit for LMB-Emulation (-30 ... 30) */
 WORD         Pressure;        /* current Pressure when in Pressure Mode */
			       /* WacomII-S: -30 ...  30 */
			       /* WacomIV:   -60 ...  60 */
			       /*           -128 ... 127 (Rom 1.2 and up) */
 UBYTE        input_device;    /* Type of current Stylus/Digitzer */
			       /* 1 = standard Stylus */
			       /* 2 = pressure Stylus */
			       /* 4 = Digitizer */
 UBYTE        Buttons;         /* State of the current input_device Buttons */
			       /* Standard Stylus:  1 = Frontbutton */
			       /*                   2 = Sidebutton */
			       /*                   3 = both */
			       /* Digitizer:        1 = middle Button top */
			       /*                   2 = left Button */
			       /*                   3 = middle Button bottom */
			       /*                   4 = right Button */
 ULONG        Tablett_Max_X;   /* Maximum X-Value on the Digitizer */
 ULONG        Tablett_Max_Y;   /* Maximum Y-Value on the Digitizer */
 long         Tablett_X;       /* current X-Coordinate */
			       /* when in WacomIV and Multimode: */
			       /* X-Coordinate of the pen */
 long         Tablett_Y;       /* current Y-Coordinate */
			       /* when in WacomIV and Multimode: */
			       /* Y-Coordinate of the pen */

 /* Additions: 10.02.1994 */
 UBYTE        Set_Mouse;       /* Mouseemulation */
			       /* 0 = off */
			       /* 1 = Mousepointer and Buttons */
			       /* 2 = only Mousepointer */
 UBYTE        Commandset;      /* Commandset actually used */
			       /* 0 = Wacom IV */
			       /* 1 = Wacom II-S */
 UBYTE        Multi_Mode;      /* Multimode on/off (only Wacom IV) */
			       /* 0 = off */
			       /* 1 = on */
 UBYTE        Multi_Mouse;     /* inputdevice used as mouse when in */
			       /* Multi_Mode (only WacomIV) */
			       /* 0 = pen */
			       /* 1 = Digitizer */
 UBYTE        Macrokey;        /* pressed Macrobutton (only Wacom IV) */
 UBYTE        MM_Dig_Buttons;  /* pressed cursorbuttons in Multimode */
			       /* (only Wacom IV) */
 ULONG        MM_Dig_X;        /* X-Coordinate of the cursor in Multimode */
			       /* (only Wacom IV) */
 ULONG        MM_Dig_Y;        /* Y-Coordinate of the cursor in Multimode */
			       /* (only Wacom IV) */

 /* Additions: 20.03.1994 */
 UBYTE        Proximity;       /* shows proximitiy of the pointing device */
			       /* 0 = not in proximity*/
			       /* 1 = in proximity */

 UBYTE        MM_Dig_Proximity;/* shows digitizers proximity in multimode */
			       /* 0 = not in proximity */
			       /* 1 = in proximity */

 /* Additions: 27.12.1994 */
 WORD         Min_Pressure;    /* Bottom limit of pressure */
 WORD         Max_Pressure;    /* top limit of pressure */

 /* Additions: 13.01.1996 */
 WORD         Tilt_X;          /* Tilt of stylus on X axis -64 ... +63 */
 WORD         Tilt_Y;          /* Tilt of stylus on Y axis -64 ... +63 */
			       /* These two are only valid when stylus is */
			       /* in use ! */

 UBYTE        reserved[104];   /* for future Expansions */
};


/* Message Structure for getting the above for use with PutMsg() */
struct WacomMSG
{
 struct Message    Mess;
 struct Wacom      WacomInfo;
 ULONG             Command;       /* Command for API */
 ULONG             Param;         /* Parameters for the API command */
 struct Screen    *AppScreen;     /* The screen of the client Application */
 UBYTE             reserved[20];  /* For future Expansions */
};
