unit TrayDemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, ExtCtrls, Buttons, PGBase, PGTray95;

type
  TTrayIconDemoForm = class(TForm)
    ShowIconButton: TButton;
    HideIconButton: TButton;
    BrowseButton: TButton;
    BrowseForIconDialog: TOpenDialog;
    NotepadIcon: TPGTrayIcon95;
    Label7: TLabel;
    NotepadPopupMenu: TPopupMenu;
    Autoexecbat: TMenuItem;
    Configsys: TMenuItem;
    Exit2: TMenuItem;
    N2: TMenuItem;
    ShowHintLabel: TLabel;
    ShowHintCheckbox: TCheckBox;
    AutoPopupCheckbox: TCheckBox;
    AutoPopupLabel: TLabel;
    HintEdit: TEdit;
    Label4: TLabel;
    BrowseIcon: TImage;
    About1: TMenuItem;
    Registration1: TMenuItem;
    N1: TMenuItem;
    MoreInformation1: TMenuItem;
    procedure ShowIconButtonClick(Sender: TObject);
    procedure HintEditChange(Sender: TObject);
    procedure BrowseButtonClick(Sender: TObject);
    procedure HideIconButtonClick(Sender: TObject);
    procedure NotepadIconDblClick(Sender: TObject);
    procedure AutoexecBatClick(Sender: TObject);
    procedure ConfigSysClick(Sender: TObject);
    procedure RegisterNowButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure AutoPopupCheckboxClick(Sender: TObject);
    procedure ShowHintCheckboxClick(Sender: TObject);
    procedure AutoPopupLabelClick(Sender: TObject);
    procedure ShowHintLabelClick(Sender: TObject);
    procedure NotepadIconClick(Sender: TObject);
  end;

var
  TrayIconDemoForm: TTrayIconDemoForm;

implementation

{$R *.DFM}

procedure TTrayIconDemoForm.ShowIconButtonClick(Sender: TObject);
begin
  { Show the icon in the Windows 95 Tray. }
  NotepadIcon.ShowIcon;
end;

procedure TTrayIconDemoForm.HideIconButtonClick(Sender: TObject);
begin
  { Hide the icon if it is currently showing, otherwise do nothing. }
  NotepadIcon.HideIcon;
end;

procedure TTrayIconDemoForm.BrowseButtonClick(Sender: TObject);
begin
  { Change the icon to the icon that the user selected in the browse dialog. }
  if BrowseForIconDialog.Execute then
    begin
    NotepadIcon.Icon.LoadFromFile(BrowseForIconDialog.Filename);
    BrowseIcon.Picture.LoadFromFile(BrowseForIconDialog.Filename);
    end;
end;

procedure TTrayIconDemoForm.AutoPopupCheckboxClick(Sender: TObject);
begin
  { Toggles displaying the Popup menu on right click on/off. }
  NotepadIcon.AutoPopup := AutoPopupCheckBox.Checked;
end;

procedure TTrayIconDemoForm.ShowHintCheckboxClick(Sender: TObject);
begin
  { Toggles displaying the icon's hint on/off. }
  NotepadIcon.ShowHint := ShowHintCheckBox.Checked;
end;

procedure TTrayIconDemoForm.HintEditChange(Sender: TObject);
begin
  { Display a new hint. }
  NotepadIcon.Hint := HintEdit.Text;
end;

procedure TTrayIconDemoForm.NotepadIconClick(Sender: TObject);
begin
  { Respond to the icon begin single clicked... }
  MessageDlg('That was a single click !!!', mtInformation, [mbOk], 0);
end;

procedure TTrayIconDemoForm.NotepadIconDblClick(Sender: TObject);
begin
  { Edit a new file. }
  WinExec('Notepad.exe', SW_SHOWNORMAL);
end;

procedure TTrayIconDemoForm.AutoexecBatClick(Sender: TObject);
begin
  { Edit Autoexec.bat }
  WinExec('Notepad.exe C:\AUTOEXEC.BAT', SW_SHOWNORMAL);
end;

procedure TTrayIconDemoForm.ConfigSysClick(Sender: TObject);
begin
  { Edit Config.sys }
  WinExec('Notepad.exe C:\CONFIG.SYS', SW_SHOWNORMAL);
end;

procedure TTrayIconDemoForm.RegisterNowButtonClick(Sender: TObject);
begin
  { Display the Registration help topic in the component help file. }
  Application.HelpJump('Ordering_Information_Order_Form');
end;

procedure TTrayIconDemoForm.About1Click(Sender: TObject);
begin
  { Display the About information for this component. }
  Application.HelpJump('About');
end;

procedure TTrayIconDemoForm.FormCreate(Sender: TObject);
begin
  { Show the components help if the user needs help. }
  Application.HelpFile := 'PGTRAY95.HLP';

  { Change to the project directory so the help file will be available. }
  Chdir( ExtractFilePath(Application.Exename) );
end;

procedure TTrayIconDemoForm.AutoPopupLabelClick(Sender: TObject);
begin
  { Toggles displaying the right click Popup menu on and off. }
  AutoPopupCheckBox.Checked := not AutoPopupCheckBox.Checked;
end;

procedure TTrayIconDemoForm.ShowHintLabelClick(Sender: TObject);
begin
  { Toggles displaying the icon's hint on and off. }
  ShowHintCheckBox.Checked := not ShowHintCheckBox.Checked;
end;

end.
