///////////////////////////////////////////////////////////////////////////////
//
// Module:		tncon.cpp
//
// Contents:	telnet console processing
//
// Product:		telnet
//
// Revisions:	02.Apr.1995	igor.milavec@uni-lj.si
//					Original code
//
///////////////////////////////////////////////////////////////////////////////

#include "tncon.h"

void telProcessConsole(TelThreadParams* pParams)
{
	HANDLE hConsole = GetStdHandle(STD_INPUT_HANDLE);

	SetConsoleMode(hConsole, 0);

	const DWORD nHandle = 2;
	HANDLE hHandle[nHandle] = {hConsole, pParams->hExit};

	for (;;) {
		DWORD dwInput;
		switch (WaitForMultipleObjects(nHandle, hHandle, FALSE, INFINITE)) {
		  case WAIT_OBJECT_0: {

			INPUT_RECORD InputRecord;
			ReadConsoleInput(hConsole, &InputRecord, 1, &dwInput);
			switch (InputRecord.EventType) {
			  case KEY_EVENT:
				if (InputRecord.Event.KeyEvent.uChar.AsciiChar)
					if (InputRecord.Event.KeyEvent.bKeyDown) {
						send(pParams->Socket, &InputRecord.Event.KeyEvent.uChar.AsciiChar, 1, 0);
					}
				break;
			}
			break;
		  }

		  default:
			return;
		}

	}

}

