// Class; Event Semaphore

#ifndef EVENT_H
#define EVENT_H

#include "Debug.h"

class Event {

   private:
      HEV Handle ;

   public:
      Event ( PSZ Name = PSZ(NULL) ) {
         if ( Name )
            Handle = 0 ;
         APIRET Status = DosCreateEventSem ( Name, &Handle, DC_SEM_SHARED, FALSE ) ;
         if ( Status ) {
            Log ( "EVENT: Unable to create event semaphore '%s'.", Name ) ;
            Handle = 0 ;
         } /* endif */
      }

      ~Event ( ) {
         DosCloseEventSem ( Handle ) ;
      }

      HEV QueryHandle ( ) { return ( Handle ) ; }

      APIRET Wait ( int Timeout = SEM_INDEFINITE_WAIT ) {
         if ( Handle == 0 )
            return ( 0xFFFFFFFF ) ;
         return ( DosWaitEventSem ( Handle, Timeout ) ) ;
      }

      APIRET Post ( ) {
         if ( Handle == 0 )
            return ( 0xFFFFFFFF ) ;
         return ( DosPostEventSem ( Handle ) ) ;
      }

      APIRET Reset ( ) {
         if ( Handle == 0 )
            return ( 0xFFFFFFFF ) ;
         ULONG PostCount ;
         return ( DosResetEventSem ( Handle, &PostCount ) ) ;
      }
} ;

#endif
