IDEAL
SEGMENT MAIN PARA PUBLIC
ASSUME CS:MAIN,DS:MAIN

ORG 100h

;*****************************************************************************
;* Equates                                                                   *
;*****************************************************************************

TRUE            EQU 1
FALSE           EQU 0

SX              EQU "$" ;(string terminator)

D_RETRIES       EQU 3
LAST_DRIVE      EQU 127
LD_SIZE         SIZESTR LAST_DRIVE
MAX_MAX_ENTRIES EQU 8192
MME_SIZE        SIZESTR MAX_MAX_ENTRIES
MAX_TRACKS      EQU 256
MT_SIZE         SIZESTR MAX_TRACKS
MAX_HEADS       EQU 256
MH_SIZE         SIZESTR MAX_HEADS
MAX_SECTORS     EQU 63
MS_SIZE         SIZESTR MAX_SECTORS
MAX_SSIZE       EQU 1024
MZ_SIZE         SIZESTR MAX_SSIZE
MAX_GAP_LENGTH  EQU 255
MGL_SIZE        SIZESTR MAX_GAP_LENGTH
MAX_RETRIES     EQU 9
MR_SIZE         SIZESTR MAX_RETRIES

DEFAULTS_SIZE   EQU (END_DEFAULTS-0100h)

SCRATCH_PAD         EQU OFFSET END_PROG
ALT_SCRATCH_PAD     EQU (OFFSET END_PROG+256)
SECTOR_BUFFER       EQU (OFFSET END_PROG+1024)
SECTOR_BUFFER_SIZE  EQU (32 * 1024)

;*****************************************************************************

BEGIN:
    JMP     NEAR PROG_START

;*****************************************************************************
;* Variables                                                                 *
;*****************************************************************************

PROG_TITLE      DB 13,10
                DB "Interrupt 13h Formatter v1.0",13,10
                DB "Artists of the Imagination, 1994",13,10,SX
                DB 26

;Formatting Parameters
DRIVE           DB  0,0
TRACKS          DB  80,0
HEADS           DB  2,0
SECTORS         DB  18,0
SECTOR_SIZE     DB  2,0
MEDIA           DB  0
INTERLEAVE      DB  1,0
GAP_LENGTH      DB  108,0
VERIFY          DB  TRUE
RETRIES         DB  D_RETRIES
OS              DB  1,0
FATS            DB  2,0
CLUSTER_SIZE    DB  1,0
MAX_ROOT_ENT    DW  64
PROMPT          DB  TRUE

CUR_DEFAULTS    DB 13,10,"Current Format Parameters",13,10
                DB "-----------------------------------",13,10
                DB "Drive Number:          "
DEF_DRIVE       DB "0  ",13,10
                DB "Tracks:                "
DEF_TRACKS      DB "80  ",13,10
                DB "Heads:                 "
DEF_HEADS       DB "2  ",13,10
                DB "Sectors/Track:         "
DEF_SECTORS     DB "18",13,10
                DB "Sector Size:           "
DEF_SECSIZE     DB "512 ",13,10
                DB "Media Type:            "
DEF_MEDIA       DB "Standard   ",13,10
                DB "Interleave:            1:"
DEF_INTERLEAVE  DB "1 ",13,10
                DB "Format Gap Length:     "
DEF_GAP_LENGTH  DB "108",13,10
                DB "Verify:                "
DEF_VERIFY      DB "ON ",13,10
                DB "Retries:               "
DEF_RETRIES     DB "3",13,10
                DB "Operating System:      "
DEF_OS          DB "DOS",13,10
                DB "Prompts:               "
DEF_PROMPTS     DB "ON ",13,10
                DB 13,10,SX

DOS_DEFAULTS    DB "DOS Parameters",13,10
                DB "-----------------------------------",13,10
                DB "Number of FATS:        "
DDEF_FATS       DB "2",13,10
                DB "Sectors/Cluster:       "
DDEF_CLUSTERZ   DB "1",13,10
                DB "Maximum Root Entries:  "
DDEF_MAXROOT    DB "64  ",13,10,SX


LABEL   END_DEFAULTS    BYTE

FINT13_SYNTAX   DB 13,10
                DB "Syntax: FINT13 /A:a /C:c /D:d /E:e /F:f /G:g /H:h /I:i "
                DB "/M:m /N:n /O:o /P:p",13,10
                DB "        /Q:q /R:r /S:s /T:t /V:v /W:w -W:w /X:x /Y:y "
                DB "/Z:z",13,10
                DB "a = # of DOS File (A)llocation Tables for disk (1-9)"
                DB 13,10
                DB "c = DOS (C)luster size in sectors (1,2,4,8)",13,10
                DB "d = BIOS (D)rive number in decimal (0-127)",13,10
                DB "e = Maximum number of directory (E)ntries for DOS "
                DB "(0-8192)",13,10
                DB "g = (G)ap length for format (1-255)",13,10
                DB "f = simple DOS (F)ormat size (1440,1200,720,360)",13,10
                DB "h = number of disk (H)eads (1-256)",13,10
                DB "i = (I)nterleave pattern (1-(s-1))",13,10
                DB "m = (M)edia type on high density drives (H,L)",13,10
                DB "n = disk serial (N)umber (00000000-FFFFFFFF)",13,10
                DB "o = (O)perating system platform (DOS only version)"
                DB 13,10
                DB "p = issue user (P)rompts for multiple disks (Y,N)",13,10
                DB "q = DOS (Q)uick format: not /R or /W compatible (Y,N)"
                DB 13,10
                DB "r = DOS file specification for virtual disk file to be "
                DB "(R)ead from",13,10
                DB "    specified drive",13,10
                DB "s = (S)ectors per track (1-63)",13,10
                DB "t = (T)racks/cylinders per disk (1-256)"
                DB 13,10
                DB "v = (V)erify format (Y,N)",13,10
                DB "w = DOS file specification for virtual disk file to be "
                DB "(W)ritten to",13,10
                DB "    specified drive",13,10
                DB "x = save parameters (other than /N, /Q, /R and /W) as "
                DB "defaults (Y,N)",13,10
                DB "y = number of retries for disk operations (0-9)",13,10
                DB "z = sector si(Z)e (128,256,512,1024)",13,10
                DB SX

OS_INFO_MSG     DB 13,10,"Writing Operating System information...",13,10,SX
OS_INFO_MSG2    DB "Complete.",13,10,SX

QUICK           DB FALSE

READ_FILE       DB FALSE
WRITE_FILE      DB FALSE
READ_END        DB FALSE

SAVE_PARMS      DB FALSE

R_HANDLE        DW 0
W_HANDLE        DW 0

PARM_LENGTH     DB 0

DISKCOPY_ONLY   DB 0

SECTORS_LEFT    DW 0

CUR_TRACK       DB 0
CUR_HEAD        DB 0
RETRY           DB 0

TRACK_BYTES     DW 0

ERROR_CODE      DB 0
ERROR_LOCATION  DB 0

USER_PROMPT_1A  DB "Insert disk into drive ",SX
USER_PROMPT_1B  DB " and press any key when ready...",13,10,13,10,SX
USER_PROMPT_2   DB 13,10,"Another (Y/N)?",SX
RETURN          DB 13,10,SX

GSN_STRING      DB 13,10,"Enter DOS Serial Number: ",SX

SECTOR_TYPES    DW 128,256,512,1024

STANDARD_MEDIA  DB "Standard   "
LOWD_MEDIA      DB "Low Density"

READ_OUTPUT     DB 13,"Reading-   ",SX
FORM_OUTPUT     DB 13,"Formatting-",SX
WRIT_OUTPUT     DB 13,"Writing-   ",SX
VERI_OUTPUT     DB 13,"Verifying- ",SX

CT_OUTPUT       DB " Cyl: ",SX
CH_OUTPUT       DB " Head: ",SX
RE_OUTPUT       DB " Retry: ",SX

READ_COMPLETE   DB 13,"Read Complete.                      ",13,10,SX
WRITE_COMPLETE  DB 13,"Write Complete.                     ",13,10,SX
FORMAT_COMPLETE DB 13,"Formatting Complete.                ",13,10,SX

LABEL           FORMAT_ERRORS   BYTE
                DB 13,"ERROR!,I(1):Illegal command         ",13,10,SX
                DB 13,"ERROR!,I(2):Sector address not found",13,10,SX
                DB 13,"ERROR!,I(3):Disk is write-protected ",13,10,SX
                DB 13,"ERROR!,I(4):Sector not found        ",13,10,SX
                DB 13,"ERROR!,I(6):Change line active      ",13,10,SX
                DB 13,"ERROR!,I(8):DMA overrun             ",13,10,SX
                DB 13,"ERROR!,I(9):DMA attempt across 64k  ",13,10,SX
                DB 13,"ERROR!,I(12):Invalid Media          ",13,10,SX
                DB 13,"ERROR!,I(16):Read\verify CRC error  ",13,10,SX
                DB 13,"ERROR!,I(32):Controller error       ",13,10,SX
                DB 13,"ERROR!,I(64):Seek failure           ",13,10,SX
                DB 13,"ERROR!,I(128):Drive not ready       ",13,10,SX

LABEL           FILE_ERRORS     BYTE
                DB 13,10,"ERROR!,F(129):Invalid Function     ",13,10,SX
                DB 13,10,"ERROR!,F(130):File not found       ",13,10,SX
                DB 13,10,"ERROR!,F(131):Path not found       ",13,10,SX
                DB 13,10,"ERROR!,F(132):No handles available ",13,10,SX
                DB 13,10,"ERROR!,F(133):Access denied        ",13,10,SX
                DB 13,10,"ERROR!,F(134):Invalid handle       ",13,10,SX
                DB 13,10,"ERROR!,F(140):Invalid access code  ",13,10,SX

LABEL           MEMORY_ERRORS   BYTE
                DB 13,10,"ERROR!,M(135):MCBs destroyed       ",13,10,SX
                DB 13,10,"ERROR!,M(136):Insufficient memory  ",13,10,SX
                DB 13,10,"ERROR!,M(137):Invalid block address",13,10,SX

LABEL           PARAMETER_ERRORS BYTE
                DB 13,10,"ERROR!,P(255):Parameter format not correct",13,10
                DB SX

;*****************************************************************************

;*****************************************************************************
;* Procedures                                                                *
;*****************************************************************************

;*****************************************************************************

PROC    PROG_START

    LEA     SI,[PROG_TITLE]
    CALL    OUTPUT

    CALL    FIX_MEMORY
    CMP     [ERROR_CODE],0
    JA      PROG_EXIT

    CALL    PROCESS_PARAMETERS
    CMP     [ERROR_CODE],0
    JA      PROG_EXIT

    CMP     [SAVE_PARMS],TRUE
    JNE     CONT

    CALL    WRITE_CURRENT_PARMS
    CMP     [ERROR_CODE],0
    JA      PROG_EXIT

CONT:
    LEA     SI,[CUR_DEFAULTS]
    CALL    OUTPUT

    CMP     [OS],1
    JNE     GO_FORMAT

    LEA     SI,[DOS_DEFAULTS]
    CALL    OUTPUT

GO_FORMAT:
    CALL    CLEAR_SECTOR_BUFFER

    CALL    FORMATTER

    CMP     [PROMPT],TRUE
    JNE     PROG_EXIT

    LEA     SI,[USER_PROMPT_2]
    CALL    OUTPUT

GET_INPUT:
    CALL    INCHAR
    CALL    FIX_CHAR
    CMP     AL,"N"
    JE      PROG_EXIT
    CMP     AL,"Y"
    JNE     GET_INPUT

    MOV     [ERROR_CODE],0
    LEA     SI,[RETURN]
    CALL    OUTPUT
    JMP     SHORT   GO_FORMAT

ENDP    PROG_START

;*****************************************************************************

;*****************************************************************************

PROC    PROG_EXIT

    LEA     SI,[RETURN]
    CALL    OUTPUT

    MOV     AH,4Ch
    MOV     AL,[ERROR_CODE]
    INT     21h

ENDP    PROG_EXIT

;*****************************************************************************

;*****************************************************************************

PROC    OUTPUT

    PUSH    AX
    PUSH    DX

    MOV     DX,SI
    MOV     AH,09h
    INT     21h

    POP     DX
    POP     AX
    RET

ENDP    OUTPUT

;*****************************************************************************

;*****************************************************************************

PROC    OUTCHAR

    PUSH    AX
    PUSH    DX

    MOV     DL,AL
    MOV     AH,02h
    INT     21h

    POP     DX
    POP     AX
    RET

ENDP    OUTCHAR

;*****************************************************************************

;*****************************************************************************

PROC    INCHAR

    MOV     AH,08h
    INT     21h

    RET

ENDP    INCHAR

;*****************************************************************************

;*****************************************************************************

STR_BUF     DB 82h DUP (0)

PROC    IN_HEXSTRING

    PUSH    AX
    PUSH    CX
    PUSH    DX
    PUSH    SI
    PUSH    DI

    CLD
    LEA     SI,[STR_BUF]
    MOV     DX,SI
    INC     AL
    MOV     [BYTE PTR SI],AL
    MOV     AH,0Ah
    INT     21h

    MOV     CL,[BYTE PTR SI+1]
    INC     CL
    CMP     CL,[BYTE PTR SI]
    JNE     IHS_ERROR

    SHR     CL,1
    XOR     CH,CH
    INC     SI
    INC     SI

COPY_LOOP1:
    XOR     DH,DH

COPY_LOOP2:
    MOV     DL,AL
    LODSB
    CALL    FIX_CHAR

    CMP     AL,"0"
    JB      IHS_ERROR
    CMP     AL,"9"
    JBE     IHS_CONT
    CMP     AL,"A"
    JB      IHS_ERROR
    CMP     AL,"F"
    JA      IHS_ERROR

IHS_CONT:
    SUB     AL,30h
    CMP     AL,10
    JB      DECIMAL

    SUB     AL,7

DECIMAL:
    INC     DH
    CMP     DH,2
    JB      COPY_LOOP2

    SHL     DL,1
    SHL     DL,1
    SHL     DL,1
    SHL     DL,1
    OR      AL,DL

    STD
    STOSB
    CLD
    LOOP    COPY_LOOP1
    CLC
    JMP     SHORT   END_IHS

IHS_ERROR:
    STC

END_IHS:
    POP     DI
    POP     SI
    POP     DX
    POP     CX
    POP     AX
    RET

ENDP    IN_HEXSTRING

;*****************************************************************************

;*****************************************************************************

PROC    FIX_CHAR

    CMP     AL,"A"
    JB      FC_END
    CMP     AL,"Z"
    JB      FC_FIX
    CMP     AL,"a"
    JB      FC_END
    CMP     AL,"z"
    JA      FC_END

FC_FIX:
    AND     AX,0DFDFh

FC_END:
    RET

ENDP    FIX_CHAR

;*****************************************************************************

;*****************************************************************************

PROC    OUT_AX

    PUSH    AX
    PUSH    BX
    PUSH    CX
    PUSH    DX

    XOR     CX,CX
    MOV     BX,10

DIV_LOOP:
    XOR     DX,DX
    DIV     BX
    PUSH    DX
    INC     CX
    CMP     AX,0
    JA      DIV_LOOP

WRITE_LOOP:
    POP     AX
    ADD     AL,30h
    CALL    OUTCHAR
    LOOP    WRITE_LOOP

    POP     DX
    POP     CX
    POP     BX
    POP     AX
    RET

ENDP    OUT_AX

;*****************************************************************************

;*****************************************************************************

WHITESPACES DB  0,9,10,13,32,255,"$"

PROC    IS_WHITESPACE

    PUSH    BX
    PUSH    SI

    MOV     SI,OFFSET WHITESPACES
    MOV     AH,[BYTE PTR SI]
    CMP     AH,"$"
    JE      NOT_WS

WHITE_LOOP:
    CMP     AL,AH
    JE      END_ISW
    INC     SI
    MOV     AH,[BYTE PTR SI]
    CMP     AH,"$"
    JNE     WHITE_LOOP

NOT_WS:
    MOV     BX,0201h
    CMP     BH,BL

END_ISW:
    POP     SI
    POP     BX
    RET

ENDP    IS_WHITESPACE

;*****************************************************************************

;*****************************************************************************

PROC    FIX_MEMORY

    POP     AX
    MOV     BX,SECTOR_BUFFER
    ADD     BX,((SECTOR_BUFFER_SIZE)+0200h)
    DEC     BX
    TEST    BX,1
    JZ      EVEN_SP

    DEC     BX

EVEN_SP:
    MOV     SP,BX
    PUSH    AX
    MOV     CL,4
    SHR     BX,CL
    INC     BX

    MOV     AH,4Ah
    INT     21h
    JNC     END_FM

    OR      AL,10000000b
    MOV     [ERROR_CODE],AL
    MOV     [ERROR_LOCATION],"M"
    CALL    DISPLAY_ERROR

END_FM:
    RET

ENDP    FIX_MEMORY

;*****************************************************************************

;*****************************************************************************

PROC    CLEAR_SECTOR_BUFFER

    push    ax
    push    cx
    push    di
    push    es

    push    cs
    pop     es

    mov     di,SECTOR_BUFFER

    cld
    mov     ax,0F6F6h
    mov     cx,(SECTOR_BUFFER_SIZE / 2)
    rep     stosw

    pop     es
    pop     di
    pop     cx
    pop     ax
    ret

ENDP    CLEAR_SECTOR_BUFFER

;*****************************************************************************

;*****************************************************************************

PROC    GET_PARM_CHAR

    CMP     [PARM_LENGTH],0
    JNE     NOT_YET_AT_END

    MOV     SP,BP
    CLC
    JMP     NEAR    PARM_PROC_EXIT

NOT_YET_AT_END:
    LODSB
    DEC     [PARM_LENGTH]
    RET

ENDP    GET_PARM_CHAR

;*****************************************************************************

;*****************************************************************************

PROC    PROCESS_PARAMETERS

    CLD
    MOV     BP,SP
    MOV     SI,80h
    LODSB
    MOV     [PARM_LENGTH],AL

PARM_LOOP:
    CALL    GET_PARM_CHAR
    CMP     AL,"/"
    JE      IS_PARM

    CMP     AL,"-"
    JE      IS_PARM

    CALL    IS_WHITESPACE
    JNE     PARM_ERROR

    JMP     PARM_LOOP

IS_PARM:
    MOV     BL,AL
    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR
    CALL    CALL_PARM_PROC
    JC      PARM_ERROR

    MOV     AH,BL
    CMP     AX,"-W"
    JNE     PARM_LOOP

    MOV     [DISKCOPY_ONLY],TRUE
    JMP     PARM_LOOP

PARM_ERROR:
    CMP     [ERROR_LOCATION],"?"
    JE      PARM_PROC_EXIT

    MOV     [ERROR_CODE],255
    MOV     [ERROR_LOCATION],"P"
    CALL    DISPLAY_ERROR

    LEA     SI,[FINT13_SYNTAX]
    CALL    OUTPUT

PARM_PROC_EXIT:
    RET

ENDP    PROCESS_PARAMETERS

;*****************************************************************************

;*****************************************************************************

LABEL   PARM_ROUTINES   WORD
A               DW OFFSET SET_NUM_FATS
C               DW OFFSET SET_CLUSTER_SIZE
D               DW OFFSET SET_DRIVE
E               DW OFFSET SET_MAX_ENTRIES
F               DW OFFSET SET_FORMAT_TYPE
G               DW OFFSET SET_GAP_LENGTH
H               DW OFFSET SET_HEADS
I               DW OFFSET SET_INTERLEAVE
M               DW OFFSET SET_MEDIA_TYPE
N               DW OFFSET SET_SERIAL_NUM
O               DW OFFSET SET_OS
P               DW OFFSET SET_PROMPTS
Q               DW OFFSET SET_QUICK
R               DW OFFSET SET_READ
S               DW OFFSET SET_SECTORS
T               DW OFFSET SET_TRACKS
V               DW OFFSET SET_VERIFY
W               DW OFFSET SET_WRITE
X               DW OFFSET SET_PARMSAVE
Y               DW OFFSET SET_RETRIES
Z               DW OFFSET SET_SECTOR_SIZE

VALID_CHARS DB  "ACDEFGHIMNOPQRSTVWXYZ$"

PROC    CALL_PARM_PROC

    PUSH    AX
    PUSH    BX

    CMP     AL,"?"
    JNE     IS_PARAMETER

    CALL    SHOW_SYNTAX
    JMP     SHORT   END_CPL

IS_PARAMETER:
    XOR     BX,BX
    MOV     DI,OFFSET VALID_CHARS
    MOV     AH,[BYTE PTR DI]
    CMP     AH,"$"
    JE      INVALID_CHAR

CHECK_LOOP:
    CMP     AL,AH
    JE      GO_ROUTINE
    INC     BX
    INC     BX
    INC     DI
    MOV     AH,[BYTE PTR DI]
    CMP     AH,"$"
    JNE     CHECK_LOOP

INVALID_CHAR:
    STC
    JMP     SHORT   END_CPL

GO_ROUTINE:
    CALL    GET_PARM_CHAR
    CMP     AL,":"
    JNE     INVALID_CHAR
    CALL    [PARM_ROUTINES+BX]

END_CPL:
    POP     BX
    POP     AX
    RET

ENDP    CALL_PARM_PROC

;*****************************************************************************

;*****************************************************************************

PROC    MUL_AX

    PUSH    CX
    XOR     AH,AH
    CMP     [DIG_PLACE],0
    JE      END_MAX

    MOV     CX,[DIG_PLACE]
    MOV     BL,10

MB_LOOP:
    MUL     BL
    LOOP    MB_LOOP

END_MAX:
    POP     CX
    RET

ENDP    MUL_AX

;*****************************************************************************

;*****************************************************************************

MAX_DIGITS      DW  0
MAX_NUMBER      DW  0
REQ_MULTIPLE    DW  0
VARIABLE_PTR    DW  0

DIG_PLACE       DW  0

PROC    GET_NUMBER_PARM

    XOR     CX,CX
    XOR     DX,DX

EXTRACT_LOOP:
    CALL    GET_PARM_CHAR
    CALL    IS_WHITESPACE
    JE      END_EXT_LOOP

    CMP     AL,"0"
    JB      BAD_NUMBER
    CMP     AL,"9"
    JA      BAD_NUMBER

    MOV     AH,AL
    SUB     AL,30h
    INC     CX
    PUSH    AX

    CMP     [PARM_LENGTH],0
    JA      EXTRACT_LOOP

END_EXT_LOOP:
    CMP     CX,0
    JE      BAD_NUMBER

    CMP     CX,[MAX_DIGITS]
    JNA     DIGITS_OK

FIX_STACK:
    POP     AX
    LOOP    FIX_STACK
    JMP     SHORT   BAD_NUMBER

DIGITS_OK:
    PUSH    CX
    PUSH    DI
    MOV     CX,[MAX_DIGITS]
    MOV     AL," "
    REP     STOSB
    POP     DI
    POP     CX

    MOV     [DIG_PLACE],0

SAVE_LOOP:
    POP     AX
    MOV     BX,CX
    MOV     [DI+BX-1],AH
    CALL    MUL_AX
    ADD     DX,AX
    INC     [DIG_PLACE]
    LOOP    SAVE_LOOP

    MOV     BX,[VARIABLE_PTR]
    MOV     [WORD PTR BX],DX
    CMP     DX,[MAX_NUMBER]
    JA      BAD_NUMBER

    MOV     AX,DX
    XOR     DX,DX
    MOV     BX,[REQ_MULTIPLE]
    DIV     BX
    OR      DX,DX
    JNE     BAD_NUMBER

    CLC
    JMP     SHORT   SD_END

BAD_NUMBER:
    STC

SD_END:
    RET

ENDP    GET_NUMBER_PARM

;*****************************************************************************

;*****************************************************************************

PROC    SHOW_SYNTAX

    LEA     SI,[FINT13_SYNTAX]
    CALL    OUTPUT

    MOV     [ERROR_LOCATION],"?"
    MOV     [ERROR_CODE],254

    RET

ENDP    SHOW_SYNTAX

;*****************************************************************************

;*****************************************************************************

PROC    SET_PARMSAVE

    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR

    CMP     AL,"Y"
    JE      SP_YES

    CMP     AL,"N"
    JNE     SPERROR

    MOV     [SAVE_PARMS],FALSE
    CLC
    JMP     SHORT   ENDSP

SP_YES:
    MOV     [SAVE_PARMS],TRUE
    CLC
    JMP     SHORT   ENDSP

SPERROR:
    STC

ENDSP:
    RET


ENDP    SET_PARMSAVE

;*****************************************************************************

;*****************************************************************************

PROC    SET_NUM_FATS

    CALL    GET_PARM_CHAR

    CMP     AL,"1"
    JB      END_SNF

    CMP     AL,"9"
    JAE     SNF_ERROR

    MOV     [DDEF_FATS],AL
    SUB     AL,30h
    MOV     [FATS],AL

    CLC
    JMP     SHORT   END_SNF

SNF_ERROR:
    STC

END_SNF:
    RET

ENDP    SET_NUM_FATS

;*****************************************************************************

;*****************************************************************************

PROC    SET_CLUSTER_SIZE

    CALL    GET_PARM_CHAR

    CMP     AL,"1"
    JE      OK_CSIZE
    CMP     AL,"2"
    JE      OK_CSIZE
    CMP     AL,"4"
    JE      OK_CSIZE
    CMP     AL,"8"
    JE      OK_CSIZE

    STC
    JMP     SHORT   END_SCS

OK_CSIZE:
    MOV     [DDEF_CLUSTERZ],AL
    SUB     AL,30h
    MOV     [CLUSTER_SIZE],AL
    CLC

END_SCS:
    RET

ENDP    SET_CLUSTER_SIZE

;*****************************************************************************

;*****************************************************************************

PROC    SET_MEDIA_TYPE

    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR

    CMP     AL,"H"
    JE      IS_STANDARD

    CMP     AL,"L"
    JNE     SMT_ERROR

    MOV     [MEDIA],1

    LEA     BX,[LOWD_MEDIA]
    JMP     SHORT   STORE_DEF

IS_STANDARD:
    MOV     [MEDIA],0

    LEA     BX,[STANDARD_MEDIA]

STORE_DEF:
    MOV     CX,11
    LEA     DI,[DEF_MEDIA]

DEFM_LOOP:
    MOV     AL,[BYTE PTR BX]
    INC     BX
    STOSB
    LOOP    DEFM_LOOP

    CLC
    JMP     SHORT   END_SMT

SMT_ERROR:
    STC

END_SMT:
    RET

ENDP    SET_MEDIA_TYPE

;*****************************************************************************

;*****************************************************************************

PROC    SET_DRIVE

    MOV     [MAX_DIGITS],LD_SIZE
    MOV     [MAX_NUMBER],LAST_DRIVE
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET DRIVE
    MOV     DI,OFFSET DEF_DRIVE
    CALL    GET_NUMBER_PARM

    RET

ENDP    SET_DRIVE

;*****************************************************************************

;*****************************************************************************

PROC    SET_MAX_ENTRIES

    MOV     [MAX_DIGITS],MME_SIZE
    MOV     [MAX_NUMBER],MAX_MAX_ENTRIES
    MOV     [REQ_MULTIPLE],16
    MOV     [VARIABLE_PTR],OFFSET MAX_ROOT_ENT
    MOV     DI,OFFSET DDEF_MAXROOT
    CALL    GET_NUMBER_PARM

    RET

ENDP    SET_MAX_ENTRIES

;*****************************************************************************

;*****************************************************************************

LABEL   DOS_DEF_TRACKS  BYTE
                DB 40
                DB 80
                DB 80
                DB 80

LABEL   DOS_DEF_HEADS   BYTE
                DB 2
                DB 2
                DB 2
                DB 2

LABEL   DOS_DEF_SECTORS BYTE
                DB 9
                DB 9
                DB 15
                DB 18

LABEL   DOS_DEF_GAP     BYTE
                DB 80
                DB 80
                DB 84
                DB 108

LABEL   TRACK_STRING    BYTE
                DB "40 "
                DB "80 "
                DB "80 "
                DB "80 "

LABEL   HEAD_STRING     BYTE
                DB "2  "
                DB "2  "
                DB "2  "
                DB "2  "

LABEL   SECTOR_STRING   BYTE
                DB "9  "
                DB "9  "
                DB "15 "
                DB "18 "

LABEL   GAP_STRING      BYTE
                DB "80 "
                DB "80 "
                DB "84 "
                DB "108"

FORMAT_SELECTED DW 0
FS_STRING       DB "XXXX"

PROC    SET_FORMAT_TYPE

    MOV     [MAX_DIGITS],4
    MOV     [MAX_NUMBER],1440
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET FORMAT_SELECTED
    MOV     DI,OFFSET FS_STRING
    CALL    GET_NUMBER_PARM
    JC      BAD_FORMAT_TYPE

    MOV     AX,[FORMAT_SELECTED]
    CMP     AX,1440
    JE      HD_FORMAT
    CMP     AX,1200
    JE      HD_FORMAT
    CMP     AX,720
    JE      LD_FORMAT
    CMP     AX,360
    JE      LD_FORMAT

BAD_FORMAT_TYPE:
    STC
    JMP     NEAR    END_SFT

HD_FORMAT:
    MOV     [MEDIA],0
    LEA     BX,[STANDARD_MEDIA]
    JMP     SHORT   OK_FORMAT

LD_FORMAT:
    MOV     [MEDIA],1
    LEA     BX,[LOWD_MEDIA]

OK_FORMAT:
    PUSH    AX
    MOV     CX,11
    LEA     DI,[DEF_MEDIA]

FTDEFM_LOOP:
    MOV     AL,[BYTE PTR BX]
    INC     BX
    STOSB
    LOOP    FTDEFM_LOOP

    POP     AX
    XOR     DX,DX
    MOV     BX,360
    DIV     BX
    DEC     AX
    MOV     BX,AX

    MOV     DL,[DOS_DEF_TRACKS+BX]
    MOV     [TRACKS],DL
    MOV     DL,[DOS_DEF_HEADS+BX]
    MOV     [HEADS],DL
    MOV     DL,[DOS_DEF_SECTORS+BX]
    MOV     [SECTORS],DL
    MOV     [SECTOR_SIZE],2
    MOV     DL,[DOS_DEF_GAP+BX]
    MOV     [GAP_LENGTH],DL

    MOV     DL,3
    MUL     DL

    MOV     BX,AX
    ADD     BX,OFFSET TRACK_STRING
    MOV     DX,[WORD PTR BX]
    MOV     [WORD PTR DEF_TRACKS],DX
    MOV     DL,[BYTE PTR BX+2]
    MOV     [BYTE PTR DEF_TRACKS+2],DL

    MOV     BX,AX
    ADD     BX,OFFSET HEAD_STRING
    MOV     DX,[WORD PTR BX]
    MOV     [WORD PTR DEF_HEADS],DX
    MOV     DL,[BYTE PTR BX+2]
    MOV     [BYTE PTR DEF_HEADS+2],DL

    MOV     BX,AX
    ADD     BX,OFFSET SECTOR_STRING
    MOV     DX,[WORD PTR BX]
    MOV     [WORD PTR DEF_SECTORS],DX

    MOV     [WORD PTR DEF_SECSIZE],"15"
    MOV     [WORD PTR DEF_SECSIZE+2]," 2"

    MOV     BX,AX
    ADD     BX,OFFSET GAP_STRING
    MOV     DX,[WORD PTR BX]
    MOV     [WORD PTR DEF_GAP_LENGTH],DX
    MOV     DL,[BYTE PTR BX+2]
    MOV     [BYTE PTR DEF_GAP_LENGTH+2],DL

    CLC

END_SFT:
    RET

ENDP    SET_FORMAT_TYPE

;*****************************************************************************

;*****************************************************************************

PROC    SET_HEADS

    MOV     [MAX_DIGITS],MH_SIZE
    MOV     [MAX_NUMBER],MAX_HEADS
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET HEADS
    MOV     DI,OFFSET DEF_HEADS
    CALL    GET_NUMBER_PARM
    JC      END_SH

    CMP     [HEADS],1

END_SH:
    RET

ENDP    SET_HEADS

;*****************************************************************************

;*****************************************************************************

PROC    SET_INTERLEAVE

    MOV     [MAX_DIGITS],MS_SIZE
    MOV     AL,[SECTORS]
    DEC     AL
    XOR     AH,AH
    MOV     [MAX_NUMBER],AX
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET INTERLEAVE
    MOV     DI,OFFSET DEF_INTERLEAVE
    CALL    GET_NUMBER_PARM
    JC      END_SI

    CMP     [INTERLEAVE],1

END_SI:
    RET

ENDP    SET_INTERLEAVE

;*****************************************************************************

;*****************************************************************************

PROC    SET_GAP_LENGTH

    MOV     [MAX_DIGITS],MGL_SIZE
    MOV     [MAX_NUMBER],MAX_GAP_LENGTH
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET GAP_LENGTH
    MOV     DI,OFFSET DEF_GAP_LENGTH
    CALL    GET_NUMBER_PARM
    JC      END_SGL

    CMP     [GAP_LENGTH],1

END_SGL:
    RET

ENDP    SET_GAP_LENGTH

;*****************************************************************************

;*****************************************************************************

PROC    SET_OS

    CALL    GET_PARM_CHAR
    CMP     AL,"0"
    JB      SHORT OS_ERROR
    JA      SHORT MAY_BE_DOS

    MOV     [OS],0
    MOV     [word ptr DEF_OS],"oN"
    MOV     [byte ptr DEF_OS+2]," "
    jmp     short os_ok

MAY_BE_DOS:
    cmp     al,"9"
    ja      short OS_ERROR

    mov     [OS],1
    MOV     [word ptr DEF_OS],"OD"
    MOV     [byte ptr DEF_OS+2],"S"

os_ok:
    CLC
    jmp     short os_exit

os_error:
    stc

os_exit:
    RET

ENDP    SET_OS

;*****************************************************************************

;*****************************************************************************

PROC    SET_SERIAL_NUM

    CLD
    MOV     DI,(OFFSET DB_SERIAL_NUM+3)
    MOV     CX,4

SSN_LOOP1:
    XOR     BL,BL

SSN_LOOP2:
    MOV     DL,AL
    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR

    CMP     AL,"0"
    JB      SSN_ERROR
    CMP     AL,"9"
    JBE     CHAR_OK
    CMP     AL,"A"
    JB      SSN_ERROR
    CMP     AL,"F"
    JA      SSN_ERROR

CHAR_OK:
    SUB     AL,30h
    CMP     AL,10
    JB      IS_DECIMAL

    SUB     AL,7

IS_DECIMAL:
    INC     BL
    CMP     BL,2
    JB      SSN_LOOP2

    SHL     DL,1
    SHL     DL,1
    SHL     DL,1
    SHL     DL,1
    OR      AL,DL
    STD
    STOSB
    CLD
    LOOP    SSN_LOOP1

    CLC
    JMP     SHORT   END_SSN

SSN_ERROR:
    STC

END_SSN:
    RET

ENDP    SET_SERIAL_NUM

;*****************************************************************************

;*****************************************************************************

PROC    SET_PROMPTS

    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR

    CMP     AL,"Y"
    JE      PROMPTS_ON

    CMP     AL,"N"
    JE      PROMPTS_OFF

    STC
    JMP     SHORT   END_SETP

PROMPTS_OFF:
    MOV     [PROMPT],FALSE
    MOV     [WORD PTR DEF_PROMPTS],"FO"
    MOV     [BYTE PTR DEF_PROMPTS+2],"F"
    CLC
    JMP     SHORT   END_SETP

PROMPTS_ON:
    MOV     [PROMPT],TRUE
    MOV     [WORD PTR DEF_PROMPTS],"NO"
    MOV     [BYTE PTR DEF_PROMPTS+2]," "
    CLC

END_SETP:
    RET

ENDP    SET_PROMPTS

;*****************************************************************************

;*****************************************************************************

PROC    SET_QUICK

    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR

    CMP     AL,"Y"
    JE      IS_QUICK

    CMP     AL,"N"
    JNE     SQ_ERROR

    MOV     [QUICK],FALSE
    CLC
    JMP     SHORT   END_SQ

IS_QUICK:
    CMP     [WRITE_FILE],TRUE
    JE      SQ_ERROR

    CMP     [READ_FILE],TRUE
    JE      SQ_ERROR

    MOV     [QUICK],TRUE
    CLC
    JMP     SHORT   END_SQ

SQ_ERROR:
    STC

END_SQ:
    RET

ENDP    SET_QUICK

;*****************************************************************************

;*****************************************************************************

PROC    SET_WRITE

    CMP     [WRITE_FILE],TRUE
    JE      WRITE_CONFLICT
    CMP     [QUICK],TRUE
    JNE     NO_WRITE_CONFLICT

WRITE_CONFLICT:
    STC
    JMP     SHORT   END_SW

NO_WRITE_CONFLICT:
    MOV     DX,SI

SW_LOOP:
    CALL    GET_PARM_CHAR
    CALL    IS_WHITESPACE
    JE      END_SW_LOOP

    CMP     [PARM_LENGTH],0
    JA      SW_LOOP

    INC     SI

END_SW_LOOP:
    MOV     [BYTE PTR SI-1],0

    MOV     AX,3D00h
    INT     21h
    JC      SW_ERROR

    MOV     [R_HANDLE],AX
    MOV     [READ_FILE],TRUE
    JMP     SHORT   END_SW

SW_ERROR:
    OR      AL,10000000b
    MOV     [ERROR_CODE],AL
    MOV     [ERROR_LOCATION],"F"
    CALL    DISPLAY_ERROR
    STC

END_SW:
    RET

ENDP    SET_WRITE

;*****************************************************************************

;*****************************************************************************

PROC    SET_SECTORS

    MOV     [MAX_DIGITS],MS_SIZE
    MOV     [MAX_NUMBER],MAX_SECTORS
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET SECTORS
    MOV     DI,OFFSET DEF_SECTORS
    CALL    GET_NUMBER_PARM
    JC      END_SS

    CMP     [SECTORS],1

END_SS:
    RET

ENDP    SET_SECTORS

;*****************************************************************************

;*****************************************************************************

PROC    SET_TRACKS

    MOV     [MAX_DIGITS],MT_SIZE
    MOV     [MAX_NUMBER],MAX_TRACKS
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET TRACKS
    MOV     DI,OFFSET DEF_TRACKS
    CALL    GET_NUMBER_PARM
    JC      END_ST

    CMP     [TRACKS],1

END_ST:
    RET

ENDP    SET_TRACKS

;*****************************************************************************

;*****************************************************************************

PROC    SET_VERIFY

    CALL    GET_PARM_CHAR
    CALL    FIX_CHAR

    CMP     AL,"Y"
    JE      VERIFY_ON

    CMP     AL,"N"
    JE      VERIFY_OFF

    STC
    JMP     SHORT   END_SETV

VERIFY_OFF:
    MOV     [VERIFY],FALSE
    MOV     [WORD PTR DEF_VERIFY],"FO"
    MOV     [BYTE PTR DEF_VERIFY+2],"F"
    CLC
    JMP     SHORT   END_SETV

VERIFY_ON:
    MOV     [VERIFY],TRUE
    MOV     [WORD PTR DEF_VERIFY],"NO"
    MOV     [BYTE PTR DEF_VERIFY+2]," "
    CLC

END_SETV:
    RET

ENDP    SET_VERIFY

;*****************************************************************************

;*****************************************************************************

PROC    SET_READ

    CMP     [READ_FILE],TRUE
    JE      READ_CONFLICT
    CMP     [QUICK],TRUE
    JNE     NO_READ_CONFLICT

READ_CONFLICT:
    STC
    JMP     SHORT   END_SR

NO_READ_CONFLICT:
    MOV     DX,SI

SR_LOOP:
    CALL    GET_PARM_CHAR
    CALL    IS_WHITESPACE
    JE      END_SR_LOOP

    CMP     [PARM_LENGTH],0
    JA      SR_LOOP

    INC     SI

END_SR_LOOP:
    MOV     [BYTE PTR SI-1],0

    MOV     AH,3Ch
    XOR     CX,CX
    INT     21h
    JC      SR_ERROR

    MOV     [W_HANDLE],AX
    MOV     [WRITE_FILE],TRUE
    JMP     SHORT   END_SR

SR_ERROR:
    OR      AL,10000000b
    MOV     [ERROR_CODE],AL
    MOV     [ERROR_LOCATION],"F"
    CALL    DISPLAY_ERROR
    STC

END_SR:
    RET

ENDP    SET_READ

;*****************************************************************************

;*****************************************************************************

PROC    WRITE_CURRENT_PARMS

    PUSH    AX
    PUSH    BX
    PUSH    CX
    PUSH    DX
    PUSH    SI

    MOV     SI,002Ch
    MOV     AX,[WORD PTR SI]

    PUSH    DS
    MOV     DS,AX
    XOR     SI,SI
    XOR     AX,AX

FIND_ENV_END_LOOP:
    CMP     AX,[WORD PTR SI]
    JE      FOUND_END
    INC     SI
    JMP     SHORT   FIND_ENV_END_LOOP

FOUND_END:
    ADD     SI,4
    MOV     DX,SI
    MOV     AX,3D02h
    INT     21h
    POP     DS
    JC      WCP_FILE_ERROR

    MOV     BX,AX
    MOV     AH,40h
    MOV     CX,(OFFSET END_DEFAULTS - 100h)
    MOV     DX,0100h
    INT     21h
    JC      WCP_FILE_ERROR

    MOV     AH,3Eh
    INT     21h
    JNC     NO_FILE_ERROR

WCP_FILE_ERROR:
    OR      AL,10000000b
    MOV     [ERROR_LOCATION],"F"
    MOV     [ERROR_CODE],AL

    CALL    DISPLAY_ERROR
    STC
    JMP     SHORT   END_WCP

NO_FILE_ERROR:
    CLC

END_WCP:
    POP     SI
    POP     DX
    POP     CX
    POP     BX
    POP     AX
    RET

ENDP    WRITE_CURRENT_PARMS

;*****************************************************************************

;*****************************************************************************

PROC    SET_RETRIES

    MOV     [MAX_DIGITS],MR_SIZE
    MOV     [MAX_NUMBER],MAX_RETRIES
    MOV     [REQ_MULTIPLE],1
    MOV     [VARIABLE_PTR],OFFSET RETRIES
    MOV     DI,OFFSET DEF_RETRIES
    CALL    GET_NUMBER_PARM

    RET

ENDP    SET_RETRIES

;*****************************************************************************

;*****************************************************************************

PROC    SET_SECTOR_SIZE

    MOV     [MAX_DIGITS],MZ_SIZE
    MOV     [MAX_NUMBER],MAX_SSIZE
    MOV     [REQ_MULTIPLE],128
    MOV     [VARIABLE_PTR],OFFSET SECTOR_SIZE
    MOV     DI,OFFSET DEF_SECSIZE
    CALL    GET_NUMBER_PARM
    JC      END_SSS

    XOR     AX,AX
    CMP     [WORD PTR SECTOR_SIZE],128
    JE      END_SSS

    INC     AX
    CMP     [WORD PTR SECTOR_SIZE],256
    JE      END_SSS

    INC     AX
    CMP     [WORD PTR SECTOR_SIZE],512
    JE      END_SSS

    INC     AX
    CMP     [WORD PTR SECTOR_SIZE],1024
    JE      END_SSS

    STC

END_SSS:
    MOV     [SECTOR_SIZE],AL

    RET

ENDP    SET_SECTOR_SIZE

;*****************************************************************************

;*****************************************************************************

PROC    FIGURE_INTERLEAVE

    MOV     DI,SCRATCH_PAD
    PUSH    DI
    XOR     AX,AX
    MOV     CX,0020h
    REP     STOSW
    POP     DI

    MOV     DL,[SECTORS]
    XOR     DH,DH
    ADD     DX,SCRATCH_PAD
    MOV     BL,[INTERLEAVE]
    XOR     BH,BH

INTERLEAVE_LOOP:
    INC     AL
    MOV     [BYTE PTR DI],AL
    CMP     AL,[SECTORS]
    JE      END_FIGURE

    ADD     DI,BX

CHECK_WRAP:
    CMP     DI,DX
    JB      NO_WRAP

    SUB     DI,[WORD PTR SECTORS]

NO_WRAP:
    CMP     [BYTE PTR DI],0
    JE      INTERLEAVE_LOOP

    INC     DI
    JMP     CHECK_WRAP

END_FIGURE:
    RET

ENDP    FIGURE_INTERLEAVE

;*****************************************************************************

;*****************************************************************************

PROC    CURRENT_POSITION

    LEA     SI,[CT_OUTPUT]
    CALL    OUTPUT
    XOR     AH,AH
    MOV     AL,[CUR_TRACK]
    CALL    OUT_AX

    LEA     SI,[CH_OUTPUT]
    CALL    OUTPUT
    MOV     AL,[CUR_HEAD]
    CALL    OUT_AX

    LEA     SI,[RE_OUTPUT]
    CALL    OUTPUT
    MOV     AL,[RETRY]
    CALL    OUT_AX

    RET

ENDP    CURRENT_POSITION

;*****************************************************************************

;*****************************************************************************

PROC    READ_TRACK


    CALL    ADJUST_DISK_BASE
    MOV     AH,02h
    MOV     AL,[SECTORS]
    MOV     BX,SECTOR_BUFFER
    MOV     CH,[CUR_TRACK]
    MOV     CL,1
    MOV     DH,[CUR_HEAD]
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE

    RET

ENDP    READ_TRACK

;*****************************************************************************

;*****************************************************************************

PROC    WRITE_TRACK_DATA

    MOV     AH,40h
    MOV     BX,[W_HANDLE]
    MOV     CX,[TRACK_BYTES]
    MOV     DX,SECTOR_BUFFER
    INT     21h

    RET

ENDP    WRITE_TRACK_DATA

;*****************************************************************************

;*****************************************************************************

PROC    CLOSE_FILES

    CMP     [WRITE_FILE],TRUE
    JNE     CF_CONT

    MOV     AH,3Eh
    MOV     BX,[W_HANDLE]
    INT     21h

CF_CONT:
    CMP     [READ_FILE],TRUE
    JNE     CF_END

    MOV     AH,3Eh
    MOV     BX,[R_HANDLE]
    INT     21h

CF_END:
    RET

ENDP    CLOSE_FILES

;*****************************************************************************

;*****************************************************************************

PROC    FORMAT_TRACK

    CALL    ADJUST_DISK_BASE
    MOV     CL,[SECTORS]
    XOR     CH,CH
    MOV     SI,SCRATCH_PAD
    MOV     DI,ALT_SCRATCH_PAD
    CLD

TAF_LOOP:
    MOV     AL,[CUR_TRACK]
    MOV     AH,[CUR_HEAD]
    STOSW
    LODSB
    MOV     AH,[SECTOR_SIZE]
    STOSW
    LOOP    TAF_LOOP

    CLD
    MOV     AH,05h
    MOV     BX,ALT_SCRATCH_PAD
    XOR     CL,CL
    MOV     CH,[CUR_TRACK]
    MOV     DH,[CUR_HEAD]
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE
    RET

ENDP    FORMAT_TRACK

;*****************************************************************************

;*****************************************************************************

PROC    WRITE_TRACK

    CALL    ADJUST_DISK_BASE
    MOV     AH,03
    MOV     AL,[SECTORS]
    MOV     BX,SECTOR_BUFFER
    MOV     CH,[CUR_TRACK]
    MOV     CL,1
    MOV     DH,[CUR_HEAD]
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE

    RET

ENDP    WRITE_TRACK

;*****************************************************************************

;*****************************************************************************

PROC    READ_TRACK_DATA

    MOV     AH,3Fh
    MOV     BX,[R_HANDLE]
    MOV     CX,[TRACK_BYTES]
    MOV     DX,SECTOR_BUFFER
    INT     21h
    JC      RTD_END

    CMP     AX,[TRACK_BYTES]
    JNC     RTD_END

    MOV     AL,133

RTD_END:
    RET

ENDP    READ_TRACK_DATA

;*****************************************************************************

;*****************************************************************************

PROC    VERIFY_TRACK

    CLD
    CALL    ADJUST_DISK_BASE
    MOV     AH,04h
    MOV     AL,[SECTORS]
    MOV     CH,[CUR_TRACK]
    MOV     CL,1
    MOV     DH,[CUR_HEAD]
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE
    RET

ENDP    VERIFY_TRACK

;*****************************************************************************

;*****************************************************************************

PROC    DISPLAY_ERROR

    PUSH    AX
    PUSH    DX
    PUSH    SI

    CMP     [ERROR_LOCATION],"I"
    JE      IS_INT13_ERROR
    CMP     [ERROR_LOCATION],"F"
    JNE     NOT_DOS_FILE_ERROR
    JMP     NEAR    IS_DOS_FILE_ERROR

NOT_DOS_FILE_ERROR:
    CMP     [ERROR_LOCATION],"M"
    JNE     IS_PARAMETER_ERROR
    JMP     NEAR    IS_DOS_MEMORY_ERROR

IS_PARAMETER_ERROR:
    MOV     SI,OFFSET PARAMETER_ERRORS
    JMP     NEAR   DO_DE

IS_INT13_ERROR:
    MOV     AL,[ERROR_CODE]
    CMP     AL,5
    JB      DO_I_MUL

    DEC     AL
    CMP     AL,6
    JB      DO_I_MUL

    DEC     AL
    CMP     AL,8
    JB      DO_I_MUL

    SUB     AL,2
    CMP     AL,9
    JB      DO_I_MUL

    SUB     AL,3
    CMP     AL,10
    JB      DO_I_MUL

    SUB     AL,15
    CMP     AL,11
    JB      DO_I_MUL

    SUB     AL,31
    CMP     AL,12
    JB      DO_I_MUL

    SUB     AL,63

DO_I_MUL:
    DEC     AL
    MOV     DL,40
    MUL     DL
    ADD     AX,OFFSET FORMAT_ERRORS
    MOV     SI,AX
    JMP     NEAR    DO_DE

IS_DOS_FILE_ERROR:
    MOV     AL,[ERROR_CODE]
    SUB     AL,129
    MOV     DL,40
    MUL     DL
    ADD     AX,OFFSET FILE_ERRORS
    MOV     SI,AX
    JMP     NEAR    DO_DE

IS_DOS_MEMORY_ERROR:
    MOV     AL,[ERROR_CODE]
    SUB     AL,135
    MOV     DL,40
    MUL     DL
    ADD     AX,OFFSET MEMORY_ERRORS
    MOV     SI,AX

DO_DE:
    CALL    OUTPUT

    POP     SI
    POP     DX
    POP     AX
    RET

ENDP    DISPLAY_ERROR

;*****************************************************************************

;*****************************************************************************

PROC    WRITE_OS_INFO

    CMP     [OS],0
    JE      SHORT END_WOSI

    CMP     [OS],1
    JA      SHORT END_WOSI

    MOV     AH,09h
    MOV     DX,OFFSET OS_INFO_MSG
    INT     21h

    CALL    WRITE_DOS_INFO
    CMP     [ERROR_CODE],0
    JNE     END_WOSI

    MOV     AH,09h
    MOV     DX,OFFSET OS_INFO_MSG2
    INT     21h

END_WOSI:
    RET

ENDP    WRITE_OS_INFO

;*****************************************************************************

;*****************************************************************************

PROC    WRITE_DOS_INFO

    MOV     CL,[FATS]
    MOV     [DB_NUM_FATS],CL
    MOV     CL,[CLUSTER_SIZE]
    MOV     [DB_CSIZE],CL
    MOV     AL,[SECTORS]
    MOV     BL,[HEADS]
    MUL     BL
    MOV     BX,[WORD PTR TRACKS]
    MUL     BX
    MOV     [DB_NUM_SECTORS],AX
    XOR     DX,DX
    XOR     CH,CH
    DIV     CX
    OR      DX,DX
    JZ      DIVIDES_EVEN

    INC     AX

DIVIDES_EVEN:
    MOV     BX,AX
    CLC
    RCR     BX,1
    JNC     IS_EVEN

    INC     BX

IS_EVEN:
    ADD     AX,BX
    XOR     DX,DX
    MOV     BL,[SECTOR_SIZE]
    XOR     BH,BH
    SHL     BX,1
    MOV     CX,[SECTOR_TYPES+BX]
    MOV     [DB_SSIZE],CX
    DIV     CX
    OR      DX,DX
    JZ      IS_MULTIPLE

    INC     AX

IS_MULTIPLE:
    MOV     [DB_FAT_SECTORS],AX
    MOV     AX,[MAX_ROOT_ENT]
    MOV     [DB_MAX_DIR_ENT],AX
    XOR     AH,AH
    MOV     AL,[SECTORS]
    MOV     [DB_SECTORS],AX
    MOV     AL,[HEADS]
    MOV     [DB_HEADS],AX
    MOV     AL,[DRIVE]
    MOV     [DB_DRIVE],AL
    CMP     [PROMPT],TRUE
    JNE     USE_DEFAULT_SN

    CALL    GET_SERIAL_NUMBER

USE_DEFAULT_SN:
    MOV     [RETRY],0

ERROR_REENTRY:
    MOV     AX,[DB_MAX_DIR_ENT]
    MOV     CX,32
    MUL     CX
    MOV     CX,[DB_SSIZE]
    DIV     CX
    OR      DX,DX
    JZ      MAX_ENTRIES_OK

    INC     [DB_MAX_DIR_ENT]
    JMP     ERROR_REENTRY

MAX_ENTRIES_OK:
    MOV     BX,AX
    MOV     CX,[DB_FAT_SECTORS]
    MOV     AL,[DB_NUM_FATS]
    XOR     AH,AH
    MUL     CX

    ADD     AX,BX
    INC     AX
    CALL    ZERO_DOS_TABLES
    JC      WDOSI_ERROR

    CALL    ADJUST_DISK_BASE
    MOV     BX,OFFSET DOS_BOOT
    MOV     AX,0301h
    MOV     CX,0001h
    MOV     DH,00h
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE
    JC      WDOSI_ERROR

    MOV     DI,SECTOR_BUFFER
    MOV     AL,[DB_MEDIA_TYPE]
    MOV     AH,0FFh
    STOSW
    MOV     AL,AH
    STOSB

    MOV     CL,[DB_NUM_FATS]
    XOR     CH,CH
    MOV     AX,0002h

WRITE_FATS_LOOP:
    CALL    WRITE_FAT_SECTOR
    JC      WDOSI_ERROR

    ADD     AX,[DB_FAT_SECTORS]
    LOOP    WRITE_FATS_LOOP

    JMP     SHORT   END_WDOSI

WDOSI_ERROR:
    INC     [RETRY]
    MOV     BL,[RETRIES]
    CMP     [RETRY],BL
    JAE     NO_RETRY
    JMP     NEAR    ERROR_REENTRY

NO_RETRY:
    MOV     [ERROR_LOCATION],"I"
    MOV     [ERROR_CODE],AH
    CALL    DISPLAY_ERROR

END_WDOSI:
    RET

ENDP    WRITE_DOS_INFO

;*****************************************************************************

;*****************************************************************************

PROC    GET_SERIAL_NUMBER

    LEA     SI,[GSN_STRING]
    CALL    OUTPUT

    LEA     DI,[DB_SERIAL_NUM+3]
    MOV     AL,8
    CALL    IN_HEXSTRING

    LEA     SI,[RETURN]
    CALL    OUTPUT
    CALL    OUTPUT

    RET

ENDP    GET_SERIAL_NUMBER

;*****************************************************************************

;*****************************************************************************

LAST_WRITE  DB  FALSE

PROC    ZERO_DOS_TABLES

    PUSH    AX

    MOV     CL,[SECTORS]
    XOR     CH,CH
    MOV     AX,[DB_SSIZE]
    MUL     CX
    SHR     AX,1
    MOV     CX,AX
    MOV     DI,SECTOR_BUFFER
    XOR     AX,AX
    REP     STOSW

    POP     [SECTORS_LEFT]
    MOV     [CUR_HEAD],0
    MOV     [CUR_TRACK],0
    MOV     [LAST_WRITE],FALSE

ZDT_LOOP:
    MOV     CL,[SECTORS]
    XOR     CH,CH
    CMP     CX,[SECTORS_LEFT]
    JB      NOT_LAST_WRITE

    MOV     CX,[SECTORS_LEFT]
    MOV     [LAST_WRITE],TRUE

NOT_LAST_WRITE:
    CALL    ADJUST_DISK_BASE
    MOV     AL,CL
    MOV     AH,03
    MOV     BX,SECTOR_BUFFER
    MOV     CL,1
    MOV     CH,[CUR_TRACK]
    MOV     DH,[CUR_HEAD]
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE
    JC      ZDT_ERROR

    CMP     [LAST_WRITE],TRUE
    JE      WAS_LAST_WRITE

    MOV     AL,[SECTORS]
    XOR     AH,AH
    SUB     [SECTORS_LEFT],AX

    INC     [CUR_HEAD]
    MOV     AL,[HEADS]
    CMP     [CUR_HEAD],AL
    JB      ZDT_LOOP

    MOV     [CUR_HEAD],0
    INC     [CUR_TRACK]
    JMP     SHORT   ZDT_LOOP

WAS_LAST_WRITE:
    CLC

ZDT_ERROR:
    RET

ENDP    ZERO_DOS_TABLES

;*****************************************************************************

;*****************************************************************************

PROC    WRITE_FAT_SECTOR

    PUSH    AX
    PUSH    CX

    MOV     [SECTORS_LEFT],AX
    MOV     [CUR_HEAD],0
    MOV     [CUR_TRACK],0

WFS_LOOP:
    MOV     AL,[SECTORS]
    XOR     AH,AH
    CMP     [SECTORS_LEFT],AX
    JBE     DO_WFS

    SUB     [SECTORS_LEFT],AX
    INC     [CUR_HEAD]
    MOV     AL,[HEADS]
    CMP     [CUR_HEAD],AL
    JB      WFS_LOOP

    MOV     [CUR_HEAD],0
    INC     [CUR_TRACK]
    JMP     SHORT   WFS_LOOP

DO_WFS:
    CALL    ADJUST_DISK_BASE
    MOV     AX,0301h
    MOV     BX,SECTOR_BUFFER
    MOV     CH,[CUR_TRACK]
    MOV     CL,[BYTE PTR SECTORS_LEFT]
    MOV     DH,[CUR_HEAD]
    MOV     DL,[DRIVE]
    INT     13h
    CALL    RESTORE_DISK_BASE

    POP     CX
    POP     AX
    RET

ENDP    WRITE_FAT_SECTOR

;*****************************************************************************

;*****************************************************************************

PROC    FIX_DISK_BASE

    PUSH    ES

    MOV     AH,08h
    MOV     DL,[DRIVE]
    INT     13h
    JC      IS_525LD

    CMP     BL,1
    JE      IS_525LD

    CMP     BL,3
    JNE     NOT_DDDRIVE
    JMP     NEAR    IS_35LD

NOT_DDDRIVE:
    CMP     BL,2
    JNE     IS_35HD

    CMP     [MEDIA],0
    JNE     IS_525HDDD

    MOV     AX,1703h
    MOV     DL,[DRIVE]
    INT     13h

    MOV     AH,18h
    MOV     CH,4Fh
    MOV     CL,0Fh
    MOV     DL,[DRIVE]
    INT     13h

    MOV     [SPECIFY1],0DFh
    MOV     [SECSPCYL],0Fh
    MOV     [FORMGAP],54h
    JMP     NEAR    END_FDB

IS_525HDDD:
    MOV     AX,1702h
    INT     13h

    MOV     AH,18h
    MOV     CH,27h
    MOV     CL,09h
    MOV     DL,[DRIVE]
    INT     13h

IS_525LD:
    MOV     [DB_MEDIA_TYPE],0FDh
    MOV     [LASTCYL],27h
    MOV     [UNK_BYTE],40h
    JMP     SHORT   PUT_DD_BASE

IS_35HD:
    CMP     [MEDIA],1
    JE      IS_35HDDD

    XOR     DX,DX
    MOV     ES,DX
    MOV     DI,0490h
    MOV     DL,[DRIVE]
    XOR     DH,DH
    ADD     DI,DX
    CMP     DI,0491h
    JA      SET_MT

    MOV     DH,[BYTE PTR ES:DI]
    AND     DH,01111111b
    MOV     [BYTE PTR ES:DI],DH

SET_MT:
    MOV     AH,18h
    MOV     CH,4Fh
    MOV     CL,12h
    MOV     DL,[DRIVE]
    INT     13h
    JMP     SHORT   END_FDB

IS_35HDDD:
    MOV     AX,1704h
    MOV     DL,[DRIVE]
    INT     13h

    MOV     AH,18h
    MOV     CH,4Fh
    MOV     CL,09h
    MOV     DL,[DRIVE]
    INT     13h

IS_35LD:
    MOV     [DB_MEDIA_TYPE],0F9h
    MOV     [UNK_BYTE],80h

PUT_DD_BASE:
    MOV     [SECSPCYL],09h
    MOV     [FORMGAP],50h
    MOV     [SPECIFY1],0DFh
    MOV     [GAP],2Ah
    JMP     SHORT   END_FDB

END_FDB:
    POP     ES
    RET

ENDP    FIX_DISK_BASE

;*****************************************************************************

;*****************************************************************************

LABEL   NEW_DISK_BASE   BYTE
SPECIFY1    DB  0AFh
SPECIFY2    DB  02h
MOTIME      DB  25h
DBSECSIZE   DB  02h
SECSPCYL    DB  12h
GAP         DB  1Bh
DATALEN     DB  0FFh
FORMGAP     DB  6Ch
FILLBYTE    DB  0F6h
HEADSETT    DB  0Fh
MOTORSU     DB  08h
LASTCYL     DB  4Fh
UNK_BYTE    DB  00h

OLD_BASE_TABLE  DD  0

PROC    ADJUST_DISK_BASE

    PUSH    AX
    PUSH    BX
    PUSH    ES

    XOR     BX,BX
    MOV     ES,BX
    MOV     BX,(1Eh*4)

    MOV     AX,[WORD PTR ES:BX]
    MOV     [WORD PTR OLD_BASE_TABLE],AX
    MOV     AX,[WORD PTR ES:BX+2]
    MOV     [WORD PTR OLD_BASE_TABLE+2],AX
    MOV     AX,OFFSET NEW_DISK_BASE
    MOV     [WORD PTR ES:BX],AX
    MOV     AX,CS
    MOV     [WORD PTR ES:BX+2],AX

    MOV     AL,[SECTOR_SIZE]
    MOV     [DBSECSIZE],AL
    MOV     AL,[SECTORS]
    MOV     [SECSPCYL],AL
    MOV     AL,[GAP_LENGTH]
    MOV     [FORMGAP],AL
    MOV     AL,[TRACKS]
    DEC     AL
    MOV     [LASTCYL],AL

    POP     ES
    POP     BX
    POP     AX
    RET

ENDP    ADJUST_DISK_BASE

;*****************************************************************************

;*****************************************************************************

PROC    RESTORE_DISK_BASE

    PUSH    AX
    PUSH    BX
    PUSH    ES

    MOV     BX,0
    MOV     ES,BX
    MOV     BX,(1Eh*4)

    MOV     AX,[WORD PTR OLD_BASE_TABLE]
    MOV     [WORD PTR ES:BX],AX
    MOV     AX,[WORD PTR OLD_BASE_TABLE+2]
    MOV     [WORD PTR ES:BX+2],AX

    POP     ES
    POP     BX
    POP     AX
    RET

ENDP    RESTORE_DISK_BASE

;*****************************************************************************

;*****************************************************************************

PROC    FORMATTER

    LEA     SI,[RETURN]
    CALL    OUTPUT

    CMP     [PROMPT],TRUE
    JNE     NO_PROMPT

    LEA     SI,[USER_PROMPT_1A]
    CALL    OUTPUT

    MOV     AL,[DRIVE]
    XOR     AH,AH
    CALL    OUT_AX

    LEA     SI,[USER_PROMPT_1B]
    CALL    OUTPUT

    CALL    INCHAR

NO_PROMPT:
    MOV     [READ_END],FALSE

    MOV     AL,[SECTORS]
    MOV     BL,[SECTOR_SIZE]
    XOR     BH,BH
    SHL     BX,1
    MOV     CX,[SECTOR_TYPES+BX]
    XOR     AH,AH
    MUL     CX
    MOV     [TRACK_BYTES],AX

    CMP     [QUICK],TRUE
    JNE     DO_FORMAT

    JMP     NEAR    WRITE_OSI

DO_FORMAT:
    CALL    FIX_DISK_BASE
    CALL    FIGURE_INTERLEAVE

    MOV     [CUR_TRACK],0

TRACK_LOOP:
    MOV     [CUR_HEAD],0

HEAD_LOOP:
    MOV     [RETRY],0

RETRY_ENTRY:
    CMP     [WRITE_FILE],TRUE
    JNE     NO_READ

    LEA     SI,[READ_OUTPUT]
    CALL    OUTPUT
    CALL    CURRENT_POSITION
    CALL    READ_TRACK
    JNC     DO_WT
    JMP     NEAR    FORMAT_ERROR

DO_WT:
    CALL    WRITE_TRACK_DATA
    JC      FILE_PROBLEM
    JMP     NEAR    NO_VERIFY

FILE_PROBLEM:
    JMP     NEAR    F_ERROR

NO_READ:
    CMP     [DISKCOPY_ONLY],TRUE
    JE      FTRACK_OK

    LEA     SI,[FORM_OUTPUT]
    CALL    OUTPUT
    CALL    CURRENT_POSITION
    CALL    FORMAT_TRACK
    JNC     FTRACK_OK
    JMP     NEAR    FORMAT_ERROR

FTRACK_OK:
    CMP     [READ_FILE],TRUE
    JNE     NO_WRITE
    CMP     [READ_END],FALSE
    JNE     NO_WRITE

    LEA     SI,[WRIT_OUTPUT]
    CALL    OUTPUT
    CALL    CURRENT_POSITION
    CALL    READ_TRACK_DATA
    JNC     READ_TD_OK

    CALL    CLOSE_FILES
    MOV     [READ_END],TRUE

READ_TD_OK:
    CALL    WRITE_TRACK
    JC      FORMAT_ERROR

NO_WRITE:
    CMP     [VERIFY],TRUE
    JNE     NO_VERIFY

    LEA     SI,[VERI_OUTPUT]
    CALL    OUTPUT
    CALL    CURRENT_POSITION
    CALL    VERIFY_TRACK
    JC      FORMAT_ERROR

NO_VERIFY:
    INC     [CUR_HEAD]
    MOV     AL,[HEADS]
    CMP     [CUR_HEAD],AL
    JNB     CYL_END
    JMP     NEAR    HEAD_LOOP

CYL_END:
    INC     [CUR_TRACK]
    MOV     AL,[TRACKS]
    CMP     [CUR_TRACK],AL
    JAE     F_COMPLETE
    JMP     NEAR    TRACK_LOOP

F_COMPLETE:
    CMP     [WRITE_FILE],TRUE
    JNE     WASNT_READ

    LEA     SI,[READ_COMPLETE]
    CALL    OUTPUT
    JMP     SHORT   END_FORMATTER

WASNT_READ:
    CMP     [DISKCOPY_ONLY],TRUE
    JNE     WAS_FORMATTED

    LEA     SI,[WRITE_COMPLETE]
    CALL    OUTPUT
    JMP     SHORT   END_FORMATTER

WAS_FORMATTED:
    LEA     SI,[FORMAT_COMPLETE]
    CALL    OUTPUT

    CMP     [READ_FILE],TRUE
    JE      END_FORMATTER

WRITE_OSI:
    CALL    WRITE_OS_INFO
    JMP     SHORT   END_FORMATTER

F_ERROR:
    OR      AL,10000000b
    MOV     [ERROR_CODE],AL
    MOV     [ERROR_LOCATION],"F"
    CALL    DISPLAY_ERROR
    JMP     NEAR    END_FORMATTER

FORMAT_ERROR:
    INC     [RETRY]
    MOV     BL,[RETRIES]
    CMP     [RETRY],BL
    JA      NO_MORE_RETRIES

    XOR     AH,AH
    MOV     DL,[DRIVE]
    INT     13h
    JMP     NEAR    RETRY_ENTRY

NO_MORE_RETRIES:
    MOV     [ERROR_CODE],AH
    MOV     [ERROR_LOCATION],"I"
    CALL    DISPLAY_ERROR

END_FORMATTER:
    CALL    CLOSE_FILES
    RET

ENDP    FORMATTER

;*****************************************************************************

ALIGN   16

;*****************************************************************************

PROC    DOS_BOOT

    JMP     NEAR    DB_START

SYSTEM_NAME     DB "AIDOS5.0"

LABEL   BPB     BYTE
DB_SSIZE        DW 512
DB_CSIZE        DB 1
DB_SECTORS_RES  DW 1
DB_NUM_FATS     DB 2
DB_MAX_DIR_ENT  DW 64
DB_NUM_SECTORS  DW 3200
DB_MEDIA_TYPE   DB 0F0h
DB_FAT_SECTORS  DW 10
DB_SECTORS      DW 20
DB_HEADS        DW 2
DB_SECTORS_HID  DD 0
DB_32_NUM_SEC   DD 0
DB_DRIVE        DB 0
                DB 0
DB_EXT_SIGN     DB 29h
DB_SERIAL_NUM   DD 77777777h
DB_VOLUME_LABEL DB "NO NAME    "
                DB "FAT12   "

DB_START:
    CLD
    XOR     AX,AX
    MOV     DS,AX
    MOV     ES,AX
    MOV     SI,7C00h
    MOV     DI,7E00h
    MOV     CX,0100h
    REP     MOVSW

    DB      0EAh
    DW      (NEXT_INSTR-DOS_BOOT+7E00h)
    DW      0

NEXT_INSTR:
    MOV     AX,0201h
    MOV     BX,7C00h
    MOV     CX,0001h
    MOV     DX,0080h
    INT     13h
    JC      HD_ERROR

    MOV     SI,7DFEh
    LODSW
    CMP     AX,0AA55h
    JNE     HD_ERROR

    DB      0EAh
    DW      7C00h
    DW      0

MESSAGE:
    DB "* Non-System Disk *",13,10
    DB "----------------------------------------",13,10
    DB "Replace and strike any key when ready...",13,10,0

HD_ERROR:
    MOV     AH,02h
    MOV     BH,0
    MOV     DX,0
    INT     10h
    MOV     SI,((OFFSET MESSAGE-OFFSET DOS_BOOT)+7E00h)

D_LOOP:
    LODSB
    CMP     AL,0
    JE      END_DISPLAY

    MOV     AH,0Eh
    MOV     BX,000Fh
    INT     10h
    JMP     SHORT   D_LOOP

END_DISPLAY:
    XOR     AH,AH
    INT     16h

    INT     19h

ORG     DOS_BOOT+510

                DW  0AA55h

ENDP    DOS_BOOT

;*****************************************************************************

LABEL   END_PROG    BYTE

ENDS    MAIN

END     BEGIN
