IDEAL

SEGMENT MAIN
ASSUME CS:MAIN,DS:MAIN,ES:MAIN,SS:MAIN

UNK     EQU 8003h
DONE    EQU 0100h

NXT_DRVR    DD -1
ATTRIB      DW 08000h
STRATPNTR   DW STRATEGY
INTPNTR     DW INTERRUPT
DRVRNAME    DB "FIXDBTD",0

LABEL REQUEST_HEADER DWORD
RH_OFF      DW 0
RH_SEG      DW 0

OLD_INT_13  DD 0

STRATEGY:
    MOV     [CS:RH_SEG],ES
    MOV     [CS:RH_OFF],BX
    RETF

INTERRUPT:
    CLD
    PUSH    DS
    PUSH    AX
    PUSH    BX
    PUSH    SI

    LDS     SI,[DWORD PTR CS:REQUEST_HEADER]
    MOV     BX,SI
    INC     SI
    INC     SI
    LODSB

    OR      AL,AL
    JZ      IS_INIT

    MOV     AX,UNK
    JMP     SHORT FINISH

IS_INIT:
    CALL    NEAR INIT_DRIVER

FINISH:
    ADD     BX,3
    OR      AX,DONE
    MOV     [BX],AX

    POP     SI
    POP     BX
    POP     AX
    POP     DS
    RETF

NEW_INT_13:
    test    dl,80h
    jnz     short ni13_goon

    cmp     ah,02h
    jb      short ni13_goon

    cmp     ah,04h
    ja      short ni13_goon

    push    bx
    push    ds

    xor     bx,bx
    mov     ds,bx
    mov     bx,0078h

    lds     bx,[dword ptr bx]
    add     bx,4
    mov     [byte ptr bx],40

    pop     ds
    pop     bx

ni13_goon:
    jmp     [dword ptr cs:OLD_INT_13]

EVEN

LABEL   END_DRIVER BYTE

INIT_MSG    DB "FIXDBT:  BIOS Disk Base Table Adjuster - V1.0",13,10
            DB "Artists of the Imagination, 1996",13,10,"$"

PROC    INIT_DRIVER     NEAR

    PUSH    BX
    PUSH    DX
    PUSH    DS
    PUSH    ES

    PUSH    CS
    POP     DS

    mov     ah,09h
    mov     dx,offset INIT_MSG
    int     21h

    mov     ax,3513h
    int     21h

    mov     [word ptr OLD_INT_13],bx
    mov     bx,es
    mov     [word ptr OLD_INT_13+2],bx

    mov     ax,2513h
    mov     dx,offset NEW_INT_13
    int     21h

    POP     ES
    POP     DS
    POP     DX
    POP     BX

    ADD     BX,14
    MOV     [WORD PTR BX],OFFSET END_DRIVER
    INC     BX
    INC     BX
    MOV     AX,CS
    MOV     [WORD PTR BX],AX
    SUB     BX,16
    XOR     AX,AX

    RET

ENDP    INIT_DRIVER

ENDS    MAIN

END





