/**************************************************************************/
/*                            PATTERN-MATCH UTILITY                       */
/*                                                                        */
/*                                                                        */
/*                                     M\Cooper                           */
/*                                    PO Box 237                          */
/*                            St. David, AZ 85630-0237                    */
/*                        -------------------------------                 */
/*                        Email:  thegrendel@theriver.com                 */
/*                                                                        */
/*                $2.00 to register the entire WORDY package	             */
/*                                                                        */
/**************************************************************************/

#include <conio.h>
#include <ctype.h>
#include "srch.h"
//srch.h (source) is part of the WORDY package


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 40
#define CR "\n"
#define FILE_SUFFIX ".pat"
#define MAXLEN 30
#define MAXWORDLEN 30
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define DBLBAR 205
#define WILDCARD '?'
//Wildcard character in command line, may be changed
#define WRONG_SPECS 10
#define PATTERN_TOO_LONG 20

#define BUFFERSIZE 8192

char ad[] =
"PATTERN MATCH util. : M\\Cooper, PO Box 237, St. David, AZ 85630-0237";

typedef enum { FALSE, TRUE } Boolean;
typedef enum { OFF, ON } Flag;

Boolean qualify( char *In );
void getword( char *lset, char *filename );
void center( char *strng );
Boolean is_valid_word( char *Pattern, char *Word );

void main( int argc, char **argv )
{

   char letterset [MAXLEN],
        iset [5 * MAXLEN],
        filename [FILENAME_MAXLEN];

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts( "Enter a LETTER PATTERN to test [example 1231234] " );
	    gets( iset );
     if( strlen( iset ) >= MAXWORDLEN - 2 )
        {
        printf( "\n\nPattern too long!\n" );
        exit( PATTERN_TOO_LONG );
        }
     strcpy( letterset, iset );
     strcpy( filename, "word.lst" );  //default
	    }
	 else
     if( argc == NOARGS + 1 )
       {
       if( strlen( *(argv +1) ) >= MAXWORDLEN - 2 )
          {
          printf( "\n\nPattern too long!\n" );
          exit( PATTERN_TOO_LONG);
          }
	      strcpy( letterset, *(argv + 1) );
       strcpy( filename, "word.lst" ); //default
       }
   else
      {      
       if( strlen( *(argv +1) ) >= MAXWORDLEN - 2 )
          {
          printf( "\n\nPattern too long!\n" );
          exit( PATTERN_TOO_LONG);
          }
      strcpy( letterset, *(argv + 1) );
      strcpy( filename, *(argv + 2) );
      }

      if( !qualify( letterset ) )
         {
         printf( "\nInput to program must be a string of digits\n" );
         printf( "in *ascending* order, beginning with '1'.\n" );
         printf( "Previously used digits may be repeated.\n" );
         exit( WRONG_SPECS );
         }

	 getword( letterset, filename );
}


/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset           */
/*                 Args in: char *letterset, char *word                   */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

Boolean wordtest( char *letterset, char *word )
{
	Boolean error_flag;
	static char dup_lset[ MAXLEN ];
	register unsigned int cnt = 0,
					  u,
					  v;

	 strcpy( dup_lset, letterset );
		 
	 u = strlen( word );
      v = strlen( letterset );

	 while( ( *letterset == *word ) || *letterset == WILDCARD )
	    {
	    letterset++;
	    word++;
	    cnt++;
	    }

	 if( u <= cnt && u == v )
		error_flag = TRUE;
	 else
		error_flag = FALSE;


		return( error_flag );
}

/**************************************************************************/

void getword( char *letter_set, char *filename )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
		messg [7];

	FILE *fptr,
		*tfile;
	int fnamelen;
	long wcount = 0L;

	   memset( bar, '*', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, DBLBAR, LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
	   strcat ( letter_set, CR );

	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
	   strcpy( targetfile, "matched.pat" );
	   /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open word file %s!", filename );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, 2 * BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 1 );

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 2 );

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take a few seconds...\n" );
	   printf( "Please be patient.\n\n" );
	   printf( "Now searching 100,000+ word file and writing file of valid words.\n\n" );
	   /*****************************************/





	   sprintf( tempstr, "Words fitting the pattern of: %s\n", strupr( l_set ) );
	   center( tempstr );
	   fprintf( tfile, double_bar );
      fprintf( tfile, CR );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( is_valid_word( letter_set, word ) )
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/

		  if( wcount == INCREMENT )
			strcpy( messg, "word" );
		  else
			strcpy( messg, "words" );

		  fprintf( tfile, bar );
      fprintf( tfile, CR );
		  sprintf( tempstr, "%ld %s fit the pattern of %s.",
				 wcount, messg, l_set );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld %s fitting the pattern of %s\7.",
				 targetfile, wcount, messg, l_set );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}


Boolean is_valid_word( char *pattern, char *word )
{
   char letter,
        wd [MAXWORDLEN],
        *index;
   int wlen,
       n,
       cindex = 0;

      strcpy( wd, word );  //wd is working copy of word.
      wlen = strlen( wd );

      for( n = 0; n < wlen; n++ )
         {
         letter = *( wd + n );
         if( !isalpha( letter ) )
            continue;
         cindex++;
         
         while( NULL != ( index = strchr( wd, letter) ) )
              *index = cindex + '0';
         //Replace all instances of that letter with appropriate 'number'.
         }

      if( !strcmp( wd, pattern ) )
          return( TRUE );
      else
          return( FALSE );

}


Boolean qualify( char *Input )
{
   size_t l;
   int i,
       n;
   Flag F [MAXWORDLEN];
      

      for( i = 2; i < MAXWORDLEN; i++ )
         F[i] = OFF;
      F[0] = F[1] = ON;
      l = strlen ( Input );

      for( i = 0; i < l; i++ )
         if( !isdigit( *(Input +i) ) )
            return( FALSE );

      if( *Input != '1' )
         return( FALSE );

      for( i = 1; i < l; i++ )
         {
         n = Input[i] - '0';

         if( F[n] )    //Number already used. Is o.k.
            continue; 

         if( F[n-1] )  //Previous consecutive number already used. Is o.k.
           {
           F[n] = ON;
           continue;
           }
        
           return( FALSE ); //Default.
           }

      return( TRUE );
}
