/*  Project gdi_demo
    
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    gdi_demo.exe Application
    FILE:         gd_dmwnd.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of gdi_demoWindow (TWindow).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "gd_dmapp.h"

#include "gd_dmwnd.h"

#include <stdio.h>


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(gdi_demoWindow, TWindow)
//{{gdi_demoWindowRSP_TBL_BEGIN}}
//{{gdi_demoWindowRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{gdi_demoWindow Implementation}}


//////////////////////////////////////////////////////////
// gdi_demoWindow
// ==========
// Construction/Destruction handling.
gdi_demoWindow::gdi_demoWindow (TWindow* parent, const char far* title, TModule* module)
    : TWindow(parent, title, module)
{
    // INSERT>> Your constructor code here.

}


gdi_demoWindow::~gdi_demoWindow ()
{
    Destroy();

    // INSERT>> Your destructor code here.

}
#include "kh_gdi\bgipaint.h"

class Demo : public KH_Paint
	 {
	 public:
		  void demo();
		  void bird();
		  void dn(int, int);
		  void wing(int, int);
		  void pero(int, int, int);
		  void calendar(int left, int top, int year, bool visocose);
		  int mon(int x, int y, char* mon, int first_day, int num_of_days);
	 };
///////////////////
void Demo::demo()
	 {
	 set_add_zoom(1,1);          // For all picture

	 setfillstyle(SOLID_FILL, WHITE);
	 set_fill(ON);
	 set_zoom(0.1, 0.05);       // To the next "zoom" call
	 rectangle(0, 0, 5000, 10000);

	 set_scroll(800, 500);
	 bird();
	 set_scroll(0, 500);
	 set_zoom(0.35, 0.33);

	 setcolor(BLACK);
	 load("trip.chr");
// Parameters: left, top, year, 0 if not visocose (1980 was)
	 calendar(80, 120, 1995, 0);

	 char s[] = { "  KNOW-HOW.GDI 1.0" };
	 load("lcom.chr");
	 set_scroll(0, 0);
	 set_zoom(1, 1);
	 setcolor(GREEN);
	 for(int i = 0; i < strlen(s); i++)
		  {
		  rotate(loc(250, 250), 180 - 180 / strlen(s) * i);
		  draw_char(480, 250, s[i], 0);
		  }
	 rotate(0,0,0);
	 }
/////////////////
void Demo::calendar(int l, int t, int year, bool v)
	 {
	 int day = 7;              // for 1995
	 if(year == 1996)          // add cone for other years or use some
	day = 1;              // calculations
	 int x = l;
	 int y = t + 15;
	 for(int i = 1; i <= 3; i++)
	{
	outtextxy(x, y, "Mo");
	y += 30;
	outtextxy(x, y, "Tu");
	y += 30;
		  outtextxy(x, y, "We");
		  y += 30;
		  outtextxy(x, y, "Th");
		  y += 30;
		  outtextxy(x, y, "Fr");
		  y += 30;
		  outtextxy(x, y, "Sa");
		  y += 30;
		  outtextxy(x, y, "Su");

		  y += 100;
		  }
	 x = l + 100;
	 y = t - 30;
	 day = mon(x, y, "January", day, 31);
	 int dv = v == 0 ? 28 : 29;

	 day = mon(x + 340, y, "February", day, dv);
	 day = mon(x + 680, y, "March", day, 31);
	 day = mon(x + 1020, y, "April", day, 30);
	 day = mon(x, y +280, "May", day, 31);
	 day = mon(x + 340, y + 280, "June", day, 30);
	 day = mon(x + 680, y + 280, "July", day, 31);
	 day = mon(x + 1020, y + 280, "August", day, 31);
	 day = mon(x, y + 560, "September", day, 30);
	 day = mon(x + 340, y + 560, "October", day, 31);
	 day = mon(x + 680, y + 560, "November", day, 30);
	 day = mon(x + 1020, y + 560, "December", day, 31);
	 }
//////////////
int Demo::mon(int x1, int y1, char* head, int start, int num)
	 {
	 set_fill(ON);
	 setfillstyle(SOLID_FILL, WHITE);
	 outtextxy(x1 + 60, y1, head);
	 int days = 1;
	 int ln = start;
	 y1 += 15;

	 char s[10];
	 while(1)
		  {
		  if(days > num)
				return ln;
		  if(ln > 7)
				{
				x1 += 50;
				ln = 1;
				continue;
				}
		  outtextxy(x1, y1 + 30 * ln, itoa(days, s, 10));
		  days++;
	ln++;
		  }
	 }
////////////////
void Demo::bird()
	 {
	 set_zoom(0.1, 0.05);       // To the next "zoom" call
	 setlinestyle(1, SOLID_LINE);
	 setcolor(BLUE);
	 setfillstyle(SOLID_FILL, YELLOW);

    int dy = 30;
    for(int i = 1; i <= 12; i++)
		  {
        ellipse(1600, 800 + 2 * dy * i, 0, 360, dy * i, dy * i);
        ellipse(1600, 2300 - 2 * dy * i, 0, 360, dy * i, dy * i);
        }
    dn(1800, 1800);
    wing(1900, 1400);
    set_mirror(1600);
    dn(1800, 1800);
	 wing(1900, 1400);
	 set_mirror(0);

    rotate(loc(0, 0), 0);
    ellipse(1600, 700, 0, 360, 360, 360);
    for(i = 0; i <= 60; i++)
	{
        pero(1800, 700, 1);
        rotate(loc(1600, 700), 6 * i);
		  }
    rotate(loc(1600, 2000), -90);
    pero(1600, 2000, 7);
    rotate(loc(1600, 2000), -100);
    pero(1600, 2000, 5);
    rotate(loc(1600, 2000), -80);
    pero(1600, 2000, 5);

	 rotate(loc(0, 0), 0);

    ellipse(1700, 600, 0, 360, 60, 130);
    ellipse(1500, 600, 0, 360, 60, 130);
    ellipse(1700, 600, 0, 360, 60, 60);
    ellipse(1500, 600, 0, 360, 60, 60);
    ellipse(1600, 800, 0, 360, 20, 90);
    }
//////////////////
void Demo::wing(int xwin, int ywin)
    {
    for(int i = 0; i <= 10; i++)
        {
        rotate(xwin, ywin, 20 * i - 120);
        pero(xwin, ywin, i / 2);
        }
    set_zoom(0.1, 0.05);
	 }
/////////////////
void Demo::dn(int xdn, int ydn)
    {
    rotate(xdn + 40, ydn + 40, -180);
    for(int i = 0; i <= 19; i++)
        {
	rotate(xdn + 40, ydn + 40, 20 * i);
        pero(xdn, ydn, 1);
		  }
    }
/////////////////
void Demo::pero(int x, int y, int sz)
    {
    int x1 = x + 40 * sz;
    int x2 = x + 100 * sz;
    int x3 = x + 230 * sz;
	 int x4 = x + 300 * sz;
	 int y1 = y - 20 * sz;
	 int y2 = y - 30 * sz;
	 int y3 = y + 20 * sz;
	 int y4 = y + 30 * sz;
	 int points[] = {  x1, y, x2, y1, x3, y2, x4, y, x3, y4, x2, y3, x1, y };
	 fillpoly(7, points);
	 line(x, y, x + 300, y);
	 }
/////

void gdi_demoWindow::Paint (TDC& dc, bool erase, TRect& rect)
{
	 TWindow::Paint(dc, erase, rect);

	 // INSERT>> Your code here.


	 Demo* demo = new Demo();
	 demo->DC = dc;
	 demo->demo();
	 delete demo;

/*
	 int getx() { POINT p; ::GetCurrentPositionEx(DC, &p); return p.x; }
	 int gety() { POINT p; ::GetCurrentPositionEx(DC, &p); return p.y; }
	 COLORREF getcolorref() { return color; }
	 int getcolor(COLORREF col);
	 int getcolor() { return getcolor(color); }

	 void setcolor(int r, int g, int b)	{ color = RGB(r,g,b); }
	 void setcolor(int c)
	{ color = tricolors[c].colorref; }

	 void putpixel(int x, int y) { ::SetPixel(DC, x, y, getcolorref()); }
    void setlinestyle(int width, int style)
	{ PenSize = width; PenStyle = style; }
    void setlinestyle(int style, unsigned int, int width)
	{ PenSize = width; PenStyle = style; }

    void setfillstyle(int style, int col)
	{
	pattern_num = style;
	fill_color = col;
	BrushColor = tricolors[col].colorref;
	}
    void setfillstyle(int style, COLORREF col)
	{
	pattern_num = style;
	BrushColor = col;
	}

    void moveto(int x, int y) { ::MoveTo(DC, x, y); }
    void lineto(int x, int y);
    void fillpoly(int numpoints, int* polypoints);
    void drawpoly(int numpoints, int far* points);

//////////////////////////////////////////////////////////////
        int getx();
        int gety();
	loc get_CP();
	void putpixel(int x, int y);
	void line(int xstart, int ystart, int xend, int yend)
	    { moveto(xstart, ystart); lineto(xend, yend); }

	void lineto(int x, int y);
	void moveto(int x, int y);
	void circle(int x, int y, int radius)
            { ellipse(x, y, 0, 360, radius, radius); }
	void ellipse(int x, int y, int stangle, int endangle, int xr, int yr);
	void rectangle(int left, int top, int right, int bottom);
	void drawpoly(int numpoints, int far* points);
	void fillpoly(int numpoints, int far* points)
	    { int f = fill; fill = ON; drawpoly(numpoints, points);
	    fill = f; }
	void bar3d(int l, int t, int r, int b, int d, int top);
	virtual void outtext(char* str, int dir = 0);
	void set_fill(int state) { fill = state; }


*/
}


