//  Metal Textures for Polyray
//  by Dan Farmer

static define gold_color      <0.5, 0.35, 0.25>
static define new_brass_color <0.70, 0.56, 0.37>
static define copper_color    <0.6, 0.45, 0.4>
static define silver1_color   <0.94, 0.93, 0.83>
static define silver2_color   <0.94, 0.93, 0.86>
static define silver3_color   <0.94, 0.93, 0.90>
static define aluminum_color  <0.55, 0.5, 0.45>
static define bronze_color    <0.36, 0.28, 0.20>

static define silver1 
texture {
  surface {
    color silver1_color
    specular silver2_color, 0.85
    ambient 0.2
    diffuse 0.35
    microfacet Gaussian 20
    reflection 0.45
  }
}

//Microfacet kinds: Blinn, Cook, Gaussian, Phong, Reitz.
static define new_penny 
texture {
  surface {
    color copper_color
    specular copper_color, 0.85
    ambient 0.1
    diffuse 0.65
    microfacet Cook 12
    reflection 0.45
  }
}

static define brass1 
texture {
  surface {
    color new_brass_color
    specular new_brass_color, 0.65
    ambient 0.1
    diffuse 0.45
    microfacet Cook 12
    reflection 0.45
  }
}

static define gold 
texture {
  surface {
    color gold_color
    specular gold_color, 0.85
    ambient 0.20
    diffuse 0.35
    microfacet Cook 12
    reflection 0.45
  }
}

static define aluminum 
texture {
  surface {
    color aluminum_color
    specular aluminum_color, 0.85
    ambient 0.20
    diffuse 0.35
    microfacet Cook 12
    reflection 0.45
  }
}

static define bronze 
texture {
  surface {
    color bronze_color
    specular bronze_color, 0.85
    ambient 0.20
    diffuse 0.55
    microfacet Cook 12
    reflection 0.45
  }
}

static define shiny_white
texture {
  surface {
    ambient white, 0.2
    diffuse white, 0.8
    specular white, 0.7
    microfacet Reitz 10
  }
}
