/*
 *  ANSI.C
 *
 *  Written by Paul Edwards et al and released to the public 
 *  domain.
 *
 *  Screen definitions & routines using ANSI codes.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#if (defined(MSDOS) || defined(OS2))
#include <conio.h>
#endif

#ifdef UNIX
static int waiting = -1;
#define kbhit() ((waiting != -1) || ((waiting = TTGetKey()) != -1))
#endif

#include "winsys.h"
#include "unused.h"

int vcol, vrow;                 /* cursor position         */
int color;                      /* current color on screen */
int cur_start = 0;
int cur_end = 0;

#ifdef SASC
int akbhit(void);
void devinit(void);
void devfin(void);
#endif

TERM term =
{
#ifdef SASC
    77,
#else
    80,
#endif
#ifdef SASC
    23,
#else
    24,
#endif
    0
};

static char *scrnbuf;
static char *colbuf;

#define EBUFSZ 100
static EVT EVent[EBUFSZ];       /* event circular queue */
static int ebufin = 0;          /* event in */
static int ebufout = 0;         /* event out */

static int mykbhit(void);
static int FullBuffer(void);

int TTScolor(unsigned int Attr)
{
    int offset;

#ifdef SASC
    offset = 3;
#else
    offset = 4;
#endif
    color = Attr;
    printf("\x1b[3%dm", (color + offset) % 8);
    fflush(stdout);
    return 1;
}

int TTBeep(void)
{
    return 1;
}

int TTCurSet(int st)
{
    unused(st);
    return (0);
}

int TTgotoxy(int row, int col)
{
    vrow = row;
    vcol = col;
    printf("\x1b[%d;%dH", row + 1, col + 1);
    fflush(stdout);
    return 1;
}

int TTgetxy(int *row, int *col)
{
    *row = vrow;
    *col = vcol;
    return 1;
}

int TTPutChr(unsigned int Ch)
{
    putchar(Ch & 0xff);
    fflush(stdout);
    scrnbuf[vrow * term.NCol + vcol] = (Ch & 0xff);
    scrnbuf[vrow * term.NCol + vcol] = (Ch & 0xff00U) >> 8;
    return 1;
}

int TTWriteStr(unsigned short *b, int len, int row, int col)
{
    int x;
    int thiscol;

    TTgotoxy(row, col);
    for (x = 0; x < len; x++)
    {
        scrnbuf[vrow * term.NCol + vcol + x] = (*b & 0xff);
        thiscol = (*b & 0xff00U) >> 8;
        colbuf[vrow * term.NCol + vcol + x] = thiscol;
        if (thiscol != color)
        {
            TTScolor(thiscol);
        }
        putchar(*b & 0xff);
        b++;
    }
    TTgotoxy(row, col + len);
    return 1;
}

int TTStrWr(unsigned char *s, int row, int col)
{
    size_t len;

    len = strlen((char *)s);
    TTgotoxy(row, col);
    memcpy(&scrnbuf[vrow * term.NCol + vcol], s, len);
    memset(&colbuf[vrow * term.NCol + vcol], color % 256, len);
    printf("%s", s);
    fflush(stdout);
    TTgotoxy(row, col + len);
    return 1;
}

int TTReadStr(unsigned short *b, int len, int row, int col)
{
    int x;

    for (x = 0; x < len; x++)
    {
        b[x] = scrnbuf[row * term.NCol + col + x];
        b[x] |= colbuf[row * term.NCol + col + x] << 8;
    }
    return 1;
}

int TTScroll(int x1, int y1, int x2, int y2, int lines, int Dir)
{
    int y;
    int diff = x2 - x1 + 1;

    if (Dir)                    /* up */
    {
        while (lines-- > 0)
        {
            for (y = y1; y < y2; y++)
            {
                TTgotoxy(y, x1);
                memcpy(&scrnbuf[y * term.NCol + x1],
                       &scrnbuf[(y + 1) * term.NCol + x1],
                       diff);
                fwrite(&scrnbuf[y * term.NCol + x1], 1, diff, stdout);
            }
        }
        TTgotoxy(y, x1);
        memset(&scrnbuf[y * term.NCol + x1], ' ', diff);
        fwrite(&scrnbuf[y * term.NCol + x1], 1, diff, stdout);
    }
    else
    {
        while (lines-- > 0)
        {
            for (y = y2; y > y1; y--)
            {
                TTgotoxy(y, x1);
                memcpy(&scrnbuf[y * term.NCol + x1],
                       &scrnbuf[(y - 1) * term.NCol + x1],
                       diff);
                fwrite(&scrnbuf[y * term.NCol + x1], 1, diff, stdout);
            }
        }
        TTgotoxy(y, x1);
        memset(&scrnbuf[y * term.NCol + x1], ' ', diff);
        fwrite(&scrnbuf[y * term.NCol + x1], 1, diff, stdout);
    }
    fflush(stdout);
    return 1;
}

int TTClear(int x1, int y1, int x2, int y2)
{
    int x, y;

    for (y = y1; y <= y2; y++)
    {
        TTgotoxy(y, x1);
        for (x = x1; x <= x2; x++)
        {
            putchar(' ');
        }
    }
    TTgotoxy(y1, x1);
    fflush(stdout);
    return 1;
}

int TTEeol(void)
{
    printf("\x1b[2K");
    fflush(stdout);
    return 1;
}

int TTChngRez(int a)
{
    unused(a);
    return 1;
}

int TTdelay(int mil)
{
    unused(mil);
    return (0);
}

unsigned int TTGetKey(void)
{
    unsigned int ch;

#if defined(OS2)
    ch = getch();
#elif defined(UNIX)
    if (waiting != -1)
    {
        ch = waiting;
        waiting = -1;
    }
    else
    {
        ch = getchar();
        if (ch <= 0)
        {
            ch = -1;
        }
    }
#else
    ch = getchar();
#endif
    if (ch == '\n')
    {
        ch = '\r';
    }
    return (ch);
}

void TTSendMsg(unsigned int msg, int x, int y, unsigned int msgtype)
{
    if (((ebufin + 1) % EBUFSZ) != ebufout)
    {
        EVent[ebufin].msg = msg;
        EVent[ebufin].x = x;
        EVent[ebufin].y = y;
        EVent[ebufin].msgtype = msgtype;
        ebufin = (ebufin + 1) % EBUFSZ;
    }
}

int collect_events(int delay)
{
    unused(delay);
    if (mykbhit())
    {
        TTSendMsg(TTGetKey(), 0, 0, WM_CHAR);
    }
    return 0;
}

#ifdef UNIX
#include <unistd.h>
#include <termios.h>

static struct termios oldtios;

#endif

int TTkopen(void)
{
#ifdef UNIX
    struct termios tios;
#endif

#ifdef SASC
    devinit();
#endif  /*  */
#ifdef UNIX
    tcgetattr(0, &tios);
    oldtios = tios;
    tios.c_lflag &= ~ICANON;
    tios.c_lflag &= ~ECHO;
    tios.c_cc[VMIN] = 0;
    tios.c_cc[VTIME] = 0;
    tcsetattr(0, 0, &tios);
    setbuf(stdin, NULL);
#endif
    scrnbuf = malloc(term.NRow * term.NCol);
    colbuf = malloc(term.NRow * term.NCol);
    memset(scrnbuf, ' ', term.NRow * term.NCol);
    memset(colbuf, 11, term.NRow * term.NCol);
    return (0);
}

int TTkclose(void)
{
#ifdef SASC
    devfin();
    printf("\x1b[31m");
#else
    printf("\x1b[37m");
#endif
#ifdef UNIX
    tcsetattr(0, 0, &oldtios);
#endif
    fflush(stdout);
    free(scrnbuf);
    free(colbuf);
    return (0);
}

void MouseOFF(void)
{
}

void MouseON(void)
{
}

void MouseInit(void)
{
}

int GetMouInfo(int *x, int *y)
{
    unused(x);
    unused(y);
    return (0);
}

int TTGetMsg(EVT * e)
{
    while (ebufin == ebufout)
        collect_events(1);

    e->msg = EVent[ebufout].msg;
    e->x = EVent[ebufout].x;
    e->y = EVent[ebufout].y;
    e->msgtype = EVent[ebufout].msgtype;
    e->id = 0;

    ebufout = (ebufout + 1) % EBUFSZ;

    return e->msg;
}

int TTPeekQue(void)
{
    collect_events(0);
    return (ebufin != ebufout);
}

void TTClearQue(void)
{
    ebufin = ebufout;
}

int TTGetChr(void)
{
    EVT e;

    TTGetMsg(&e);
    return e.msg;
}

int TTopen(void)
{
    vcol = vrow = 0;
    color = 0x07;

    TTkopen();
    return 1;
}

int TTclose(void)
{
    TTkclose();
    return 1;
}

static int mykbhit(void)
{
    int ret;

    if (FullBuffer())
    {
        return (0);
    }
#ifdef SASC
    ret = akbhit();
#else
    ret = kbhit();
#endif
    return (ret);
}

int dv_running(void)
{
    return 0;
}

static int FullBuffer(void)
{
    if (((ebufin + 1) % EBUFSZ) != ebufout)
    {
        return (0);
    }
    else
    {
        return (1);
    }
}
