/* This code was posted on a Fidonet echo several years ago (1991?)
   by an unknown person and thus it should really be rewritten by 
   someone who is happy to explicitly declare their work as PD.
   Consider this code to be "copyright but with an allowed-to-use
   license */

#include <proto/exec.h>
#include <proto/dos.h>
#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/ports.h>
#include <exec/libraries.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <devices/serial.h>
extern struct MsgPort *CreatePort();
static int last_ch = -1;
static struct MsgPort *port;
static struct MsgPort *wport;
static struct MsgPort *cport;
static unsigned char rec_buf[1];
static unsigned char write_buf[1];
int agetch(void);
int agetchr(void);
int setmode(int mode);
int akbhit(void);

int agetchr(void)
{
    int c;
    c = agetch();
    if (c == 155)
    {
        c = agetch();
        if (c != -1)
        {
            if (agetch() != -1)
                return (256 + c);
        }
    }
    return (c);
}

#include <exec/types.h>
#include <exec/memory.h>
#include <libraries/dos.h>
#include <libraries/dosextens.h>
#include <stdio.h>
#include <ios1.h>

LONG sendpkt(struct MsgPort * pid, LONG action, LONG args[], LONG nargs)
{
    struct MsgPort *replyport;
    struct StandardPacket *packet;
    LONG count, *pargs, res1;


    replyport = (struct MsgPort *)CreatePort(NULL, 0);
    if (!replyport)
        return (NULL);

    packet = (struct StandardPacket *)
        AllocMem((long)sizeof(struct StandardPacket),
                 MEMF_PUBLIC | MEMF_CLEAR);
    if (!packet)
    {
        DeletePort(replyport);
        return (NULL);
    }

    packet->sp_Msg.mn_Node.ln_Name = (char *)&(packet->sp_Pkt);
    packet->sp_Pkt.dp_Link = &(packet->sp_Msg);
    packet->sp_Pkt.dp_Port = replyport;
    packet->sp_Pkt.dp_Type = action;

    /* copy the args into the packet */
    pargs = &(packet->sp_Pkt.dp_Arg1);  /* address of first argument */
    for (count = 0; count < nargs; count++)
        pargs[count] = args[count];

    PutMsg(pid, (struct Message *)packet);  /* send packet */

    WaitPort(replyport);
    GetMsg(replyport);

    res1 = packet->sp_Pkt.dp_Res1;

    FreeMem((char *)packet, (long)sizeof(struct StandardPacket));
    DeletePort(replyport);

    return (res1);
}

/*
 *  Set console mode: setmode( -1 ) -> raw; setmode( 0 ) -> cooked.
 *  Returns 0 if OK, -1 on failure.
 */
int setmode(int mode)
{
    long myargs[8];
    struct UFB *ufb;
    struct FileHandle *fh;

    ufb = chkufb(0);
    if (ufb == NULL || ufb->ufbfh == NULL)
        return (-1);

    fh = (struct FileHandle *)(ufb->ufbfh << 2);
    myargs[0] = mode;
    sendpkt(fh->fh_Type, ACTION_SCREEN_MODE, myargs, 1);

    return (0);
}


#define GETCH_ECHO  0           /* Set it to 1 if getch is supposed to
                                   echo */

/*
 *  Get a character from the console without waiting for <RETURN>.
 *  Returns EOF on end-of-file or failure.
 *  Assumes the console is set to "raw" mode.
 */
int agetch()
{
    int len;
    unsigned char buf[1];
    struct UFB *ufb;

    ufb = chkufb(0);
    if (ufb == NULL || ufb->ufbfh == NULL)
        return (EOF);

    len = Read(ufb->ufbfh, buf, 1);

    if (len == 0)
        return (EOF);

#if GETCH_ECHO
    printf("%c", buf[0]);
#endif
    return ((int)buf[0]);
}


#define TIMEOUT 1               /* Number of microseconds to wait. */
                  /* Don't use 0, due to a bug in the "timer.device" */
/*
 *  Tests if a character is available to be read from the console.
 *  Returns 1 if there is, 0 if there isn't, and -1 on failure.
 *  Assumes the console is set to "raw" mode.
 */
int akbhit(void)
{
    struct UFB *ufb;

    ufb = chkufb(0);
    if (ufb == NULL || ufb->ufbfh == NULL)
        return (-1);

    return (WaitForChar(ufb->ufbfh, TIMEOUT) ? 1 : 0);
}

void devinit(void)
{
    setmode(-1);
    return;
}

void devfin(void)
{
    setmode(0);
    return;
}
