/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    3987 South Gessner #224
    Houston Tx 77063
    Paul.Elliott@Hrnowl.LoneStar.Org
*/
#ifndef LTPROF
#define LTPROF
#include <istring.hpp>
#include "AProfile.hpp"

#include "ltper.hpp"

// ToStorage is an abstract base class allowing fixed length byte strings
// to be moved to and from some generalized kind of external storage.
// ProfStorage implements this using UICL profiles.

class ProfStorage : public ToStorage
{
  private:
     AProfile profile;                   // Store the application profile.
     IString key;                        // key string for this info.
  public:
     // read from profile.
     virtual void read ( char * buf,int count);

     // Write to profile.
     virtual void write (const char * buf,int count);

     // the information exists in the profile.
     virtual Boolean isInStorage(void)
     {
        return profile.containsKeyName( key );
     };

     // Construct from 3 informations:
     // 1) application name.
     // 2) key for application profile file name in system wide user profile.
     // 3) key for this piece of info.
     ProfStorage(const IString& app_name,const IString& user_file_id,
                 const IString& id );

     // copy from an existing ProfStorage.
     friend class ProfStorage;
     ProfStorage(const ProfStorage& old,const IString& id) :
       profile(old.profile),
       key(id)
     {
     };

};
#endif // LTPROF
