#ifndef NLS_H_INCLUDED
#define NLS_H_INCLUDED


// external data
extern UCHAR AfbDBCS[256];
extern UCHAR AbUpperChars[256];
extern UCHAR AbLowerChars[256];
extern UCHAR AbCollate[256];


// external functions

void nlsInitialize();

PUCHAR nlsSearch(PUCHAR psz, UINT ui);
PUCHAR nlsSearch(PUCHAR pb, UINT ui, UINT cbLength);
PUCHAR nlsSearchCollate(PUCHAR psz, UINT ui);
PUCHAR nlsSearchCollate(PUCHAR pb, UINT ui, UINT cbLength);

PUCHAR nlsSearchLast(PUCHAR psz, UINT ui);
PUCHAR nlsSearchLast(PUCHAR pb, UINT ui, UINT cbLength);
PUCHAR nlsSearchCollateLast(PUCHAR psz, UINT ui);
PUCHAR nlsSearchCollateLast(PUCHAR pb, UINT ui, UINT cbLength);

BOOL nlsIncludeDBCS(PUCHAR psz);
int nlsCountChar(PUCHAR psz);

int nlsCompare(PUCHAR psz1, PUCHAR psz2);

PUCHAR nlsUpperString(PUCHAR psz);
PUCHAR nlsLowerString(PUCHAR psz);


// inline functions

inline UCHAR nlsIsDBCS(UCHAR uc)
{  return AfbDBCS[uc];
}

inline UCHAR nlsUpper(UCHAR uc)
{  return AbUpperChars[uc];
}

inline UCHAR nlsLower(UCHAR uc)
{  return AbLowerChars[uc];
}

inline UCHAR nlsCollate(UCHAR uc)
{  return AbCollate[uc];
}

inline PUCHAR nlsNext(PUCHAR psz)
{  return psz + (nlsIsDBCS(*psz) + 1);
}


// inline functions for type conversion

inline PCHAR nlsSearch(PCHAR psz, UINT ui)
{  return (PCHAR)nlsSearch((PUCHAR)psz, ui);
}

inline PCHAR nlsSearch(PCHAR pb, UINT ui, UINT cbLength)
{  return (PCHAR)nlsSearch((PUCHAR)pb, ui, cbLength);
}

inline PCHAR nlsSearchCollate(PCHAR psz, UINT ui)
{  return (PCHAR)nlsSearchCollate((PUCHAR)psz, ui);
}

inline PCHAR nlsSearchCollate(PCHAR pb, UINT ui, UINT cbLength)
{  return (PCHAR)nlsSearchCollate((PUCHAR)pb, ui, cbLength);
}

inline PCHAR nlsSearchLast(PCHAR psz, UINT ui)
{  return (PCHAR)nlsSearchLast((PUCHAR)psz, ui);
}

inline PCHAR nlsSearchLast(PCHAR pb, UINT ui, UINT cbLength)
{  return (PCHAR)nlsSearchLast((PUCHAR)pb, ui, cbLength);
}

inline PCHAR nlsSearchCollateLast(PCHAR psz, UINT ui)
{  return (PCHAR)nlsSearchCollateLast((PUCHAR)psz, ui);
}

inline PCHAR nlsSearchCollateLast(PCHAR pb, UINT ui, UINT cbLength)
{  return (PCHAR)nlsSearchCollateLast((PUCHAR)pb, ui, cbLength);
}

inline BOOL nlsIncludeDBCS(PCHAR psz)
{  return nlsIncludeDBCS((PUCHAR)psz);
}

inline int nlsCountChar(PCHAR psz)
{  return nlsCountChar((PUCHAR)psz);
}

inline int nlsCompare(PCHAR psz1, PCHAR psz2)
{  return nlsCompare((PUCHAR)psz1, (PUCHAR)psz2);
}

inline PCHAR nlsUpperString(PCHAR psz)
{  return (PCHAR)nlsUpperString((PUCHAR)psz);
}

inline PCHAR nlsLowerString(PCHAR psz)
{  return (PCHAR)nlsLowerString((PUCHAR)psz);
}


#endif
