/* REXX */

Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
Call SysLoadFuncs;

 PSUP_DIR = directory();
 say;say "Current directory is: " PSUP_DIR;

 psup_fullpath = stream(PSUP_DIR || '\PSUP.EXE', 'c', 'query exists')
 if '' = psup_fullpath then
     DO
        say
        say 'PSFolder Install ERROR! - Can not find PSUP.EXE in current directory.'
        say 'Please run the "PSFolder" command from the directory in which'
        say '  you installed PSUp (and where all the PSUp icon files are located).'
        say
        EXIT
     END
 else do
     say; say "Found:" psup_fullpath
     end

reply='R';

say;say 'Creating PSUp Tools Folder.'
rc=SysCreateObject("WPFolder","PSUp Tools","<WP_DESKTOP>",,
"HELPPANEL=1277;"||,
"DEFAULTVIEW=CONTENTS;"||,
"NOPRINT=YES;"||,
PSUP_DIR || "\PSFOLDER.ICO;"||,
"ICONVIEW=FLOWED,"||,
"NORMAL;"||,
"TREEVIEW=LINES,"||,
"NORMAL;"||,
"DETAILSVIEW=MINI;"||,
"ICONFONT=10.System Proportional;"||,
"DETAILSFONT=8.Helv;"||,
"TREEFONT=10.System Proportional;"||,
"ICONVIEWPOS=26 22 35 47;"||,
"ALWAYSSORT=NO;"||,
"DEFAULTSORT=NAME;"||,
"OBJECTID=<PSUp_Tools>;"||,
"ICONFILE=" || PSUP_DIR || "\PSFOLDER.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: PSUp^Tools could not be created/updated !";
else say "     ==> SUCCESSFUL <=="



say;say 'Creating PSUp 4-Up / 132x100 object.'
rc=SysCreateObject("WPProgram","4-UP"||'0A'X||"132x100","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PARAMETERS=/8 %*;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_4UP_132>;"||,
"ICONFILE=" || PSUP_DIR || "\4UP.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: 4-UP^132x100 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="





say;say 'Creating PSUp 2-Up / 132x100 object.'
rc=SysCreateObject("WPProgram","2-UP"||'0A'X||"132x100","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PARAMETERS=/6 %*;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_2UP_132>;"||,
"ICONFILE=" || PSUP_DIR || "\2UP.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: 2-UP^132x100 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="





say;say 'Creating PSUp 1-Up / 132x100 object.'
rc=SysCreateObject("WPProgram","1-UP"||'0A'X||"132x100","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PARAMETERS=/5 %*;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_1UP_132>;"||,
"ICONFILE=" || PSUP_DIR || "\1UP.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: 1-UP^132x100 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="





say;say 'Creating PSUp Reference object.'
rc=SysCreateObject("WPProgram","PSUp"||'0A'X||"Reference","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"NOPRINT=YES;"||,
"EXENAME=VIEW.EXE;"||,
"PARAMETERS=" || PSUP_DIR || "\PSUPREF.INF;"||,
"PROGTYPE=PM;"||,
"OBJECTID=<PSUp_REF>;"||,
"", reply);
If rc<>1 Then Say "Object: PSUp^Reference could not be created/updated !";
else say "     ==> SUCCESSFUL <=="





say;say 'Creating PSUp 4-Up / 80x60 object.'
rc=SysCreateObject("WPProgram","4-UP"||'0A'X||"80x66","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PARAMETERS=/4 %*;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_4UP_80>;"||,
"ICONFILE=" || PSUP_DIR || "\4UP.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: 4-UP^80x66 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="




say;say 'Creating PSUp 2-Up / 80x60 object.'
rc=SysCreateObject("WPProgram","2-UP"||'0A'X||"80x66","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PARAMETERS=/2 %*;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_2UP_80>;"||,
"ICONFILE=" || PSUP_DIR || "\2UP.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: 2-UP^80x66 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="




say;say 'Creating PSUp 1-Up / 80x60 object.'
rc=SysCreateObject("WPProgram","1-UP"||'0A'X||"80x66","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PARAMETERS=/1 %*;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_1UP_80>;"||,
"ICONFILE=" || PSUP_DIR || "\1UP.ICO;"||,
"", reply);
If rc<>1 Then Say "Object: 1-UP^80x66 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="




say;say 'Creating PSUp Version 3.00 program object.'
rc=SysCreateObject("WPProgram","PSUp"||'0A'X||"3.00","<PSUp_Tools>",,
"HELPPANEL=4083;"||,
"DEFAULTVIEW=RUNNING;"||,
"CCVIEW=YES;"||,
"NOPRINT=YES;"||,
"EXENAME=" || PSUP_DIR || "\PSUP.EXE;"||,
"PROGTYPE=PM;"||,
"STARTUPDIR=" || PSUP_DIR || ";"||,
"OBJECTID=<PSUp_300>;"||,
"", reply);
If rc<>1 Then Say "Object: PSUp^3.00 could not be created/updated !";
else say "     ==> SUCCESSFUL <=="


say; say "PSFolder - Done"
