/* REXX */

'@ECHO OFF'
Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
Call SysLoadFuncs;

 START_DIR = directory();
 cls;
 say 'PSUP Installation Program - Copyright (c) 1996 - Knight Research'
 say '                       All Rights Reserved';say

 psup_fullpath = stream(START_DIR || '\PSUP.EXE', 'c', 'query exists')
 if '' = psup_fullpath then
     DO
        say
        say 'PSUPInst Install ERROR! - Can not find PSUP.EXE in current directory.'
        say 'Please run the "PSUPInst" command from the directory in which'
        say '  you unzipped the files (from PSUP_300.ZIP).'
        say
        EXIT
     END
 else do
     say; say "Found:" psup_fullpath
     end


looper:
 say;say;
 say 'Please type in the drive letter and directory in which to install PSUP'
 say
 say '    Example ==>  C:\PSUP'
 say '            ==>  D:\UTIL\PSUP'
 say '            ==>  F:\FRED'
 say
 pull INST_DIR .
 INST_DIR = strip(INST_DIR)
 if ':\' \= substr(INST_DIR,2,2) then
     DO
     say 'Please type in the DRIVE LETTER and the \path...see Example'
     say; signal looper
     END


 if INST_DIR = directory() then
     DO
     say "Can't install TO the" INST_DIR "directory...this is the directory"
     say "    we are installing FROM...specify another drive/path."
     signal looper
     END

 say 'Install PSUP to the' INST_DIR '  Is this correct? (Y/N)'
 pull yesno .
 if 'Y' = substr(yesno, 1, 1) then
     DO
     say; say 'Installing to' INST_DIR
     END
 else DO
     signal looper
     END

 say 'Proceed with install? (Y --> Install PSUP  or   N --> Cancel)'
 pull yesno .
 if 'Y' \= substr(yesno, 1, 1) then
     DO
      say 'Install Canceled.'
      exit
     END


/*** Proceed with install - MKDIR & copy all files to INST_DIR ***/
/*** Check for NEW directories more than 1 deep ***/
 numtimes = 0
 pos1 = 3
 DO WHILE pos('\', INST_DIR) \= lastpos('\', INST_DIR) & numtimes < 10
     pos2 = pos('\', INST_DIR, pos1 + 1)
     if pos2 = 0 then leave
     make_dir_first = substr(INST_DIR, 1, (pos2 - 1))
     'mkdir' make_dir_first '1> nul 2>&1'
     pos1 = pos2
     END

 'mkdir' INST_DIR '1> nul 2>&1'
 if rc = 0 | rc = 1 then
     DO
       NEW_DIR = Directory(INST_DIR)
       if INST_DIR \= NEW_DIR then
         DO
          say; say 'Unable to Create/Change-To' INST_DIR 'directory!'
          say 'Install Canceled.'
          EXIT
         END
     END
 else DO
     say 'Unexpected RC from MKDIR...Installation Canceled'
     say 'RC:' rc
     EXIT
     END

 say;say 'We are now in the' directory() 'directory!'

/*********** COPY FILES HERE *************************/

 'copy' START_DIR || '\PSUP.EXE     .'
 'copy' START_DIR || '\PSUPREF.INF     .'
 'copy' START_DIR || '\1UP.ICO      .'
 'copy' START_DIR || '\2UP.ICO      .'
 'copy' START_DIR || '\4UP.ICO      .'
 'copy' START_DIR || '\PSFOLDER.ICO   .'
 'copy' START_DIR || '\PSFOLDER.CMD .'

 /* Create PSUP Folder and all objects within */
 call 'PSFOLDER'

 NEW_DIR = Directory(START_DIR)
/******************** DONE ***************************/
say; say "PSUPInst - Done"
EXIT


