/******************************************************************/
/* WPSSETUP.CMD Workplace Security Settings Utility               */
/*                                                                */
/*                                                                */
/*  Function:  Automates Workplace Security Settings.             */
/*                                                                */
/*             Tailor this Rexx command script to                 */
/*             meet your needs. See the User Guide                */
/*             for information on the setup string                */
/*             keywords.                                          */
/*                                                                */
/*                                                                */
/*  Note: This utility requires the master password to            */
/*        change an objects security settings. Therefore,         */
/*        it will only work after the product has been            */
/*        registered and a master password has been set.          */
/*                                                                */
/*                                                                */
/*                                                                */
/*        Copyright (C) 1995, 1996 by Maple Valley Software       */
/******************************************************************/
  
'@Echo Off'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls          /* clear the screen */
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say 'WPSECURE: Enter the Master password '
parse upper pull master .
Call SysCls          /* clear the screen */
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '

Say 'WPSECURE: Enter the new object password'
parse upper pull password .
Call SysCls

ObjectID = '<WP_DESKTOP>'  /* Set the Desktop password settings */
MenuItems = "REFRESHMENUITEM=YES;SHUTDOWNMENUITEM=YES;LOCKUPMENUITEM=YES;LOCKOUTMENUITEM=YES;MASTERACCESS=NO;"
Settings = Menuitems||"LOCK=YES;LOCKOUT=NO;REMAINLOCKED=YES;PROTECT=YES;PASSWORD="password";LOCKICON=YES;LOCKTEXT=NO;MASTER="master";"
Result = SysSetObjectData(ObjectID, Settings )
if Result = 0 then signal Object_Settings_error

ObjectID = '<WP_OS2SYS>'  /* Set the OS/2 System folder settings */
Settings = "LOCK=YES;AUTOLOCK=YES;PROTECT=YES;PASSWORD="password";LOCKICON=YES;LOCKTEXT=NO;MASTER="master";"
Result = SysSetObjectData(ObjectID, Settings )
if Result = 0 then signal Object_Settings_error

ObjectID = '<WP_CONFIG>'  /* Set the System Setup folder settings */
Settings = "LOCK=YES;AUTOLOCK=YES;PROTECT=NO;PASSWORD="password";LOCKICON=YES;LOCKTEXT=NO;MASTER="master";"
Result = SysSetObjectData(ObjectID, Settings )
if Result = 0 then signal Object_Settings_error

ObjectID = '<WP_DRIVES>'  /* Set the Drives folder settings */
Settings = "LOCK=YES;AUTOLOCK=YES;REMOVEMENUITEMS=YES;PASSWORD="passord";LOCKICON=NO;LOCKTEXT=YES;MASTER="master";"
Result = SysSetObjectData(ObjectID, Settings )
if Result = 0 then signal Object_Settings_error

ObjectID = '<WP_PROMPTS>' /* Set the Command Prompts folder settings */
Settings = "LOCK=YES;AUTOLOCK=YES;PROTECT=NO;PASSWORD="password";LOCKICON=YES;LOCKTEXT=NO;MASTER="master";"
Result = SysSetObjectData(ObjectID, Settings )
if Result = 0 then signal Object_Settings_error

Call SysCls          /* clear the screen */
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say 'WPSECURE: WPSSETUP complete'
Signal DONE

Object_settings_error:
Call SysCls          /* clear the screen */
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say ' '
Say 'Error changing settings for ObjectID='ObjectID'. Possible reasons:'
Say '=> Master password is incorrect'
Say '=> Object ID does not exist'
Say '=> Workplace Security has not been registered.' 

Signal DONE 

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
