unit Gridu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, Grids, DBGrids, Qgrids;

type
  TForm1 = class(TForm)
    QDBGrid1: TQDBGrid;
    DataSource1: TDataSource;
    Table1: TTable;
    Table1OrderNo: TFloatField;
    Table1SaleDate: TDateTimeField;
    Table1CustNo: TFloatField;
    Table1ShipDate: TDateTimeField;
    Table1ShipVIA: TStringField;
    Table1EmpNo: TIntegerField;
    Table1ShipToContact: TStringField;
    Table1ShipToAddr1: TStringField;
    Table1ShipToAddr2: TStringField;
    Table1ShipToCity: TStringField;
    Table1ShipToState: TStringField;
    Table1ShipToZip: TStringField;
    Table1ShipToCountry: TStringField;
    Table1ShipToPhone: TStringField;
    Table1PO: TStringField;
    Table1Terms: TStringField;
    Table1PaymentMethod: TStringField;
    Table1ItemsTotal: TCurrencyField;
    Table1TaxRate: TFloatField;
    Table1Freight: TCurrencyField;
    Table1AmountPaid: TCurrencyField;
    procedure QDBGrid1ColorDrawDataCell(Sender: TObject; const Rect: TRect;
      Field: TField; State: TGridDrawState; var cPen, cBrush: TColor);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.QDBGrid1ColorDrawDataCell(Sender: TObject;
  const Rect: TRect; Field: TField; State: TGridDrawState; var cPen,
  cBrush: TColor);
begin
  if not( gdFocused in State) then begin
    if (Field.FieldName = 'CustNo') then begin
     cBrush := clRed;
     cPen := clWhite;
     end
    else if (Field.FieldName = 'ShipVIA') and
            (Field.Text = 'UPS') then begin
       cBrush := clYellow;
       end
    else if (Table1.FieldByNAme('AmountPaid').AsFloat > 20000.00) then begin
       cBrush := clBlue;
       end;
    end; { if }
end;

end.
