unit CyborgQA;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, dsgnintf, cybabout, Cfrminfo;

type
  tCYBAboutParentInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

    tCYBTabInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;


  tCYBParentInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCYBHintedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;


  tCYBRePosnEdit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCyborgQA = class(TCOMPONENT)

  protected
    { Protected declarations }
   Function GetAll : tcontrol;
   Procedure SetAll(AAll : tcontrol);

  published
    { Published declarations }
   Property About : tcontrol Read GetAll write setAll stored false;
   Property Parentage : tcontrol Read GetAll write setAll stored false;
   Property Hints : tcontrol Read GetAll write setAll stored false;
   Property Positions : tcontrol Read GetAll write setAll stored false;
   Property Tabs : tcontrol Read GetAll write setAll stored false;


  end;

procedure register;

implementation

Function tCyborgQA.GetAll : tcontrol;
Begin
   Result := (self.owner as tcontrol);
End;

Procedure tCyborgQA.SetAll(AAll : tcontrol);
Begin
End;


procedure tCYBAboutParentInfoedit.Edit;
var
  tbmp : tbitmap;

begin
   AboutBox := TAboutBox.create(application);
   tbmp := tbitmap.create;
   with aboutbox do begin
try
      prodnametext := 'CyborgQA';
      yeartext := '1996';
      Boxcaptiontext := 'About CyborgQA';
      versiontext := 'Free Version April 1996';
      vercommenttext := 'Limited to 10 controls, no DataInfo';
      tbmp.handle := LoadBitmap(HInstance, 'TCYBORGQA');
      ICONBMP := tbmp;
      execute;
finally
      free;
      tbmp.free;
end;
  end;
end;


procedure tCYBParentInfoedit.Edit;

begin
   showparentage(tcontrol(getordvalue));
end;


procedure tCYBHintedit.Edit;

begin
   showHints(tcontrol(getordvalue));
end;

procedure tCYBRePosnEdit.Edit;

begin
   reposition(tcontrol(getordvalue));
end;

procedure tCYBTabInfoedit.Edit;
begin
   showalltabs(tcontrol(getordvalue));
end;

procedure register;

begin
   RegisterComponents('Cyborg', [tCyborgQA]);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'About', tCYBAboutParentInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Parentage', tCYBParentInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Hints', tCYBHintedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Positions', tCYBRePosnEdit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Tabs', tCYBTabInfoedit);
end;

end.
