unit EdChkLst;

{ TEditCheckList V 1.0
  (c) Olivier Dahan March, 23th 1996

  This component is a TCustomEdit child. It not allows text input but
  posess an Items (TString) property where to stock all "legal" values, like
  a Combobox.
  The main difference with a Combo is the way the values are used.
  In the TEditCheckList the user can use Up and Down Arrows to directly
  get access to all values and he/she can type characters used as an incremental
  search seed. By example, if the Items property contains "July/Juliet" and
  if "J" is typed, the control displays "July" (the first corresponding). If
  the user enters "U" and "L", the control stays on "July", and if he/she next
  types "I", the controls displays "Juliet".
  The typed characters remain in the control memory until arrows are used or
  "escape" key is entered.
  The control shows, as a selection, the number of typed characters. In our
  example (July/Juliet), at the end of the sequence, Juliet is displays and
  "juli" are shown as a selection. This is a good visual way to show the
  silent incremental search text.
  When an entry is found in the list of values, the OnFound events is
  fired. So, you can connect here some code to hold this special condition.
  The OnFound event return the sender, the found item (text and index in
  the Items property) and the incremental search text.

  Used keys are:
  * Up and Down arrows        to navigate throught the list of values
  * 'A'..'Z','0'..'9'         add a character to incremental search text
                              (case insensitive)
  * Escape                    blanks the incremental search text
                              No display change (but no visible selection).
  * Back                      Erases last character of incremental search text

  TEditCheckList is not intented to be used as a text input control. Its
  creator switches the ReadOnly propery to true. Its a Tedit sibling but
  it acts more like a ComboBox.

Legal stuff
-----------
Copyright:     This software is copyrighted by Olivier Dahan, Paris, France
               CIS 100531,163
Use:           This software is distributed as Freeware, that means you can
               use it with no charge in any application, ONLY IF YOU REGISTER.
               Registration is FREE but you must send a message saying you're
               using the component to Olivier Dahan CIS 100531,163.
               DO IT ! You'll sleep better and you'll encourage source code
               distribution.
Limitation:    You can't sell this software (but a minimal distribution fee)
               without author permission.
               If you distribute it, you must include all original files.
Changes:       You can change this component but, in this case, you must give
               your version a specific name (not TeditCheckList).
               You can send a copy to the author (myself) he will be very
               pleased...


--------------------
The Legal Disclaimer
--------------------
THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO AS
"SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
OLIVIER DAHAN BE LIABLE FOR ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT,
INCIDENTAL, CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN
IF OLIVIER DAHAN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. SOME
STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF LIABILITY FOR
CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE FOREGOING LIMITATION MAY NOT
APPLY. IN SUCH CASES, THE FOLLOWING LEGAL DISCLAIMER WILL APPLY:
FOR FRANCE (and all countries not allowing exclusion or limitation of
liability for consequential or incidental damages):
LE PRESENT LOGICIEL EST MIS GRACIEUSEMENT A DISPOSITON SUR LE FORUM DELPHI DE
LA SOCIETE BORLAND SUR COMPUSERVE UNIQUEMENT A TITRE D'EXEMPLE. IL EST DESTINE
AUX PROFESSIONNELS INFORMATICIENS QUI FREQUENTENT CE FORUM. SEULS CES PERSONNES
SONT AUTORISEES A FAIRE USAGE DU PRESENT LOGICIEL ET CE, SOUS LEUR SEULE ET
UNIQUE RESPONSABILITE D'INFORMATICIEN PROFESSIONNEL. SI VOUS NE COMPRENEZ PAS
LE CODE SOURCE DU PRESENT LOGICIEL ET N'AVEZ PAS LES COMPETENCES POUR LE
CORRIGER (en cas de bug), NE L'UTILISEZ PAS !
}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, stdctrls;


Type
TSelectionFound = Procedure(Sender:Tobject;const TypedText,Foundtext:String;
                            ItemIndex:Longint) of object;

TEditCheckList = Class (TCustomEdit)
                 Protected
                 fItems : TStringList;
                 fitemindex : longint;
                 ftempStr : string;
                 FOnFound : TSelectionFound;
                 procedure KeyUp(var Key: Word; Shift: TShiftState); override;
                 Function Traitekey(var Key: Word; Shift: TShiftState):boolean;
                 Private
                 Procedure SetItems(value:TStringList);
                 procedure SetItemIndex(value:Longint);
                 procedure SetTStr(value:string);
                 property TStr:String read FtempStr Write SetTStr;
                 procedure SynchroText;
                 Public
                 Constructor Create(Aowner:Tcomponent); override;
                 Destructor Destroy; override;
                 Published
                 property OnFound:TSelectionFound Read FonFound Write FOnFound;
                 Property Items : TstringList Read fItems Write SetItems;
                 property text;
                 property ItemIndex : Longint Read FitemIndex Write SetItemIndex;
                 property Borderstyle;
                 property color;
                 property ctl3d;
                 property font;
                 property hideselection;
                 property showhint;
                 property hint;
                 property Onchange;
                 property onclick;
                 property OnDblClick;
                 property OnEnter;
                 Property OnExit;
                 Property OnKeyDown;
                 Property OnKeyUp;
                 Property OnMouseDown;
                 Property OnMouseMove;
                 Property OnMouseUp;
                 end;


Procedure register;

implementation

Constructor TEditCheckList.Create;
begin
Inherited Create(Aowner);
Parent:=AOwner as TWinControl;
FItems := TStringList.Create;
Fitems.sorted:=true;
fItemIndex:=-1;
FTempStr:='';
readonly:=true;
end;

Destructor TEditCheckList.Destroy;
begin
Fitems.Free;
Inherited Destroy;
end;

Procedure TEditCheckList.SetItems;
begin
Fitems.Assign(Value);
end;

procedure TEditCheckList.KeyUp(var Key: Word; Shift: TShiftState);
begin
if not traiteKey(key,shift) then Inherited KeyUp(key,shift);
end;

Function TeditCheckList.TraiteKey;
begin
if Key=Vk_Up then begin ItemIndex:=ItemIndex-1; key:=0; FtempStr:=''; end;
if key=Vk_Down then begin ItemIndex:=ItemIndex+1; key:=0; FtempStr:=''; end;
if ((key>=ord('A')) and (key<=ord('Z'))) or (key=vk_space) or
   ((key>=ord('0')) and (key<=ord('9'))) then begin Tstr:=Tstr+char(key);
                                            key:=0;
                                      end;
if ((key=vk_back) and (Tstr<>'')) then begin tstr:=copy(tstr,1,length(tstr)-1);
                                            key:=0;
                                      end;
if (key=vk_escape) then begin FtempStr:=''; key:=0; sellength:=0; end;
end;

Procedure TeditCheckList.SetItemIndex;
begin
if 
   (value>-2) and
   (value<Fitems.count) then begin FitemIndex:=Value;
                                   SynchroText;
                             end;
end;

Procedure TeditCheckList.SetTStr;
var i,ii:longint; found:boolean;
begin
if (value<>FTempStr) then
   begin
   FtempStr:=value; found:=false;
   for i:=0 to items.count-1 do
       if Ftempstr=uppercase(copy(items[i],1,length(FtempStr)))
          then begin itemindex:=i; found:=true; ii:=i; break; end;
   if (not found) and (Ftempstr<>'') then
      begin TStr:=copy(FTempstr,1,length(FtempStr)-1);
            messagebeep(MB_ICONEXCLAMATION);
      end;
   if found and assigned(fonfound) then fonfound(self,ftempstr,text,ii);
   end;
end;



Procedure TeditCheckList.Synchrotext;
begin
if (FitemIndex>-1) and (FitemIndex<Fitems.Count) then
                       Text:=Items[ItemIndex];
refresh;
SelStart:=0; selLength:=length(Ftempstr);
end;

Procedure Register;
begin
 RegisterComponents('Div', [TEditCheckList]);
end;

end.

