		------------------------------
		-- Print a Euphoria program --
		------------------------------
-- This works with HP PCL printers.
-- You can change control codes (bold, italics etc) for other printers.
-- If you have a color printer you can choose colors,
-- otherwise you will simply get keywords in bold, comments in italics.
-- You can print non-Euphoria files too.

-- usage: eprint filename


constant TRUE = 1, FALSE = 0
constant ERROR = 2

---- some parameters you can adjust for your printer --------------------------
constant NCOLUMNS = 2              -- 1 or 2
constant CONDENSED = TRUE          -- TRUE or FALSE
constant PAGE_LENGTH = 59*NCOLUMNS -- (upper bound) 118 for condensed
constant COLOR_PRINTER = FALSE     -- TRUE (HP550C) or FALSE
integer syntax
syntax = TRUE                      -- to highlight syntax in .e/.ex/.pro files
-------------------------------------------------------------------------------

constant ESC = 27

constant hp550c = {"2", "8", "1", "12", "4", "10", "1", "1"}

integer printer

procedure bold_on()
    puts(printer, ESC & "(s3B")
end procedure

procedure bold_off()
    puts(printer, ESC & "(s0B")
end procedure

procedure italics_on()
    puts(printer, ESC & "(s1S")
end procedure

procedure italics_off()
    puts(printer, ESC & "(s0S")
end procedure

procedure second_column()
    puts(printer, ESC & "&a80C")
end procedure

procedure form_feed()
    puts(printer, 12)
end procedure

procedure reset()
    puts(printer, ESC & 'E')   -- reset
end procedure

procedure color()
    puts(printer, ESC & "*r-4U")  -- CYMK
end procedure

procedure small()
    puts(printer, ESC & "(s20H")    -- Print Pitch (width)
    puts(printer, ESC & "(s8V")     -- Point Size (height)
    puts(printer, ESC & "&l4C")     -- vertical motion
end procedure

-- symbols needed by syncolor.e:
global integer SCREEN
global constant  NORMAL_COLOR = 8,
		COMMENT_COLOR = 4,
		KEYWORD_COLOR = 1,
		BUILTIN_COLOR = 5,
		 STRING_COLOR = 6

global constant BRACKET_COLOR = {NORMAL_COLOR}

global procedure text_color(integer color)
-- this overrides the graphics.e procedure for screen color
-- that is used by syncolor.e
    sequence color_code

    if not syntax then
	return
    end if

    if COLOR_PRINTER then
	color_code = hp550c[color]
	puts(printer, ESC & "*v" & color_code & "S")
    else
	-- normal mono printer
	if color = KEYWORD_COLOR then
	    italics_off()
	    bold_on()
	elsif color = COMMENT_COLOR then
	    bold_off()
	    italics_on()
	else
	    italics_off()
	    bold_off()
	end if
    end if
end procedure

include syncolor.e

procedure try_colors()
-- display colors on hp550c
    for i = '0' to '6' do
	for j = '0' to '9' do
	    puts(printer, ESC & "*v" & i & j & "S")
	    printf(printer, "%s:", {i&j})
	    puts(printer, "Testing Colors ...\n")
	end for
    end for
end procedure

procedure eprint()
    integer efile
    sequence command, matchname
    object line
    sequence buffer
    integer base_line

    command = command_line()
    if length(command) != 3 then
	puts(ERROR, "usage: eprint filename\n")
	return
    end if
    efile = open(command[3], "r")
    if efile = -1 then
	puts(ERROR, "couldn't open " & command[3] & '\n')
	return
    end if
    matchname = command[3] & '&'
    if not match(".e&", matchname) and
       not match(".ex&", matchname) and
       not match(".pro&", matchname) then
	syntax = FALSE
    end if
    printer = open("PRN", "w")
    if printer = -1 then
	puts(ERROR, "Can't open printer\n")
	return
    end if
    SCREEN = printer -- SCREEN is needed by syncolor
    init_class()
    reset()
    if COLOR_PRINTER then
	color()
    end if
    if CONDENSED then
	small()
    end if

    -- read in whole file
    buffer = {}
    while TRUE do
	line = gets(efile)
	if atom(line) then
	    exit
	end if
	if line[length(line)] != '\n' then
	    line = line & '\n' -- need end marker
	end if
	buffer = append(buffer, line)
    end while
    base_line = 1
    while base_line <= length(buffer) do
	for i = base_line to base_line + PAGE_LENGTH - 1 do
	    if i <= length(buffer) then
		DisplayColorLine(buffer[i])
		if NCOLUMNS = 2 and i + PAGE_LENGTH <= length(buffer) then
		    second_column()
		    DisplayColorLine(buffer[i + PAGE_LENGTH])
		end if
		puts(printer, '\n')
	    end if
	end for
	base_line = base_line + PAGE_LENGTH * NCOLUMNS
	form_feed()
    end while
    close(efile)
    close(printer)
end procedure

eprint()

