{
                PROGRAM: Easy Mouse Lib Ver 2.0, SHAREWARE
                AUTHOR: Jeff Weinstein
                DATE STARTED: 4/7/96
                DATE FINISHED: 4/13/96
                UPDATE:5/11/96 -Ver 2.0
                Copyright (c) 1996, by Jeff Weinstein.  All rights reserved.
}


unit ezmouse;

Interface
         uses crt, dos;

{******************************TYPES*****************************}

type
    EMouseType = (UNDEF,BUS,SERIAL,INPORT,PS2,HP);



{***************************CONSTANTS****************************}

const
     LEFT_BUTTON = 0;
     RIGHT_BUTTON = 1;

{**************************VARIABLES*****************************}

var
         iv,bt : word;
         MouseInstalled, NumberOfButtons : Integer; {is installed, #buttons}
         MouseX,MouseY:Integer; {mouse coords}
         LeftPressed, RightPressed:Integer; {are they pressed}
         dummy:integer;
         ButtonX,ButtonY:integer;
         MouseMajor,MouseMinor:byte;
         MouseType : EMouseType;
         MouseIRQ  : byte;



{*****************************PROCEDURES**************************}

         procedure InstallMouse; {installs mouse driver}
         procedure ShowMouse; {displays mouse on screen}
         procedure HideMouse; {hides mouse}
         procedure MouseXY; {retrieves mouse current coordinates}
         procedure ButtonPress; {tells which button(s) are being held down}
         procedure SetMouseXY(x,y:integer); {moves mouse to x,y}
         procedure ButtonClick(button:integer); {determines where last BUTTON click was}
         procedure ConfineMouse(MinX,MinY,MaxX,MaxY:integer); {confines mouse to window}
         procedure NormalConfine; {resets mouse confines to normal}
         procedure MouseInfo; {gets ver, IRQ, type}
         Procedure ResetMouse;
         Procedure ChangeCursor(Offs,Segm:word;hhs,vhs:integer); {creates new cursor}

Implementation

         procedure InstallMouse;
             begin
                {set shareware delay}
                textcolor(4);
                writeln('This is the SHAREWARE version of EZ-Mouse.');
                writeln('Why not register?  It''s only $5 including S/H.');
                writeln('See the file REGISTER.TXT for details.');
                writeln('There will be a 12 second delay before the mouse initializes');
                delay(12000);
                textcolor(7);

                {procedure installs mouse and returns succes, #buttons}
                asm
                   mov ax, 0h
                   int 33h
                   mov [iv], ax
                   mov [bt], bx
                end;
                if iv=65535 then MouseInstalled:=-1; {mouse is installed}
                if iv<>65535 then MouseInstalled:=0; {not installed}
                NumberOfButtons:=bt;
           end;


         Procedure ShowMouse;
         begin
              asm
                 mov ax,01h
                 int 33h
              end;
         end;


         Procedure HideMouse;
         begin
              asm
                 mov ax,02h
                 int 33h
              end;
         end;


         Procedure MouseXY;
         begin
              asm
                 mov ax,03h
                 int 33h
                 mov [dummy],bx
                 mov [MouseX],cx
                 mov [MouseY],dx
              end;

         end;

         Procedure ButtonPress;
         begin
              asm
                 mov ax,03h
                 int 33h
                 mov [dummy],bx
              end;
              if dummy=1 then
                 begin
                      LeftPressed:=-1;
                      RightPressed:=0;
                 end;
              if dummy=2 then begin
                 LeftPressed:=0;
                 RightPressed:=-1;
                 end;
              if dummy=3 then begin
                 LeftPressed:=-1;
                 RightPressed:=-1;
                 end;
              if (((dummy<>1) and (dummy<>2)) and (dummy<>3)) then begin
                 LeftPressed:=0;
                 RightPressed:=0;
                 end;
         end;


         Procedure SetMouseXY(x,y:integer);
         begin
              asm
                 mov ax,04h
                 mov cx,[x]
                 mov dx,[y]
                 int 33h
              end;
         end;


        Procedure ButtonClick(button:integer);
        begin
             asm
                mov ax,05h
                mov bx,[button]
                int 33h
                mov [ButtonX],cx
                mov [ButtonY],dx
             end;
        end;


        procedure ConfineMouse(MinX,MinY,MaxX,MaxY:integer);
        begin
             asm
                mov ax,07h {first do the x's}
                mov cx,[MinX]
                mov dx,[MaxX]
                int 33h
                mov ax,08h
                mov cx,[MinY]
                mov dx,[MaxY]
                int 33h
             end;
        end;

        procedure NormalConfine;
        begin
             asm
                mov ax,07h
                mov cx,0
                mov dx,639
                int 33h
                mov ax,08h
                mov cx,0
                mov dx,199
                int 33h
             end;
        end;


        procedure MouseInfo;
        begin
             asm
                mov ax,24h
                int 33h
                mov [MouseMajor],bh
                mov [MouseMinor],bl
                mov [MouseType],ch
                mov [MouseIRQ],cl
             end;
        end;


        Procedure ResetMouse;assembler;
        asm
           mov ax,21h
           int 33h
        end;

        Procedure ChangeCursor(Offs,Segm:word;hhs,vhs:integer);assembler;
        asm
               mov ax,09h
               mov bx,[hhs]
               mov cx,[vhs]
               mov es,[Segm]
               mov dx,[Offs]
               int 33h
        end;




end.