unit Demomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DBTables, DB, Maillbl, ExtCtrls;

type
  TDemoMainDlg = class(TForm)
    Panel1: TPanel;
    Table1: TTable;
    DataSource1: TDataSource;
    MailLabel1: TMailLabel;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1Addr2: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    Table1Attention: TStringField;
    Panel2: TPanel;
    bbtnDefineLabels: TBitBtn;
    bbtnFont: TBitBtn;
    bbtnPrint: TBitBtn;
    bbtnClose: TBitBtn;
    FontDialog1: TFontDialog;
    PrintDialog1: TPrintDialog;
    procedure Table1CalcFields(DataSet: TDataset);
    procedure bbtnDefineLabelsClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure bbtnFontClick(Sender: TObject);
    procedure bbtnPrintClick(Sender: TObject);
    procedure bbtnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DemoMainDlg: TDemoMainDlg;

implementation

{$R *.DFM}

procedure TDemoMainDlg.Table1CalcFields(DataSet: TDataset);
begin
	Table1Attention.AsString := 'Attn: '+Table1Contact.AsString;
end;

procedure TDemoMainDlg.bbtnDefineLabelsClick(Sender: TObject);
begin
	MailLabel1.LabelDefinition.Edit;
end;

procedure TDemoMainDlg.FormActivate(Sender: TObject);
begin
	Table1.Open;
end;

procedure TDemoMainDlg.bbtnFontClick(Sender: TObject);
begin
	if FontDialog1.Execute then
   	MailLabel1.Font := FontDialog1.Font;
end;

procedure TDemoMainDlg.bbtnPrintClick(Sender: TObject);
begin
	if PrintDialog1.Execute then
   	MailLabel1.Print;
end;

procedure TDemoMainDlg.bbtnCloseClick(Sender: TObject);
begin
	Close;
end;

end.
